plugin simpleManipulator hkPlaneGizmo
    name:"hkPlaneGizmo"
    invisible:true
(
    -- Create the green and red colors for the gizmo
    local activeColor =   colorMan.getColor #manipulatorsActive
    local selectedColor = [1,1,0]
    local rotXColor = GetUIColor 68  -- COLOR_MANIPULATOR_X Gizmos & Apparatuses Transform Gizmo X
    local rotYColor = GetUIColor 69  -- COLOR_MANIPULATOR_Y Gizmos & Apparatuses Transform Gizmo Y
    local rotZColor = GetUIColor 70  -- COLOR_MANIPULATOR_Z Gizmos & Apparatuses Transform Gizmo Z
	local dragStartPoint = [0, 0, 0]
	local dragStartNormal = [0, 1, 0]
	local gizmoVarList = #()

    -- This manipulator manipulates any node with a "PLANE" gizmo property
    on canManipulate target do
    (
		targetAtt = custAttributes.get target 1
		
		if (targetAtt == undefined) then
		(
			return false
		)

		propList = getPropNames targetAtt

		for p in propList do
		(
			propName = p as string
			if ((findString propName "HkGizmos") != undefined) then
			(
				propContent = getProperty targetAtt p
				if ((findString propContent ":PLANE") != undefined) then
				(
					return true
				)
			)
		)

		return false
	)
	
    -- Create the manipulator gizmo.
    -- This is called initially and whenever the manipulator target changes
    on updateGizmos do
    (
        -- Clear the current gizmo cache
        this.clearGizmos()

		targetAtt = custAttributes.get target 1
		propList = getPropNames targetAtt
        
        gizmoVarList = #()
		for p in propList do
		(
			propName = p as string
			if ((findString propName "HkGizmos") != undefined) then
			(
				propContent = getProperty targetAtt p
				gizmoList = filterString propContent " "
				for gizmoVar in gizmoList do
				(
					g = filterString gizmoVar ":"
					if ((findString g[2] "PLANE") != undefined) then
					(
						gName = g[1] as name
						gVal = getProperty targetAtt gName
						-- [0,0,0] normal signals automatic orientation, dont draw it
						if ((length gVal) > 0.0) then
						(
							append gizmoVarList gName
						)
					)
				)
			)
		)

		-- every gizmo is actually made out of 4 items: the plane and 3 rotation rings
		for gizmoVar in gizmoVarList do
		(
			gizmoValue = getProperty targetAtt gizmoVar
        
			local bboxMin = getModContextBBoxMin node target
			if (bboxMin == undefined) then bboxMin = [-1, -1, -1]
			local bboxMax = getModContextBBoxMax node target
			if (bboxMax == undefined) then bboxMax = [1, 1, 1]
			local halfSize = (length (bboxMax - bboxMin)) / 2
			local pos = [0,0,0]
			
			giz = manip.makeGizmoShape()
	    
			-- The corners
			local p00 = pos + [  halfSize,  halfSize, 0]
			local p01 = pos + [  halfSize, -halfSize, 0]
			local p10 = pos + [ -halfSize,  halfSize, 0]
			local p11 = pos + [ -halfSize, -halfSize, 0]
	    
			-- Create the plane
			giz.addPoint p00
			giz.addPoint p10
			giz.addPoint p11
			giz.addPoint p01
			giz.addPoint p00

			-- Rotate into desired orientation
			giz.transform (matrixFromNormal (normalize gizmoValue))
			
			-- Add the gizmo to the manipulator
			this.addGizmoShape giz 0 activeColor selectedColor  
		
			-- The 3 rotation rings
			local gizRadius = halfSize / 2
			gizX = manip.makeCircle [0,0,0] gizRadius 16
			gizY = manip.makeCircle [0,0,0] gizRadius 16
			gizZ = manip.makeCircle [0,0,0] gizRadius 16

			-- Rotate into desired orientation
			gizX.transform (rotateYMatrix 90)
			gizY.transform (rotateXMatrix 90)
			
			-- Add the rings to the manipulator
			this.addGizmoShape gizX gizmoActiveViewportOnly rotXColor selectedColor
			this.addGizmoShape gizY gizmoActiveViewportOnly rotYColor selectedColor
			this.addGizmoShape gizZ gizmoActiveViewportOnly rotZColor selectedColor
		)
		
        -- return the ToolTip string
        return node.name
    )

    -- mouseMove is called on every mouse move when dragging the manip
    -- It needs to convert the mouse position 'm' into a new value for the gizmo
    on mouseMove m which do
    (
        targetAtt = custAttributes.get target 1

		local gizmoNumber = (floor (which / 4)) + 1
		local subGizmo = (mod which 4) as Integer
		
        local gizmoValue = normalize (getProperty targetAtt gizmoVarList[gizmoNumber])

		-- Compute the hit-ray in local coordinates
		local viewRay = this.getLocalViewRay m
		local projectedPoint = [0,0,0]

		-- Intersect the view plane with the view ray
		local pl = manip.makePlaneFromNormal viewRay.dir [0, 0, 0]
		local res = pl.intersect viewRay &projectedPoint

		local incrDist = projectedPoint - dragStartPoint

		-- If the intersection worked, set
		if (res) then
		(
			case subGizmo of
			(
				0: -- pulled the plane
				(
					gizmoValue = normalize (dragStartNormal + incrDist)
				)
				
				1: -- pulled the X ring
				(
					local incrDir = -incrDist.y / ((abs incrDist.y) + 0.00001)
					local incrRot = rotateXMatrix ((length incrDist) * incrDir)
					local rotNormal = dragStartNormal * incrRot
					gizmoValue = normalize rotNormal
					dragStartPoint = projectedPoint
					dragStartNormal = gizmoValue
				)
				
				2: -- pulled the Y ring
				(
					local incrDir = -incrDist.z / ((abs incrDist.z) + 0.00001)
					local incrRot = rotateYMatrix ((length incrDist) * incrDir)
					local rotNormal = dragStartNormal * incrRot
					gizmoValue = normalize rotNormal
					dragStartPoint = projectedPoint
					dragStartNormal = gizmoValue
				)
				
				3: -- pulled the Z ring
				(
					local incrDir = -incrDist.y / ((abs incrDist.y) + 0.00001)
					local incrRot = rotateZMatrix ((length incrDist) * incrDir)
					local rotNormal = dragStartNormal * incrRot
					gizmoValue = normalize rotNormal
					dragStartPoint = projectedPoint
					dragStartNormal = gizmoValue
				)
			)
		)
		
		setProperty targetAtt gizmoVarList[gizmoNumber] gizmoValue
    )

	-- initial mouse button press event: record starting point	
	on MouseDown m which do
	(
        targetAtt = custAttributes.get target 1

		local gizmoNumber = (floor (which / 4)) + 1

		dragStartNormal = normalize (getProperty targetAtt gizmoVarList[gizmoNumber])

        -- Compute the hit-ray in local coordinates
        local viewRay = this.getLocalViewRay m

		-- Intersect the view plane with the view ray
		local pl = manip.makePlaneFromNormal viewRay.dir [0, 0, 0]
		pl.intersect viewRay &dragStartPoint
	)
)


plugin simpleManipulator hkArrowGizmo
    name:"hkArrowGizmo"
    invisible:true
(
    -- Create the green and red colors for the gizmo
    local activeColor = colorMan.getColor #manipulatorsActive
    local selectedColor = [1,1,0]
	local gizmoVarList = #()

    -- This manipulator manipulates any node with a "ARROW" gizmo property
    on canManipulate target do
    (
		targetAtt = custAttributes.get target 1
		
		if (targetAtt == undefined) then
		(
			return false
		)

		propList = getPropNames targetAtt

		for p in propList do
		(
			propName = p as string
			if ((findString propName "HkGizmos") != undefined) then
			(
				propContent = getProperty targetAtt p
				if ((findString propContent ":ARROW") != undefined) then
				(
					return true
				)
			)
		)

		return false
	)
	
    -- Create the manipulator gizmo.
    -- This is called initially and whenever the manipulator target changes
    on updateGizmos do
    (
        -- Clear the current gizmo cache
        this.clearGizmos()

		targetAtt = custAttributes.get target 1
		propList = getPropNames targetAtt
        
        gizmoVarList = #()
		for p in propList do
		(
			propName = p as string
			if ((findString propName "HkGizmos") != undefined) then
			(
				propContent = getProperty targetAtt p
				gizmoList = filterString propContent " "
				for gizmoVar in gizmoList do
				(
					g = filterString gizmoVar ":"
					if ((findString g[2] "ARROW") != undefined) then
					(
						gName = g[1] as name
						append gizmoVarList gName
					)
				)
			)
		)

		for gizmoVar in gizmoVarList do
		(
			gizmoValue = getProperty targetAtt gizmoVar
        
			local bboxMin = getModContextBBoxMin node target
			if (bboxMin == undefined) then bboxMin = [-1, -1, -1]
			local bboxMax = getModContextBBoxMax node target
			if (bboxMax == undefined) then bboxMax = [1, 1, 1]
			local halfSize = (length (bboxMax - bboxMin)) / 2
			local t =  0.03 * halfSize
			local t2 = 0.09 * halfSize
			local t3 = 0.5 * halfSize
			local t4 = 0.4 * halfSize
			local t5 = 0.7 * halfSize
			local pos = [0,0,0]

			giz = manip.makeGizmoShape()
	    
   			local p00 = pos + [ -t,  0, 0  ]
   			local p01 = pos + [ -t,  0, t3 ]
   			local p02 = pos + [  t,  0, 0  ]
   			local p03 = pos + [  t,  0, t3 ]
   			local p04 = pos + [  0, -t, 0  ]
   			local p05 = pos + [  0, -t, t3 ]
   			local p06 = pos + [  0,  t, 0  ]
   			local p07 = pos + [  0,  t, t3 ]

   			local p10 = pos + [-t2,   0, t4 ]
   			local p11 = pos + [  0,   0, t5 ]
   			local p12 = pos + [ t2,   0, t4 ]
   			local p13 = pos + [  0, -t2, t4 ]
   			local p14 = pos + [  0,  t2, t4 ]

			-- shaft
			giz.addPoint p00
			giz.addPoint p01
			giz.startNewLine()
			giz.addPoint p02
			giz.addPoint p03
			giz.startNewLine()
			giz.addPoint p04
			giz.addPoint p05
			giz.startNewLine()
			giz.addPoint p06
			giz.addPoint p07

			-- head
			giz.startNewLine()
			giz.addPoint p10
			giz.addPoint p11
			giz.addPoint p12
			giz.startNewLine()
			giz.addPoint p13
			giz.addPoint p11
			giz.addPoint p14

			-- Rotate into desired orientation
			giz.transform (matrixFromNormal (normalize gizmoValue))
			
			-- Add the gizmo to the manipulator
			this.addGizmoShape giz 0 activeColor selectedColor  
		)
		
        -- return the ToolTip string
        return node.name
    )

    -- mouseMove is called on every mouse move when dragging the manip
    -- It needs to convert the mouse position 'm' into a new value for the gizmo
    on mouseMove m which do
    (
        targetAtt = custAttributes.get target 1

        gizmoValue = normalize (getProperty targetAtt gizmoVarList[which + 1])

        -- Compute the hit-ray in local coordinates
        local viewRay = this.getLocalViewRay m

        local pl = manip.makePlaneFromNormal viewRay.dir [0, 0, 0]
        local projectedPoint = [0,0,0]
		
        -- Intersect the plane with the view ray
        local res = pl.intersect viewRay &projectedPoint

        -- If the intersection worked, set
        if (res) then
		(
			gizmoValue = normalize projectedPoint
			setProperty targetAtt gizmoVarList[which + 1] gizmoValue
		)
    )
)
