
------------------------------------------------------------------------------
-- EXTERNAL METHODS
------------------------------------------------------------------------------

global hvkDestruction_createGenericModifier


------------------------------------------------------------------------------
-- LOCAL METHODS
------------------------------------------------------------------------------

function hvkDestructionDialog_uniqueOrSharedFracture reqTitle =
(
	global returnValue = -1
	
	rollout requester reqTitle
	(
		label _label1 "You can create an unique Fracture algorithm for all objects in the selection or you" align:#center offset:[0,10]
		label _label2 "can create one single Fracture modifier to be shared between all selected objects."  align:#center
		
		button reqButton1 "Unique" across:3 width:100 offset:[-10,10]
		button reqButton2 "Shared"          width:100 offset:[  0,10]
		button reqButton3 "Cancel"          width:100 offset:[ 10,10]
		
		on reqButton1 pressed do
		(
			DestroyDialog requester
			returnValue = 0
		)

		on reqButton2 pressed do
		(
			DestroyDialog requester
			returnValue = 1
		)

		on reqButton3 pressed do
		(
			DestroyDialog requester
			returnValue = 2
		)
	)

	createDialog requester 420 100 modal:true
	
	return returnValue
)


------------------------------------------------------------------------------
-- GLOBAL METHODS
------------------------------------------------------------------------------

function hvkDestruction_createNewFracture fractureCtor requesterTitle =
(
	if ( selection.count == 0 ) then
	(
		fractureHelper = dummy()
		fractureHelper.boxsize.x = 0
		fractureHelper.boxsize.y = 0
		fractureHelper.boxsize.z = 0
		fractureHelper.name = uniqueName (fractureCtor as string)
		hvkDestruction_createGenericModifier fractureHelper fractureCtor
		select(fractureHelper)
	)
	else
	(
		creationType = 0
		if ( selection.count > 1 ) then
		(
			creationType = hvkDestructionDialog_uniqueOrSharedFracture requesterTitle
		)

		if ( creationType == 2 ) then
		(
			return false
		)

		if ( creationType == 0 ) then
		(
			-- Unique
			for object in selection do
			(
				genericModifier = hvkDestruction_createGenericModifier object fractureCtor
			)
		)
		else if ( creationType == 1 ) then
		(
			-- Shared
			genericModifier = fractureCtor()
			for object in selection do
			(
				addModifier object genericModifier
			)
		)

		select selection[1]
	)

	setCommandPanelTaskMode mode:#modify
)


