
------------------------------------------------------------------------------
-- EXTERNAL METHODS
------------------------------------------------------------------------------

global hvkDestruction_createGenericModifier
global hvkDestruction_isModifierOnNodeStack


------------------------------------------------------------------------------
-- LOCAL METHODS
------------------------------------------------------------------------------

function hvkDestruction_hasControllerAttached theNode =
(
	for modifier in theNode.modifiers do
	(
		if ( hkIsOfGenericModifierBaseType modifier "hkdController" ) then
		(
			return true
		)
	)
	return false
)


function hvkDestruction_createSharedController_Requester reqTitle =
(
	global returnValue = -1
	
	rollout requester reqTitle
	(
		label _label1 "You can create an individual Controller for all objects in the" align:#left
		label _label2 "selection (UNIQUE) or you can create one single Controller"     align:#left
		label _label3 "that is being shared between all selected objects (SHARED)."    align:#left
		label _label4 ""
		
		button reqButton1 "Unique" width:80 across:3
		button reqButton2 "Shared" width:80
		button reqButton3 "Cancel" width:80
		
		on reqButton1 pressed do
		(
			DestroyDialog requester
			returnValue = 0
		)

		on reqButton2 pressed do
		(
			DestroyDialog requester
			returnValue = 1
		)

		on reqButton3 pressed do
		(
			DestroyDialog requester
			returnValue = 2
		)
	)

	createDialog requester 350 110 modal:true
	
	return returnValue
)


function hvkDestruction_createController_LinkOr_add_Requester reqTitle =
(
	global returnValue = -1
	
	rollout requester reqTitle
	(
		label _labelInfo1  "Some objects in your selection already have an active Controller. Do"
		label _labelInfo2  "you want to link the new Controller as the active one for these objects?"
		label _labelEmpty1 ""
		
		button reqButton2 "Yes, link" width:90 offset:[0,-10] across:2
		button reqButton1 "No"        width:90 offset:[0,-10]

		on reqButton2 pressed do
		(
			DestroyDialog requester
			returnValue = 1
		)

		on reqButton1 pressed do
		(
			DestroyDialog requester
			returnValue = 0
		)
	)

	createDialog requester 380 85 modal:true
	
	return returnValue
)


function hvkDestruction_linkNewControllerInBlueprint node controller linkOrAdd =
(
	for modifier in node.modifiers do
	(
		if ( hkIsOfGenericModifierType modifier "hkdBody" ) then
		(
			if ( linkOrAdd == 1 OR modifier.controllerHkUnique == undefined ) then
			(
				-- Important: DO NOT change uppercase/lowercase for this custom attribute! This might break the exporter!
				modifier.controllerHkUnique = controller
			)
			return true
		)
	)
	return false
)


------------------------------------------------------------------------------
-- GLOBAL METHODS
------------------------------------------------------------------------------

function hvkDestruction_newControllerPreCheck controllerClassName windowTitle &linkFlagOut =
(
	if ( selection.count == 0 ) then
	(
		messageBox("Please select one or more Havok Breakable Bodies first.")
		return -1
	)

	sharedOrUnique = 0
	
	-- First we need to decide whether we want to share the new Controller or not (if more than one object is selected)
	if ( selection.count > 1 ) then
	(
		sharedOrUnique = hvkDestruction_createSharedController_Requester windowTitle
		if ( sharedOrUnique == 2 ) then
		(
			return -1
		)
	)

	-- This variabe will only be used if selection.count == 1
	existingControllerOfSameType = undefined

	-- Counts the total number of valid Breakable Bodies in the current selection
	numBreakableBodiesInSelection = 0

	-- Is set to true once we come across a Breakable Body whose controller link is already set
	atLeastOneControllerAlreadyLinkedInSelection = false
		
	for selectedObject in selection do
	(
		for modifier in selectedObject.modifiers do
		(
			if ( hkIsOfGenericModifierType modifier controllerClassName ) then
			(
				existingControllerOfSameType = modifier
			)
			if ( hkIsOfGenericModifierType modifier "hkdBody" ) then
			(
				numBreakableBodiesInSelection = numBreakableBodiesInSelection + 1
				
				if ( modifier.controllerHkUnique != undefined ) then
				(
					-- at least one Breakable Body has a controller already linked in, so we need to query the user.
					atLeastOneControllerAlreadyLinkedInSelection = true
				)
			)
		)
	)

	if ( numBreakableBodiesInSelection == 0 ) then
	(
		messageBox("Please select one or more Havok Breakable Bodies first.")
		return -1
	)

	if ( selection.count == 1 AND existingControllerOfSameType != undefined ) then
	(
		-- Exactly ONE object is selected and it already has a controller of the same type: display it...
		setCommandPanelTaskMode mode:#modify
		modPanel.setCurrentObject existingControllerOfSameType
		
		return -1
	)

	-- Default: Link-in the new Controller
	linkFlagOut = 0

	if ( atLeastOneControllerAlreadyLinkedInSelection == true ) then
	(
		-- Query the user whether he wants to replace the already existing Controller links in some of the selected
		-- objects or if the new Controller should only be added without linking.
		linkFlagOut = hvkDestruction_createController_LinkOr_add_Requester windowTitle
	)

	return sharedOrUnique
)


function hvkDestruction_createNewController controllerCtor sharedOrUnique linkFlag =
(
	if ( sharedOrUnique == 0 ) then
	(
		-- Unique
		
		for selectedObject in selection do
		(
			uniqueController = hvkDestruction_createGenericModifier selectedObject controllerCtor
			hvkDestruction_linkNewControllerInBlueprint selectedObject uniqueController linkFlag
		)

		setCommandPanelTaskMode mode:#modify
	)
	else
	(
		-- Shared
		
		sharedController = controllerCtor()
		
		for selectedObject in selection do
		(
			addModifier selectedObject sharedController

			hvkDestruction_linkNewControllerInBlueprint selectedObject sharedController linkFlag
		)

		setCommandPanelTaskMode mode:#modify
	)
)


