
------------------------------------------------------------------------------
-- EXTERNAL METHODS
------------------------------------------------------------------------------

global hvkDestruction_createGenericModifier


------------------------------------------------------------------------------
-- LOCAL METHODS
------------------------------------------------------------------------------

function hvkDestructionDialog_uniqueOrSharedAction reqTitle =
(
	global returnValue = -1
	
	rollout requester reqTitle
	(
		label _label1 "You can create individual Actions for all objects in the"         align:#left
		label _label2 "selection (UNIQUE) or you can create one single Action modifier"  align:#left
		label _label3 "that is being shared between all selected objects (SHARED)."      align:#left
		label _label4 ""
		
		button reqButton1 "Unique" width:80 across:3
		button reqButton2 "Shared" width:80
		button reqButton3 "Cancel" width:80
		
		on reqButton1 pressed do
		(
			DestroyDialog requester
			returnValue = 0
		)

		on reqButton2 pressed do
		(
			DestroyDialog requester
			returnValue = 1
		)

		on reqButton3 pressed do
		(
			DestroyDialog requester
			returnValue = 2
		)
	)

	createDialog requester 350 110 modal:true
	
	return returnValue
)


------------------------------------------------------------------------------
-- GLOBAL METHODS
------------------------------------------------------------------------------

function hvkDestruction_createNewAction actionCtor requesterTitle =
(
	--//
	--//  No node selected:
	--//  o create a dummy node
	--//  o add new Action modifier to dummy node
	--//  o switch to Action modifier
	--//
	if ( selection.count == 0 ) then
	(
		actionHelper           = dummy()
		actionHelper.boxsize.x = 0
		actionHelper.boxsize.y = 0
		actionHelper.boxsize.z = 0
		actionHelper.name      = uniqueName (actionCtor as string)

		hvkDestruction_createGenericModifier actionHelper actionCtor
		select(actionHelper)
		setCommandPanelTaskMode mode:#modify
	)
	else
	(
		creationType           = 0        --// 0 = unique, 1 = shared, 2 = cancel
		sharedActionModifier = undefined  --// This holds the shared Action modifier. 'Undefined' if user selects to create unique Action modifiers or if selection.count == 1.

		--// Only query for 'shared' if more than one node is in selection.
		if ( selection.count > 1 ) then
		(
			creationType = hvkDestructionDialog_uniqueOrSharedAction requesterTitle

			--// Share Fracture modifier.
			if ( creationType == 1 ) then
			(
				sharedActionModifier = actionCtor()
			)
			--// User abort...
			else if ( creationType == 2 ) then
			(
				return false
			)
		)

		--// Process all selected nodes/meshes.
		for node in selection do
		(
			--//
			--// Either create & add a new unique modifier or only add the shared modifier.
			--//
			if ( creationType == 0 ) then --// unique
			(
				hvkDestruction_createGenericModifier node actionCtor
			)
			else --// shared
			(
				addModifier node sharedActionModifier
			)
		)

		select selection[1]
		setCommandPanelTaskMode mode:#modify
	)
)
