--Auto generated by Visual MAXScript editor. Don't overwrite.

fileIn "havokConvexDecomp/ConvexDecompositionTools/hvkConvexDecomp_Common.ms"

global \
hvkConvexDecomp_View_UpdateUI,
hvkConvexDecomp_View_ToggleHide_Pressed,
hvkConvexDecomp_View_Hide_Pressed,
hvkConvexDecomp_View_Show_Pressed,
hvkConvexDecomp_View_Explode_Pressed,
hvkConvexDecomp_View_Contract_Pressed,
hvkConvexDecomp_View_UpdateExplodedNodes,
hvkConvexDecomp_View_UpdateExplodeValue,
hvkConvexDecomp_View_UpdateSelectedRange,
hvkConvexDecomp_View_SelectNeighbors_Pressed

rollout hvkConvexDecomp_View "View" width:194 height:254
(
	slider sldExplode "" pos:[16,86] width:170 height:25 range:[0,5,2]
	label lblExplode "Explode factor: 2.0" pos:[11,69] width:157 height:15
	button btnExplode "Explode hulls" pos:[12,124] width:97 height:23 toolTip:"Temporarily move hulls away from the group COM"
	button btnContract "Contract" pos:[118,124] width:65 height:23 toolTip:"Return exploded hulls to their original positions"
	button btnHide "Hide hulls" pos:[9,36] width:101 height:23 toolTip:"Hide hulls, show original meshes"
	button btnShow "Show" pos:[119,36] width:65 height:23 toolTip:"Show (and select) hulls, hide original meshes"
	slider sldNeighbors "" pos:[16,183] width:170 height:25 range:[0,100,0]
	button btnNeighbors "Select neighbors within range" pos:[12,217] width:171 height:23 toolTip:"Select neighbors within range of selected nodes (range as % of size of node group)"
	checkbox chkHideOriginalMesh "Hide original mesh on decompose" pos:[10,11] width:178 height:18 checked:true toolTip:"Automatically hide original mesh"
	groupBox grp1 "" pos:[6,153] width:183 height:94
	groupBox grp2 "" pos:[6,58] width:183 height:95
	label lblSelectedRange "1637200040f size of node group: 0" pos:[11,167] width:169 height:14

	on hvkConvexDecomp_View open do
		hvkConvexDecomp_View_OpenRollout()
	local explodeFactor
	on sldExplode changed explodeFactor do
		hvkConvexDecomp_View_UpdateExplodedNodes explodeFactor
	on btnHide pressed do
		hvkConvexDecomp_View_Hide_Pressed()
	on btnShow pressed do
		hvkConvexDecomp_View_Show_Pressed()
	on btnExplode pressed do
		hvkConvexDecomp_View_Explode_Pressed()
	on btnContract pressed do
		hvkConvexDecomp_View_Contract_Pressed()
	local selectedRange
	on sldNeighbors changed selectedRange do
		hvkConvexDecomp_View_UpdateSelectedRange selectedRange
	on btnNeighbors pressed do
		hvkConvexDecomp_View_SelectNeighbors_Pressed()
)

function hvkConvexDecomp_View_OpenRollout =
(
	if (undefined == hkConvexDecompUtility) then
	(
		hvkConvexDecomp_View.btnExplode.enabled = false
		hvkConvexDecomp_View.btnContract.enabled = false
		hvkConvexDecomp_View.btnHide.enabled = false
		hvkConvexDecomp_View.btnShow.enabled = false
		hvkConvexDecomp_View.btnNeighbors.enabled = false
	)
	else
	(
		hvkConvexDecomp_View_UpdateUI()

		callbacks.addScript #selectionSetChanged "hvkConvexDecomp_View_UpdateUI()" id:#HAVOK_CD_DEC
		callbacks.addScript #sceneUndo "hvkConvexDecomp_View_UpdateUI()" id:#HAVOK_CD_DEC
		callbacks.addScript #sceneRedo "hvkConvexDecomp_View_UpdateUI()" id:#HAVOK_CD_DEC	
	)	
)

function hvkConvexDecomp_View_UpdateUI =
(
	hvkConvexDecomp_View_UpdateExplodeValue()

	local selectedRange = hvkConvexDecomp_View.sldNeighbors.value as float
	hvkConvexDecomp_View_UpdateSelectedRange selectedRange
)

function hvkConvexDecomp_View_Hide_Pressed =
(
	local selectedNodes = $selection as Array

	local selectedMeshes = hvkConvexDecomp_getSelectedMeshes selectedNodes
	if (0 == selectedMeshes.count) then
	(
		return false
	)

	clearSelection()

	for mesh in selectedMeshes do
	(
		--access conves hulls via groupHead CA on original mesh
		local groupHeadCA = custAttributes.get mesh hvkConvexDecomp_ConvexHullGroupCAdef
		if (undefined != groupHeadCA) then
		(
			local groupHead = groupHeadCA.groupHead
			if (undefined != groupHead) then
			(
				--show original mesh and hide children
				hide groupHead.children

				hvkConvexDecomp_HideOriginalMesh mesh false
			)
		)
	)
	return true
)

function hvkConvexDecomp_View_Show_Pressed =
(
	local selectedNodes = $selection as Array

	local selectedMeshes = hvkConvexDecomp_getSelectedMeshes selectedNodes
	if (0 == selectedMeshes.count) then
	(
		return false
	)

	clearSelection()

	for mesh in selectedMeshes do
	(
		--access conves hulls via groupHead CA on original mesh
		local groupHeadCA = custAttributes.get mesh hvkConvexDecomp_ConvexHullGroupCAdef
		if (undefined != groupHeadCA) then
		(
			local groupHead = groupHeadCA.groupHead
			if (undefined != groupHead) then
			(
				--show hulls, hide original mesh
				unhide groupHead.children
				selectMore groupHead.children

				hvkConvexDecomp_HideOriginalMesh mesh true
			)
		)
	)
	return true
)

--If the user has selected some/all of the convex hulls from a mesh, expand all hulls for this mesh
function hvkConvexDecomp_View_Explode_Pressed =
(
	local selectedNodes = $selection as Array
	selectedNodes = hvkConvexDecomp_GetSelectedMeshes selectedNodes 
	if (0 == selectedNodes.count) then
	(
		return false
	)

	local explodeFactor = hvkConvexDecomp_View.sldExplode.value as float

	for node in selectedNodes do
	(
		local groupHeadCA = custAttributes.get node hvkConvexDecomp_ConvexHullGroupCAdef
		if (undefined != groupHeadCA) then
		(
			local groupHead = groupHeadCA.groupHead
			if (undefined != groupHead) then
			(
				if (undefined == custAttributes.get groupHead hvkConvexDecomp_ExplodeCAdef) then
				(
					custAttributes.add groupHead hvkConvexDecomp_ExplodeCAdef
					groupHead.hvkConvexDecomp_ExplodeCA.flag = false
					groupHead.hvkConvexDecomp_ExplodeCA.explodeFactor = 0
					groupHead.hvkConvexDecomp_ExplodeCA.nHulls = 0
				)

				if (false == groupHead.hvkConvexDecomp_ExplodeCA.flag or
					explodeFactor != groupHead.hvkConvexDecomp_ExplodeCA.explodeFactor or
					groupHead.hvkConvexDecomp_ExplodeCA.nHulls != groupHead.children.count) then
				(
					--have to recalculate com if the group of hulls was altered
					if (groupHead.hvkConvexDecomp_ExplodeCA.nHulls != groupHead.children.count) then
					(
						groupHead.hvkConvexDecomp_ExplodeCA.com = hvkConvexDecomp_CalcHullGroupCom groupHead.children
						groupHead.hvkConvexDecomp_ExplodeCA.nHulls = groupHead.children.count
					)

					local result = hvkConvexDecomp_ExplodeHulls groupHead.children groupHead.hvkConvexDecomp_ExplodeCA.com explodeFactor
					
					if (true == result) then
					(
						groupHead.hvkConvexDecomp_ExplodeCA.flag = true
						groupHead.hvkConvexDecomp_ExplodeCA.explodeFactor = explodeFactor
					)
				)
			)
		)
	)
)

function hvkConvexDecomp_View_Contract_Pressed =
(
	local selectedNodes = $selection as Array
	selectedNodes = hvkConvexDecomp_GetSelectedMeshes selectedNodes 
	if (0 == selectedNodes.count) then
	(
		return false
	)

	for node in selectedNodes do
	(
		local groupHeadCA = custAttributes.get node hvkConvexDecomp_ConvexHullGroupCAdef
		if (undefined != groupHeadCA) then
		(
			local groupHead = groupHeadCA.groupHead
			if (undefined != groupHead) then
			(
				local explodeCA = custAttributes.get groupHead hvkConvexDecomp_ExplodeCAdef
				if (undefined != explodeCA) then
				(
					if (true == explodeCA.flag) then
					(
						for child in groupHead.children do
						(
							child.pos = child.hvkConvexDecomp_TransformCA.originalTransform
						)

						explodeCA.flag = false
					)
				)
			)
		)
	)
	return true
)

function hvkConvexDecomp_View_UpdateExplodeValue =
(
	local selectedNodes = $selection as Array
	selectedNodes = hvkConvexDecomp_GetSelectedMeshes selectedNodes 
	if (0 == selectedNodes.count) then
	(
		return false
	)

	for node in selectedNodes do
	(
		local groupHeadCA = custAttributes.get node hvkConvexDecomp_ConvexHullGroupCAdef
		if (undefined != groupHeadCA) then
		(
			local groupHead = groupHeadCA.groupHead
			if (undefined != groupHead) then
			(
				local explodeCA = custAttributes.get groupHead hvkConvexDecomp_ExplodeCAdef
				if (undefined != explodeCA and explodeCA.explodeFactor != 0) then
				(
					hvkConvexDecomp_View.sldExplode.value = explodeCA.explodeFactor
					
					str = "Explode factor: "
					str += explodeCA.explodeFactor as string
					hvkConvexDecomp_View.lblExplode.caption = str
					
					--Multiple selected nodes may currently have different explode factors, but is simplest to take that of first one
					return true	
				)
			)
		)
	)
)

function hvkConvexDecomp_View_UpdateExplodedNodes explodefactor =
(
	str = "Explode factor: "
	str += explodeFactor as string
	hvkConvexDecomp_View.lblExplode.caption = str

	hvkConvexDecomp_View_Explode_Pressed();
)

function hvkConvexDecomp_View_UpdateSelectedRange selectedRange =
(
	str = "% size of node group: "
	str += selectedRange as string
	hvkConvexDecomp_View.lblSelectedRange.caption = str
)

--Select neighboring nodes of that selected
function hvkConvexDecomp_View_SelectNeighbors_Pressed =
(
	local range = hvkConvexDecomp_View.sldNeighbors.value as float
	local selectedNodes = $selection as Array
	
	range = range * 1.5 * 0.01;

	undo "select neighbors" on
	(
		for node in selectedNodes do
		(
			nodeCA = custAttributes.get node hvkConvexDecomp_OrigMeshCAdef
			if (undefined != nodeCA) then
			(
				local parentMeshNode = nodeCA.mesh
				if (undefined != parentMeshNode) then
				(
					--access conves hulls via groupHead CA on original mesh
					local groupHeadCA = custAttributes.get parentMeshNode hvkConvexDecomp_ConvexHullGroupCAdef
					if (undefined != groupHeadCA) then
					(
						local groupHead = groupHeadCA.groupHead
						if (undefined != groupHead) then
						(
							local Point3 selectedHullPos = node.pos
							local Point3 otherHullPos
							
							local origMeshScale = parentMeshNode.hvkConvexDecomp_OrigMeshScaleCA.scale
							origMeshScale = range * origMeshScale
	
							for child in groupHead.children do
							(
								otherHullPos = child.pos
	
								local dist = abs( selectedHullPos.x - otherHullPos.x ) + abs( selectedHullPos.y - otherHullPos.y ) + abs( selectedHullPos.z - otherHullPos.z )
	
								if (dist < origMeshScale) then
								(
									selectMore child
								)
							)
						)
					)
				)
			)
		)
	)
	return true
)



