--Auto generated by Visual MAXScript editor. Don't overwrite.

fileIn "havokConvexDecomp/ConvexDecompositionTools/hvkConvexDecomp_Common.ms"
fileIn "havokConvexDecomp/ConvexDecompositionTools/hvkConvexDecomp_View.ms"

global \
hvkConvexDecomp_Combine_OpenRollout,
hvkConvexDecomp_Combine_CloseRollout,
hvkConvexDecomp_Combine_SelectionUpdatedCallback,
hvkConvexDecomp_Combine_UndoRedoCallback,
hvkConvexDecomp_Combine_UpdateUI,
hvkConvexDecomp_Combine_Pressed,
hvkConvexDecomp_Combine_UpdateCombineControls,
hvkConvexDecomp_Combine_GetOrigMeshFromNodes,
hvkConvexDecomp_Combine_UpdateCombineText,
hvkConvexDecomp_Combine_UpdateCombineText_sld,
hvkConvexDecomp_Combine_UpdateCombineText_edt,
hvkConvexDecomp_Combine_CanCombine,
hvkConvexDecomp_Combine_GetOrigMeshNodes,
hvkConvexDecomp_Combine_AbsoluteAccuracy,
hvkConvexDecomp_Combine_PercentageAccuracy,
hvkConvexDecomp_Combine_GetOctreeDepth

rollout hvkConvexDecomp_Combine "Combine convex shapes" width:194 height:177
(
	label lblAccuracy "" pos:[9,42] width:175 height:18
	label lblAccuracyType "Max error" pos:[9,97] width:74 height:16
	radioButtons rdoAccuracyMode "Accuracy mode:" pos:[9,6] width:175 height:30 labels:#("Tolerance", "Hull count") default:1 columns:2 toolTip:"Contol combining of hulls by hull count or by max error"
	button btnCombine "Combine" pos:[9,148] width:175 height:23 toolTip:"Combine selected hulls based on specified limits"
	slider sldAccuracy "" pos:[9,60] width:182 height:25 range:[0,100,0]
	editText edtAccuracy "" pos:[90,97] width:94 height:17
	label lblOctree "Fix open meshes" pos:[9,123] width:90 height:16
	dropDownList ddlCombineOctree "" pos:[94,121] width:92 height:21 items:#("don't fix", "fastest", "medium", "best")

	on hvkConvexDecomp_Combine open do
		hvkConvexDecomp_Combine_OpenRollout()
	on hvkConvexDecomp_Combine close do
		hvkConvexDecomp_Combine_CloseRollout()
	on btnCombine pressed do
		hvkConvexDecomp_Combine_Pressed()
	on rdoAccuracyMode changed radioMode do
		hvkConvexDecomp_Combine_UpdateCombineControls radioMode
	on sldAccuracy changed combineAccuracy_sld do
		hvkConvexDecomp_Combine_UpdateCombineText_sld combineAccuracy_sld
	on edtAccuracy changed combineAccuracy_edt do
		hvkConvexDecomp_Combine_UpdateCombineText_edt combineAccuracy_edt
)

function hvkConvexDecomp_Combine_OpenRollout =
(
	if (undefined == hkConvexDecompUtility) then
	(
		hvkConvexDecomp_Combine.btnCombine.enabled = false
	)
	else
	(
		hvkConvexDecomp_Combine_AbsoluteAccuracy = 0.5
		hvkConvexDecomp_Combine_PercentageAccuracy = 80

		hvkConvexDecomp_Combine_UpdateCombineControls 1

		callbacks.addScript #selectionSetChanged "hvkConvexDecomp_Combine_SelectionUpdatedCallback()" id:#HAVOK_CD_CMB
		callbacks.addScript #sceneUndo "hvkConvexDecomp_Combine_UndoRedoCallback()" id:#HAVOK_CD_CMB
		callbacks.addScript #sceneRedo "hvkConvexDecomp_Combine_UndoRedoCallback()" id:#HAVOK_CD_CMB

		hvkConvexDecomp_Combine_UpdateUI();
	)
)

function hvkConvexDecomp_Combine_CloseRollout =
(
	callbacks.removeScripts id:#HAVOK_CD_CMB
)

function hvkConvexDecomp_Combine_SelectionUpdatedCallback =
(
	hvkConvexDecomp_Combine_UpdateUI()
)

function hvkConvexDecomp_Combine_UndoRedoCallback =
(
	hvkConvexDecomp_Combine_UpdateUI()
)

global hvkConvexDecomp_Combine_Flag_DontUpdate = 0

function hvkConvexDecomp_Combine_UpdateUI =
(
	if (0 == hvkConvexDecomp_Combine_Flag_DontUpdate) then
	(
		local canCombine = hvkConvexDecomp_Combine_CanCombine()

		hvkConvexDecomp_Combine.btnCombine.enabled = canCombine
		hvkConvexDecomp_Combine.rdoAccuracyMode.enabled = canCombine
		hvkConvexDecomp_Combine.sldAccuracy.enabled = canCombine
		hvkConvexDecomp_Combine.edtAccuracy.enabled = canCombine
		hvkConvexDecomp_Combine.lblAccuracy.visible = canCombine
		hvkConvexDecomp_Combine.lblAccuracyType.visible = canCombine
		hvkConvexDecomp_Combine.lblOctree.visible = canCombine
		hvkConvexDecomp_Combine.ddlCombineOctree.enabled = canCombine

		hvkConvexDecomp_Combine_UpdateCombineText_sld hvkConvexDecomp_Combine.sldAccuracy.value as float
	)
)

function hvkConvexDecomp_Combine_Pressed = 
(
	local inputNodes = $selection as Array

	local outputNodes = #()

	local accuracyCombine = hvkConvexDecomp_Combine.sldAccuracy.value as float
	local singleOutCombine = false
	local genGuards
	if (1 == hvkConvexDecomp_Combine.rdoAccuracyMode.state) then
	(
		genGuards = true
	)
	else
	(
		genGuards = false
	)

	local octreeDepth = hvkConvexDecomp_Combine_GetOctreeDepth()
	local reduceMethod = hvkConvexDecomp_DecomposeAdv_GetReduceMethod()

	hvkConvexDecomp_View_Contract_Pressed()

	hvkConvexDecomp_Combine_Flag_DontUpdate = 1

	local status
	undo "Combine shapes" on
	(
		local origMesh = hvkConvexDecomp_Combine_GetOrigMeshFromNodes inputNodes
		if (undefined == origMesh) then
		(
			status = false
		)
		else
		(
			local outputHead = inputNodes[1].parent
			local origMeshNodes = #()
			status = hvkConvexDecomp_Combine_GetOrigMeshNodes origMesh &origMeshNodes

			if (status == true) then
			(
				status = hkConvexDecompUtility.doCombine origMesh origMeshNodes inputNodes &outputNodes accuracyCombine singleOutCombine genGuards octreeDepth reduceMethod
				if (status == true) then
				(
					select outputNodes

					status = hvkConvexDecomp_ConnectNewNodes origMesh &outputNodes
					if (true == status) then
					(
						status = hvkConvexDecomp_SetHullTransforms origMesh outputNodes
						
						if ( hvkConvexDecomp_DecomposeAdv.chkAddShapeModifier.checked == true ) then
						(
							for node in outputNodes do
							(
								hvkPhysics_createShape node
							)
						)
					)
				)
			)
		)
	)

	redrawViews()

	hvkConvexDecomp_Combine_Flag_DontUpdate = 0
	hvkConvexDecomp_Combine_UpdateUI()

	return status
)

function hvkConvexDecomp_Combine_GetOrigMeshFromNodes nodes =
(
	if (nodes.count == 0) then
	(
		return undefined
	)

	local origMeshCA = custAttributes.get nodes[1] hvkConvexDecomp_OrigMeshCAdef
	if (undefined == origMeshCA) then
	(
		return undefined
	)

	return origMeshCA.mesh
)

--Update text of combine accuracy labels
function hvkConvexDecomp_Combine_UpdateCombineText combineAccuracy = 
(
	local radioMode = hvkConvexDecomp_Combine.rdoAccuracyMode.state

	if (1 == radioMode) then
	(
		hvkConvexDecomp_Combine.lblAccuracy.caption = "Accepted tolerance"
		hvkConvexDecomp_Combine.lblAccuracyType.caption = "Max error:"

		--update accuracy for next time radio button is switches
		hvkConvexDecomp_Combine_AbsoluteAccuracy = combineAccuracy
	)
	else
	(
		hvkConvexDecomp_Combine_PercentageAccuracy = combineAccuracy

		local selectedPieces = $selection as Array
		i = 1
		while (i <= selectedPieces.count) do
		(
			if (not canConvertTo selectedPieces[i] Editable_mesh) then
			(
				deleteItem selectedPieces i
			)
			else
			(
				i += 1
			)
		)

		local nSelected = selectedPieces.count as integer
		local nOut
		if (0 == nSelected) then
		(
			nOut = 0
		)
		else
		(
			nOut = ((combineAccuracy * nSelected) / 100 + 0.5) as integer
			if (nOut == 0) then
			(
				nOut = 1
			)
		)

		hvkConvexDecomp_Combine.lblAccuracy.caption = "Combine " + nSelected as string + " hulls into " + nOut as string
		hvkConvexDecomp_Combine.lblAccuracyType.caption = "% of original:"
	)
)

function hvkConvexDecomp_Combine_UpdateCombineText_sld combineAccuracy_sld = 
(
	hvkConvexDecomp_Combine.edtAccuracy.text = combineAccuracy_sld as string

	hvkConvexDecomp_Combine_UpdateCombineText combineAccuracy_sld
)

function hvkConvexDecomp_Combine_UpdateCombineText_edt combineAccuracy_edt = 
(
	local accuracy = combineAccuracy_edt as float
	
	if (undefined == accuracy) then
	(
		hvkConvexDecomp_Combine.edtAccuracy.text = hvkConvexDecomp_Combine.sldAccuracy.value as string
	)
	else
	(		
		local Point3 range = hvkConvexDecomp_Combine.sldAccuracy.range
	
		if (accuracy < range.x) then
		(
			accuracy = range.x
			hvkConvexDecomp_Combine.edtAccuracy.text = accuracy as string
		)
		if (accuracy > range.y) then
		(
			accuracy = range.y
			hvkConvexDecomp_Combine.edtAccuracy.text = accuracy as string
		)
	
		hvkConvexDecomp_Combine.sldAccuracy.value = accuracy
	
		hvkConvexDecomp_Combine_UpdateCombineText accuracy
	)
)

--Update parameters of combine accuracy controls and update text
function hvkConvexDecomp_Combine_UpdateCombineControls radioMode =
(
	if (1 == radioMode) then
	(
		hvkConvexDecomp_Combine.sldAccuracy.range = [0,5,hvkConvexDecomp_Combine_AbsoluteAccuracy]
		hvkConvexDecomp_Combine.sldAccuracy.ticks = 10
	)
	else
	(
		hvkConvexDecomp_Combine.sldAccuracy.range = [0,100,hvkConvexDecomp_Combine_PercentageAccuracy]
		hvkConvexDecomp_Combine.sldAccuracy.ticks = 10
	)

	local combineAccuracy_sld = hvkConvexDecomp_Combine.sldAccuracy.value as float
	hvkConvexDecomp_Combine_UpdateCombineText_sld combineAccuracy_sld
)

function hvkConvexDecomp_Combine_CanCombine =
(
	local selectedPieces = $selection as Array
	local nSelected = selectedPieces.count as integer

	if nSelected < 2 then
	(
		return false
	)
	
	local commonParent
	local isParentSet = false

	for node in selectedPieces do
	(
		if (not canConvertTo node Editable_mesh) then 
		(
			return false
		)
		if (undefined != custAttributes.get node hvkConvexDecomp_IsDecomposedCAdef or undefined == custAttributes.get node hvkConvexDecomp_OrigMeshCAdef) then
		(
			return false
		)
		
		if (false == isParentSet) then
		(
			local origMeshCA = custAttributes.get node hvkConvexDecomp_OrigMeshCAdef
			commonParent = origMeshCA.mesh
			isParentSet = true
		)
		else
		(
			local origMeshCA = custAttributes.get node hvkConvexDecomp_OrigMeshCAdef
			local thisParent = origMeshCA.mesh
			if (commonParent != thisParent) then
			(
				return false
			)
		)
	)
	return true
)

function hvkConvexDecomp_Combine_GetOrigMeshNodes origMesh &origMeshNodes = 
(
	if (not isGroupHead origMesh) then
	(
		if (not canConvertTo origMesh Editable_mesh) then
		(
			return false
		)

		append origMeshNodes origMesh
		return true
	)
	else
	(
		if (0 == origMesh.children.count)then
		(
			return false
		)

		local stack = #()
		append stack origMesh

		while (0 != stack.count) do
		(
			local children = stack[stack.count].children
			deleteItem stack stack.count

			if (0 == children.count) then
			(
				return false
			)

			for child in children do
			(
				if (isGroupHead child) then
				(
					append stack child
				)
				else
				(
					if (canConvertTo child Editable_mesh) then
					(
						if (undefined != custAttributes.get child hvkConvexDecomp_IsDecomposedCAdef) then
						(
							return false
						)
						else
						(
							append origMeshNodes child
						)
					)
				)
			)
			--node has been popped from stack
		)
		return true
	)
)

function hvkConvexDecomp_Combine_GetOctreeDepth =
(
	local text = hvkConvexDecomp_Combine.ddlCombineOctree.selected

	if text == "fastest" then
	(
		return 2;
	)
	else if text == "medium" then
	(
		return 4;
	)
	else if text == "best" then
	(
		return 7;
	)
	else
	(
		return 0;
	)	
)





