// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Max/MaxSceneExport/resource.h>

#include <ContentTools/Max/MaxSceneExport/hctMaxIncludes.h>

#include <ContentTools/Max/MaxFpInterfaces/Physics/Objects/TaperedCapsule/hctTaperedCapsuleObjectInterface.h>

class TaperedCapsuleObjCreateCallBack;

class hctTaperedCapsuleObject : public SimpleObject2
{
    friend class TaperedCapsuleObjCreateCallBack; // To access protected member, pblock2

    public:
        // Class vars
        static IObjParam* m_interface;


        //hctTaperedCapsuleObject(ClassDesc2* theClassDesc);
        hctTaperedCapsuleObject(BOOL loading);

        CreateMouseCallBack* GetCreateMouseCallBack();
        void BeginEditParams( IObjParam  *ip, ULONG flags, Animatable *prev);
        void EndEditParams( IObjParam *ip, ULONG flags, Animatable *next);
        RefTargetHandle Clone(RemapDir& remap);

        //// From Object
        int CanConvertToType(Class_ID obtype);
        Object* ConvertToType(TimeValue t, Class_ID obtype);
        void GetCollapseTypes(Tab<Class_ID> &clist, Tab<MSTR*> &nlist);

        // From GeomObject
        int IntersectRay(TimeValue t, Ray& ray, float& at, Point3& norm);

        // Animatable methods

        void DeleteThis() {delete this;}

        int NumParamBlocks() { return 1; }                  // return number of ParamBlocks in this instance
        IParamBlock2* GetParamBlock(int i) { return pblock2; } // return i'th ParamBlock
        IParamBlock2* GetParamBlockByID(BlockID id) { return (pblock2->ID() == id) ? pblock2 : NULL; } // return id'd ParamBlock

        //From Animatable
        /*virtual*/ Class_ID ClassID() { return HK_TAPEREDCAPSULE_CLASS_ID;}
        /*virtual*/ CONST15 MCHAR *GetObjectName() { return GetString(IDS_TAPEREDCAPSULE_OBJECT_NAME); }
        /*virtual*/ void GetClassName(MSTR& s) { s = GetString(IDS_TAPEREDCAPSULE_CLASS_NAME);}

        // From SimpleObject
        void BuildMesh(TimeValue t);
        BOOL OKtoDisplay(TimeValue t);
        void InvalidateUI();
        void UpdateUI();
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
