// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>
#include <ContentTools/Max/MaxSceneExport/Modifiers/hctBasicModifier.h>
#include <icustattribcontainer.h>

/*
   TODO: Adam.Yaxley, Chris.Keogh
   The following preprocessor pragmas simply place the initialisation code for this
   compilation unit at the start of the program. This is used here only TEMPORARILY
   to fix the crash that is associated with the order of static destructors.

   The problem is that the static variable g_comboBoxHandlerDlgProc is being
   destructed before the static ParamBlockDesc2 objects are, which cause invalid
   accesses or (pure virtual calls) in this case which probably happens when the
   ParamBlockDesc2 object tries to call DeleteThis in hkComboBoxHandlerDlgProc, but
   this is only a guess.

   A possible solution is to set the UserDlgProc of each ParamBlockDesc2 object to
   NULL when the static g_comboBoxHandlerDlgProc is destroyed.

   Another solution is to make sure that the g_comboBoxHandlerDlgProc is destructed
   after the ParamBlockDesc2 objects.
*/

#pragma warning(disable:4074)
#pragma init_seg(compiler)

IObjParam* hctBasicModifier::m_interface = NULL;
MoveModBoxCMode* hctBasicModifier::m_moveMode = NULL;
RotateModBoxCMode* hctBasicModifier::m_rotateMode = NULL;
NUScaleModBoxCMode* hctBasicModifier::m_scaleMode = NULL;

// You can use this default dlgProc if you don't need to do any other processing
class hkComboBoxHandlerDlgProc : public ParamMap2UserDlgProc
{
    public:

        hkComboBoxHandlerDlgProc (hctBasicModifier* theModifier) { m_theModifier = theModifier; }

        INT_PTR DlgProc(TimeValue t, IParamMap2 *pmap, HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
        {
            if (m_theModifier)
            {
                return m_theModifier->handleComboBoxMessages(hWnd, msg, wParam, lParam);
            }
            else
            {
                return FALSE;
            }
        }

        /*virtual*/ void DeleteThis() { } // Nothing, we use a static instance

        void SetThing (ReferenceTarget* m)
        {
            m_theModifier = (hctBasicModifier*) m;
        }

    protected:

        hctBasicModifier *m_theModifier;
};

static hkComboBoxHandlerDlgProc g_comboBoxHandlerDlgProc (NULL);

const ParamMap2UserDlgProc* hctBasicModifier::getComboBoxHandlerDlgProc()
{
    return &g_comboBoxHandlerDlgProc;
}


//Constructor/Destructor
hctBasicModifier::hctBasicModifier(ClassDesc2* theClassDesc)
:  m_classDesc(theClassDesc), m_updatingParamsFromComboBoxes(false), m_updatingComboBoxesFromParams(false)
{
    theClassDesc->MakeAutoParamBlocks(this);
}

hctBasicModifier::~hctBasicModifier()
{

}

void hctBasicModifier::getSubobjectTransform (int subobjId, TimeValue t, INode* node, Matrix3& transformOut)
{
    // default
    transformOut = node->GetNodeTM(t);
}

void hctBasicModifier::BeginEditParams( IObjParam *ip, ULONG flags,Animatable *prev )
{
    this->m_interface = ip;

    m_moveMode = new MoveModBoxCMode(this,ip);
    m_scaleMode = new NUScaleModBoxCMode(this,ip);
    m_rotateMode = new RotateModBoxCMode(this,ip);

    TimeValue t = ip->GetTime();
    NotifyDependents(Interval(t,t), PART_ALL, REFMSG_BEGIN_EDIT);
    NotifyDependents(Interval(t,t), PART_ALL, REFMSG_MOD_DISPLAY_ON);
    SetAFlag(A_MOD_BEING_EDITED);

    m_lastSelectedSubobjectID = -1;

    m_classDesc->BeginEditParams(ip, this, flags, prev);
    Modifier::BeginEditParams(ip, flags, prev);

    /* Fill Combo Boxes */
    fillComboBoxes();

    /* Update the state of controls */
    updateUI();

    g_comboBoxHandlerDlgProc.SetThing(this);

}

void hctBasicModifier::EndEditParams( IObjParam *ip, ULONG flags,Animatable *next)
{
    if (m_moveMode)
    {
        ip->DeleteMode(m_moveMode);
        delete m_moveMode;
        m_moveMode=NULL;
    }

    if (m_scaleMode)
    {
        ip->DeleteMode(m_scaleMode);
        delete m_scaleMode;
        m_scaleMode=NULL;
    }

    if (m_rotateMode)
    {
        ip->DeleteMode(m_rotateMode);
        delete m_rotateMode;
        m_rotateMode=NULL;
    }

    g_comboBoxHandlerDlgProc.SetThing(NULL);

    Modifier::EndEditParams(ip,flags,next);
    m_classDesc->EndEditParams(ip, this, flags, next);

    TimeValue t = ip->GetTime();
    ClearAFlag(A_MOD_BEING_EDITED);
    NotifyDependents(Interval(t,t), PART_ALL, REFMSG_END_EDIT);
    NotifyDependents(Interval(t,t), PART_ALL, REFMSG_MOD_DISPLAY_OFF);

    m_lastSelectedSubobjectID = -1;

    this->m_interface = NULL;

}


void hctBasicModifier::setClassDesc2(ClassDesc2* classDesc)
{
    m_classDesc = classDesc;
}


/*
** Subobject handling
*/
int hctBasicModifier::subobjectLevelToID (int subobjLevel)
{
    // Level 0 = node (no subobject)
    if (subobjLevel==0)
    {
        return -1;
    }

    const int totalIds = getNumSubobjects();
    int levels = 0;

    for (int id=0; id<totalIds; id++)
    {
        if (isSubobjectEnabled(id))
        {
            levels++;
        }
        if (levels==subobjLevel)
        {
            return id;
        }
    }

    return -1;
}

int hctBasicModifier::subobjectIDToLevel (int subobjId)
{
    int level = 0;

    for (int id=0; id<=subobjId; id++)
    {
        if (isSubobjectEnabled(id))
        {
            level++;
        }
    }

    return level;
}

// Gets the ID of the subobject currently selected
int hctBasicModifier::getCurrentSubobjectID ()
{
    int currentLevel = m_interface->GetSubObjectLevel();

    return subobjectLevelToID(currentLevel);

}

// Updates the subobject list in the interface
void hctBasicModifier::updateSubobjects()
{
        if (m_lastSelectedSubobjectID<0 || !isSubobjectEnabled(m_lastSelectedSubobjectID))
        {
            m_interface->SetSubObjectLevel(0, TRUE);
        }

        NotifyDependents(FOREVER, PART_SELECT, REFMSG_CHANGE);
        NotifyDependents(FOREVER, (PartID) this, REFMSG_BRANCHED_HISTORY_CHANGED);

        // Restore the current subobject if it's still enabled
        if (m_lastSelectedSubobjectID>=0 && isSubobjectEnabled(m_lastSelectedSubobjectID))
        {
            m_interface->SetSubObjectLevel(subobjectIDToLevel(m_lastSelectedSubobjectID), TRUE);
        }
        else
        {
            m_interface->SetSubObjectLevel(0, TRUE);
        }

}

// Selects the given subobject ID
void hctBasicModifier::selectSubobjectByID (int subobjId)
{
    if (isSubobjectEnabled(subobjId))
    {
        m_interface->SetSubObjectLevel(subobjectIDToLevel(subobjId));
    }
}


int hctBasicModifier::NumSubObjTypes()
{
    const int totalIds = getNumSubobjects();

    int totalEnabled = 0;

    for (int id=0; id<totalIds; id++)
    {
        if (isSubobjectEnabled(id))
        {
            totalEnabled++;
        }
    }

    return totalEnabled;
}

ISubObjType *hctBasicModifier::GetSubObjType(int i)
{
    const int subobjLevel = i+1;
    const int subobjId = subobjectLevelToID(subobjLevel);

    return getSubobjectTypeByID(subobjId);

}

void hctBasicModifier::ActivateSubobjSel(int level, XFormModes& modes )
{
    const int subobjId = subobjectLevelToID(level);

    m_lastSelectedSubobjectID = subobjId;

    const bool canMove = canSubobjectMove(subobjId);
    const bool canRotate = canSubobjectRotate(subobjId);
    const bool canScale = canSubobjectScale(subobjId);

    CommandMode* moveMode = canMove ? m_moveMode : NULL;
    CommandMode* rotateMode = canRotate ? m_rotateMode : NULL;
    CommandMode* scaleMode = canScale ? m_scaleMode : NULL;

    modes = XFormModes(moveMode,rotateMode,scaleMode,scaleMode,scaleMode,NULL);

    NotifyDependents(FOREVER,PART_DISPLAY,REFMSG_CHANGE);
}


void hctBasicModifier::GetSubObjectTMs(SubObjAxisCallback *cb, TimeValue t,INode *node, ModContext *mc)
{
    const int subobjId = getCurrentSubobjectID();

    if (subobjId>=0)
    {
        Matrix3 tm;
        getSubobjectTransform(subobjId, t, node, tm);
        cb->TM(tm, 0);
    }
}

void hctBasicModifier::GetSubObjectCenters(SubObjAxisCallback *cb,TimeValue t,INode *node, ModContext *mc)
{
    const int subobjId = getCurrentSubobjectID();

    if (subobjId>=0)
    {
        Matrix3 tm;
        getSubobjectTransform(subobjId, t, node, tm);
        cb->Center(tm.GetTrans(), 0);
    }
}

/*
** COMBO BOX HANDLING
*/

void hctBasicModifier::fillComboBoxes()
{
    if (!m_interface) return;

    const int numComboBoxes = getNumComboBoxes();

    for (int i=0; i<numComboBoxes; i++)
    {
        ComboBoxDescriptor* comboBox = getComboBoxDescriptor(i);

        IParamBlock2* pblock = GetParamBlock(comboBox->getParamBlockID());

        MapID mapID = comboBox->getParamMapID();
        IParamMap2* pmap = pblock->GetMap(mapID);

        HWND dlgWnd = pmap->GetHWnd();

        if (!dlgWnd) continue;

        HWND comboBoxWnd = GetDlgItem(dlgWnd, comboBox->getControlID());

        SendMessage (comboBoxWnd, CB_RESETCONTENT, 0,0);

        HCT_SCOPED_CONVERSIONS;

        for (int element=0; element< comboBox->getNumElements(); element++)
        {
            const char* str = comboBox->getElementString(element);

            SendMessage (comboBoxWnd, CB_ADDSTRING, 0, (LPARAM) TO_WINDOWS(str));
        }

        updateComboBoxFromParam(i);
    }
}

void hctBasicModifier::updateComboBoxFromParam(int comboBoxId)
{
    if (!m_interface) return;

    // Do not recurse
    if (m_updatingParamsFromComboBoxes) return;

    const TimeValue now = m_interface->GetTime();

    ComboBoxDescriptor* comboBox = getComboBoxDescriptor(comboBoxId);

    IParamBlock2* pblock = GetParamBlock(comboBox->getParamBlockID());
    ParamID param = comboBox->getParamID();

    MapID mapid = comboBox->getParamMapID();
    IParamMap2* pmap = pblock->GetMap(mapid);

    if (!pmap) return;

    HWND dlgWnd = pmap->GetHWnd();

    if (!dlgWnd) return;

    HWND comboBoxWnd = GetDlgItem(dlgWnd, comboBox->getControlID());

    int selectedValue = pblock->GetInt(param, now);

    // look for the item with that value
    int selectedItem = -1;
    for (int element=0; element<comboBox->getNumElements(); element++)
    {
        if (comboBox->getElementValue(element)==selectedValue)
        {
            selectedItem = element;
            break;
        }
    }

    // Update combo box
    m_updatingComboBoxesFromParams = true;
    {
        LRESULT currentSelectedItem = SendMessage(comboBoxWnd, CB_GETCURSEL, 0, 0);

        if (currentSelectedItem != selectedItem)
        {
            SendMessage(comboBoxWnd, CB_SETCURSEL, (WPARAM) selectedItem, 0);
        }
    }
    m_updatingComboBoxesFromParams = false;

}

void hctBasicModifier::updateParamFromComboBox (int comboBoxId)
{
    if (!m_interface) return;

    // Do not recurse
    if (m_updatingComboBoxesFromParams) return;

    const TimeValue now = m_interface->GetTime();

    ComboBoxDescriptor* comboBox = getComboBoxDescriptor(comboBoxId);

    IParamBlock2* pblock = GetParamBlock(comboBox->getParamBlockID());
    ParamID param = comboBox->getParamID();

    MapID mapid = comboBox->getParamMapID();
    IParamMap2* pmap = pblock->GetMap(mapid);

    if (!pmap) return;

    HWND dlgWnd = pmap->GetHWnd();

    if (!dlgWnd) return;

    HWND comboBoxWnd = GetDlgItem(dlgWnd, comboBox->getControlID());

    int currentValue = pblock->GetInt(param, now);

    LRESULT currentSelectedItem = SendMessage(comboBoxWnd, CB_GETCURSEL, 0, 0);

    LRESULT newValue = comboBox->getElementValue( int(currentSelectedItem) );

    if (newValue!=currentValue)
    {
        m_updatingParamsFromComboBoxes = true;
        BEGIN_UNDOABLE_ACTION
            pblock->SetValue(param, now, int(newValue) );
        END_UNDOABLE_ACTION(GetString(IDS_BASIC_MODIFIER_ACTION_PARAMETER_CHANGE))
        m_updatingParamsFromComboBoxes = false;
    }
}

BOOL hctBasicModifier::handleComboBoxMessages (HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
    if (!m_interface) return FALSE;

    // Do not recurse
    if (m_updatingComboBoxesFromParams) return FALSE;

    int notification = HIWORD (wParam);
    int controlID = LOWORD (wParam);

    if (notification != CBN_SELCHANGE) return FALSE;

    const int numComboBoxes = getNumComboBoxes();

    for (int c=0; c<numComboBoxes; c++)
    {
        ComboBoxDescriptor* comboBox = getComboBoxDescriptor(c);

        if (controlID == comboBox->getControlID())
        {
            updateParamFromComboBox(c);
        }
    }

    return FALSE;
}



/*
** Display
*/

int hctBasicModifier::HitTest(TimeValue t, INode* inode, int type, int crossing, int flags, IPoint2 *p, ViewExp *vpt, ModContext* mc)
{
    return 0;
}

// Returns the overall scale of the display
/*virtual*/ float hctBasicModifier::getScaleDisplay(TimeValue t, INode* inode, ViewExp* vpt)
{
    const Point3 worldPoint = inode->GetNodeTM(t).GetTrans();

    return getScaleDisplay(worldPoint, vpt);
}

/*virtual*/ float hctBasicModifier::getScaleDisplay(const Point3& posWorld, ViewExp* vpt)
{
    const float uniformScale = vpt->NonScalingObjectSize();
    const float scale = vpt->GetVPWorldWidth(posWorld) * 0.2f * uniformScale;

    return scale;
}


void hctBasicModifier::ModifyObject(TimeValue t, ModContext &mc, ObjectState * os, INode *node)
{
    const int numXTCObjects = getNumXTCObjects();

    for (int i=0; i<numXTCObjects; ++i)
    {
        hctBasicXTCObject* xtcObject = getXTCObject(i,t,mc,os,node);
        if (xtcObject)
        {
            os->obj->AddXTCObject(xtcObject);
            os->obj->SetChannelValidity(EXTENSION_CHAN_NUM, FOREVER);
        }
    }
}

// Neil Hazzard's clever approach to surviving a stack collapse:
void hctBasicModifier::NotifyPreCollapse(INode *node, IDerivedObject *derObj, int index)
{
    // Here we would backup any local mod data. But there is none.
}

// We want to survive a collapsed stack so we reapply ourselves here
void hctBasicModifier::NotifyPostCollapse(INode *node,Object *obj, IDerivedObject *derObj, int index)
{
    Object *bo = node->GetObjectRef();
    IDerivedObject *derob = NULL;
    if(bo->SuperClassID() != GEN_DERIVOB_CLASS_ID)
    {
        derob = CreateDerivedObject(obj);
        node->SetObjectRef(derob);
    }
    else
    {
        derob = (IDerivedObject*) bo;
    }

    // Add ourselves to the top of the stack
    derob->AddModifier(this,NULL,derob->NumModifiers());

    // When collapsing some Custom Attributes sitting on original modifiers might get
    // replicated on the base object (e.g. after a boolean operation). We will remove
    // them manually again.
    ICustAttribContainer* reattachingModifierCustomAttributeContainer = GetCustAttribContainer();
    ICustAttribContainer* baseObjectCustomAttributeContainer          = obj->GetCustAttribContainer();

    // Only check for replicates if both objects actually have Custom Attributes attached.
    if ( reattachingModifierCustomAttributeContainer && baseObjectCustomAttributeContainer )
    {
        for (int i = baseObjectCustomAttributeContainer->GetNumCustAttribs()-1; i>=0; i--)
        {
            // Get Custom Attribute from collapsed (base) object.
            CustAttrib* baseObjectCustomAttribute = baseObjectCustomAttributeContainer->GetCustAttrib(i);

            for (int j = 0; j < reattachingModifierCustomAttributeContainer->GetNumCustAttribs(); j++)
            {
                // If the re-attaching modifier also contain this Custom Attribute we will remove it from the new base object.
                if ( baseObjectCustomAttribute == reattachingModifierCustomAttributeContainer->GetCustAttrib(j) )
                {
                    baseObjectCustomAttributeContainer->RemoveCustAttrib(i);
                }
            }
        }
    }
}

Interval hctBasicModifier::LocalValidity (TimeValue t)
{
    Interval validity = FOREVER;

    for (int i=0; i<NumParamBlocks(); i++)
    {
        IParamBlock2* pblock2 = GetParamBlock(i);
        if (pblock2)
        {
            pblock2->GetValidity(t, validity);
        }
    }

    return validity;
}

#if MAX_VERSION_MAJOR>=17
    RefResult hctBasicModifier::NotifyRefChanged( const Interval& changeInt, RefTargetHandle hTarget, PartID& partID,  RefMessage message, BOOL propagate )
#else
    RefResult hctBasicModifier::NotifyRefChanged( Interval changeInt, RefTargetHandle hTarget, PartID& partID, RefMessage message )
#endif
{
    //TODO: Add code to handle the various reference changed messages
    switch (message)
    {
    case REFMSG_CHANGE:
        {
            if (m_interface && hTarget)
            {
                // see if we know of the target
                for (int i=0; i < m_pblocks.Count(); ++i)
                {
                    if (m_pblocks[i] == hTarget)
                    {
                        m_pblocks[i]->GetDesc()->InvalidateUI(m_pblocks[i]->LastNotifyParamID());

                        break; // for loop
                    }
                }

                // Check also combo boxes
                {
                    const int numComboBoxes = getNumComboBoxes();
                    for (int c=0; c<numComboBoxes; c++)
                    {
                        ComboBoxDescriptor* comboBox = getComboBoxDescriptor(c);
                        IParamBlock2* pblock2 = m_pblocks[comboBox->getParamBlockID()];
                        if ( pblock2 == hTarget)
                        {
                            if (pblock2->LastNotifyParamID() == comboBox->getParamID())
                            {
                                updateComboBoxFromParam(c);
                            }
                        }
                    }
                }

                // Update the state of controls
                updateUI();
            }
            break;
        }
    }

    return REF_SUCCEED;
}

int hctBasicModifier::NumRefs()
{
    return m_pblocks.Count();
}

IParamBlock2* hctBasicModifier::GetParamBlockByID(BlockID id)
{
    for (int i=0; i < m_pblocks.Count(); ++i)
    {
        if (m_pblocks[i] && m_pblocks[i]->ID() == id)
        {
            return m_pblocks[i];
        }
    }
    return NULL;
}

void hctBasicModifier::SetReference(int i, RefTargetHandle rtarg)
{
    const int c = m_pblocks.Count();
    if ( c <= i )
    {
        m_pblocks.SetCount(i+1);
        for (int j=c; j < i; ++j)
        {
            m_pblocks[j] = NULL;
        }
    }
    m_pblocks[i] = (IParamBlock2*)rtarg;
}

RefTargetHandle hctBasicModifier::GetReference(int i)
{
    if (i>=0 && i<m_pblocks.Count())
    {
        return m_pblocks[i];
    }
    else
    {
        return NULL;
    }
}

RefTargetHandle hctBasicModifier::Clone( RemapDir &remap )
{
    hctBasicModifier* newmod = (hctBasicModifier*) m_classDesc->Create(FALSE);

    BaseClone(this, newmod, remap);

    return(newmod);

}

void hctBasicModifier::BaseClone(ReferenceTarget* from, ReferenceTarget* to, RemapDir& remap)
{
    for (int b=0; b < m_pblocks.Count(); ++b)
    {
        to->ReplaceReference(b, m_pblocks[b]->Clone(remap));
    }

    Modifier::BaseClone(from, to, remap);
}

/*
** UTILITY (static) methods
*/

Quat hctBasicModifier::getRotationFromMatrix (const Matrix3& matrix)
{
    AffineParts affineParts;

    decomp_affine(matrix, &affineParts);

    return affineParts.q;
}

Matrix3 hctBasicModifier::removeScale (const Matrix3& matrix)
{
    AffineParts affParts;
    decomp_affine(matrix, &affParts);

    Matrix3 result;
    result.SetRotate(affParts.q);
    result.SetTrans(affParts.t);

    return result;
}

/*
** FORCE NOTIFY ACCESOR
*/

void hctBasicModifier::ForceNotifyPBAccessor::Set(PB2Value& v, ReferenceMaker* owner, ParamID id, int tabIndex, TimeValue t)
{
    for (int i=0; i<m_modifiers.Count(); ++i)
    {
        (reinterpret_cast<hctBasicModifier*> (m_modifiers[i]))->ForceNotify(Interval(t,t));
    }
}

void hctBasicModifier::ForceNotifyPBAccessor::addModifier(hctBasicModifier* modifierItem)
{
    ReferenceMaker* refmaker = modifierItem;
    m_modifiers.Append(1,&refmaker);
}

void hctBasicModifier::ForceNotifyPBAccessor::removeModifier(hctBasicModifier* modifierItem)
{
    for (int i=m_modifiers.Count()-1; i>=0; i--)
    {
        if (m_modifiers[i]== modifierItem)
        {
            m_modifiers.Delete(i,1);
        }
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
