// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Max/MaxSceneExport/resource.h>

#include <ContentTools/Max/MaxSceneExport/Modifiers/hctBasicModifier.h>

#include <ContentTools/Max/MaxFpInterfaces/Physics/Shape/hctShapeModifierInterface.h>

// Shape Types
enum
{
    ST_BOX,
    ST_SPHERE,
    ST_CAPSULE,
    ST_CYLINDER,
    ST_HULL,
    ST_MESH,

    ST_LAST
};

class hctShapeModifier : public hctBasicModifier
{
    public:

        //Constructor/Destructor
        hctShapeModifier (ClassDesc2* theClassDesc);
        /*virtual*/ ~hctShapeModifier();

        // From hctBasicModifier
        // Enables/disables controls
        /*virtual*/ void updateUI();

        /*
        ** EXTENSION CHANNEL (unselected display) : From hctBasicModifier
        */

        virtual int getNumXTCObjects () { return 1; }
        /*virtual*/ hctBasicXTCObject* getXTCObject (int number, TimeValue t, ModContext &mc, ObjectState * os, INode *node);

        /*
        ** COMBO BOXES
        */
        /*virtual*/ int getNumComboBoxes () { return 1; }
        /*virtual*/ ComboBoxDescriptor* getComboBoxDescriptor (int comboBoxID);

        /*
        ** MAX STUFF
        */

        // From ReferenceMaker
        // Used to upgrade scenes
        /*virtual*/ IOResult Load (ILoad* iload);

        //From Animatable
        /*virtual*/ Class_ID ClassID() { return HK_SHAPE_MODIFIER_CLASS_ID;}
        /*virtual*/ CONST15 MCHAR *GetObjectName() { return GetString(IDS_SHAPE_MODIFIER_OBJECT_NAME); }
        /*virtual*/ void GetClassName(MSTR& s) { s = GetString(IDS_SHAPE_MODIFIER_CLASS_NAME);}

};

/*
** Shape XTCObject : Not using it at the moment
*/

#define HK_SHAPE_XTCOBJECT_CLASS_ID  Class_ID(0x4d8357c1, 0x20855370)

class hctShapeXTCObject : public hctBasicXTCObject
{
    public:

        /*virtual*/ Class_ID ExtensionID() { return HK_SHAPE_XTCOBJECT_CLASS_ID; }

        /*virtual*/ XTCObject *Clone() { return new hctShapeXTCObject(); }

        /*virtual*/ int Display (TimeValue t, INode* inode, ViewExp *vpt, int flags, Object *pObj);
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
