// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>
#include <ContentTools/Max/MaxSceneExport/Modifiers/Shape/hctShapeModifier.h>

#define DEFAULT_SHAPE_MODIFIER_VERSION  0
#define CURRENT_SHAPE_MODIFIER_VERSION  7000

class hkShapeModifierDesc : public ClassDesc2
{
    public:
    int             IsPublic() { return TRUE; }
    void *          Create (BOOL loading = FALSE);
    const MCHAR *   ClassName() { return GetString(IDS_SHAPE_MODIFIER_CLASS_NAME); }
    SClass_ID       SuperClassID() { return OSM_CLASS_ID; }
    Class_ID        ClassID() { return HK_SHAPE_MODIFIER_CLASS_ID; }
    const MCHAR*    Category() { return GetString(IDS_HAVOK_MODIFIERS_CATEGORY); }
    const MCHAR*    InternalName() { return TEXT("hkShapeModifier"); }
    HINSTANCE       HInstance() { return hInstance; }
};

ClassDesc2* getHkShapeModifierDesc()
{
    static hkShapeModifierDesc shapeModifierDesc;
    return &shapeModifierDesc;
}


void* hkShapeModifierDesc::Create (BOOL loading)
{
    hctShapeModifier* newModifier =  new hctShapeModifier(this);

    // New instances -> we set the version to the latest
    if (!loading)
    {
        IParamBlock2* pblock2 = newModifier->GetParamBlock(PB_SHAPE_MOD_PBLOCK);
        if (pblock2)
        {
            pblock2->SetValue(PA_SHAPE_MOD_VERSION_INTERNAL, 0, CURRENT_SHAPE_MODIFIER_VERSION);
        }
    }

    return newModifier;
}

/*
** Instance parameters
*/

// History of changes
// 4.0 :    Deprecated "convexRadius" (default 0.0f) for "extraRadius" (default 0.05m)
//          Added "version" in order to handle upgrade from 3.x assets

static ParamBlockDesc2 hkShape_ParamBlockDesc ( PB_SHAPE_MOD_PBLOCK, _T("hkShape"),  0, getHkShapeModifierDesc(),
    P_AUTO_CONSTRUCT + P_AUTO_UI, PB_SHAPE_MOD_PBLOCK,

    // Rollout
    // We use the default dlg proc that handles combo boxes, defined in hctBasicModifier
    IDD_SHAPE_MODIFIER_ROLLOUT_PROPERTIES,
    IDS_SHAPE_MODIFIER_ROLLOUT_PROPERTIES,
    0, 0, hctBasicModifier::getComboBoxHandlerDlgProc(),

    // GENERAL PROPERTIES PARAMETERS

    // Shape Type
    PA_SHAPE_MOD_SHAPE_TYPE,
        _T("shapeType"), TYPE_INT, P_ANIMATABLE | P_RESET_DEFAULT, IDS_SHAPE_MODIFIER_PA_SHAPE_TYPE,
        p_default,      ST_BOX,
        p_end,


    PA_SHAPE_MOD_CHANGE_EXTRA_RADIUS,
        _T("changeExtraRadius"), TYPE_BOOL, P_RESET_DEFAULT, IDS_SHAPE_MODIFIER_PA_CHANGE_EXTRA_RADIUS,
        p_default,      FALSE,
        p_ui,           TYPE_SINGLECHEKBOX, IDC_CB_CHANGE_EXTRA_RADIUS,
        p_enable_ctrls, 1, PA_SHAPE_MOD_EXTRA_RADIUS,
        p_end,

    // Extra Radius
    PA_SHAPE_MOD_EXTRA_RADIUS,
        _T("extraRadius"), TYPE_FLOAT, P_ANIMATABLE | P_RESET_DEFAULT , IDS_SHAPE_MODIFIER_PA_EXTRA_RADIUS,
        p_default,      0.05f, // meters - we'll scale later in the constructor
        p_range,        0.0f, 100.0f,
        p_ui,           TYPE_SPINNER, EDITTYPE_UNIVERSE, IDC_ED_EXTRA_RADIUS, IDC_SP_EXTRA_RADIUS,
                        SPIN_AUTOSCALE,
        p_end,

    // Convex Radius : DEPRECATED
    PA_SHAPE_MOD_CONVEX_RADIUS_DEPRECATED,
        _T(""), TYPE_FLOAT, P_RESET_DEFAULT | P_READ_ONLY, 0,
        p_default,      0.0f,
        p_end,

    // Version: INTERNAL: Used to upgrade assets
    PA_SHAPE_MOD_VERSION_INTERNAL,
        _T(""), TYPE_INT,  P_RESET_DEFAULT | P_READ_ONLY, 0 ,
        p_default,  DEFAULT_SHAPE_MODIFIER_VERSION,
        p_end,

    p_end
    );

class ShapeTypeComboBoxDescriptor : public hctBasicModifier::ComboBoxDescriptor
{
    public:

        /*virtual*/ BlockID getParamBlockID() { return PB_SHAPE_MOD_PBLOCK; }
        /*virtual*/ ParamID getParamID() { return PA_SHAPE_MOD_SHAPE_TYPE; }
        /*virtual*/ MapID getParamMapID() { return 0; }
        /*virtual*/ int getControlID() { return IDC_COMBO_SHAPE_TYPE; }
        /*virtual*/ int getNumElements() { return 6; }
        /*virtual*/ const char* getElementString (int i)
        {
            static const char* m_elementStrings [] = {"Box", "Sphere", "Capsule", "Cylinder", "Convex Hull", "Mesh"};
            return m_elementStrings[i];
        }

        /*virtual*/ const int getElementValue (int i) { return i; }
};

hctShapeModifier::hctShapeModifier(ClassDesc2* theClassDesc)
: hctBasicModifier(theClassDesc)
{
    // EXP-1006 : Set the extraRadius default based on system units
    const float metersPerUnit = float(GetMasterScale(UNITS_METERS));
    IParamBlock2* pblock2 = GetParamBlock(PB_SHAPE_MOD_PBLOCK);
    if (pblock2)
    {
        const float meters = pblock2->GetFloat(PA_SHAPE_MOD_EXTRA_RADIUS);
        const float units = meters / metersPerUnit;
        pblock2->SetValue(PA_SHAPE_MOD_EXTRA_RADIUS, 0, units);
    }
}

hctShapeModifier::~hctShapeModifier()
{
}

hctBasicModifier::ComboBoxDescriptor* hctShapeModifier::getComboBoxDescriptor (int comboBoxID)
{
    static ShapeTypeComboBoxDescriptor shapeTypeComboBox;

    return &shapeTypeComboBox;
}

void hctShapeModifier::updateUI ()
{
    if (!m_interface) return;

    IParamBlock2* pblock2 = GetParamBlock(PB_SHAPE_MOD_PBLOCK);
    IParamMap2* map2 = pblock2->GetMap();
    if (!map2) return;

    HWND hWnd = map2->GetHWnd();

    int shapeType = pblock2->GetInt(PA_SHAPE_MOD_SHAPE_TYPE);

    const BOOL hasExtraRadius = (shapeType!=1) && (shapeType!=2); // Not sphere or capsule

    EnableWindow(GetDlgItem(hWnd, IDC_CB_CHANGE_EXTRA_RADIUS), hasExtraRadius);

    // EXP-736
    BOOL canChangeExtraRadius = hasExtraRadius && (pblock2->GetInt(PA_SHAPE_MOD_CHANGE_EXTRA_RADIUS)!=FALSE);

    ICustEdit* iEdit = GetICustEdit(GetDlgItem(hWnd, IDC_ED_EXTRA_RADIUS));
    iEdit->Enable(canChangeExtraRadius);
    ReleaseICustEdit(iEdit);


    ISpinnerControl* iSpinner = GetISpinner(GetDlgItem(hWnd, IDC_SP_EXTRA_RADIUS));
    iSpinner->Enable(canChangeExtraRadius);
    ReleaseISpinner(iSpinner);
}


hctBasicXTCObject* hctShapeModifier::getXTCObject (int number, TimeValue t, ModContext &mc, ObjectState * os, INode *node)
{
    return NULL;
}


/*
** EXTENSION CHANNEL OBJECT
*/

int hctShapeXTCObject::Display (TimeValue t, INode* inode, ViewExp *vpt, int flags, Object *pObj)
{
    // TODO : Possibly display the actual bounding box, sphere, mesh, etc..
    return 1;
}

/*
** LOAD : Upgrade from older versions
*/

class hkShapeModifierUpgradePLCB : public PostLoadCallback
{
    public:

        hkShapeModifierUpgradePLCB (hctShapeModifier* shapeModifier) : m_modifier (shapeModifier) {}

        /*virtual*/ void proc (ILoad* iload)
        {
            IParamBlock2* pblock2 = m_modifier->GetParamBlock (PB_SHAPE_MOD_PBLOCK);
            const int version = pblock2->GetInt(PA_SHAPE_MOD_VERSION_INTERNAL);

            // Upgrade 3.x to 4.0
            if (version < 4000)
            {
                upgradeTo4000 ();
            }


            // Set version to the latest
            pblock2->SetValue(PA_SHAPE_MOD_VERSION_INTERNAL, 0, CURRENT_SHAPE_MODIFIER_VERSION);

            delete this;
        }

    protected :

        hctShapeModifier* m_modifier;

        void upgradeTo4000();

};

void hkShapeModifierUpgradePLCB::upgradeTo4000()
{
    IParamBlock2* pblock2 = m_modifier->GetParamBlock (PB_SHAPE_MOD_PBLOCK);

    // Convex Radius is now in "extra Radius"
    const float oldRadius = pblock2->GetFloat(PA_SHAPE_MOD_CONVEX_RADIUS_DEPRECATED);
    pblock2->SetValue(PA_SHAPE_MOD_CHANGE_EXTRA_RADIUS, 0, TRUE);
    pblock2->SetValue(PA_SHAPE_MOD_EXTRA_RADIUS, 0, oldRadius);
}


IOResult hctShapeModifier::Load (ILoad* iload)
{
    IOResult res = hctBasicModifier::Load(iload);

    iload->RegisterPostLoadCallback (new hkShapeModifierUpgradePLCB (this));

    return res;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
