// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64
// PRODUCT      : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Max/MaxSceneExport/Modifiers/hctBasicModifier.h>

// Class ID
#define HK_SCRIPTED_FRACTURE_MODIFIER_CLASS_ID Class_ID(0xa71686c, 0x385c5713)

class hctScriptedFractureModifier : public hctBasicModifier
{
    public:

        /// Constructor
        hctScriptedFractureModifier(ClassDesc2* theClassDesc);

        /// Destructor
        ~hctScriptedFractureModifier();

        /// Class id functions
        virtual Class_ID ClassID()          {   return HK_SCRIPTED_FRACTURE_MODIFIER_CLASS_ID;  }
        virtual CONST15 MCHAR *GetObjectName()      {   return _T("hkdScriptedFracture");               }
        virtual void GetClassName(MSTR& s)  {   s = _T("hkdScriptedFracture");                  }

        /// Parse a given script
        hkResult parse( const char* scriptPath );

        /// Initializes the UI
        void initUI();

        /// Resets the UI
        void resetUI();

    public:

        /// MaxScript helpers
        static Value* hkScript_get();
        static Value* hkScript_set(Value* val);

    public:

        /// StringBuf compare
        static HK_INLINE bool compareStringPtr( const hkStringPtr& b1, const hkStringPtr& b2 )
        {
            return ( hkString::strCmp( b1, b2 ) < 0 );
        }

    protected:

        /// Unique ID
        int uid;
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
