// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Max/MaxSceneExport/resource.h>

#include <ContentTools/Max/MaxSceneExport/Modifiers/hctBasicModifier.h>

#include <ContentTools/Max/MaxFpInterfaces/Physics/RigidBody/hctRigidBodyModifierInterface.h>

// Subobjects (may not be visible)
enum
{
    SOBJ_RB_MOD_CENTER_OF_MASS,
    SOBJ_RB_MOD_INERTIA_TENSOR,
};

class hctRigidBodyModifier : public hctBasicModifier
{
    public:

        //Constructor/Destructor
        hctRigidBodyModifier (ClassDesc2* theClassDesc);
        /*virtual*/ ~hctRigidBodyModifier ();

        /*
        ** SUBOBJECT HANDLING: From hctBasicModifier
        */

        /*virtual*/ int getNumSubobjects () { return 2; }
        /*virtual*/ ISubObjType* getSubobjectTypeByID (int subobjId);
        /*virtual*/ bool canSubobjectMove (int subobjId);
        /*virtual*/ bool canSubobjectRotate (int subobjId);
        /*virtual*/ bool canSubobjectScale (int subobjId);
        /*virtual*/ bool isSubobjectEnabled (int subobjId);

        /*virtual*/ void getSubobjectTransform (int subobjId, TimeValue t, INode* node, Matrix3& transformOut);

        /*
        ** EXTENSION CHANNEL (unselected display) : From hctBasicModifier
        */
        virtual int getNumXTCObjects () { return 1; }
        /*virtual*/ hctBasicXTCObject* getXTCObject (int number, TimeValue t, ModContext &mc, ObjectState * os, INode *node);

        /*
        ** COMBO BOXES
        */
        /*virtual*/ int getNumComboBoxes () { return 3; }
        /*virtual*/ ComboBoxDescriptor* getComboBoxDescriptor (int comboBoxID);

        // Update UI - Enables some controls, etc
        /*virtual*/ void updateUI ();

        /*
        ** MAX STUFF
        */

        //From Modifier
        /*virtual*/ void ModifyObject(TimeValue t, ModContext &mc, ObjectState * os, INode *node);


        // Subobject manipulation
        /*virtual*/ void Move(TimeValue t, Matrix3& partm, Matrix3& tmAxis, Point3& despAxis, BOOL localOrigin=FALSE );
        /*virtual*/ void Scale(TimeValue t, Matrix3& partm, Matrix3& tmAxis, Point3& val, BOOL localOrigin=FALSE );

        // Display
        /*virtual*/ int Display(TimeValue t, INode* inode, ViewExp *vpt, int flagst, ModContext *mc);
        /*virtual*/ void GetLocalBoundBox(TimeValue t, INode* inode, ViewExp* vp, Box3& box );
        /*virtual*/ void GetWorldBoundBox(TimeValue t,INode* inode, ViewExp *vpt, Box3& box, ModContext *mc);

        //From Animatable
        /*virtual*/ Class_ID ClassID() { return HK_RIGIDBODY_MODIFIER_CLASS_ID;}
        /*virtual*/ CONST15 MCHAR *GetObjectName() { return GetString(IDS_RB_MODIFIER_OBJECT_NAME); }
        /*virtual*/ void GetClassName(MSTR& s) { s = GetString(IDS_RB_MODIFIER_CLASS_NAME);}

    private:

        /*
        ** UTILITY METHODS (non-virtual)
        */

        // Returns the current COM in world. If node is NULL, it is searched
        Point3 getCOMWorld (TimeValue t, INode* node= NULL);

        // Builds the display mesh (the box for the inertial tensor). Called only once.
        void buildMesh();

        // Returns the scale values used for the displaying inertia tensor
        Point3 getInertiaTensorDisplayScale(TimeValue t, INode* inode);

        // Returns a normalized inertia vector
        Point3 getNormalizedInertia (TimeValue t);

        // Returns true if the rb should be displayed with the fixed display ( "[RB]" label and colors)
        bool fixedDisplay(TimeValue t);

        // Mesh (1x1x1 cube)
        static Mesh m_cubeMesh;
        static bool m_meshBuilt;
        Box3 m_meshBoundingBox;


};

/*
** Rigid Body XTCObject : It displays the letters RB on the rigid bodies
*/

#define HK_RIGIDBODY_XTCOBJECT_CLASS_ID  Class_ID(0x7cba41fc, 0x2935563d)

class hctRigidBodyXTCObject : public hctBasicXTCObject
{
    public:

        hctRigidBodyXTCObject (bool isFixed);

        /*virtual*/ Class_ID ExtensionID() { return HK_RIGIDBODY_XTCOBJECT_CLASS_ID; }

        /*virtual*/ XTCObject *Clone() { return new hctRigidBodyXTCObject(m_isFixed); }

        /*virtual*/ int Display (TimeValue t, INode* inode, ViewExp *vpt, int flags, Object *pObj);

    private:

        bool m_isFixed;

        Point3 m_labelColor;
        Point3 m_shadowColor;
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
