// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>
#include <ContentTools/Max/MaxSceneExport/Modifiers/RigidBody/hctRigidBodyModifier.h>

class hkRigidBodyModifierDesc : public ClassDesc2
{
    public:
    int             IsPublic() { return TRUE; }
    void *          Create (BOOL loading = FALSE) { return new hctRigidBodyModifier(this); }
    const MCHAR *   ClassName() { return GetString(IDS_RB_MODIFIER_CLASS_NAME); }
    SClass_ID       SuperClassID() { return OSM_CLASS_ID; }
    Class_ID        ClassID() { return HK_RIGIDBODY_MODIFIER_CLASS_ID; }
    const MCHAR*    Category() { return GetString(IDS_HAVOK_MODIFIERS_CATEGORY); }

    const MCHAR*    InternalName() { return TEXT("hkRigidBodyModifier"); }
    HINSTANCE       HInstance() { return hInstance; }
};

ClassDesc2* getHkRigidBodyModifierDesc()
{
    static hkRigidBodyModifierDesc rigidBodyModifierDesc;
    return &rigidBodyModifierDesc;
}

Mesh hctRigidBodyModifier::m_cubeMesh;
bool hctRigidBodyModifier::m_meshBuilt = false;

/*
** Class Parameters
*/

static hctBasicModifier::ForceNotifyPBAccessor g_pbForceNotifyAccessor;

static ParamBlockDesc2 hkRigidBodyClass_ParamBlockDesc (CPB_RB_MOD_PBLOCK, _T("hkRigidBodyClass"), 0, getHkRigidBodyModifierDesc(),
    P_AUTO_UI + P_CLASS_PARAMS + P_AUTO_CONSTRUCT, CPB_RB_MOD_PBLOCK,

    IDD_RB_MODIFIER_ROLLOUT_CLASS_PROPERTIES,
    IDS_RB_MODIFIER_ROLLOUT_CLASS_PROPERTIES, 0, APPENDROLL_CLOSED,0,

    CPA_RB_MOD_MARK_RIGID_BODIES, _T("markRigidBodies"), TYPE_BOOL, P_RESET_DEFAULT, 0,
        p_default, TRUE,
        p_accessor, &g_pbForceNotifyAccessor,
        p_ui, TYPE_SINGLECHEKBOX, IDC_CB_MARK_RIGID_BODIES,
        p_end,

    p_end
    );

/*
** Instance parameters
*/

/*
** Accessor
*/

class hkRigidBodyModifierPBAccessor:public PBAccessor
{
    public:

        hkRigidBodyModifierPBAccessor () {}

        /*virtual*/void Set(PB2Value& v, ReferenceMaker* owner, ParamID id, int tabIndex, TimeValue t);
};

void hkRigidBodyModifierPBAccessor::Set(PB2Value& v, ReferenceMaker* owner, ParamID id, int tabIndex, TimeValue t)
{
    hctRigidBodyModifier* theModifier = static_cast<hctRigidBodyModifier*> (owner);

    if (theModifier->m_interface)
    {
        theModifier->updateSubobjects();
    }
}

static hkRigidBodyModifierPBAccessor g_pbAccessor;

// We use multi map parameter blocks so we can move parameters to different rollouts in the future
// without extra hassle
enum
{
    MAP_GENERAL_PROPERTIES_ROLLOUT,
    MAP_COM_AND_INERTIA_TENSOR_ROLLOUT,
    MAP_ADVANCED_PROPERTIES_ROLLOUT
};

static ParamBlockDesc2 hkRigidBody_ParamBlockDesc ( PB_RB_MOD_PBLOCK, _T("hkRigidBody"),  0, getHkRigidBodyModifierDesc(),
    P_AUTO_CONSTRUCT + P_AUTO_UI + P_MULTIMAP, PB_RB_MOD_PBLOCK,

    // Three rollouts
    3,
    MAP_GENERAL_PROPERTIES_ROLLOUT,
        IDD_RB_MODIFIER_ROLLOUT_GENERAL_PROPERTIES,
        IDS_RB_MODIFIER_ROLLOUT_GENERAL_PROPERTIES,
        0, 0,
        NULL,
    MAP_COM_AND_INERTIA_TENSOR_ROLLOUT,
        IDD_RB_MODIFIER_ROLLOUT_COM_AND_INERTIA_TENSOR,
        IDS_RB_MODIFIER_ROLLOUT_COM_AND_INERTIA_TENSOR,
        0, APPENDROLL_CLOSED,
        NULL,
    MAP_ADVANCED_PROPERTIES_ROLLOUT,
        IDD_RB_MODIFIER_ROLLOUT_ADVANCED_PROPERTIES,
        IDS_RB_MODIFIER_ROLLOUT_ADVANCED_PROPERTIES,
        0, APPENDROLL_CLOSED,
        hctBasicModifier::getComboBoxHandlerDlgProc(),

    // GENERAL PROPERTIES PARAMETERS
    PA_RB_MOD_MASS,
        _T("mass"), TYPE_FLOAT, P_ANIMATABLE | P_RESET_DEFAULT, IDS_RB_MODIFIER_PA_MASS,
        p_default,      0.0f,
        p_range,        0.0f, 10000000.0f,
        p_ui,           MAP_GENERAL_PROPERTIES_ROLLOUT,
                        TYPE_SPINNER,   EDITTYPE_FLOAT, IDC_ED_MASS, IDC_SP_MASS,
                        SPIN_AUTOSCALE,
        p_end,
    PA_RB_MOD_FRICTION,
        _T("friction"), TYPE_FLOAT, P_ANIMATABLE | P_RESET_DEFAULT, IDS_RB_MODIFIER_PA_FRICTION,
        p_default,      0.5f,
        p_range,        0.0f, 255.0f,
        p_ui,           MAP_GENERAL_PROPERTIES_ROLLOUT,
                        TYPE_SPINNER, EDITTYPE_FLOAT, IDC_ED_FRICTION, IDC_SP_FRICTION,
                        SPIN_AUTOSCALE,
        p_end,
    PA_RB_MOD_RESTITUTION,
        _T("restitution"), TYPE_FLOAT, P_ANIMATABLE | P_RESET_DEFAULT, IDS_RB_MODIFIER_PA_RESTITUTION,
        p_default,      0.4f,
        p_range,        0.0f, 1.98f,
        p_ui,           MAP_GENERAL_PROPERTIES_ROLLOUT,
                        TYPE_SPINNER, EDITTYPE_FLOAT, IDC_ED_RESTITUTION, IDC_SP_RESTITUTION,
                        SPIN_AUTOSCALE,
        p_end,

    // COM & INERTIA TENSOR PARAMETERS
    PA_RB_MOD_CHANGE_CENTER_OF_MASS,
        _T("changeCenterOfMass"), TYPE_BOOL, P_ANIMATABLE | P_RESET_DEFAULT, IDS_RB_MODIFIER_PA_CHANGE_CENTER_OF_MASS,
        p_default,      FALSE,
        p_ui,           MAP_COM_AND_INERTIA_TENSOR_ROLLOUT,
                        TYPE_SINGLECHEKBOX, IDC_CB_OVERRIDE_COM,
        p_enable_ctrls, 1, PA_RB_MOD_CENTER_OF_MASS,
        p_accessor,     &g_pbAccessor,
        p_end,
    PA_RB_MOD_CENTER_OF_MASS,
        _T("centerOfMass"), TYPE_POINT3, P_ANIMATABLE | P_RESET_DEFAULT, IDS_RB_MODIFIER_PA_CENTER_OF_MASS,
        p_default,      Point3(0,0,0),
        p_range,        -1000000.0f, 1000000.0f,
        p_ui,           MAP_COM_AND_INERTIA_TENSOR_ROLLOUT,
                        TYPE_SPINNER,       EDITTYPE_UNIVERSE,
                        IDC_ED_COM_X, IDC_SP_COM_X,
                        IDC_ED_COM_Y, IDC_SP_COM_Y,
                        IDC_ED_COM_Z, IDC_SP_COM_Z,
                        SPIN_AUTOSCALE,
        p_end,
    PA_RB_MOD_CHANGE_INERTIA_TENSOR,
        _T("changeInertiaTensor"), TYPE_BOOL, P_ANIMATABLE | P_RESET_DEFAULT, IDS_RB_MODIFIER_PA_CHANGE_INERTIA_TENSOR,
        p_default,      FALSE,
        p_ui,           MAP_COM_AND_INERTIA_TENSOR_ROLLOUT,
                        TYPE_SINGLECHEKBOX, IDC_CB_OVERRIDE_INERTIA_TENSOR,
        p_enable_ctrls, 1, PA_RB_MOD_INERTIA_TENSOR,
        p_accessor,     &g_pbAccessor,
        p_end,
    PA_RB_MOD_INERTIA_TENSOR,
        _T("inertiaTensor"), TYPE_POINT3, P_ANIMATABLE | P_RESET_DEFAULT, IDS_RB_MODIFIER_PA_INERTIA_TENSOR,
        p_default,      Point3(1,1,1),
        p_range,        0.0f, 1000.0f,
        p_ui,           MAP_COM_AND_INERTIA_TENSOR_ROLLOUT,
                        TYPE_SPINNER,   EDITTYPE_FLOAT,
                        IDC_ED_INERTIA_TENSOR_X, IDC_SP_INERTIA_TENSOR_X,
                        IDC_ED_INERTIA_TENSOR_Y, IDC_SP_INERTIA_TENSOR_Y,
                        IDC_ED_INERTIA_TENSOR_Z, IDC_SP_INERTIA_TENSOR_Z,
                        SPIN_AUTOSCALE,
        p_end,

    // ADVANCED PROPERTIES PARAMETERS
    PA_RB_MOD_CHANGE_LINEAR_DAMPING,
        _T("changeLinearDamping"), TYPE_BOOL, P_ANIMATABLE | P_RESET_DEFAULT, IDS_RB_MODIFIER_PA_CHANGE_LINEAR_DAMPING,
        p_default,      FALSE,
        p_ui,           MAP_ADVANCED_PROPERTIES_ROLLOUT,
                        TYPE_SINGLECHEKBOX, IDC_CB_OVERRIDE_LINEAR_DAMPING,
        p_enable_ctrls, 1, PA_RB_MOD_LINEAR_DAMPING,
        p_accessor,     &g_pbAccessor,
        p_end,
    PA_RB_MOD_LINEAR_DAMPING,
        _T("linearDamping"), TYPE_FLOAT, P_ANIMATABLE | P_RESET_DEFAULT, IDS_RB_MODIFIER_PA_LINEAR_DAMPING,
        p_default,      0.05f,
        p_range,        0.0f, 1.0f,
        p_ui,           MAP_ADVANCED_PROPERTIES_ROLLOUT,
                        TYPE_SPINNER,   EDITTYPE_FLOAT, IDC_ED_LINEAR_DAMPING, IDC_SP_LINEAR_DAMPING,
                        SPIN_AUTOSCALE,
        p_end,

    PA_RB_MOD_CHANGE_ANGULAR_DAMPING,
        _T("changeAngularDamping"), TYPE_BOOL, P_ANIMATABLE | P_RESET_DEFAULT, IDS_RB_MODIFIER_PA_CHANGE_ANGULAR_DAMPING,
        p_default,      FALSE,
        p_ui,           MAP_ADVANCED_PROPERTIES_ROLLOUT,
                        TYPE_SINGLECHEKBOX, IDC_CB_OVERRIDE_ANGULAR_DAMPING,
        p_enable_ctrls, 1, PA_RB_MOD_ANGULAR_DAMPING,
        p_accessor,     &g_pbAccessor,
        p_end,
    PA_RB_MOD_ANGULAR_DAMPING,
        _T("angularDamping"), TYPE_FLOAT, P_ANIMATABLE | P_RESET_DEFAULT, IDS_RB_MODIFIER_PA_ANGULAR_DAMPING,
        p_default,      0.05f,
        p_range,        0.0f, 1.0f,
        p_ui,           MAP_ADVANCED_PROPERTIES_ROLLOUT,
                        TYPE_SPINNER,   EDITTYPE_FLOAT, IDC_ED_ANGULAR_DAMPING, IDC_SP_ANGULAR_DAMPING,
                        SPIN_AUTOSCALE,
        p_end,

    PA_RB_MOD_CHANGE_ALLOWED_PENETRATION_DEPTH,
        _T("changeAllowedPenetrationDepth"), TYPE_BOOL, P_ANIMATABLE | P_RESET_DEFAULT, IDS_RB_MODIFIER_PA_CHANGE_ALLOWED_PENETRATION_DEPTH,
        p_default,      FALSE,
        p_ui,           MAP_ADVANCED_PROPERTIES_ROLLOUT,
                        TYPE_SINGLECHEKBOX, IDC_CB_OVERRIDE_ALLOWED_PENETRATION_DEPTH,
        p_enable_ctrls, 1, PA_RB_MOD_ALLOWED_PENETRATION_DEPTH,
        p_accessor,     &g_pbAccessor,
        p_end,
    PA_RB_MOD_ALLOWED_PENETRATION_DEPTH,
        _T("allowedPenetrationDepth"), TYPE_FLOAT, P_ANIMATABLE | P_RESET_DEFAULT, IDS_RB_MODIFIER_PA_ALLOWED_PENETRATION_DEPTH,
        p_default,      0.05f,
        p_range,        0.0f, 1.0f,
        p_ui,           MAP_ADVANCED_PROPERTIES_ROLLOUT,
                        TYPE_SPINNER,   EDITTYPE_FLOAT, IDC_ED_ALLOWED_PENETRATION_DEPTH, IDC_SP_ALLOWED_PENETRATION_DEPTH,
                        SPIN_AUTOSCALE,
        p_end,

    PA_RB_MOD_CHANGE_MAX_LINEAR_VELOCITY,
        _T("changeMaxLinearVelocity"), TYPE_BOOL, P_ANIMATABLE | P_RESET_DEFAULT, IDS_RB_MODIFIER_PA_CHANGE_MAX_LINEAR_VELOCITY,
        p_default,      FALSE,
        p_ui,           MAP_ADVANCED_PROPERTIES_ROLLOUT,
                        TYPE_SINGLECHEKBOX, IDC_CB_OVERRIDE_MAX_LINEAR_VELOCITY,
        p_enable_ctrls, 1, PA_RB_MOD_MAX_LINEAR_VELOCITY,
        p_accessor,     &g_pbAccessor,
        p_end,
    PA_RB_MOD_MAX_LINEAR_VELOCITY,
        _T("maxLinearVelocity"), TYPE_FLOAT, P_ANIMATABLE | P_RESET_DEFAULT, IDS_RB_MODIFIER_PA_MAX_LINEAR_VELOCITY,
        p_default,      200.0f,
        p_range,        0.0f, 1000.0f,
        p_ui,           MAP_ADVANCED_PROPERTIES_ROLLOUT,
                        TYPE_SPINNER,   EDITTYPE_FLOAT, IDC_ED_MAX_LINEAR_VELOCITY, IDC_SP_MAX_LINEAR_VELOCITY,
                        SPIN_AUTOSCALE,
        p_end,

    PA_RB_MOD_CHANGE_MAX_ANGULAR_VELOCITY,
        _T("changeMaxAngularVelocity"), TYPE_BOOL, P_ANIMATABLE | P_RESET_DEFAULT, IDS_RB_MODIFIER_PA_CHANGE_MAX_ANGULAR_VELOCITY,
        p_default,      FALSE,
        p_ui,           MAP_ADVANCED_PROPERTIES_ROLLOUT,
                        TYPE_SINGLECHEKBOX, IDC_CB_OVERRIDE_MAX_ANGULAR_VELOCITY,
        p_enable_ctrls, 1, PA_RB_MOD_MAX_ANGULAR_VELOCITY,
        p_accessor,     &g_pbAccessor,
        p_end,
    PA_RB_MOD_MAX_ANGULAR_VELOCITY,
        _T("maxAngularVelocity"), TYPE_FLOAT, P_ANIMATABLE | P_RESET_DEFAULT, IDS_RB_MODIFIER_PA_MAX_ANGULAR_VELOCITY,
        p_default,      200.0f,
        p_range,        0.0f, 1000.0f,
        p_ui,           MAP_ADVANCED_PROPERTIES_ROLLOUT,
                        TYPE_SPINNER,   EDITTYPE_FLOAT, IDC_ED_MAX_ANGULAR_VELOCITY, IDC_SP_MAX_ANGULAR_VELOCITY,
                        SPIN_AUTOSCALE,
        p_end,

    PA_RB_MOD_CHANGE_COLLISION_FILTER_INFO,
        _T("changeCollisionFilterInfo"), TYPE_BOOL, P_ANIMATABLE | P_RESET_DEFAULT, IDS_RB_MODIFIER_PA_CHANGE_COLLISION_FILTER_INFO,
        p_default,      FALSE,
        p_ui,           MAP_ADVANCED_PROPERTIES_ROLLOUT,
                        TYPE_SINGLECHEKBOX, IDC_CB_OVERRIDE_COLLISION_FILTER_INFO,
        p_enable_ctrls, 1, PA_RB_MOD_COLLISION_FILTER_INFO,
        p_accessor,     &g_pbAccessor,
        p_end,
    PA_RB_MOD_COLLISION_FILTER_INFO,
        _T("collisionFilterInfo"), TYPE_INT, P_ANIMATABLE | P_RESET_DEFAULT, IDS_RB_MODIFIER_PA_COLLISION_FILTER_INFO,
        p_default,      0,
        p_range,        0, 32767,
        p_ui,           MAP_ADVANCED_PROPERTIES_ROLLOUT,
                        TYPE_SPINNER,   EDITTYPE_INT, IDC_ED_COLLISION_FILTER_INFO, IDC_SP_COLLISION_FILTER_INFO,
                        SPIN_AUTOSCALE,
        p_end,

    PA_RB_MOD_CHANGE_QUALITY_TYPE,
        _T("changeQualityType"), TYPE_BOOL, P_RESET_DEFAULT | P_ANIMATABLE, IDS_RB_MODIFIER_PA_CHANGE_QUALITY_TYPE,
        p_default,      FALSE,
        p_ui,           MAP_ADVANCED_PROPERTIES_ROLLOUT,
                        TYPE_SINGLECHEKBOX, IDC_CB_CHANGE_QUALITY_TYPE,
        p_end,
    PA_RB_MOD_QUALITY_TYPE,
        _T("qualityType"), TYPE_INT, P_ANIMATABLE | P_RESET_DEFAULT, IDS_RB_MODIFIER_PA_QUALITY_TYPE,
        p_default,      QT_MOVING,
        p_end,

    PA_RB_MOD_CHANGE_SOLVER_DEACTIVATION,
        _T("changeSolverDeactivation"), TYPE_BOOL, P_RESET_DEFAULT | P_ANIMATABLE, IDS_RB_MODIFIER_PA_CHANGE_SOLVER_DEACTIVATION,
        p_default,      FALSE,
        p_ui,           MAP_ADVANCED_PROPERTIES_ROLLOUT,
        TYPE_SINGLECHEKBOX, IDC_CB_CHANGE_SOLVER_DEACTIVATION,
        p_end,
    PA_RB_MOD_SOLVER_DEACTIVATION,
        _T("solverDeactivation"), TYPE_INT, P_ANIMATABLE | P_RESET_DEFAULT, IDS_RB_MODIFIER_PA_SOLVER_DEACTIVATION,
        p_default,      SD_MEDIUM,
        p_end,

    PA_RB_MOD_CHANGE_DEACTIVATOR_TYPE,
        _T("changeRigidBodyDeactivatorType"), TYPE_BOOL, P_RESET_DEFAULT | P_ANIMATABLE, IDS_RB_MODIFIER_PA_CHANGE_DEACTIVATOR_TYPE,
        p_default,      FALSE,
        p_ui,           MAP_ADVANCED_PROPERTIES_ROLLOUT,
        TYPE_SINGLECHEKBOX, IDC_CB_CHANGE_DEACTIVATOR_TYPE,
        p_end,
    PA_RB_MOD_DEACTIVATOR_TYPE,
        _T("rigidBodyDeactivatorType"), TYPE_INT, P_ANIMATABLE | P_RESET_DEFAULT, IDS_RB_MODIFIER_PA_DEACTIVATOR_TYPE,
        p_default,      DT_SPATIAL,
        p_end,

    PA_RB_MOD_SCALE_INERTIA_TENSOR,
        _T("scaleInertiaTensor"), TYPE_BOOL, P_ANIMATABLE | P_RESET_DEFAULT, IDS_RB_MODIFIER_PA_SCALE_INERTIA_TENSOR,
        p_default,      FALSE,
        p_ui,           MAP_COM_AND_INERTIA_TENSOR_ROLLOUT,
                        TYPE_SINGLECHEKBOX, IDC_CB_SCALE_INERTIA_TENSOR,
        p_enable_ctrls, 1, PA_RB_MOD_INERTIA_TENSOR_SCALE,
        p_accessor,     &g_pbAccessor,
        p_end,
    PA_RB_MOD_INERTIA_TENSOR_SCALE,
        _T("inertiaTensorScale"), TYPE_FLOAT, P_ANIMATABLE | P_RESET_DEFAULT, IDS_RB_MODIFIER_PA_INERTIA_TENSOR_SCALE,
        p_default,      1.0f,
        p_range,        0.0f, 10.0f,
        p_ui,           MAP_COM_AND_INERTIA_TENSOR_ROLLOUT,
                        TYPE_SPINNER,   EDITTYPE_FLOAT,
                        IDC_ED_INERTIA_TENSOR_SCALE, IDC_SP_INERTIA_TENSOR_SCALE,
                        SPIN_AUTOSCALE,
        p_end,

    p_end
    );


class QualityTypeComboBoxDescriptor : public hctBasicModifier::ComboBoxDescriptor
{
public:

    /*virtual*/ BlockID getParamBlockID() { return PB_RB_MOD_PBLOCK; }
    /*virtual*/ MapID getParamMapID() {return MAP_ADVANCED_PROPERTIES_ROLLOUT;}
    /*virtual*/ ParamID getParamID() { return PA_RB_MOD_QUALITY_TYPE; }
    /*virtual*/ int getControlID() { return IDC_COMBO_QUALITY_TYPE; }
    /*virtual*/ int getNumElements() { return 8; }
    /*virtual*/ const char* getElementString (int i)
    {
        static const char* m_elementStrings [] =
        {"Fixed", "Keyframed", "Keyframed Reporting", "Debris", "Moving", "Critical", "Bullet", "Debris simple TOI"};
        return m_elementStrings[i];
    }

    /*virtual*/ const int getElementValue (int i) { return i; }
};

class SolverDeactivationComboBoxDescriptor : public hctBasicModifier::ComboBoxDescriptor
{
public:

    /*virtual*/ BlockID getParamBlockID() { return PB_RB_MOD_PBLOCK; }
    /*virtual*/ MapID getParamMapID() {return MAP_ADVANCED_PROPERTIES_ROLLOUT;}
    /*virtual*/ ParamID getParamID() { return PA_RB_MOD_SOLVER_DEACTIVATION; }
    /*virtual*/ int getControlID() { return IDC_COMBO_SOLVER_DEACTIVATION; }
    /*virtual*/ int getNumElements() { return 4; }
    /*virtual*/ const char* getElementString (int i)
    {
        static const char* m_elementStrings [] = {"Off", "Low", "Medium", "High"};
        return m_elementStrings[i];
    }

    /*virtual*/ const int getElementValue (int i) { return i; }
};

class DeactivatorTypeComboBoxDescriptor : public hctBasicModifier::ComboBoxDescriptor
{
public:

    /*virtual*/ BlockID getParamBlockID() { return PB_RB_MOD_PBLOCK; }
    /*virtual*/ MapID getParamMapID() {return MAP_ADVANCED_PROPERTIES_ROLLOUT;}
    /*virtual*/ ParamID getParamID() { return PA_RB_MOD_DEACTIVATOR_TYPE; }
    /*virtual*/ int getControlID() { return IDC_COMBO_DEACTIVATOR_TYPE; }
    /*virtual*/ int getNumElements() { return 2; }
    /*virtual*/ const char* getElementString (int i)
    {
        static const char* m_elementStrings [] = {"Spatial", "Never"};
        return m_elementStrings[i];
    }

    /*virtual*/ const int getElementValue (int i) { return i; }
};

hctRigidBodyModifier::hctRigidBodyModifier(ClassDesc2* theClassDesc)
: hctBasicModifier(theClassDesc), m_meshBoundingBox(Point3::Origin, Point3::Origin)
{
    theClassDesc->MakeAutoParamBlocks(this);

    if (!m_meshBuilt)
    {
        buildMesh();
    }

    // Register this modifier so it gets notified of changes in class params
    g_pbForceNotifyAccessor.addModifier(this);
}

hctRigidBodyModifier::~hctRigidBodyModifier()
{
    // Unregister this modifier
    g_pbForceNotifyAccessor.removeModifier(this);
}

hctBasicModifier::ComboBoxDescriptor* hctRigidBodyModifier::getComboBoxDescriptor (int comboBoxID)
{
    static QualityTypeComboBoxDescriptor        qualityTypeComboBox;
    static SolverDeactivationComboBoxDescriptor solverDeactivationComboBox;
    static DeactivatorTypeComboBoxDescriptor    deactivatorTypeComboBox;

    switch (comboBoxID)
    {
        case 0:
            return &qualityTypeComboBox;
        case 1:
            return &solverDeactivationComboBox;
        case 2:
            return &deactivatorTypeComboBox;
        default:
            break;
    }

    // Shouldn't get here
    assert(0);
    return NULL;
}

// Update UI - Enables some controls, etc
void hctRigidBodyModifier::updateUI ()
{
    if (!m_interface) return;

    const TimeValue now = m_interface->GetTime();

    IParamBlock2* pblock = GetParamBlock(PB_RB_MOD_PBLOCK);
    IParamMap2* map = pblock->GetMap();
    if (!map) return;

    // qualityType combo box
    {
        ComboBoxDescriptor* comboBox = getComboBoxDescriptor(0);
        IParamBlock2* pblockC = GetParamBlock(comboBox->getParamBlockID());
        MapID mapID = comboBox->getParamMapID();
        IParamMap2* pmap = pblockC->GetMap(mapID);
        HWND dlgWnd = pmap->GetHWnd();
        if (dlgWnd)
        {
            HWND comboBoxWnd = GetDlgItem(dlgWnd, comboBox->getControlID());
            const BOOL changeQualityType = pblockC->GetInt(PA_RB_MOD_CHANGE_QUALITY_TYPE, now, 0);
            EnableWindow(comboBoxWnd, changeQualityType);
        }
    }

    // solverDeactivation combo box
    {
        ComboBoxDescriptor* comboBox = getComboBoxDescriptor(1);
        IParamBlock2* pblockC = GetParamBlock(comboBox->getParamBlockID());
        MapID mapID = comboBox->getParamMapID();
        IParamMap2* pmap = pblockC->GetMap(mapID);
        HWND dlgWnd = pmap->GetHWnd();
        if (dlgWnd)
        {
            HWND comboBoxWnd = GetDlgItem(dlgWnd, comboBox->getControlID());
            const BOOL changeSolverDeactivation = pblockC->GetInt(PA_RB_MOD_CHANGE_SOLVER_DEACTIVATION, now, 0);
            EnableWindow(comboBoxWnd, changeSolverDeactivation);
        }
    }

    // deactivatorType combo box
    {
        ComboBoxDescriptor* comboBox = getComboBoxDescriptor(2);
        IParamBlock2* pblockC = GetParamBlock(comboBox->getParamBlockID());
        MapID mapID = comboBox->getParamMapID();
        IParamMap2* pmap = pblockC->GetMap(mapID);
        HWND dlgWnd = pmap->GetHWnd();
        if (dlgWnd)
        {
            HWND comboBoxWnd = GetDlgItem(dlgWnd, comboBox->getControlID());
            const BOOL changeDeactivatorType = pblockC->GetInt(PA_RB_MOD_CHANGE_DEACTIVATOR_TYPE, now, 0);
            EnableWindow(comboBoxWnd, changeDeactivatorType);
        }
    }

    // mass control
    {
        const bool setQuality = pblock->GetInt(PA_RB_MOD_CHANGE_QUALITY_TYPE, now) != FALSE;
        const int quality = pblock->GetInt(PA_RB_MOD_QUALITY_TYPE, now );

        BOOL massEnabled = !setQuality || !( (quality==QT_FIXED) || (quality==QT_KEYFRAMED) || (quality==QT_KEYFRAMED_REPORTING) );

        IParamMap2* pmap = pblock->GetMap(MAP_GENERAL_PROPERTIES_ROLLOUT);
        HWND dlgWnd = pmap->GetHWnd();

        ICustEdit* iEdit = GetICustEdit(GetDlgItem(dlgWnd, IDC_ED_MASS));
        iEdit->Enable(massEnabled);
        ReleaseICustEdit(iEdit);


        ISpinnerControl* iSpinner = GetISpinner(GetDlgItem(dlgWnd, IDC_SP_MASS));
        iSpinner->Enable(massEnabled);
        ReleaseISpinner(iSpinner);

    }
}

/*
** Subobject handling
*/

ISubObjType* hctRigidBodyModifier::getSubobjectTypeByID (int subobjId)
{
    static GenSubObjType centerOfMassSObj(GetString(IDS_RB_MODIFIER_SOBJ_CENTER_OF_MASS),_T("SubObjectIcons") , 0);
    static GenSubObjType inertiaTensorSObj(GetString(IDS_RB_MODIFIER_SOBJ_INERTIA_TENSOR), _T("SubObjectIcons"), 0);

    switch (subobjId)
    {
        case SOBJ_RB_MOD_CENTER_OF_MASS:
            return &centerOfMassSObj;
        case SOBJ_RB_MOD_INERTIA_TENSOR:
            return &inertiaTensorSObj;
    }

    return NULL;
}

bool hctRigidBodyModifier::canSubobjectMove (int subobjId)
{
    return (subobjId == SOBJ_RB_MOD_CENTER_OF_MASS);
}
bool hctRigidBodyModifier::canSubobjectRotate (int subobjId)
{
    return FALSE;
}
bool hctRigidBodyModifier::canSubobjectScale (int subobjId)
{
    return (subobjId == SOBJ_RB_MOD_INERTIA_TENSOR);
}

bool hctRigidBodyModifier::isSubobjectEnabled (int subobjId)
{
    IParamBlock2* blk = GetParamBlock(PB_RB_MOD_PBLOCK);
    switch (subobjId)
    {
        case SOBJ_RB_MOD_CENTER_OF_MASS:
            {
                const bool comOn =  blk->GetInt(PA_RB_MOD_CHANGE_CENTER_OF_MASS) != FALSE;
                return comOn;
            }
        case SOBJ_RB_MOD_INERTIA_TENSOR:
            {
                const bool inertiaOn = blk->GetInt(PA_RB_MOD_CHANGE_INERTIA_TENSOR) != FALSE;
                return inertiaOn;
            }
    }

    return false;
}

void hctRigidBodyModifier::getSubobjectTransform (int subobjId, TimeValue t, INode* node, Matrix3& transformOut)
{
    transformOut = node->GetNodeTM(t);

    Point3 comWorld = getCOMWorld(t,node);
    transformOut.SetTrans(comWorld);
}

void hctRigidBodyModifier::Move(TimeValue t, ::Matrix3& partm, ::Matrix3& tmAxis, Point3& despAxis, BOOL localOrigin )
{
    IParamBlock2* blk = GetParamBlock(PB_RB_MOD_PBLOCK);

    if (!theHold.Holding())
    {
        theHold.Begin();
        SetAFlag(A_HELD);
    }
    else if(!TestAFlag(A_HELD))
    {
        SetAFlag(A_HELD);
    }

    Point3 despLocal;

    INode* theNode = hctMaxUtils::findNodeRef(this);

    ::Matrix3 worldToNode = Inverse(theNode->GetNodeTM(t));

    // tmAxis = axisToWorld
    // res = despAxis * axisToWorld * worldToNode
    despLocal = VectorTransform(tmAxis * worldToNode,despAxis);

    Point3 comLocal = blk->GetPoint3(PA_RB_MOD_CENTER_OF_MASS, t);
    comLocal += despLocal;
    blk->SetValue(PA_RB_MOD_CENTER_OF_MASS, t, comLocal);

    NotifyDependents(FOREVER, PART_ALL, REFMSG_CHANGE);
}

void hctRigidBodyModifier::Scale(TimeValue t, Matrix3& partm, Matrix3& tmAxis, Point3& scaleAxis, BOOL localOrigin )
{
    IParamBlock2* blk = GetParamBlock(PB_RB_MOD_PBLOCK);
    if (!theHold.Holding())
    {
        theHold.Begin();
        SetAFlag(A_HELD);
    }
    else if(!TestAFlag(A_HELD))
    {
        SetAFlag(A_HELD);
    }

    INode* theNode = hctMaxUtils::findNodeRef(this);

    ::Matrix3 worldToNode = Inverse(theNode->GetNodeTM(t));

    // tmAxis = axisToWorld
    // res = despAxis * axisToWorld * worldToNode
    Point3 scaleLocal = VectorTransform(tmAxis * worldToNode,scaleAxis);

    // ensure no negative scale
    scaleLocal.x = scaleLocal.x < 0.0f ?  (-scaleLocal.x) : scaleLocal.x;
    scaleLocal.y = scaleLocal.y < 0.0f ?  (-scaleLocal.y) : scaleLocal.y;
    scaleLocal.z = scaleLocal.z < 0.0f ?  (-scaleLocal.z) : scaleLocal.z;

    Point3 currentInertia = blk->GetPoint3(PA_RB_MOD_INERTIA_TENSOR, t);
    currentInertia *= scaleLocal;

    blk->SetValue(PA_RB_MOD_INERTIA_TENSOR, t, currentInertia);

    NotifyDependents(FOREVER, PART_ALL, REFMSG_CHANGE);

}

Point3 hctRigidBodyModifier::getCOMWorld (TimeValue t, INode* node)
{
    IParamBlock2* blk = GetParamBlock(PB_RB_MOD_PBLOCK);
    const bool comOn =  blk->GetInt(PA_RB_MOD_CHANGE_CENTER_OF_MASS) != FALSE;

    if (!node)
    {
        node = hctMaxUtils::findNodeRef(this);
    }

    Point3 comLocal;
    if (comOn)
    {
        comLocal = blk->GetPoint3(PA_RB_MOD_CENTER_OF_MASS, t);
    }
    else
    {
        // Assume COM is in the middle of bounding box
        // Mesh center is in object coordinates
        Point3 centerWorld = m_meshBoundingBox.Center() * node->GetObjectTM(t);
        comLocal = centerWorld * Inverse (node->GetNodeTM(t));
    }

    const Point3 comWorld = comLocal * node->GetNodeTM(t);

    return comWorld;
}

Point3 hctRigidBodyModifier::getNormalizedInertia (TimeValue t)
{
    IParamBlock2* blk = GetParamBlock(PB_RB_MOD_PBLOCK);
    const bool inertiaOn = blk->GetInt(PA_RB_MOD_CHANGE_INERTIA_TENSOR) != FALSE;

    Point3 normalizedInertia;
    if ( inertiaOn )
    {
        const Point3 inertia = blk->GetPoint3(PA_RB_MOD_INERTIA_TENSOR, t);
        const float factor = pow( ( 1.0f / ( inertia.x * inertia.y * inertia.z ) ), 0.33333f );
        normalizedInertia = inertia * factor;
    }
    else
    {
        normalizedInertia.Set( 1.0f, 1.0f, 1.0f );
    }

    return normalizedInertia;
}

Point3 hctRigidBodyModifier::getInertiaTensorDisplayScale(TimeValue t, INode* node)
{
    const Point3 normalizedInertia = getNormalizedInertia (t);

    if (!node)
    {
        node = hctMaxUtils::findNodeRef(this);
    }

    Box3 meshBoxWorld = m_meshBoundingBox;
    const Point3 bboxWidth = meshBoxWorld.Width();

    Point3 displayScale = bboxWidth * normalizedInertia;

    IParamBlock2* blk = GetParamBlock(PB_RB_MOD_PBLOCK);
    const bool inertiaScaleOn = blk->GetInt(PA_RB_MOD_SCALE_INERTIA_TENSOR) != FALSE;
    if ( inertiaScaleOn )
    {
        const float scale = blk->GetFloat(PA_RB_MOD_INERTIA_TENSOR_SCALE, t);

        displayScale *= scale;
    }

    return displayScale;
}

// Display


void hctRigidBodyModifier::buildMesh()
{
    if (m_meshBuilt)
    {
        return;
    }

    m_cubeMesh.setNumVerts(8);
    m_cubeMesh.setNumFaces(12);

    m_cubeMesh.setVert(0, Point3(-0.5,-0.5,-0.5));
    m_cubeMesh.setVert(1, Point3( 0.5,-0.5,-0.5));
    m_cubeMesh.setVert(2, Point3(-0.5, 0.5,-0.5));
    m_cubeMesh.setVert(3, Point3( 0.5, 0.5,-0.5));
    m_cubeMesh.setVert(4, Point3(-0.5,-0.5, 0.5));
    m_cubeMesh.setVert(5, Point3( 0.5,-0.5, 0.5));
    m_cubeMesh.setVert(6, Point3(-0.5, 0.5, 0.5));
    m_cubeMesh.setVert(7, Point3( 0.5, 0.5, 0.5));
    m_cubeMesh.faces[0].setVerts(0,2,3);
    m_cubeMesh.faces[0].setEdgeVisFlags(1,1,0);
    m_cubeMesh.faces[1].setVerts(3,1,0);
    m_cubeMesh.faces[1].setEdgeVisFlags(1,1,0);
    m_cubeMesh.faces[2].setVerts(4,5,7);
    m_cubeMesh.faces[2].setEdgeVisFlags(1,1,0);
    m_cubeMesh.faces[3].setVerts(7,6,4);
    m_cubeMesh.faces[3].setEdgeVisFlags(1,1,0);
    m_cubeMesh.faces[4].setVerts(0,1,5);
    m_cubeMesh.faces[4].setEdgeVisFlags(1,1,0);
    m_cubeMesh.faces[5].setVerts(5,4,0);
    m_cubeMesh.faces[5].setEdgeVisFlags(1,1,0);
    m_cubeMesh.faces[6].setVerts(1,3,7);
    m_cubeMesh.faces[6].setEdgeVisFlags(1,1,0);
    m_cubeMesh.faces[7].setVerts(7,5,1);
    m_cubeMesh.faces[7].setEdgeVisFlags(1,1,0);
    m_cubeMesh.faces[8].setVerts(3,2,6);
    m_cubeMesh.faces[8].setEdgeVisFlags(1,1,0);
    m_cubeMesh.faces[9].setVerts(6,7,3);
    m_cubeMesh.faces[9].setEdgeVisFlags(1,1,0);
    m_cubeMesh.faces[10].setVerts(2,0,4);
    m_cubeMesh.faces[10].setEdgeVisFlags(1,1,0);
    m_cubeMesh.faces[11].setVerts(4,6,2);
    m_cubeMesh.faces[11].setEdgeVisFlags(1,1,0);

    m_cubeMesh.buildNormals();
    m_cubeMesh.BuildStripsAndEdges();

    m_meshBuilt = true;
}

bool hctRigidBodyModifier::fixedDisplay(TimeValue t)
{
    IParamBlock2* blk = GetParamBlock(PB_RB_MOD_PBLOCK);

    const bool setQuality = blk->GetInt(PA_RB_MOD_CHANGE_QUALITY_TYPE,t) != FALSE;
    const int quality = blk->GetInt(PA_RB_MOD_QUALITY_TYPE,t );
    const float mass = blk->GetFloat(PA_RB_MOD_MASS, t);

    if (setQuality)
    {
        switch (quality)
        {
            case QT_FIXED:
            case QT_KEYFRAMED:
            case QT_KEYFRAMED_REPORTING:
                return true;
            default:
                return mass==0.0f;
        }
    }
    else
    {
        return mass==0.0f;
    }
}

void hctRigidBodyModifier::ModifyObject(TimeValue t, ModContext &mc, ObjectState * os, INode *node)
{
    os->obj->GetDeformBBox(t, m_meshBoundingBox);

    hctBasicModifier::ModifyObject(t,mc,os,node);
}

hctBasicXTCObject* hctRigidBodyModifier::getXTCObject (int number, TimeValue t, ModContext &mc, ObjectState * os, INode *node)
{
    // Add display if required
    if (hkRigidBodyClass_ParamBlockDesc.GetInt(CPA_RB_MOD_MARK_RIGID_BODIES,t)!=FALSE)
    {
        return new  hctRigidBodyXTCObject(fixedDisplay(t));
    }
    else
    {
        return NULL;
    }

}

int hctRigidBodyModifier::Display(TimeValue t, INode* inode, ViewExp *vpt, int flagst, ModContext *mc)
{
    IParamBlock2* blk = GetParamBlock(PB_RB_MOD_PBLOCK);

    const bool comOn = blk->GetInt(PA_RB_MOD_CHANGE_CENTER_OF_MASS) != FALSE;
    const bool inertiaProportionsOn = blk->GetInt(PA_RB_MOD_CHANGE_INERTIA_TENSOR) != FALSE;
    const bool inertiaScaleOn = blk->GetInt(PA_RB_MOD_SCALE_INERTIA_TENSOR) != FALSE;

    if (!inertiaProportionsOn && !inertiaScaleOn && !comOn)
    {
        // Nothing to draw
        return 0;
    }

    GraphicsWindow *gw=vpt->getGW();
    const DWORD savedLimits=gw->getRndLimits();

    Material material;
    Point3 objectColor= GetUIColor(COLOR_SELECTION);
    gw->setColor(LINE_COLOR,objectColor);
    material.Kd = objectColor;

    Matrix3 tm = inode->GetNodeTM(t);
    Point3 comWorld = getCOMWorld(t, inode);
    tm.SetTrans(comWorld);
    // remove any scale
    tm = removeScale(tm);

    const Point3 scale = getInertiaTensorDisplayScale(t, inode);

    // we prescale because we want the scale to be affected by the rotation
    tm.PreScale(scale, FALSE);

    gw->setTransform(tm);
    gw->setRndLimits(GW_WIREFRAME|GW_BACKCULL);

    // Draw a box (inertia)
    if ( inertiaProportionsOn || inertiaScaleOn )
    {
        m_cubeMesh.render(gw,&material,NULL,COMP_ALL);
    }

    // Draw a red marker (com)
    if (comOn)
    {
        gw->setColor(LINE_COLOR,Point3(1.0f,0.0f,0.0f));
        Point3 p(0,0,0);
        IPoint3 markerPos;
        gw->wTransPoint(&p, &markerPos);
        const bool notClipped = ( gw->wTransPoint(&p, &markerPos) == 0);
        if (notClipped)  // EXP-565
        {
            gw->wMarker(&markerPos, X_MRKR);
            gw->wMarker(&markerPos, BIG_BOX_MRKR);
        }
    }

    gw->setRndLimits(savedLimits);

    return(0);

}

void hctRigidBodyModifier::GetLocalBoundBox(TimeValue t, INode* inode, ViewExp* vpt, Box3& box3 )
{
    Box3 worldBox;
    GetWorldBoundBox(t,inode,vpt,worldBox,NULL);

    Matrix3 worldToLocal = Inverse(inode->GetNodeTM(t));

    box3 = worldBox * worldToLocal;
}

void hctRigidBodyModifier::GetWorldBoundBox(TimeValue t,INode* inode, ViewExp *vpt, Box3& box3, ModContext *mc)
{

    Matrix3 tm = inode->GetNodeTM(t);
    Point3 comWorld = getCOMWorld(t, inode);
    tm.SetTrans(comWorld);
    // remove any scale
    tm = removeScale(tm);

    const Point3 scale = getInertiaTensorDisplayScale(t, inode);

    // we prescale because we want the scale to be affected by the rotation
    tm.PreScale(scale, FALSE);

    box3 = m_cubeMesh.getBoundingBox(&tm);

}

/*
** EXTENSION CHANNEL OBJECT
*/

hctRigidBodyXTCObject::hctRigidBodyXTCObject (bool isFixed) : hctBasicXTCObject(), m_isFixed(isFixed)
{
    IColorManager* theColorManager = GetColorManager();

    m_labelColor = m_isFixed ?      theColorManager->GetColorAsPoint3(HK_COLOR_FIXED_RB_LABEL) :
                                    theColorManager->GetColorAsPoint3(HK_COLOR_RIGIDBODY_LABEL);

    m_shadowColor = m_isFixed ?     theColorManager->GetColorAsPoint3(HK_COLOR_FIXED_RB_LABEL_SHADOW) :
                                    theColorManager->GetColorAsPoint3(HK_COLOR_RIGIDBODY_LABEL_SHADOW);

}

int hctRigidBodyXTCObject::Display (TimeValue t, INode* inode, ViewExp *vpt, int flags, Object *pObj)
{
    GraphicsWindow *gw=vpt->getGW();
    const DWORD savedLimits=gw->getRndLimits();

    // Write the text in the middle of the bounding box
    Box3 box3;
    pObj->GetDeformBBox(t, box3);
    Point3 centerWorld = box3.Center() * inode->GetObjectTM(t);;

    Matrix3 tm(1); tm.SetTrans(centerWorld);

    gw->setTransform(tm);
    gw->setRndLimits(GW_WIREFRAME|GW_BACKCULL);

    MCHAR* rbText = m_isFixed ? TEXT("[RB]") : TEXT("RB");

    Point3 p(0,0,0);
    IPoint3 markerPos;
    const bool notClipped = ( gw->wTransPoint(&p, &markerPos) == 0);
    if (notClipped)  // EXP-565
    {
        gw->wMarker(&markerPos, X_MRKR);

        // Try to center text
        markerPos.x-= m_isFixed ? 10:7;
        markerPos.y+= 10;
        // Display it twice, first black then yellow
        markerPos.x++;
        markerPos.y++;
        gw->setColor(TEXT_COLOR, m_shadowColor);
        gw->wText(&markerPos, rbText);
        markerPos.x--;
        markerPos.y--;
        gw->setColor(TEXT_COLOR, m_labelColor);
        gw->wText(&markerPos, rbText);
    }

    gw->setRndLimits(savedLimits);

    return 1;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
