// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>
#include <ContentTools/Max/MaxSceneExport/Modifiers/LocalFrame/hctLocalFrameModifier.h>

class hkLocalFrameModifierDesc : public ClassDesc2
{
public:
    int             IsPublic() { return TRUE; }
    void *          Create (BOOL loading = FALSE) { return new hctLocalFrameModifier(this); };
    const MCHAR *   ClassName() { return GetString(IDS_LOCAL_FRAME_MODIFIER_CLASS_NAME); }
    SClass_ID       SuperClassID() { return OSM_CLASS_ID; }
    Class_ID        ClassID() { return HK_LOCAL_FRAME_MODIFIER_CLASS_ID; }
    const MCHAR*    Category() { return GetString(IDS_HAVOK_MODIFIERS_CATEGORY); }
    const MCHAR*    InternalName() { return TEXT("hkLocalFrameModifier"); }
    HINSTANCE       HInstance() { return hInstance; }
};

ClassDesc2* getHkLocalFrameModifierDesc()
{
    static hkLocalFrameModifierDesc localFrameModifierDesc;
    return &localFrameModifierDesc;
}

// We use multi map parameter blocks so we can move parameters to different rollouts in the future
// without extra hassle
enum
{
    MAP_GENERAL_PROPERTIES_ROLLOUT
};

hctLocalFrameXTCObject::hctLocalFrameXTCObject()
{
    m_labelColor = GetColorManager()->GetColorAsPoint3( HK_COLOR_LOCAL_FRAME );
}

static ParamBlockDesc2 hkLocalFrame_ParamBlockDesc (
    PB_LOCAL_FRAME_MOD_PBLOCK, _T("hkLocalFrame"),  0, getHkLocalFrameModifierDesc(),
    P_AUTO_CONSTRUCT + P_AUTO_UI + P_MULTIMAP, PB_LOCAL_FRAME_MOD_PBLOCK,

    // One Rollout
    1,
    // General properties rollout
    MAP_GENERAL_PROPERTIES_ROLLOUT,
    IDD_LOCAL_FRAME_MODIFIER_ROLLOUT_PROPERTIES,
    IDS_LOCAL_FRAME_MODIFIER_ROLLOUT_PROPERTIES,
    0, 0, NULL,

    // GENERAL PROPERTIES PARAMETERS

    // notes
    PA_LOCAL_FRAME_MOD_LOCAL_FRAME_NAME,
    _T("localFrameName"), TYPE_STRING, P_ANIMATABLE | P_RESET_DEFAULT, IDS_LOCAL_FRAME_MODIFIER_PA_LOCAL_FRAME_NAME,
    p_default,      0,
    p_ui,           MAP_GENERAL_PROPERTIES_ROLLOUT,
    TYPE_EDITBOX,   IDC_ED_LOCAL_FRAME_MOD_LOCAL_FRAME_NAME,
    p_end,

    PA_LOCAL_FRAME_MOD_LOCAL_FRAME_GROUP,
    _T("localFrameGroup"), TYPE_STRING, P_ANIMATABLE | P_RESET_DEFAULT, IDS_LOCAL_FRAME_MODIFIER_PA_GROUP,
    p_default,      0,
    p_ui,           MAP_GENERAL_PROPERTIES_ROLLOUT,
    TYPE_EDITBOX,   IDC_ED_LOCAL_FRAME_MOD_LOCAL_FRAME_GROUP,
    p_end,

    p_end
    );

hctLocalFrameModifier::hctLocalFrameModifier(ClassDesc2* theClassDesc)
: hctBasicModifier(theClassDesc)
{
}

hctLocalFrameModifier::~hctLocalFrameModifier()
{
}

hctBasicXTCObject* hctLocalFrameModifier::getXTCObject (int number, TimeValue t, ModContext &mc, ObjectState * os, INode *node)
{
    return new hctLocalFrameXTCObject();
}


/*
** EXTENSION CHANNEL OBJECT
*/

int hctLocalFrameXTCObject::Display (TimeValue t, INode* inode, ViewExp *vpt, int flags, Object *pObj)
{
    GraphicsWindow *gw=vpt->getGW();
    const DWORD savedLimits=gw->getRndLimits();

    // Write the text in the middle of the bounding box
    Box3 box3;
    pObj->GetDeformBBox(t, box3);
    Point3 centerWorld = box3.Center() * inode->GetObjectTM(t);;

    Matrix3 tm(1); tm.SetTrans(centerWorld);

    gw->setTransform(tm);
    gw->setRndLimits(GW_WIREFRAME|GW_BACKCULL);

    MCHAR* rbText = TEXT("LF");

    Point3 p(0,0,0);
    IPoint3 markerPos;
    const bool notClipped = ( gw->wTransPoint(&p, &markerPos) == 0);
    if (notClipped)  // EXP-565
    {
        gw->wMarker(&markerPos, X_MRKR);

        // Try to center text
        markerPos.x-= 7;
        markerPos.y+= 10;
        // Display it twice, first black then yellow
        markerPos.x++;
        markerPos.y++;
        gw->setColor( TEXT_COLOR, m_labelColor );
        gw->wText(&markerPos, rbText);
        markerPos.x--;
        markerPos.y--;
        gw->setColor( TEXT_COLOR, m_labelColor );
        gw->wText(&markerPos, rbText);
    }

    gw->setRndLimits(savedLimits);

    return 1;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
