// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>

#include <ICustAttribContainer.h>

#include <Common/Base/hkBase.h>

#include <ContentTools/Common/SdkUtils/hctSdkUtils.h>

#include <ContentTools/Max/MaxSceneExport/Modifiers/Generic/hctGenericModifier.h>

#include <ContentTools/Max/MaxSceneExport/Modifiers/Generic/hctGenericXTCObject.h>


#define HK_GENERIC_XTCOBJECT_CLASS_ID Class_ID(0x4d8357c2, 0x20855372)


Class_ID hctGenericXTCObject::ExtensionID()
{
    return HK_GENERIC_XTCOBJECT_CLASS_ID;
}


XTCObject* hctGenericXTCObject::Clone()
{
    hctGenericXTCObject* clone = new hctGenericXTCObject();
    clone->m_genericModifierBacklink = m_genericModifierBacklink;
    return clone;
}


int hctGenericXTCObject::Display(TimeValue t, INode* inode, ViewExp *vpt, int flags, Object *pObj)
{
    GraphicsWindow *gw=vpt->getGW();
    const DWORD savedLimits=gw->getRndLimits();

    // Write the text in the middle of the bounding box
    Box3 box3;
    pObj->GetDeformBBox(t, box3);
    Point3 centerWorld = box3.Center() * inode->GetObjectTM(t);;

    Matrix3 tm(1); tm.SetTrans(centerWorld);

    gw->setTransform(tm);
    gw->setRndLimits(GW_WIREFRAME|GW_BACKCULL);

    MSTR rbText = TEXT("BB");

    Point3 p(0,0,0);
    IPoint3 markerPos;
    const bool notClipped = ( gw->wTransPoint(&p, &markerPos) == 0);
    if (notClipped)  // EXP-565
    {
        gw->wMarker(&markerPos, X_MRKR);

        Point3 textColor(1.0f, 0.0f, 0.0f);
        Point3 shadowColor(0.0f, 0.0f, 0.0f);

        // Try to center text
        markerPos.x-= 7;
        markerPos.y+= 22;
        // Display it twice, first black then red
        markerPos.x++;
        markerPos.y++;
        gw->setColor(TEXT_COLOR, shadowColor);
        gw->wText(&markerPos, rbText);
        markerPos.x--;
        markerPos.y--;
        gw->setColor(TEXT_COLOR, textColor);
        gw->wText(&markerPos, rbText);
    }

    gw->setRndLimits(savedLimits);

    return 1;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
