// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>

#include <sstream>

#include <Common/Base/System/Io/IStream/hkIStream.h>

#include <ContentTools/Common/SdkUtils/ClassHierarchy/hctClassHierarchyUtil.h>

#include <ContentTools/Max/MaxFpInterfaces/Physics/Generic/hctGenericModifierInterface.h>
#include <ContentTools/Max/MaxSceneExport/Modifiers/Generic/hctGenericModifier.h>


// ================================================================================================
// Command: "hkIsOfGenericModifierType"
// ================================================================================================

def_visible_primitive( hkIsOfGenericModifierType, "hkIsOfGenericModifierType" );
Value* hkIsOfGenericModifierType_cf( Value** arg_list, int count )
{
    check_arg_count(hkIsOfGenericModifierType, 2, count);

    Modifier* modifierItem = arg_list[0]->to_modifier();
    Class_ID classId = modifierItem->ClassID();
    if ( classId != HK_GENERIC_MODIFIER_CLASS_ID )
    {
        return &false_value;
    }

    HCT_SCOPED_CONVERSIONS;

    hctGenericModifier* genericModifier = reinterpret_cast<hctGenericModifier*>(modifierItem);
    MSTR modifierTypeNameStr = arg_list[1]->to_string();

    const char* modifierTypeName = FROM_MAX(modifierTypeNameStr);

    if ( strcmp(modifierTypeName, hctSdkUtils::getUiClass(genericModifier->getId()).m_class->getName()) != 0)
    {
        return &false_value;
    }

    return &true_value;
}


// ================================================================================================
// Command: "hkIsOfGenericModifierBaseType"
// ================================================================================================

def_visible_primitive( hkIsOfGenericModifierBaseType, "hkIsOfGenericModifierBaseType" );
Value* hkIsOfGenericModifierBaseType_cf( Value** arg_list, int count )
{
    check_arg_count(hkIsOfGenericModifierBaseType, 2, count);

    Modifier* modifierItem = arg_list[0]->to_modifier();
    Class_ID classId = modifierItem->ClassID();
    if ( classId != HK_GENERIC_MODIFIER_CLASS_ID )
    {
        return &false_value;
    }

    hctGenericModifier* genericModifier = reinterpret_cast<hctGenericModifier*>(modifierItem);
    MSTR modifierBaseTypeNameStr = arg_list[1]->to_string();

    HCT_SCOPED_CONVERSIONS;

    const char* modifierBaseTypeName = FROM_MAX(modifierBaseTypeNameStr);

    const hkReflect::Type* modifierClass = hctSdkUtils::getUiClass(genericModifier->getId()).m_class;
    if ( hctClassHierarchyUtil::isParentClassOf(modifierBaseTypeName, modifierClass) )
    {
        return &true_value;
    }
    return &false_value;
}


// ================================================================================================
// Command: "hkGetModifierClassAsString"
// ================================================================================================

def_visible_primitive( hkGetModifierClassAsString, "hkGetModifierClassAsString" );
Value* hkGetModifierClassAsString_cf( Value** arg_list, int count )
{
    // We expect exactly 1 parameter: modifier
    check_arg_count(hkGetModifierClassAsString, 1, count);

    Modifier* modifierItem = arg_list[0]->to_modifier();
    Class_ID classId = modifierItem->ClassID();
    if ( classId != HK_GENERIC_MODIFIER_CLASS_ID )
    {
        String* nonGenericModifierClassName = new String(modifierItem->GetName());
        return nonGenericModifierClassName;
    }

    hctGenericModifier* genericModifier = reinterpret_cast<hctGenericModifier*>(modifierItem);
    const hkReflect::Type* modifierClass = hctSdkUtils::getUiClass(genericModifier->getId()).m_class;

    HCT_SCOPED_CONVERSIONS;

    String* genericModifierClassName = new String(TO_MAX(modifierClass->getName()));
    return genericModifierClassName;
}


// ================================================================================================
// Command: "hkOpenChmDocs"
// ================================================================================================

def_visible_primitive( hkOpenChmDocs, "hkOpenChmDocs" );
Value* hkOpenChmDocs_cf( Value** arg_list, int count )
{
    check_arg_count(hkOpenChmDocs, 1, count);

    HCT_SCOPED_CONVERSIONS;

    MSTR classNameStr = arg_list[0]->to_string();

    const char* className = FROM_MAX(classNameStr);

    std::stringstream errorStream;

    hkStringOld documentationPathAndFileName;
    hctSdkUtils::getPathToAndNameOfDocumentationChmFile(documentationPathAndFileName);

    hkIfstream docsFile(documentationPathAndFileName.cString());
    if ( docsFile.isOk() )
    {
        const hkReflect::Type* modifierClass = hctSdkUtils::getTypeByName(className);
        if ( modifierClass )
        {
            bool docsFound = false;

            if( const hkDocumentationAttribute* documentationAttribute = modifierClass->findAttribute<hkDocumentationAttribute>() )
            {
                const hkAttributeHideCriteria::Types hideCriteria = hctSdkUtils::getUiAttributesHideCriteria(hkAttributeHideCriteria::MODELER_IS_MAX);
                const char* docsSectionTag = documentationAttribute->m_getDocsSectionTag(hideCriteria);
                if ( docsSectionTag && docsSectionTag[0] != 0 )
                {
                    const char* sectionTag = docsSectionTag;

                    std::stringstream parametersStream;
                    parametersStream << documentationPathAndFileName.cString() << "::" << sectionTag << ".html#" << modifierClass->getName() << "Tag";

                    std::string parametersString;
                    parametersString = parametersStream.str();

                    ShellExecuteA(NULL, "open", "hh.exe", parametersString.c_str(), NULL, SW_NORMAL);
                    docsFound = true;
                }
            }
            if(!docsFound)
            {
                errorStream << "messagebox \"No documentation section defined for class '" << modifierClass->getName() << "'\'.\"";
            }
        }
        else
        {
            errorStream << "Class '"<< className << "' not registered.";
        }
    }
    else
    {
        errorStream << "messagebox \"Couldn't find documentation file '" << documentationPathAndFileName.cString() << "'.\"";
    }

    //
    // Print error (if any).
    //
    {
        std::string errorString = errorStream.str();
        const char* errorStr = errorString.c_str();
        if ( errorStr && errorStr[0] != 0 )
        {
            HCT_SCOPED_CONVERSIONS;

            const MCHAR* maxStr = TO_MAX(errorStr);

            ExecuteMAXScriptScript(CONST15_CAST(maxStr));
        }
    }

    return &true_value;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
