// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>

#include <ContentTools/Common/SdkUtils/hctSdkUtils.h>

#include <ContentTools/Max/MaxFpInterfaces/Physics/Generic/hctGenericModifierInterface.h>
#include <ContentTools/Max/MaxSceneExport/Modifiers/Generic/hctGenericModifier.h>

#include <ContentTools/Max/MaxSceneExport/Modifiers/Generic/hctGenericModifierDesc.h>


//#define DEFAULT_GENERIC_MODIFIER_VERSION  0
#define CURRENT_GENERIC_MODIFIER_VERSION    4000


int hkGenericModifierDesc::IsPublic()
{
    return TRUE;
}


void* hkGenericModifierDesc::Create (BOOL loading)
{
    hctGenericModifier* newModifier =  new hctGenericModifier(this, m_id);

    // New instances -> we set the version to the latest
    if (!loading)
    {
        // We need to make this a separate call (instead of putting it into the constructor),
        // as MAXScript crashes when we add a new parameter to the constructor. Reason unknown.
        newModifier->initUI();

        IParamBlock2* pblock2 = newModifier->GetParamBlock(PB_GENERIC_MOD_PBLOCK);
        if (pblock2)
        {
            pblock2->SetValue(PA_GENERIC_MOD_VERSION_INTERNAL, 0, CURRENT_GENERIC_MODIFIER_VERSION);
        }
    }

    return newModifier;
}


const MCHAR *hkGenericModifierDesc::ClassName()
{
    return hkGenericModifierDesc::InternalName();
}


SClass_ID hkGenericModifierDesc::SuperClassID()
{
    return OSM_CLASS_ID;
}


Class_ID hkGenericModifierDesc::ClassID()
{
    // Special handling of old modifiers.
    if ( m_id < 20 )
    {
        return Class_ID(0x4d8357c2+m_id, 0x20855372+m_id);
    }
    else
    {
        return Class_ID(m_id, m_id);
    }
}


const MCHAR* hkGenericModifierDesc::Category()
{
    return GetString(IDS_HAVOK_MODIFIERS_CATEGORY);
}


const MCHAR* hkGenericModifierDesc::InternalName()
{
    if (m_internalName.length()==0)
    {
        HCT_SCOPED_CONVERSIONS;

        m_internalName = TO_MAX(hctSdkUtils::getUiClass(m_id).m_class->getName());
    }

    return m_internalName;
}


HINSTANCE hkGenericModifierDesc::HInstance()
{
    return hInstance;
}


//
// GLOBAL FUNCTIONS
//

int getHkNumGenericModifiers()
{
    return int(hctSdkUtils::getNumUiClasses());
}


static hkGenericModifierDesc g_genericModifierDesc[HCT_MAX_NUM_CLASS_ENTRIES];

ClassDesc2* getHkGenericModifierDesc(int enumeratorIndex)
{
    if ( enumeratorIndex >= int(hctSdkUtils::getNumUiClasses()) )
    {
        return &g_genericModifierDesc[0];
    }

    const hkArray<hctModelerNodeIdToClassMap>& classMap = hctSdkUtils::getNodeIdToClassMap();
    const hctModelerNodeIdToClassMap& mapEntry = classMap[enumeratorIndex];
    g_genericModifierDesc[enumeratorIndex].m_id = mapEntry.m_3dsMaxClassId;
    return &g_genericModifierDesc[enumeratorIndex];
}


ClassDesc2* getHkGenericModifierDescById(int modifierId)
{
    for (int i = 0; i < int(hctSdkUtils::getNumUiClasses()); i++)
    {
        if ( g_genericModifierDesc[i].m_id == modifierId )
        {
            return &g_genericModifierDesc[i];
        }
    }

    return &g_genericModifierDesc[0];
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
