// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>

#include <ICustAttribContainer.h>

#include <ContentTools/Max/MaxSceneExport/Modifiers/Generic/hctGenericModifier.h>
#include <ContentTools/Max/MaxSceneExport/Modifiers/Generic/hctGenericModifierUtil.h>
#include <ContentTools/Max/MaxFpInterfaces/Physics/Generic/hctGenericModifierInterface.h>
#include <ContentTools/Max/MaxSceneExport/Modifiers/Generic/hctGenericModifierDesc.h>
#include <ContentTools/Max/MaxSceneExport/Modifiers/Generic/hctGenericXTCObject.h>

#include <Common/Base/Types/Uuid/hkUuid.h>


hctGenericModifier* g_hctCurrentGenericModifierTempTransfer;
hctGenericModifier* g_hctCurrentGenericModifierTempTransfer2;


#define HCT_GENERIC_MODIFIER_ID_CHUNK 1




Value* hkCurrentGenericModifier_get()
{
    return MAXClass::make_wrapper_for(g_hctCurrentGenericModifierTempTransfer);
}


Value* hkCurrentGenericModifier2_get()
{
    return MAXClass::make_wrapper_for(g_hctCurrentGenericModifierTempTransfer2);
}


Value* hkCurrentGenericModifier_set(Value* val)
{
    // We do nothing here. As this global variable is not exposed to any external MAXScript there shouldn't
    // be a need to set it from MAXScript.
    return val;
}






class hctGenericModifierCustomAttributesVersioningUtil
{
    public:

        // Backup structure for one single parameter.
        struct ValueBackup
        {
            // Matching tests will only be done on the actual parameter's (and thus class member's) name.
            MSTR            m_name;

            // Only one of these members will be used per value backup.
            int              m_int;
            float            m_float;
            hkVector4        m_vector;
            MSTR             m_string;
            ReferenceTarget* m_refTarget;
            hkBool           m_refTargetLocked;
        };

        struct ActionPriority
        {
            MSTR m_name;
            int m_priority;
        };

    public:

        hctGenericModifierCustomAttributesVersioningUtil(hctGenericModifier* modifier);

            // Go through all parameters in the Custom Attributes and save their respective value.
        void backupValues();

            // Go through the (updated) set of parameters in the Custom Attributes and restore all values that have been previously stored.
        void restoreValues();

        /// Returns true if the modifier has hkdAction class type
        int getActionModifierDefaultPriority();

    protected:

        hctGenericModifier*  m_modifier;

        hkArray<ValueBackup> m_backupArray;
};


hctGenericModifierCustomAttributesVersioningUtil::hctGenericModifierCustomAttributesVersioningUtil(hctGenericModifier* modifierItem)
{
    m_modifier = modifierItem;
}


void hctGenericModifierCustomAttributesVersioningUtil::backupValues()
{
    ICustAttribContainer* customAttributeContainer = m_modifier->GetCustAttribContainer();
    if ( !customAttributeContainer )
    {
        return;
    }

    // Iterate over all Custom Attributes. Note that one single CA can hold more than one actual parameter!
    {
        for (int customAttributesIdx = 0; customAttributesIdx < customAttributeContainer->GetNumCustAttribs(); customAttributesIdx++)
        {
            CustAttrib* customAttribute = (CustAttrib*)customAttributeContainer->GetCustAttrib(customAttributesIdx);
            if ( !customAttribute ) // just to be safe
            {
                continue;
            }

            // Iterate over all ParamBlocks in the Custom Attribute. One ParamBlock should map to one rollout in the GUI.
            {
                for (int paramBlockIdx = 0; paramBlockIdx < customAttribute->NumParamBlocks(); paramBlockIdx++)
                {
                    IParamBlock2* paramBlock = customAttribute->GetParamBlock(paramBlockIdx);
                    if ( !paramBlock )
                    {
                        continue;
                    }

                    //MSTR paramBlockName = paramBlock->GetLocalName();

                    // Iterate over all parameters in the ParamBlock and store a backup of each value.
                    {
                        for (int paramIdx = 0; paramIdx < paramBlock->NumParams(); paramIdx++)
                        {
                            const ParamID paramID    = paramBlock->IndextoID(paramIdx);
                            ParamType2    paramType  = paramBlock->GetParameterType(paramID);
                            MSTR          paramName  = paramBlock->GetParamDef(paramID).int_name;
                            PB2Value&     paramValue = paramBlock->GetPB2Value(paramID);

                            // Workaround for what seems to be an obscure bug in 3ds Max: once 3ds Max fails to load a scene file (e.g. one of higher version number)
                            // any subsequently loaded files will give NULL as Custom Attribute names. In this rare case we will simply skip versioning (instead of
                            // risking a crash).
                            if ( paramName == HK_NULL )
                            {
                                continue;
                            }

                            ValueBackup& newAttribute = m_backupArray.expandOne();
                            {
                                newAttribute.m_name = paramName;
                                newAttribute.m_refTargetLocked = false;

                                switch ( (int)paramType )
                                {
                                    case TYPE_BOOL:
                                    {
                                        newAttribute.m_int = paramValue.i;
                                        break;
                                    }

                                    case TYPE_INT:
                                    {
                                        newAttribute.m_int = paramValue.i;
                                        break;
                                    }

                                    case TYPE_FLOAT:
                                    {
                                        newAttribute.m_float = paramValue.f;
                                        break;
                                    }

                                    case TYPE_POINT3:
                                    {
                                        newAttribute.m_vector(0) = paramValue.p->x;
                                        newAttribute.m_vector(1) = paramValue.p->y;
                                        newAttribute.m_vector(2) = paramValue.p->z;
                                        break;
                                    }

                                    case TYPE_STRING:
                                    {
                                        newAttribute.m_string = paramValue.s;
                                        break;
                                    }

                                    case TYPE_INODE:
                                    case TYPE_REFTARG:
                                    {
                                        newAttribute.m_refTarget = paramValue.r;

                                        // We need to prevent the linked object from getting deleted while rebuilding the Gui.
                                        // This can happen if the linking custom attribute has been moved to another rollout:
                                        // by this the linked object's refCount will be decremented by 1 and it might drop to 0,
                                        // causing 3ds Max to delete it altogether. An example: a modifier is linked but not
                                        // added to the stack. So the modifier only has one referrer (this attribute). Once this
                                        // attribute gets deleted the modifier will be deleted as well.
                                        // This shouldn't actually happen as we force linked modifiers onto the stack on opening
                                        // the Rollout, but we'll leave it in for safety reasons.
                                        if ( newAttribute.m_refTarget )
                                        {
                                            newAttribute.m_refTarget->SetAFlag(A_LOCK_TARGET);
                                            newAttribute.m_refTargetLocked = true;
                                        }
                                        break;
                                    }

                                    default:
                                    {
                                        //HK_ASSERT(0xaf1fae23, false, "Unsupported value type in Custom Attribute.");
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

//
//  Returns true if the modifier has hkdAction class type

int hctGenericModifierCustomAttributesVersioningUtil::getActionModifierDefaultPriority()
{
    const ActionPriority knownActions[] =
    {
        {   MSTR(TEXT("hkdConvexHullAction")),              7   },      // PRIORITY_CONVEX_HULL
        {   MSTR(TEXT("hkdRemoveWeakConnectionsAction")),   60 },       // PRIORITY_REMOVE_WEAK_CONNECTIONS
        {   MSTR(TEXT("hkdConvexDecompositionAction")),     10  },      // PRIORITY_CONVEX_DECOMPOSITION
        {   MSTR(TEXT("hkdSplitByPhysicsIslandsAction")),   8   },      // PRIORITY_SPLITBYPHYSICSISLANDS
        {   MSTR(TEXT("hkdGlueFixedPiecesAction")),         50  },      // PRIORITY_GLUE_FIXED_PIECES
        {   MSTR(TEXT("hkdDecorateFractureFaceAction")),    5   },      // PRIORITY_DECORATE_FRACTURE_FACE
        {   MSTR(TEXT("hkdMeshSimplifierAction")),          30  },      // PRIORITY_MESH_SIMPLIFIER
        {   MSTR(TEXT("hkdFlattenHierarchyAction")),        55  },      // PRIORITY_FLATTEN_HIERARCHY
        {   MSTR(TEXT("hkdDecalMapAction")),                6   },      // PRIORITY_CREATE_DECAL_MAP
        {   MSTR(TEXT("hkdShareVerticesAction")),           20  },      // PRIORITY_SHARE_VERTICES
    };

    MSTR modifierClassName;
    m_modifier->GetClassName(modifierClassName);

    const int numKnownActions = sizeof(knownActions) / sizeof(ActionPriority);
    for (int k = numKnownActions - 1; k >= 0; k--)
    {
        const ActionPriority& knownAction = knownActions[k];
        if ( knownAction.m_name == modifierClassName )
        {
            return knownAction.m_priority;
        }
    }

    return -1;
}


void hctGenericModifierCustomAttributesVersioningUtil::restoreValues()
{
    ICustAttribContainer* customAttributeContainer = m_modifier->GetCustAttribContainer();
    if ( !customAttributeContainer )
    {
        return;
    }

    //
    // Extract class version number from Custom Attributes.
    //
    int classVersion = -1;
    {
        for (int i = 0; i < m_backupArray.getSize(); i++)
        {
            ValueBackup& backupValue = m_backupArray[i];
            if ( backupValue.m_name == MSTR(TEXT("internalClassVersion")) )
            {
                classVersion = backupValue.m_int;
                break;
            }
        }
    }

    // Iterate over all Custom Attributes. Note that one single CA can hold more than one actual parameter!
    {
        for (int customAttributesIdx = 0; customAttributesIdx < customAttributeContainer->GetNumCustAttribs(); customAttributesIdx++)
        {
            CustAttrib* customAttribute = (CustAttrib*)customAttributeContainer->GetCustAttrib(customAttributesIdx);
            if ( !customAttribute ) // just to be safe
            {
                continue;
            }

            // Iterate over all ParamBlocks in the Custom Attribute. One ParamBlock should map to one rollout in the GUI.
            {
                for (int paramBlockIdx = 0; paramBlockIdx < customAttribute->NumParamBlocks(); paramBlockIdx++)
                {
                    IParamBlock2* paramBlock = customAttribute->GetParamBlock(paramBlockIdx);
                    if ( !paramBlock )
                    {
                        continue;
                    }

                    //MSTR paramBlockName = paramBlock->GetLocalName();

                    // Iterate over all parameters in the ParamBlock.
                    {
                        HCT_SCOPED_CONVERSIONS;

                        for (int paramIdx = 0; paramIdx < paramBlock->NumParams(); paramIdx++)
                        {
                            const ParamID paramID      = paramBlock->IndextoID(paramIdx);
                            MSTR paramNameStr = paramBlock->GetParamDef(paramID).int_name;
                            //const char*   paramName    = FROM_MAX(paramNameStr);
                            PB2Value&     paramValue   = paramBlock->GetPB2Value(paramID);

                            // For each parameter search (by name only) for a backup value and, if available, write it back.
                            bool foundMatch = false;
                            for (int valueIdx = 0; valueIdx < m_backupArray.getSize(); valueIdx++)
                            {
                                ValueBackup& backupValue = m_backupArray[valueIdx];
                                if ( backupValue.m_name == paramNameStr )
                                {
                                    ParamType2 paramType = paramBlock->GetParameterType(paramID);
                                    foundMatch = true;

                                    switch ( (int)paramType )
                                    {
                                        case TYPE_BOOL:
                                        {
                                            paramBlock->SetValue(paramID, 0, backupValue.m_int);
                                            break;
                                        }

                                        case TYPE_INT:
                                        {
                                            // Special versioning code for HKD-332: only if class is hkdShape and member is m_bodyQualityType and version is older than the one where we added the new ENUM member
                                            if ( (m_modifier->getId() == 15) && (paramNameStr == MSTR(TEXT("bodyQualityType"))) && (classVersion < 2) )
                                            {
                                                // Do not change QUALITY_INHERITED type but shift all subsequent ones by 1.
                                                if ( backupValue.m_int >= 2 )
                                                {
                                                    backupValue.m_int++;
                                                }
                                            }
                                            else if ( paramNameStr == MSTR(TEXT("internalClassVersion")))
                                            {
                                                // There's currently no proper "generalized" versioning for modifiers available, so we simply
                                                // ramp up the modifier's version value to the class's current version, assuming that "all"
                                                // that was necessary will have been done once we return from this method.
                                                const hkReflect::Type* klass = hctSdkUtils::getUiClass(m_modifier->getId()).m_class;
                                                backupValue.m_int = klass->getVersion();
                                            }
                                            paramBlock->SetValue(paramID, 0, backupValue.m_int);
                                            break;
                                        }

                                        case TYPE_FLOAT:
                                        {
                                            paramBlock->SetValue(paramID, 0, backupValue.m_float);
                                            break;
                                        }

                                        case TYPE_POINT3:
                                        {
                                            paramValue.p->Set(backupValue.m_vector(0), backupValue.m_vector(1), backupValue.m_vector(2));
                                            break;
                                        }

                                        case TYPE_STRING:
                                        {
                                            paramBlock->SetValue(paramID, 0, backupValue.m_string);
                                            break;
                                        }

                                        case TYPE_INODE:
                                        case TYPE_REFTARG:
                                        {
                                            paramBlock->SetValue(paramID, 0, backupValue.m_refTarget);

                                            // Unlock reference target. For details see backupValues().
                                            if ( backupValue.m_refTarget )
                                            {
                                                backupValue.m_refTarget->ClearAFlag(A_LOCK_TARGET);
                                                backupValue.m_refTargetLocked = false;
                                            }
                                            break;
                                        }

                                        default:
                                        {
                                            //HK_ASSERT(0xaf1fae24, false, "Unsupported value type in Custom Attribute.");
                                            break;
                                        }
                                    }

                                    break;
                                }
                            }

                            // We did not find a matching value in the backup parameters
                            if ( !foundMatch )
                            {
                                // Special cases
                                const MSTR strUuid(TEXT("uuid"));
                                const MSTR strPrio(TEXT("Priority"));

                                if ( paramNameStr == strUuid )
                                {
                                    const MSTR strBody          (TEXT("hkdBody"));
                                    MSTR modifierClassName;     m_modifier->GetClassName(modifierClassName);

                                    if ( modifierClassName == strBody )
                                    {
                                        HCT_SCOPED_CONVERSIONS;

                                        // This is a breakable body that didn't have its UUID set. Do it now
                                        hkUuid uuid;        uuid.setRandom();
                                        hkStringBuf strb;   uuid.toString(strb);
                                        MSTR mstr           = TO_MAX(strb.cString());
                                        paramBlock->SetValue(paramID, 0, mstr);
                                    }
                                }
                                else
                                if ( paramNameStr == strPrio )
                                {
                                    const int actionPriority = getActionModifierDefaultPriority();
                                    if ( actionPriority >= 0 )
                                    {
                                        paramBlock->SetValue(paramID, 0, actionPriority);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    //
    // As a post-step we need to go through all backed-up values once more and manually unlock those reference targets
    // whose Custom Attribute/member were deleted (as opposed to moved) and thus didn't get unlocked by the new CA/member.
    //
    {
        for (int i = 0; i < m_backupArray.getSize(); i++)
        {
            ValueBackup& backupValue = m_backupArray[i];
            if ( backupValue.m_refTargetLocked )
            {
                backupValue.m_refTarget->ClearAFlag(A_LOCK_TARGET);
                backupValue.m_refTargetLocked = false;
            }
        }
    }
}

class hkGenericModifierUpgradeBackupAttributesPLCB : public PostLoadCallback
{
    public:

        hkGenericModifierUpgradeBackupAttributesPLCB(hctGenericModifier* genericModifier)
        :   m_modifier(genericModifier)
        {
        }

        int Priority ()
        {
            // Using Priority 9 makes sure that *this* callback is executed *before* our other callback.
            return 9;
        }

        void proc (ILoad* iload)
        {
            //
            // First step to versioning the custom attributes:
            // Make a backup of all custom attributes values after they have been loaded from the file.
            // Rebuilding the GUI (next step below) will drop any values that have just been moved around
            // in the layout (i.e. to a different rollout).
            //
            {
                m_modifier->m_attributesBackupDuringLoad = new hctGenericModifierCustomAttributesVersioningUtil(m_modifier);
                m_modifier->m_attributesBackupDuringLoad->backupValues();
            }

            delete this;
        }

    protected:

        hctGenericModifier* m_modifier;
};


class hkGenericModifierUpgradeRestoreAttributesPLCB : public PostLoadCallback
{
    public:

        hkGenericModifierUpgradeRestoreAttributesPLCB(hctGenericModifier* genericModifier)
        :   m_modifier(genericModifier)
        {
        }

        int Priority ()
        {
            // Using Priority 10 makes sure that *this* callback is executed *after* our other callback.
            return 10;
        }

        void proc (ILoad* iload)
        {
            //
            // Rebuild the GUI.
            //
            {
                Interface* ip = GetCOREInterface();
                std::stringstream execString;
                hctGenericModifierUtil::createCustomAttributesDefinition(m_modifier->getId(), execString);
                std::string execStringStr = execString.str();
                hctMaxUtils::evaluateMAXScript(ip, execStringStr.c_str());
            }

            //
            // Restore the custom attributes values. This will successfully copy back the original values to all attributes
            // that have just been moved around in the GUI but have kept their original name and type.
            //
            {
                m_modifier->m_attributesBackupDuringLoad->restoreValues();
                delete m_modifier->m_attributesBackupDuringLoad;
                m_modifier->m_attributesBackupDuringLoad = HK_NULL;
            }

//          IParamBlock2* pblock2 = m_modifier->GetParamBlock (PB_GENERIC_MOD_PBLOCK);
//          const int version = pblock2->GetInt(PA_GENERIC_MOD_VERSION_INTERNAL);
//
//          // Set version to the latest
//          pblock2->SetValue(PA_GENERIC_MOD_VERSION_INTERNAL, 0, CURRENT_GENERIC_MODIFIER_VERSION);

            delete this;
        }

    protected:

        hctGenericModifier* m_modifier;
};






hctGenericModifier::hctGenericModifier(ClassDesc2* theClassDesc, int id)
:   hctBasicModifier(theClassDesc)
,   m_id(id)
,   m_attributesBackupDuringLoad(HK_NULL)
{
    updateNamesFromId();
}

void hctGenericModifier::updateNamesFromId()
{
    HCT_SCOPED_CONVERSIONS;
    m_objectName = TO_MAX(hctSdkUtils::getUiClass(m_id).m_displayName);
    m_className = TO_MAX(hctSdkUtils::getUiClass(m_id).m_class->getName());
}

hctGenericModifier::~hctGenericModifier()
{
}


Class_ID hctGenericModifier::ClassID()
{
    return HK_GENERIC_MODIFIER_CLASS_ID;
}


CONST15 MCHAR *hctGenericModifier::GetObjectName()
{
    return m_objectName;
}


void hctGenericModifier::GetClassName(MSTR& s)
{
    s = m_className;
}


void hctGenericModifier::BaseClone(ReferenceTarget* from, ReferenceTarget* to, RemapDir& remap)
{
    g_hctCurrentGenericModifierTempTransfer = (hctGenericModifier*)from;
    define_system_global(TEXT("hvkDestruction_copyModifierData_srcModifier"), hkCurrentGenericModifier_get, hkCurrentGenericModifier_set);

    g_hctCurrentGenericModifierTempTransfer2 = (hctGenericModifier*)to;
    define_system_global(TEXT("hvkDestruction_copyModifierData_dstModifier"), hkCurrentGenericModifier2_get, hkCurrentGenericModifier_set);

    Interface* ip = GetCOREInterface();
    std::string execString("");
    execString.append("hvkDestruction_copyModifierData hvkDestruction_copyModifierData_srcModifier hvkDestruction_copyModifierData_dstModifier\n");
    hctMaxUtils::evaluateMAXScript(ip, execString.c_str());
}


IOResult hctGenericModifier::Load(ILoad* iload)
{
    IOResult res = hctBasicModifier::Load(iload);

    iload->RegisterPostLoadCallback(new hkGenericModifierUpgradeBackupAttributesPLCB(this));
    iload->RegisterPostLoadCallback(new hkGenericModifierUpgradeRestoreAttributesPLCB(this));

    while ( (res = iload->OpenChunk()) == IO_OK )
    {
        switch ( iload->CurChunkID() )
        {
        case HCT_GENERIC_MODIFIER_ID_CHUNK:
            {
                ULONG nb;
                res = iload->Read(&m_id, sizeof(m_id), &nb);
                break;
            }
        }

        iload->CloseChunk();
        if ( res != IO_OK )
        {
            return res;
        }
    }

    setClassDesc2(getHkGenericModifierDescById(m_id));

    updateNamesFromId();

    return IO_OK;
}


IOResult hctGenericModifier::Save(ISave *isave)
{
    IOResult res = Modifier::Save(isave);

    ULONG nb;
    isave->BeginChunk(HCT_GENERIC_MODIFIER_ID_CHUNK);
    isave->Write(&m_id, sizeof(m_id), &nb);
    isave->EndChunk();

    return res;
}


void hctGenericModifier::initUI()
{
    // We need to define a (hidden) global MAXScript variable that holds the current modifier so that
    // the auto-generated MAXScript can access it.
    g_hctCurrentGenericModifierTempTransfer = this;
    define_system_global(TEXT("hkCurrentGenericModifierTempTransfer"), hkCurrentGenericModifier_get, hkCurrentGenericModifier_set);

    int modifierId = this->m_id;
    hctGenericModifierUtil::addCustomAttributesToModifier(modifierId);
}


void hctGenericModifier::updateUI ()
{
}


hctBasicXTCObject* hctGenericModifier::getXTCObject (int number, TimeValue t, ModContext &mc, ObjectState * os, INode *node)
{
    if ( hkString::strCmp( hctSdkUtils::getUiClass(m_id).m_class->getName(), "hkdBody") == 0 )
    {
        hctGenericXTCObject* xtcObject = new hctGenericXTCObject();
        xtcObject->m_genericModifierBacklink = this;
        return xtcObject;
    }
    else
    {
        return NULL;
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
