// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/hkBase.h>
#include <ContentTools/Max/MaxSceneExport/resource.h>

#include <ContentTools/Max/MaxSceneExport/Modifiers/hctBasicModifier.h>
#include <ContentTools/Max/MaxFpInterfaces/Physics/ExportChannel/hctExportChannelModifierInterface.h>


// Modifier representing a Havok Export Channel.
// Turns a 3dsMax paint channel into an export channel, with its own name, rescaling and type used at export time.
// Below "Havok Channel" is used as synonym of Export Channel, while just "channel" is meant to be paint channel.
// It displays the channel's values according to the type.
class hctExportChannelModifier : public hctBasicModifier
{
    public:

        //Constructor/Destructor
        hctExportChannelModifier(ClassDesc2* theClassDesc);
        virtual ~hctExportChannelModifier();

        // From hctBasicModifier
        // Enables/disables controls
        /*virtual*/ void updateUI();

        struct MyNormal
        {
            Point3 normal;
            DWORD smGroup;
            int contributions;

            MyNormal() : normal( 0,0,0 ), smGroup(-1), contributions(0) {}
        };

        // Particle display data struct: radius and position
        struct ParticleData
        {
            Point3 position;
            Point3 normal;
            float value;
        };

        /*
        ** EXTENSION CHANNEL (unselected display) : From hctBasicModifier
        */
        virtual int getNumXTCObjects () { return 1; }
        /*virtual*/  hctBasicXTCObject* getXTCObject (int number, TimeValue t, ModContext &mc, ObjectState * os, INode *node);

        /*
        ** MAX STUFF
        */

        //From Animatable
        /*virtual*/ Class_ID ClassID() { return HK_EXPORT_CHANNEL_MODIFIER_CLASS_ID;}
        /*virtual*/ CONST15 MCHAR *GetObjectName() { return GetString( IDS_EXPORT_CHANNEL_MODIFIER_OBJECT_NAME ); }
        /*virtual*/ void GetClassName(MSTR& s) { s = GetString( IDS_EXPORT_CHANNEL_MODIFIER_CLASS_NAME );}

        /* From Animatable. It sets ups dialog procs. Make sure inheriting classes call them too */
        /*virtual*/ void BeginEditParams(IObjParam *ip, ULONG flags,Animatable *prev);
        /*virtual*/ void EndEditParams(IObjParam *ip, ULONG flags,Animatable *next);

        /*virtual*/ void NotifyInputChanged(Interval changeInt, PartID partID, RefMessage message, ModContext *mc);
        /*virtual*/ void ModifyObject(TimeValue t, ModContext &mc, ObjectState * os, INode *node);

        // returns true if the display is requested
        BOOL shouldDisplay(TimeValue t, INode* inode);

        // access to materials
        Material* getSphereDisplayMaterial(TimeValue t);
        Material* getSphereDisplayMaterialNegRadius();

        // extracts a TriObject from Object
        static TriObject* extractTriObjectFromObject( TimeValue t, Object* obj, bool& deleteTriObject );

        // retrieves mesh channel name for the specified ID, returns true if found
        static bool getMeshChannelName (INode* inode, int channelId, MSTR& nameOut);

        // access to display meshes
        // Sphere
        static Mesh& getSphereDisplayMeshLowRes() { return m_sphereDisplayMeshLowRes; }
        static Mesh& getSphereDisplayMeshHighRes() { return m_sphereDisplayMeshHighRes; }
        static Mesh& getSphereDisplayMesh( int lowRes = false ) { return (lowRes)? getSphereDisplayMeshLowRes() : getSphereDisplayMeshHighRes(); }
        // Distance
        static Mesh& getDistanceDisplayMeshLowRes() { return m_sphereDisplayMeshLowRes; }
        static Mesh& getDistanceDisplayMeshHighRes() { return m_sphereDisplayMeshHighRes; }
        static Mesh& getDistanceDisplayMesh( int lowRes = false ) { return (lowRes)? getDistanceDisplayMeshLowRes() : getDistanceDisplayMeshHighRes(); }
        // Dummy
        static Mesh& getDummyDisplayMesh() { return m_dummyDisplayMesh; }

        void GetWorldBoundBox(TimeValue t,INode* inode, ViewExp *vpt, Box3& box, ModContext *mc);
        /*virtual*/ void GetLocalBoundBox(TimeValue t, INode* inode, ViewExp* vp, Box3& box );

        // Check if particle data is up to date and update id necessary
        void checkAndUpdateData( TimeValue t, INode* inode, Object* object, Tab<hctExportChannelModifier::ParticleData>& data );

        Tab<hctExportChannelModifier::ParticleData>* getParticleData() { return &m_particleData; }

        const float& getMaxRadius() const { return m_maxRadius; }
        const Box3& getBBox() const { return m_bBox; }

        bool isNormalsDataUpToDate() const { return !m_updateNormals; }
        bool isParticleDataUpToDate() const { return !m_updateParticleData; }

        /*virtual*/ int getNumComboBoxes () { return 2; }
        hctBasicModifier::ComboBoxDescriptor* getComboBoxDescriptor ( int comboBoxID );

        int getDisplayType();

        float getParticleValObjRatioX() const { return m_particleValObjRatioX; }
        float getParticleValObjRatioY() const { return m_particleValObjRatioY; }

    private:
        int getMapChannelID( IParamBlock2* pblock );

        // mesh setup
        static void createSphereDisplayMeshes();
        static void createDistanceDisplayMeshes();

        // material setup
        void setupMaterials();

        // Retrieves vertex normals from the rendering vertex of the mesh for the "vIdx-th" vertex
        void updateNormalsForParticle( Point3& normalOut, int vIdx, Mesh& theMesh );

        // Retrieve particle data
        void gatherParticleNormalsData( TimeValue t, INode* inode, Object* object, Tab<hctExportChannelModifier::ParticleData>& data );
        void gatherParticleVertexColorData(TimeValue t, INode* inode, Object* object, Tab<hctExportChannelModifier::ParticleData>& data);

    private:
        // Display data
        // Array of particle data, for each particle the position and value
        Tab<hctExportChannelModifier::ParticleData> m_particleData;

        // Keeps the indices to get the particle value from the mesh mapVerts. Size is the same as m_particleData
        Tab<int> m_particleValueMap;

        // max particle radius
        float m_maxRadius;
        // object's bounding box
        Box3 m_bBox;
        // true if the materials were set
        bool m_areMaterialsSet;
        // radius display material
        Material m_sphereDisplayMaterial;
        Material m_sphereDisplayMaterialNegRadius;

        // STATIC DISPLAY DATA -- reused by all instances
        // true if the sphere display mesh has been initialized
        static bool m_isSphereMeshCreated;
        static bool m_isDistanceMeshCreated;
        // display meshes, different complexities
        static Mesh m_sphereDisplayMeshLowRes;
        static Mesh m_sphereDisplayMeshHighRes;
        static Mesh m_dummyDisplayMesh;

        // true if the object was modified and we have not updated the data yet
        BOOL m_updateParticleData;
        BOOL m_updateNormals;

        // bbox of the object
        Box3 m_bbox;
        float m_particleValObjRatioX;
        float m_particleValObjRatioY;

        int m_channelType;
};

// EXTENSION CHANNELS


// Channel for per particle radius display
#define HK_EXPORT_CHANNEL_XTCOBJECT_CLASS_ID     Class_ID(0x652c079a, 0x30be36ba)

class hctExportChannelXTCObject : public hctBasicXTCObject
{
    public:

        hctExportChannelXTCObject(hctExportChannelModifier* theModifier);
        ~hctExportChannelXTCObject(){}

        /*virtual*/ Class_ID ExtensionID() { return HK_EXPORT_CHANNEL_XTCOBJECT_CLASS_ID; }

        /*virtual*/ XTCObject *Clone() { return new hctExportChannelXTCObject( m_modifier ); }

        static Mesh& getDisplayMesh( int elementCount, int type );

        /*virtual*/ int Display (TimeValue t, INode* inode, ViewExp *vpt, int flags, Object *pObj);
        /*virtual*/  void MaybeEnlargeViewportRect(GraphicsWindow *gw, Rect &rect);
        // we want to be notified of any change in the vertex color channel
        ChannelMask DependsOn() { return 0; /*m_channelDependencies;*/ }

        // We'll update our data
        void PostChanChangedNotify(TimeValue t, ModContext &mc, ObjectState* os, INode *node, Modifier *mod, bool bEndOfPipeline)
        {
            /*m_updateData = true;*/
        }
    private:

        void displaySpheres( TimeValue t, GraphicsWindow* gw, Tab<hctExportChannelModifier::ParticleData>* data, Mesh& displayMesh, INode* inode, Material* material );
        void displayNormalDistances( TimeValue t, GraphicsWindow* gw, const Tab<hctExportChannelModifier::ParticleData>* data, Mesh& displayMesh, INode* inode, Material* material );

    private:
        // the Simulation cloth modifier that created this Channel Object
        hctExportChannelModifier* m_modifier;

        // saved object translation
        Point3 m_translation;

        // true if the data was modified ( set by PostChanChangedNotify )
        BOOL m_updateData;

        // Channels this Object depends on
        static unsigned long m_channelDependencies;
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
