// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>
#include <ContentTools/Max/MaxSceneExport/Modifiers/Constraints/hctConstraintModifier.h>

BaseInterface* hctConstraintModifier::GetInterface(Interface_ID id)
{
    BaseInterface* result = NULL;

    if (id == HK_CONSTRAINT_FPINTERFACE_ID)
    {
        result = (hctConstraintModifierFPInterface*) this;
    }
    else
    {
        result = hctBasicModifier::GetInterface(id);
    }

    return result;
}



/*
** FP Interface
*/

static FPInterfaceDesc g_theCommonFPInterfaceDescriptor
    (
    HK_CONSTRAINT_FPINTERFACE_ID, _T("hkConstraintModifierInterface"), 0, NULL, FP_MIXIN,

    // methods,
        FPI_ResetChildSpaceRotation, TEXT("resetChildSpaceRotation"), IDS_CONSTRAINT_MODIFIER_ACTION_RESET_CHILD_SPACE_ROTATION, TYPE_BOOL, 0, 0,
        FPI_ResetChildSpaceTranslation, TEXT("resetChildSpaceTranslation"), IDS_CONSTRAINT_MODIFIER_ACTION_RESET_CHILD_SPACE_TRANSLATION, TYPE_BOOL, 0, 0,
        FPI_ResetParentSpaceRotation, TEXT("resetParentSpaceRotation"), IDS_CONSTRAINT_MODIFIER_ACTION_RESET_PARENT_SPACE_ROTATION, TYPE_BOOL, 0, 0,
        FPI_ResetParentSpaceTranslation, TEXT("resetParentSpaceTranslation"), IDS_CONSTRAINT_MODIFIER_ACTION_RESET_PARENT_SPACE_TRANSLATION, TYPE_BOOL, 0,0,

    properties,
        FPI_GetChildSpaceInWorld, FPI_SetChildSpaceInWorld, TEXT("childSpaceInWorld"), IDS_CONSTRAINT_MODIFIER_PROP_CHILD_SPACE_IN_WORLD, TYPE_MATRIX3,
        FPI_GetParentSpaceInWorld, FPI_SetParentSpaceInWorld, TEXT("parentSpaceInWorld"), IDS_CONSTRAINT_MODIFIER_PROP_PARENT_SPACE_IN_WORLD, TYPE_MATRIX3,
    p_end
    );


void hctConstraintModifier::addCommonFPInterface (hctConstraintDescriptor* constraintDescriptor)
{
    ClassDesc2* classDesc = constraintDescriptor->getClassDesc();

    classDesc->AddInterface(&g_theCommonFPInterfaceDescriptor);
}

FPInterfaceDesc* hctConstraintModifier::getCommonFPInterfaceDescriptor()
{
    return &g_theCommonFPInterfaceDescriptor;
}

BOOL hctConstraintModifier::iResetChildSpaceTranslation()
{
    IParamBlock2* pblock2 = GetParamBlock(PB_CONSTRAINT_MOD_COMMON_SPACES_PARAMS);

    TimeValue now = GetCOREInterface()->GetTime();

    BEGIN_UNDOABLE_ACTION
        pblock2->SetValue(PA_CONSTRAINT_MOD_CHILD_SPACE_TRANSLATION,now,Point3(0,0,0));
    END_UNDOABLE_ACTION (GetString(IDS_CONSTRAINT_MODIFIER_ACTION_RESET_CHILD_SPACE_TRANSLATION))

    return FPS_OK;
}

BOOL hctConstraintModifier::iResetChildSpaceRotation()
{
    IParamBlock2* pblock2 = GetParamBlock(PB_CONSTRAINT_MOD_COMMON_SPACES_PARAMS);

    TimeValue now = GetCOREInterface()->GetTime();

    BEGIN_UNDOABLE_ACTION
        pblock2->SetValue(PA_CONSTRAINT_MOD_CHILD_SPACE_ROTATION,now,Matrix3(1));
    END_UNDOABLE_ACTION (GetString(IDS_CONSTRAINT_MODIFIER_ACTION_RESET_CHILD_SPACE_ROTATION))

    return FPS_OK;
}

BOOL hctConstraintModifier::iResetParentSpaceTranslation()
{
    IParamBlock2* pblock2 = GetParamBlock(PB_CONSTRAINT_MOD_COMMON_SPACES_PARAMS);
    const TimeValue now = GetCOREInterface()->GetTime();
    const bool transLocked = pblock2->GetInt(PA_CONSTRAINT_MOD_PARENT_TRANSLATION_LOCK,now) != FALSE;

    const bool resetToChildSpace = getConstraintDescriptor()->parentSpaceResetsToChildSpace();

    if ( (transLocked&&resetToChildSpace) || (!transLocked&&!resetToChildSpace))
    {
        // If we:
        //   Want to align the parent space to the child space, and the parent space is locked (child-space-relative), or
        //   want to align the parent space to the parent body, and the parent space is unlocked (parent-body-relative), then
        //   We just need to set the translation to 0,0,0
        BEGIN_UNDOABLE_ACTION
            pblock2->SetValue(PA_CONSTRAINT_MOD_PARENT_SPACE_TRANSLATION,now, Point3(0,0,0));
        END_UNDOABLE_ACTION (GetString(IDS_CONSTRAINT_MODIFIER_ACTION_RESET_PARENT_SPACE_TRANSLATION))
    }
    else
    {
        INode* inode = hctMaxUtils::findNodeRef(this);
        if (!inode) return FPS_FAIL;

        Matrix3 childSpaceToWorld;
        this->getSubobjectTransform(SOBJ_CONSTRAINT_MOD_CHILD_SPACE,now, inode, childSpaceToWorld);

        Matrix3 parentToWorld(1);
        INode* parentNode = pblock2->GetINode(PA_CONSTRAINT_MOD_PARENT_NODE,now);
        if (parentNode)
        {
            parentToWorld = parentNode->GetNodeTM(now);
        }

        // - Align the parent space to the child space, when the parent space is unlocked (parent-body-relative)
        if ( resetToChildSpace ) // && !transLocked
        {
            // we want parentSpaceToWorld = parentSpaceToParent * parentToworld = childSpaceToWorld
            // so parentSpaceToParent = childSpaceToWorld * Inv(parentToWorld)
            Matrix3 parentSpaceToParent = childSpaceToWorld * Inverse(parentToWorld);

            BEGIN_UNDOABLE_ACTION
                Point3 translation = parentSpaceToParent.GetTrans();
                pblock2->SetValue(PA_CONSTRAINT_MOD_PARENT_SPACE_TRANSLATION,now,translation);
            END_UNDOABLE_ACTION (GetString(IDS_CONSTRAINT_MODIFIER_ACTION_RESET_PARENT_SPACE_TRANSLATION))
        }
        else
        // - Align the parent space to the parent body, when the parent space is locked (child-space-relative)
        {
            // !resetChildtospace && transLocked
            // We want parentSpaceToWorld = parentSpaceToChildSpace * childSpaceToWorld = parentToWorld
            // so parentSpaceToChildSpace = parentToWorld * Inv (childSpaceToWorld)
            Matrix3 parentSpaceToChildSpace = parentToWorld * Inverse (childSpaceToWorld);

            BEGIN_UNDOABLE_ACTION
                Point3 translation = parentSpaceToChildSpace.GetTrans();
                pblock2->SetValue(PA_CONSTRAINT_MOD_PARENT_SPACE_TRANSLATION,now,translation);
            END_UNDOABLE_ACTION (GetString(IDS_CONSTRAINT_MODIFIER_ACTION_RESET_PARENT_SPACE_TRANSLATION))
        }

    }


    return FPS_OK;
}

BOOL hctConstraintModifier::iResetParentSpaceRotation()
{
    IParamBlock2* pblock2 = GetParamBlock(PB_CONSTRAINT_MOD_COMMON_SPACES_PARAMS);

    const TimeValue now = GetCOREInterface()->GetTime();
    const bool rotLocked = pblock2->GetInt(PA_CONSTRAINT_MOD_PARENT_ROTATION_LOCK,now) != FALSE;
    const bool resetToChildSpace = getConstraintDescriptor()->parentSpaceResetsToChildSpace();


    if ((rotLocked&&resetToChildSpace)|| (!rotLocked&&!resetToChildSpace))
    {
        // If we:
        //   Want to align the parent space to the child space, and the parent space is locked (child-space-relative), or
        //   want to align the parent space to the parent body, and the parent space is unlocked (parent-body-relative), then
        //   We just need to set the rotation to identity
        BEGIN_UNDOABLE_ACTION
            pblock2->SetValue(PA_CONSTRAINT_MOD_PARENT_SPACE_ROTATION,now, Matrix3(1));
        END_UNDOABLE_ACTION (GetString(IDS_CONSTRAINT_MODIFIER_ACTION_RESET_PARENT_SPACE_ROTATION))

    }
    else
    {
        INode* inode = hctMaxUtils::findNodeRef(this);
        if (!inode) return FPS_FAIL;

        Matrix3 childSpaceToWorld;
        this->getSubobjectTransform(SOBJ_CONSTRAINT_MOD_CHILD_SPACE,now, inode, childSpaceToWorld);

        Matrix3 parentToWorld(1);
        INode* parentNode = pblock2->GetINode(PA_CONSTRAINT_MOD_PARENT_NODE,now);
        if (parentNode)
        {
            parentToWorld = parentNode->GetNodeTM(now);
        }

        // - Align the parent space to the child space, when the parent space is unlocked (parent-body-relative)
        if (resetToChildSpace)
        {
            // we want parentSpaceToWorld = parentSpaceToParent * parentToworld = childSpaceToWorld
            // so parentSpaceToParent = childSpaceToWorld * Inv(parentToWorld)
            Matrix3 parentSpaceToParent = childSpaceToWorld * Inverse(parentToWorld);
            parentSpaceToParent.SetTrans(Point3(0,0,0));

            BEGIN_UNDOABLE_ACTION
                pblock2->SetValue(PA_CONSTRAINT_MOD_PARENT_SPACE_ROTATION,now,parentSpaceToParent);
            END_UNDOABLE_ACTION (GetString(IDS_CONSTRAINT_MODIFIER_ACTION_RESET_PARENT_SPACE_ROTATION))
        }
        else
        // - Align the parent space to the parent body, when the parent space is locked (child-space-relative)
        {
            // !resetChildtospace && transLocked
            // We want parentSpaceToWorld = parentSpaceToChildSpace * childSpaceToWorld = parentToWorld
            // so parentSpaceToChildSpace = parentToWorld * Inv (childSpaceToWorld)
            Matrix3 parentSpaceToChildSpace = parentToWorld * Inverse (childSpaceToWorld);
            parentSpaceToChildSpace.SetTrans(Point3(0,0,0));

            BEGIN_UNDOABLE_ACTION
                pblock2->SetValue(PA_CONSTRAINT_MOD_PARENT_SPACE_ROTATION,now,parentSpaceToChildSpace);
            END_UNDOABLE_ACTION (GetString(IDS_CONSTRAINT_MODIFIER_ACTION_RESET_PARENT_SPACE_ROTATION))

        }

    }

    return FPS_OK;
}

Matrix3 hctConstraintModifier::iGetChildSpaceInWorld(TimeValue t)
{
    Matrix3 result;
    ConstraintSpaceData currentData;
    getConstraintSpaceData(t, NULL, currentData);

    getSpaceInWorld(currentData, SOBJ_CONSTRAINT_MOD_CHILD_SPACE, t, result);

    return result;
}

void hctConstraintModifier::iSetChildSpaceInWorld(Matrix3 childSpaceWorld, TimeValue t)
{
    BEGIN_UNDOABLE_ACTION
        setSpaceInWorld (SOBJ_CONSTRAINT_MOD_CHILD_SPACE, t, NULL, childSpaceWorld);
    END_UNDOABLE_ACTION (GetString(IDS_CONSTRAINT_MODIFIER_UNDO_SET_CHILD_SPACE_TRANSFORM))
}

Matrix3 hctConstraintModifier::iGetParentSpaceInWorld(TimeValue t)
{
    Matrix3 result;
    ConstraintSpaceData currentData;
    getConstraintSpaceData(t, NULL, currentData);

    getSpaceInWorld(currentData, SOBJ_CONSTRAINT_MOD_PARENT_SPACE, t, result);

    return result;
}

void hctConstraintModifier::iSetParentSpaceInWorld(Matrix3 parentSpaceWorld, TimeValue t)
{
    BEGIN_UNDOABLE_ACTION
        setSpaceInWorld (SOBJ_CONSTRAINT_MOD_PARENT_SPACE, t, NULL, parentSpaceWorld);
    END_UNDOABLE_ACTION (GetString(IDS_CONSTRAINT_MODIFIER_UNDO_SET_PARENT_SPACE_TRANSFORM))
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
