// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>
#include <ContentTools/Max/MaxSceneExport/Modifiers/Constraints/hctConstraintModifier.h>

bool hctConstraintModifier::m_meshesAndMaterialsSetup = false;
Material hctConstraintModifier::m_parentSpaceMaterial;
Material hctConstraintModifier::m_childSpaceMaterial;
Material hctConstraintModifier::m_limitsMaterial;

//Constructor/Destructor
hctConstraintModifier::hctConstraintModifier(ClassDesc2* theClassDesc)
:   hctBasicModifier(theClassDesc)
{

    if (!m_meshesAndMaterialsSetup)
    {
        setupMeshesAndMaterials();
    }

    makePreviousValuesCurrent();
}

hctConstraintModifier::~hctConstraintModifier()
{

}

void hctConstraintModifier::SetReference(int i, RefTargetHandle rtarg)
{
    hctBasicModifier::SetReference(i, rtarg);

    if ((i==PB_CONSTRAINT_MOD_COMMON_SPACES_PARAMS) && (rtarg!=NULL))
    {
        makePreviousValuesCurrent();
    }
}

void hctConstraintModifier::makePreviousValuesCurrent()
{
    // Initialize "previous" values
    IParamBlock2* pblock2 = GetParamBlock(PB_CONSTRAINT_MOD_COMMON_SPACES_PARAMS);
    m_previousConstrainTo = pblock2->GetInt(PA_CONSTRAINT_MOD_WORLD_OR_PARENT);
    m_previousParentNode = pblock2->GetINode(PA_CONSTRAINT_MOD_PARENT_NODE);
    m_previousParentTranslationLocked = pblock2->GetInt(PA_CONSTRAINT_MOD_PARENT_TRANSLATION_LOCK) != FALSE;
    m_previousParentRotationLocked = pblock2->GetInt(PA_CONSTRAINT_MOD_PARENT_ROTATION_LOCK) != FALSE;
}



void hctConstraintModifier::Move(TimeValue t, ::Matrix3& partm, ::Matrix3& tmAxis, Point3& despAxis, BOOL localOrigin )
{
    IParamBlock2* pblock2 = GetParamBlock(PB_CONSTRAINT_MOD_COMMON_SPACES_PARAMS);

    INode* childNode = hctMaxUtils::findNodeRef (this);

    if (!childNode) return;

    if (!theHold.Holding())
    {
        theHold.Begin();
        SetAFlag(A_HELD);
    }
    else if(!TestAFlag(A_HELD))
    {
        SetAFlag(A_HELD);
    }

    /*
    ** We need to know
    ** - The Point3 parameter that stores the translation
    ** - The space to which that translation is relative
    */
    Matrix3 relativeTM; // relativeToWorld
    ParamID parameterID = -1;
    {
        const int subobjId = getCurrentSubobjectID();
        switch (subobjId)
        {
            case SOBJ_CONSTRAINT_MOD_CHILD_SPACE:
            {
                parameterID = PA_CONSTRAINT_MOD_CHILD_SPACE_TRANSLATION;
                relativeTM = childNode->GetNodeTM(t);
                break;
            }
            case SOBJ_CONSTRAINT_MOD_PARENT_SPACE:
            {
                parameterID = PA_CONSTRAINT_MOD_PARENT_SPACE_TRANSLATION;

                INode* parent = pblock2->GetINode(PA_CONSTRAINT_MOD_PARENT_NODE, t);
                if (!parent)
                {
                    relativeTM.IdentityMatrix();
                }
                else
                {
                    relativeTM = parent->GetNodeTM(t);
                }
                break;
            }
        }
    }

    /*
    ** Now we calculate the relative displacement and add it to the stored parameter
    */

    const Point3 despWorld = VectorTransform ( tmAxis, despAxis);
    const Matrix3 worldToRelative = Inverse (relativeTM);
    const Point3 despRelative = VectorTransform (worldToRelative, despWorld);
    Point3 relativeTrans = pblock2->GetPoint3(parameterID, t);
    relativeTrans += despRelative;
    pblock2->SetValue(parameterID, t, relativeTrans);

    NotifyDependents(FOREVER, PART_ALL, REFMSG_CHANGE);
}

void hctConstraintModifier::Rotate(TimeValue t, Matrix3& partm, Matrix3& tmAxis, Quat& val, BOOL localOrigin )
{
    IParamBlock2* pblock2 = GetParamBlock(PB_CONSTRAINT_MOD_COMMON_SPACES_PARAMS);

    INode* childNode = hctMaxUtils::findNodeRef (this);

    if (!childNode) return;

    if (!theHold.Holding())
    {
        theHold.Begin();
        SetAFlag(A_HELD);
    }
    else if(!TestAFlag(A_HELD))
    {
        SetAFlag(A_HELD);
    }

    /*
    ** We need to know
    ** - The Point3 parameter that stores the translation
    ** - The space to which that translation is relative
    */
    Matrix3 relativeTM; // relativeToWorld
    ParamID parameterID = -1;
    {
        const int subobjId = getCurrentSubobjectID();
        switch (subobjId)
        {
            case SOBJ_CONSTRAINT_MOD_CHILD_SPACE:
            {
                parameterID = PA_CONSTRAINT_MOD_CHILD_SPACE_ROTATION;
                relativeTM = childNode->GetNodeTM(t);
                break;
            }
            case SOBJ_CONSTRAINT_MOD_PARENT_SPACE:
            {
                parameterID = PA_CONSTRAINT_MOD_PARENT_SPACE_ROTATION;

                INode* parent = pblock2->GetINode(PA_CONSTRAINT_MOD_PARENT_NODE, t);
                if (!parent)
                {
                    relativeTM.IdentityMatrix();
                }
                else
                {
                    relativeTM = parent->GetNodeTM(t);
                }
                break;
            }
        }
    }

    /*
    ** Now we calculate the relative displacement and add it to the stored parameter
    */

    Quat despWorld = TransformQuat(tmAxis,val);
    const Matrix3 worldToRelative = Inverse (relativeTM);
    Quat despRel = TransformQuat(worldToRelative, despWorld);
    Matrix3 despRelative; despRel.MakeMatrix(despRelative);

    Matrix3 currentRot = pblock2->GetMatrix3(parameterID, t);
    currentRot = currentRot * despRelative;
    currentRot.SetTrans(Point3(0,0,0));
    pblock2->SetValue(parameterID, t, currentRot);

    NotifyDependents(FOREVER, PART_ALL, REFMSG_CHANGE);

}

void hctConstraintModifier::GetLocalBoundBox(TimeValue t, INode* inode, ViewExp* vpt, Box3& box3 )
{
    Box3 worldBox;
    GetWorldBoundBox(t,inode,vpt,worldBox,NULL);

    Matrix3 worldToLocal = Inverse(inode->GetNodeTM(t));

    box3 = worldBox * worldToLocal;
}


int hctConstraintModifier::getNumSubobjects ()
{
    return 2;
}
bool hctConstraintModifier::canSubobjectMove (int subobjId)
{
    IParamBlock2* pblock2 = GetParamBlock(PB_CONSTRAINT_MOD_COMMON_SPACES_PARAMS);

    switch (subobjId)
    {
        case SOBJ_CONSTRAINT_MOD_PARENT_SPACE:
            {
                return (pblock2->GetInt(PA_CONSTRAINT_MOD_PARENT_TRANSLATION_LOCK) == FALSE);
            }
        case SOBJ_CONSTRAINT_MOD_CHILD_SPACE:
            {
                return (pblock2->GetInt(PA_CONSTRAINT_MOD_CHILD_TRANSLATION_LOCK) == FALSE);
            }
    }

    return false;
}

bool hctConstraintModifier::canSubobjectRotate (int subobjId)
{
    IParamBlock2* pblock2 = GetParamBlock(PB_CONSTRAINT_MOD_COMMON_SPACES_PARAMS);

    if (getConstraintDescriptor()->ignoreRotations())
    {
        return false;
    }

    switch (subobjId)
    {
        case SOBJ_CONSTRAINT_MOD_PARENT_SPACE:
            {
                return (pblock2->GetInt(PA_CONSTRAINT_MOD_PARENT_ROTATION_LOCK) == FALSE);
            }
        case SOBJ_CONSTRAINT_MOD_CHILD_SPACE:
            {
                return (pblock2->GetInt(PA_CONSTRAINT_MOD_CHILD_ROTATION_LOCK) == FALSE);
            }
    }

    return false;
}

bool hctConstraintModifier::canSubobjectScale (int subobjId)
{
    return false;
}

bool hctConstraintModifier::isSubobjectEnabled (int subobjId)
{
    return canSubobjectMove(subobjId) || canSubobjectRotate(subobjId);
}

void hctConstraintModifier::getSpaceInWorld (int subobjId, TimeValue t, INode* inode, Matrix3& spaceToWorldOut)
{
    ConstraintSpaceData data;
    getConstraintSpaceData (t, inode, data);

    hctConstraintModifier::getSpaceInWorld(data, subobjId, t, spaceToWorldOut);
}

void hctConstraintModifier::getConstraintSpaceData (TimeValue t, INode* inode, ConstraintSpaceData& dataOut)
{
    IParamBlock2* pblock2 = GetParamBlock(PB_CONSTRAINT_MOD_COMMON_SPACES_PARAMS);

    if (inode == NULL)
    {
        inode = hctMaxUtils::findNodeRef(this);
    }

    dataOut.m_childNode = inode;
    dataOut.m_parentNode = pblock2->GetINode(PA_CONSTRAINT_MOD_PARENT_NODE, t);
    dataOut.m_childSpaceRotation = pblock2->GetMatrix3(PA_CONSTRAINT_MOD_CHILD_SPACE_ROTATION, t);
    dataOut.m_childSpaceTranslation = pblock2->GetPoint3(PA_CONSTRAINT_MOD_CHILD_SPACE_TRANSLATION, t);
    dataOut.m_parentSpaceRotation = pblock2->GetMatrix3(PA_CONSTRAINT_MOD_PARENT_SPACE_ROTATION, t);
    dataOut.m_parentSpaceTranslation = pblock2->GetPoint3(PA_CONSTRAINT_MOD_PARENT_SPACE_TRANSLATION, t);
    dataOut.m_parentSpaceRotationLocked = pblock2->GetInt(PA_CONSTRAINT_MOD_PARENT_ROTATION_LOCK) != FALSE;
    dataOut.m_parentSpaceTranslationLocked = pblock2->GetInt(PA_CONSTRAINT_MOD_PARENT_TRANSLATION_LOCK) != FALSE;
}


// Constraint spaces
void hctConstraintModifier::getSpaceInWorld (const ConstraintSpaceData& data, int subobjId, TimeValue t, Matrix3& spaceToWorldOut)
{

    switch (subobjId)
    {
        case SOBJ_CONSTRAINT_MOD_CHILD_SPACE:
        {
            // For the child node, the "lock" parameter does not affect the interpretation of the transform
            Matrix3 childSpaceToChild;
            {
                Quat childSpaceToChild_Rot (data.m_childSpaceRotation);
                Point3 childSpaceToChild_Trans (data.m_childSpaceTranslation);
                childSpaceToChild.SetRotate(childSpaceToChild_Rot);
                childSpaceToChild.SetTrans(childSpaceToChild_Trans);
            }
            Matrix3 childToWorld = (data.m_childNode!=NULL) ? data.m_childNode->GetNodeTM(t) : Matrix3(1);

            Matrix3 childSpaceToWorldTemp = childSpaceToChild * childToWorld;

            // Decompose (removes scale)
            Point3 childSpaceToWorldTranslation = childSpaceToWorldTemp.GetTrans();
            Quat childSpaceToWorldRotation = getRotationFromMatrix(childSpaceToWorldTemp);

            spaceToWorldOut.SetRotate(childSpaceToWorldRotation);
            spaceToWorldOut.SetTrans(childSpaceToWorldTranslation);
            break;
        }

        case SOBJ_CONSTRAINT_MOD_PARENT_SPACE:
        {
            // For the parent space, though, the "lock" parameters change the interpretation of the transform

            // We probably need the child space
            Matrix3 childSpaceToWorld;
            getSpaceInWorld (data, SOBJ_CONSTRAINT_MOD_CHILD_SPACE, t, childSpaceToWorld);

            INode* parentNode = data.m_parentNode;
            const Matrix3 parentToWorld = (parentNode!=NULL) ? parentNode->GetNodeTM(t) : Matrix3(1);

            Point3 parentSpaceTranslation_World;
            {
                const bool transLocked = data.m_parentSpaceTranslationLocked;
                if (!transLocked)
                {
                    // Not locked : relative to parent
                    Point3 parentSpaceTranslation_Parent = data.m_parentSpaceTranslation;
                    parentSpaceTranslation_World = parentSpaceTranslation_Parent * parentToWorld;
                }
                else
                {
                    // Locked : relative to child space
                    Point3 parentSpaceTranslation_ChildSpace = data.m_parentSpaceTranslation;
                    parentSpaceTranslation_World = parentSpaceTranslation_ChildSpace * childSpaceToWorld;
                }
            }

            Quat parentSpaceRotation_World;
            {
                const bool rotLocked = data.m_parentSpaceRotationLocked;
                if (!rotLocked)
                {
                    // Not locked : relative to parent
                    Quat parentSpaceRotation_Parent ( data.m_parentSpaceRotation );
                    parentSpaceRotation_World = parentSpaceRotation_Parent * getRotationFromMatrix(parentToWorld);
                }
                else
                {
                    // Locked : relative to child space
                    Quat parentSpaceRotation_ChildSpace ( data.m_parentSpaceRotation );
                    parentSpaceRotation_World = parentSpaceRotation_ChildSpace * getRotationFromMatrix(childSpaceToWorld);
                }
            }

            spaceToWorldOut.SetRotate(parentSpaceRotation_World);
            spaceToWorldOut.SetTrans(parentSpaceTranslation_World);
        }
    }
}

void hctConstraintModifier::setSpaceInWorld (int subobjId, TimeValue t, INode* inode, const Matrix3& spaceToWorld)
{
    IParamBlock2* pblock2 = GetParamBlock(PB_CONSTRAINT_MOD_COMMON_SPACES_PARAMS);

    if (inode == NULL)
    {
        inode = hctMaxUtils::findNodeRef(this);
    }

    {
        switch (subobjId)
        {
            case SOBJ_CONSTRAINT_MOD_CHILD_SPACE:
                {
                    Matrix3 nodeToWorld = (inode!=NULL) ? inode->GetNodeTM(t) : Matrix3(1);
                    Matrix3 spaceToNodeTemp = spaceToWorld * Inverse (nodeToWorld);

                    // Decompose
                    Point3 spaceToNodeTranslation = spaceToNodeTemp.GetTrans();
                    Quat spaceToNodeRotation = getRotationFromMatrix(spaceToNodeTemp);

                    Matrix3 spaceToNode;
                    spaceToNode.SetRotate(spaceToNodeRotation);
                    spaceToNode.SetTrans(spaceToNodeTranslation);

                    Point3 translation = spaceToNode.GetTrans();
                    pblock2->SetValue(PA_CONSTRAINT_MOD_CHILD_SPACE_TRANSLATION,t, translation);

                    // Remove translation
                    spaceToNode.SetTrans(Point3(0,0,0));
                    pblock2->SetValue(PA_CONSTRAINT_MOD_CHILD_SPACE_ROTATION,t,spaceToNode);
                    break;
                }

            case SOBJ_CONSTRAINT_MOD_PARENT_SPACE:
                {
                    INode* parentNode = pblock2->GetINode(PA_CONSTRAINT_MOD_PARENT_NODE, t);
                    const Matrix3 parentToWorld = (parentNode!=NULL) ? parentNode->GetNodeTM(t) : Matrix3(1);
                    Matrix3 childSpaceToWorld;
                    getSpaceInWorld(SOBJ_CONSTRAINT_MOD_CHILD_SPACE, t, inode, childSpaceToWorld);

                    // Rotation
                    {
                        const bool rotLocked = pblock2->GetInt(PA_CONSTRAINT_MOD_PARENT_ROTATION_LOCK) != FALSE;
                        Quat relativeToWorld;
                        if (rotLocked)
                        {
                            relativeToWorld = getRotationFromMatrix(childSpaceToWorld);
                        }
                        else
                        {
                            relativeToWorld = getRotationFromMatrix(parentToWorld);
                        }

                        Quat spaceToRelative = getRotationFromMatrix(spaceToWorld) * Inverse (relativeToWorld);
                        //spaceToRelative.SetTrans(Point3(0,0,0));
                        Matrix3 matrix; matrix.SetRotate(spaceToRelative);
                        pblock2->SetValue(PA_CONSTRAINT_MOD_PARENT_SPACE_ROTATION,t,matrix);
                    }

                    // Translation
                    {
                        const bool transLocked = pblock2->GetInt(PA_CONSTRAINT_MOD_PARENT_TRANSLATION_LOCK) != FALSE;
                        Matrix3 relativeToWorld;
                        if (transLocked)
                        {
                            relativeToWorld = childSpaceToWorld;
                        }
                        else
                        {
                            relativeToWorld = parentToWorld;
                        }

                        Matrix3 spaceToRelative = spaceToWorld * Inverse (relativeToWorld);
                        Point3 translation = spaceToRelative.GetTrans();
                        pblock2->SetValue(PA_CONSTRAINT_MOD_PARENT_SPACE_TRANSLATION,t, translation);
                    }
                }
        }
    }

    NotifyDependents(FOREVER, PART_ALL, REFMSG_CHANGE);

}

void hctConstraintModifier::getSubobjectTransform (int subobjId, TimeValue t, INode* node, Matrix3& transformOut)
{
    getSpaceInWorld(subobjId, t, node, transformOut);
}

ISubObjType* hctConstraintModifier::getSubobjectTypeByID (int subobjId)
{
    static GenSubObjType childSpaceSObj(GetString(IDS_CONSTRAINT_MODIFIER_SOBJ_CHILD_SPACE),_T("SubObjectIcons") , 0);
    static GenSubObjType parentSpaceSObj(GetString(IDS_CONSTRAINT_MODIFIER_SOBJ_PARENT_SPACE), _T("SubObjectIcons"), 0);
    static GenSubObjType constraintSpaceSObj(GetString(IDS_CONSTRAINT_MODIFIER_SOBJ_CONSTRAINT_SPACE), _T("SubObjectIcons"), 0);

    const bool parentEnabled = isSubobjectEnabled(SOBJ_CONSTRAINT_MOD_PARENT_SPACE);

    switch (subobjId)
    {
        case SOBJ_CONSTRAINT_MOD_PARENT_SPACE:
            {
                return &parentSpaceSObj;
            }
        case SOBJ_CONSTRAINT_MOD_CHILD_SPACE:
            {
                // If there is no parent space, we use the text "constraint space" instead of "child space" for the subobject
                if (parentEnabled)
                {
                    return &childSpaceSObj;
                }
                else
                {
                    return &constraintSpaceSObj;
                }
            }
    }

    return NULL;
}

void hctConstraintModifier::updateCommonUI (TimeValue t)
{
    // If ui is not shown, nothing to do
    if (!m_interface) return;

    IParamBlock2* pblock2 = GetParamBlock(PB_CONSTRAINT_MOD_COMMON_SPACES_PARAMS);
    IParamMap2* map2 = pblock2->GetMap(MAP_BODIES_ROLLOUT);
    if (!map2) return;

    HWND hWnd = map2->GetHWnd();
    if (!hWnd) return;

    // Enable/disable the parent node pick button
    {
        const BOOL constrainToParent = (pblock2->GetInt(PA_CONSTRAINT_MOD_WORLD_OR_PARENT) == 1);

        const HWND hButton = GetDlgItem(hWnd, IDC_PICK_PARENT_NODE);
        ICustButton *iButton = GetICustButton(hButton);
        iButton->Enable(constrainToParent);
        ReleaseICustButton(iButton);
    }

}

/*
** Spaces Dialog Proc
*/

class hkConstraintSpacesDlgProc : public ParamMap2UserDlgProc
{
    public:

        hkConstraintSpacesDlgProc (hctConstraintModifier* theModifier) { m_theModifier = theModifier; }

        INT_PTR DlgProc(TimeValue t, IParamMap2 *pmap, HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);

        void DeleteThis() { } // Nothing, we use a static instance

        void SetThing (ReferenceTarget* m)
        {
            m_theModifier = (hctConstraintModifier*) m;
        }

    protected:

        hctConstraintModifier *m_theModifier;

};

INT_PTR hkConstraintSpacesDlgProc::DlgProc(TimeValue t, IParamMap2 *pmap, HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
    // TODO : Use FP Actions instead of Windows
    if (!m_theModifier) return FALSE;

    switch (msg)
    {
        case WM_CREATE:
        case WM_PAINT:
        {
            hctConstraintDescriptor* descriptor = m_theModifier->getConstraintDescriptor();

            if (descriptor->ignoreRotations())
            {
                EnableWindow(GetDlgItem(hWnd, IDC_B_CHILD_ROTATION_RESET), FALSE);
                EnableWindow(GetDlgItem(hWnd, IDC_B_PARENT_ROTATION_RESET), FALSE);
                EnableWindow(GetDlgItem(hWnd, IDC_LAB_CHILD_ROTATION), FALSE);
                EnableWindow(GetDlgItem(hWnd, IDC_LAB_PARENT_ROTATION), FALSE);
            }

            break;
        }
        case WM_COMMAND:
        {
            switch(LOWORD(wParam))
            {
                case IDC_B_CHILD_TRANSLATION_RESET:
                {
                    m_theModifier->iResetChildSpaceTranslation();
                    return FALSE;
                }
                case IDC_B_CHILD_ROTATION_RESET:
                {
                    m_theModifier->iResetChildSpaceRotation();
                    return FALSE;
                }
                case IDC_B_PARENT_TRANSLATION_RESET:
                {
                    m_theModifier->iResetParentSpaceTranslation();
                    return FALSE;
                }
                case IDC_B_PARENT_ROTATION_RESET:
                {
                    m_theModifier->iResetParentSpaceRotation();
                    return FALSE;
                }
            }
            return FALSE;
            break;
        }
    }

    return FALSE;
}

static hkConstraintSpacesDlgProc g_pbSpacesDlgProc (NULL);
/*
** Accessor : Used to update the subobjects when changes to locking checkboxes happen
*/

class hkConstraintSpacesPBAccessor:public PBAccessor
{
    public:

        hkConstraintSpacesPBAccessor ()  {}

        void Set(PB2Value& v, ReferenceMaker* owner, ParamID id, int tabIndex, TimeValue t)
        {
            // To avoid recursion. The accessor may temporarily set an attribute to its previous
            BOOL isUndo;
            const BOOL doingUndo = theHold.Restoring(isUndo);

            hctConstraintModifier* theModifier = static_cast<hctConstraintModifier*> (owner);
            IParamBlock2* pblock2 = theModifier->GetParamBlock(PB_CONSTRAINT_MOD_COMMON_SPACES_PARAMS);

            switch (id)
            {
                case PA_CONSTRAINT_MOD_WORLD_OR_PARENT:
                    {
                        const int constrainTo = pblock2->GetInt(id,t);

                        if (constrainTo == theModifier->m_previousConstrainTo)
                        {
                            break;
                        }

                        if (constrainTo == 0) // To World
                        {
                            pblock2->SetValue(PA_CONSTRAINT_MOD_PARENT_NODE,t, (INode*) NULL);
                        }

                        break;
                    }

                case PA_CONSTRAINT_MOD_PARENT_NODE:
                case PA_CONSTRAINT_MOD_PARENT_TRANSLATION_LOCK:
                case PA_CONSTRAINT_MOD_PARENT_ROTATION_LOCK:
                    {
                        // Do nothing if changes come from undo - since all the operations will have been undone already
                        if (doingUndo)
                        {
                            break;
                        }
                        // Do nothing if there is no change
                        if (    (id == PA_CONSTRAINT_MOD_PARENT_NODE) &&
                                (pblock2->GetINode(id,t)==theModifier->m_previousParentNode) )
                        {
                            break;
                        }

                        // Do nothing if there is no change
                        if (    (id == PA_CONSTRAINT_MOD_PARENT_TRANSLATION_LOCK) &&
                                ( (pblock2->GetInt(id,t)!=FALSE) == theModifier->m_previousParentTranslationLocked) )
                        {
                            break;
                        }

                        // Do nothing if there is no change
                        if (    (id == PA_CONSTRAINT_MOD_PARENT_ROTATION_LOCK) &&
                                ( (pblock2->GetInt(id,t)!=FALSE) == theModifier->m_previousParentRotationLocked) )
                        {
                            break;
                        }

                        INode* theNode = hctMaxUtils::findNodeRef(theModifier);

                        hctConstraintModifier::ConstraintSpaceData oldData;
                        theModifier->getConstraintSpaceData(t, theNode, oldData);
                        oldData.m_parentSpaceRotationLocked = theModifier->m_previousParentRotationLocked;
                        oldData.m_parentSpaceTranslationLocked = theModifier->m_previousParentTranslationLocked;
                        oldData.m_parentNode = theModifier->m_previousParentNode;

                        Matrix3 parentSpaceWorld;
                        hctConstraintModifier::getSpaceInWorld(oldData, SOBJ_CONSTRAINT_MOD_PARENT_SPACE, t, parentSpaceWorld);


                        // Max, when setting inodes, suspends undo. Temporarily resume it
                        BEGIN_RESUME_UNDO
                        theModifier->setSpaceInWorld(SOBJ_CONSTRAINT_MOD_PARENT_SPACE, t, theNode, parentSpaceWorld);
                        END_RESUME_UNDO

                        break;
                    }
            }

            // We store up-to-date values
            theModifier->makePreviousValuesCurrent();

            // And we update the interface, if it's shown
            if (theModifier->m_interface)
            {
                theModifier->updateSubobjects();
                theModifier->updateCommonUI(t);
            }

        }

};


static hkConstraintSpacesPBAccessor g_spacesPbAccessor;

//Default pblock
hctConstraintDescriptor::hctConstraintDescriptor() : m_commonSpacesPBD (NULL)
{
}


hctConstraintDescriptor::~hctConstraintDescriptor()
{
    delete m_commonSpacesPBD;
}

ParamBlockDesc2* hctConstraintModifier::setupCommonSpacesPBD (hctConstraintDescriptor* descriptor)
{
    const BOOL ignoreRotations = descriptor->ignoreRotations();

    const BOOL defaultLockParentTranslation = descriptor->getDefaultLockParentTranslation();
    const BOOL defaultLockParentRotation = ignoreRotations || descriptor->getDefaultLockParentRotation();
    const BOOL defaultLockChildTranslation = descriptor->getDefaultLockChildTranslation();
    const BOOL defaultLockChildRotation = ignoreRotations || descriptor->getDefaultLockChildRotation();

    ParamBlockDesc2* commonPBlockDesc2= new ParamBlockDesc2
        ( PB_CONSTRAINT_MOD_COMMON_SPACES_PARAMS, descriptor->getConstraintName(),  0, descriptor->getClassDesc(),
                    P_AUTO_UI + P_MULTIMAP + P_AUTO_CONSTRUCT + P_HASCATEGORY, PB_CONSTRAINT_MOD_COMMON_SPACES_PARAMS,

        // Two rollouts
        3,
        MAP_BODIES_ROLLOUT,
            IDD_CONSTRAINT_MODIFIER_ROLLOUT_BODIES,
            IDS_CONSTRAINT_MODIFIER_ROLLOUT_BODIES,
            0,0,
            NULL, ROLLOUT_CATEGORY_CONSTRAINT_BEFORE_PARAMS,
        MAP_SPACES_ROLLOUT,
            IDD_CONSTRAINT_MODIFIER_ROLLOUT_SPACES,
            IDS_CONSTRAINT_MODIFIER_ROLLOUT_SPACES,
            0, APPENDROLL_CLOSED,
            &g_pbSpacesDlgProc, ROLLOUT_CATEGORY_CONSTRAINT_BEFORE_PARAMS,
        MAP_BREAKABLE_ROLLOUT,
            IDD_CONSTRAINT_MODIFIER_ROLLOUT_BREAKABLE,
            IDS_CONSTRAINT_MODIFIER_ROLLOUT_BREAKABLE,
            0, APPENDROLL_CLOSED,
            NULL, ROLLOUT_CATEGORY_CONSTRAINT_POST_PARAMS,

        // PARAMS

        // Hidden
        PA_CONSTRAINT_MOD_CHILD_SPACE_TRANSLATION,
            _T("childSpaceTranslation"), TYPE_POINT3, P_RESET_DEFAULT | P_ANIMATABLE , IDS_CONSTRAINT_MODIFIER_PA_CHILD_SPACE_TRANSLATION,
            p_default,      Point3(0,0,0),
            p_end,
        PA_CONSTRAINT_MOD_CHILD_SPACE_ROTATION,
            _T("childSpaceRotation"), TYPE_MATRIX3, P_RESET_DEFAULT | P_ANIMATABLE, IDS_CONSTRAINT_MODIFIER_PA_CHILD_SPACE_ROTATION,
            p_default,      Matrix3(1),
            p_end,
        PA_CONSTRAINT_MOD_PARENT_SPACE_TRANSLATION,
            _T("parentSpaceTranslation"), TYPE_POINT3, P_RESET_DEFAULT | P_ANIMATABLE, IDS_CONSTRAINT_MODIFIER_PA_PARENT_SPACE_TRANSLATION,
            p_default,      Point3(0,0,0),
            p_end,
        PA_CONSTRAINT_MOD_PARENT_SPACE_ROTATION,
            _T("parentSpaceRotation"), TYPE_MATRIX3, P_RESET_DEFAULT | P_ANIMATABLE, IDS_CONSTRAINT_MODIFIER_PA_PARENT_SPACE_ROTATION,
            p_default,      Matrix3(1),
            p_end,

        // Bodies
        PA_CONSTRAINT_MOD_WORLD_OR_PARENT,
            _T("constrainTo"), TYPE_INT, P_RESET_DEFAULT, IDS_CONSTRAINT_MODIFIER_PA_CONSTRAIN_TO,
            p_default,      1,
            p_ui,           MAP_BODIES_ROLLOUT,
                            TYPE_RADIO, 2, IDC_RB_TO_WORLD, IDC_RB_TO_PARENT,
            p_accessor,     &g_spacesPbAccessor,
            p_end,
        PA_CONSTRAINT_MOD_PARENT_NODE,
            _T("parent"), TYPE_INODE, P_RESET_DEFAULT, IDS_CONSTRAINT_MODIFIER_PA_PARENT,
            p_ui,           MAP_BODIES_ROLLOUT,
                            TYPE_PICKNODEBUTTON, IDC_PICK_PARENT_NODE,
                            p_prompt, IDS_CONSTRAINT_MODIFIER_PROMPT_PICK_PARENT,
            p_accessor,     &g_spacesPbAccessor,
            p_end,

        // Spaces
        PA_CONSTRAINT_MOD_CHILD_TRANSLATION_LOCK,
            _T("childSpaceTranslationLocked"), TYPE_BOOL, P_RESET_DEFAULT | P_ANIMATABLE, IDS_CONSTRAINT_MODIFIER_PA_CHILD_SPACE_TRANSLATION_LOCKED,
            p_default,      defaultLockChildTranslation ,
            p_accessor,     &g_spacesPbAccessor,
            p_ui,           MAP_SPACES_ROLLOUT,
                            TYPE_SINGLECHEKBOX, IDC_CB_CHILD_TRANSLATION_LOCK,
            p_end,
        PA_CONSTRAINT_MOD_CHILD_ROTATION_LOCK,
            _T("childSpaceRotationLocked"), TYPE_BOOL, P_RESET_DEFAULT | P_ANIMATABLE, IDS_CONSTRAINT_MODIFIER_PA_CHILD_SPACE_ROTATION_LOCKED,
            p_default,      defaultLockChildRotation,
            p_accessor,     &g_spacesPbAccessor,
            p_enabled,      (!ignoreRotations),
            p_ui,           MAP_SPACES_ROLLOUT,
                            TYPE_SINGLECHEKBOX, IDC_CB_CHILD_ROTATION_LOCK,
            p_end,
        PA_CONSTRAINT_MOD_PARENT_TRANSLATION_LOCK,
            _T("parentSpaceTranslationLocked"), TYPE_BOOL, P_RESET_DEFAULT | P_ANIMATABLE, IDS_CONSTRAINT_MODIFIER_PA_PARENT_SPACE_TRANSLATION_LOCKED,
            p_default,      defaultLockParentTranslation,
            p_accessor,     &g_spacesPbAccessor,
            p_ui,           MAP_SPACES_ROLLOUT,
                            TYPE_SINGLECHEKBOX, IDC_CB_PARENT_TRANSLATION_LOCK,
            p_end,
        PA_CONSTRAINT_MOD_PARENT_ROTATION_LOCK,
            _T("parentSpaceRotationLocked"), TYPE_BOOL, P_RESET_DEFAULT | P_ANIMATABLE, IDS_CONSTRAINT_MODIFIER_PA_PARENT_SPACE_ROTATION_LOCKED,
            p_default,      defaultLockParentRotation,
            p_accessor,     &g_spacesPbAccessor,
            p_enabled,      (!ignoreRotations),
            p_ui,           MAP_SPACES_ROLLOUT,
                            TYPE_SINGLECHEKBOX, IDC_CB_PARENT_ROTATION_LOCK,
            p_end,

        // Breakable
        PA_CONSTRAINT_MOD_IS_BREAKABLE,
            _T("isBreakable"), TYPE_BOOL, P_RESET_DEFAULT | P_ANIMATABLE, IDS_CONSTRAINT_MODIFIER_PA_IS_BREAKABLE,
            p_default, FALSE,
            p_ui,           MAP_BREAKABLE_ROLLOUT,
                            TYPE_SINGLECHEKBOX, IDC_CB_BREAKABLE,
            p_enable_ctrls, 1, PA_CONSTRAINT_MOD_BREAK_THRESHOLD,
            p_end,

        PA_CONSTRAINT_MOD_BREAK_THRESHOLD,
            _T("breakThreshold"), TYPE_FLOAT, P_RESET_DEFAULT | P_ANIMATABLE, IDS_CONSTRAINT_MODIFIER_PA_BREAK_THRESHOLD,
            p_default, 0.0f,
            p_range,        0.0f,   1e8f,
            p_ui,           MAP_BREAKABLE_ROLLOUT,
                            TYPE_SPINNER, EDITTYPE_FLOAT,
                            IDC_ED_BREAK_THRESHOLD, IDC_SP_BREAK_THRESHOLD,
                            SPIN_AUTOSCALE,
            p_end,
        p_end
    );

    return commonPBlockDesc2;
}

static void _colorsChanged (void* pararam, NotifyInfo* info)
{
    hctConstraintModifier::setupMaterials();
}

void hctConstraintModifier::setupMeshesAndMaterials()
{
    if (m_meshesAndMaterialsSetup)
    {
        return;
    }

    setupMaterials();

    RegisterNotification(_colorsChanged,NULL,NOTIFY_COLOR_CHANGE);

    m_meshesAndMaterialsSetup = true;

}

void hctConstraintModifier::BeginEditParams( IObjParam *ip, ULONG flags,Animatable *prev )
{
    g_pbSpacesDlgProc.SetThing(this);
    hctBasicModifier::BeginEditParams(ip, flags, prev);
}

void hctConstraintModifier::EndEditParams( IObjParam *ip, ULONG flags,Animatable *next)
{
    hctBasicModifier::EndEditParams(ip,flags,next);
    g_pbSpacesDlgProc.SetThing(NULL);
}


void hctConstraintModifier::setupMaterials()
{
    IColorManager* theColorManager = GetColorManager();

    const Point3 psColor = theColorManager->GetColorAsPoint3(HK_COLOR_CONSTRAINT_PARENT_SPACE);
    const Point3 csColor = theColorManager->GetColorAsPoint3(HK_COLOR_CONSTRAINT_CHILD_SPACE);
    const Point3 volColor = theColorManager->GetColorAsPoint3(HK_COLOR_CONSTRAINT_VOLUME);

    m_parentSpaceMaterial.shinStrength = 0.1f;
    m_parentSpaceMaterial.Ka =  m_parentSpaceMaterial.Ks =  m_parentSpaceMaterial.Kd = psColor;
    m_parentSpaceMaterial.selfIllum = 0.8f;

    m_childSpaceMaterial.shinStrength = 0.1f;
    m_childSpaceMaterial.Ka = m_childSpaceMaterial.Ks = m_childSpaceMaterial.Kd = csColor;
    m_childSpaceMaterial.selfIllum = 0.8f;

    m_limitsMaterial.shinStrength = 0.2f;
    m_limitsMaterial.Ka = m_limitsMaterial.Ks = m_limitsMaterial.Kd = volColor;
    m_limitsMaterial.selfIllum = 0.8f;
    m_limitsMaterial.opacity = 0.5f;
}

CONST15 MCHAR *hctConstraintModifier::GetObjectName()
{
    const int stringId = getConstraintDescriptor()->getObjectNameStringID();
    return GetString(stringId);
}

Class_ID hctConstraintModifier::ClassID()
{
    ClassDesc2* classDesc = getConstraintDescriptor()->getClassDesc();
    return classDesc->ClassID();
}

void hctConstraintModifier::GetClassName(MSTR& s)
{
    const int stringId = getConstraintDescriptor()->getClassNameStringID();
    s = GetString(stringId);
}


hctBasicXTCObject* hctConstraintModifier::getXTCObject (int number, TimeValue t, ModContext &mc, ObjectState * os, INode *node)
{
    if (!node)
    {
        node = hctMaxUtils::findNodeRef(this);
    }
    if (!node) return NULL;

    ConstraintSpaceData data;
    getConstraintSpaceData(t, node, data);

    hctConstraintXTCObject* xtcObject = new  hctConstraintXTCObject (data);

    return xtcObject;

}

hctConstraintXTCObject::hctConstraintXTCObject (const hctConstraintModifier::ConstraintSpaceData& data) : m_data (data)
{

}

hctConstraintXTCObject::~hctConstraintXTCObject()
{
}

int hctConstraintXTCObject::Display (TimeValue t, INode* inode, ViewExp *vpt, int flags, Object *pObj)
{
    // If the modifier was applied to more than one object, this will get called with different inodes

    INode* originalChild = m_data.m_childNode;
    if (inode)
    {
        m_data.m_childNode = inode;
    }

    Matrix3 parentSpaceTM;
    hctConstraintModifier::getSpaceInWorld(m_data, SOBJ_CONSTRAINT_MOD_PARENT_SPACE, t, parentSpaceTM);

    Matrix3 childSpaceTM;
    hctConstraintModifier::getSpaceInWorld(m_data, SOBJ_CONSTRAINT_MOD_CHILD_SPACE, t, childSpaceTM);

    GraphicsWindow *gw=vpt->getGW();
    const DWORD savedLimits=gw->getRndLimits();

    gw->setRndLimits(GW_WIREFRAME|GW_BACKCULL);

    const Point3 parentColor = hctConstraintModifier::m_parentSpaceMaterial.Kd;
    const Point3 childColor = hctConstraintModifier::m_childSpaceMaterial.Kd;

    // Draw parent space as a box marker
    {
        gw->setColor(LINE_COLOR, parentColor);
        gw->setTransform(parentSpaceTM);

        Point3 p(0,0,0);
        IPoint3 markerPos;
        bool notClipped = (gw->wTransPoint(&p, &markerPos) == 0);
        if (notClipped) // EXP-565
        {
            gw->wMarker(&markerPos, BOX6_MRKR);
        }
    }

    // Draw child space as a box marker
    {
        gw->setColor(LINE_COLOR, childColor);
        gw->setTransform(childSpaceTM);

        Point3 p(0,0,0);
        IPoint3 markerPos;
        bool notClipped = (gw->wTransPoint(&p, &markerPos) == 0);
        if (notClipped) // EXP-565
        {
            gw->wMarker(&markerPos, BOX4_MRKR);
        }
    }

    // Draw a dashed red line between both spaces
    {
        gw->setTransform(Matrix3(1));
        const Point3 start = parentSpaceTM.GetTrans();
        const Point3 p_end = childSpaceTM.GetTrans();

        hctMaxUtils::drawColoredDashedLine(gw, start, p_end, parentColor, childColor);
    }

    gw->setRndLimits(savedLimits);

    // Restore original inode
    m_data.m_childNode = originalChild;

    return(0);

}

void hctConstraintXTCObject::MaybeEnlargeViewportRect(GraphicsWindow *gw, Rect &rect)
{
    TimeValue now = GetCOREInterface()->GetTime();

    Matrix3 parentSpaceTM;
    hctConstraintModifier::getSpaceInWorld(m_data, SOBJ_CONSTRAINT_MOD_PARENT_SPACE, now, parentSpaceTM);

    Matrix3 childSpaceTM;
    hctConstraintModifier::getSpaceInWorld(m_data, SOBJ_CONSTRAINT_MOD_CHILD_SPACE, now, childSpaceTM);

    const Point3 parentWorld = parentSpaceTM.GetTrans();
    const Point3 childWorld = childSpaceTM.GetTrans();

    IPoint3 parentDevice;
    IPoint3 childDevice;
    gw->wTransPoint(&parentWorld, &parentDevice);
    gw->wTransPoint(&childWorld, &childDevice);

    IPoint2 parentDevice2 (parentDevice.x, parentDevice.y);
    IPoint2 childDevice2 (childDevice.x, childDevice.y);

    rect += parentDevice2;
    rect += childDevice2;

}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
