// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Max/MaxSceneExport/resource.h>
#include <ContentTools/Max/MaxSceneExport/Modifiers/Constraints/hctConstraintModifier.h>
#include <ContentTools/Max/MaxFpInterfaces/Physics/Constraints/hctStiffSpringConstraintModifierInterface.h>

class hctStiffSpringConstraintModifier : public hctConstraintModifier
{
    public:

        //Constructor/Destructor
        hctStiffSpringConstraintModifier(ClassDesc2* theClassDesc);
        /*virtual*/  ~hctStiffSpringConstraintModifier();

        /*virtual*/ hctConstraintDescriptor* getConstraintDescriptor();

        // From Object - Display stuff. We want to display just two markers.
        /*virtual*/ int Display(TimeValue t, INode* inode, ViewExp *vpt, int flagst, ModContext *mc);
        /*virtual*/ void GetWorldBoundBox(TimeValue t,INode* inode, ViewExp *vpt, Box3& box, ModContext *mc);

        // From RefMaker
#if MAX_VERSION_MAJOR>=17
        /*virtual*/ RefResult NotifyRefChanged( const Interval& changeInt, RefTargetHandle hTarget, PartID& partID,  RefMessage message, BOOL propagate );
#else
        /*virtual*/ RefResult NotifyRefChanged( Interval changeInt, RefTargetHandle hTarget, PartID& partID,  RefMessage message );
#endif


    private:

        void getRodDisplayTransform (TimeValue t, INode* inode, ViewExp* vpt, Matrix3& transformOut);

        // The mesh is static since it is reused by all stiff springs
        static Mesh m_rodMesh;
        static bool m_rodMeshSetup;
        void setupRodMesh();

        // Set the rest length based on the current distance between spaces
        void setRestLengthBasedOnCurrentDistance();

};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
