// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>
#include <ContentTools/Max/MaxSceneExport/Modifiers/Constraints/StiffSpring/hctStiffSpringConstraintModifier.h>


// Mesh representing the rotation axis and the zero/perpendicular axis
/*static*/ Mesh hctStiffSpringConstraintModifier::m_rodMesh;
/*static*/ bool hctStiffSpringConstraintModifier::m_rodMeshSetup = false;

class hkStiffSpringConstraintModifierDesc : public ClassDesc2
{
    public:
        int             IsPublic() { return TRUE; }
        void *          Create (BOOL loading = FALSE) { return new hctStiffSpringConstraintModifier(this); }
        const MCHAR *   ClassName() { return GetString(IDS_STIFF_SPRING_MODIFIER_CLASS_NAME); }
        SClass_ID       SuperClassID() { return OSM_CLASS_ID; }
        Class_ID        ClassID() { return HK_CONSTRAINT_STIFF_SPRING_CLASS_ID; }
        const MCHAR*    Category() { return GetString(IDS_HAVOK_MODIFIERS_CATEGORY); }
        const MCHAR*    InternalName() { return _T("hkStiffSpringConstraintModifier");; }
        HINSTANCE       HInstance() { return hInstance; }
};

ClassDesc2* getHkStiffSpringConstraintModifierDesc()
{
    static hkStiffSpringConstraintModifierDesc modifierDesc;
    return &modifierDesc;
}

class hkStiffSpringConstraintDescriptor : public hctConstraintDescriptor
{
    public:

        // Return the Class Descriptor of the modifier implementing the constraint
        /*virtual*/ ClassDesc2* getClassDesc() const {return getHkStiffSpringConstraintModifierDesc();}

        // Return the constraint name (name for the pblock)
        /*virtual*/ MCHAR* getConstraintName() const {return TEXT("hkStiffSpringConstraint");}

        // Return a string ID for the Class Name
        /*virtual*/ int getClassNameStringID () const {return IDS_STIFF_SPRING_MODIFIER_CLASS_NAME;}

        // Return a string ID for the Object NAme
        /*virtual*/ int getObjectNameStringID () const {return IDS_STIFF_SPRING_MODIFIER_OBJECT_NAME;}

        // We want to ignore rotations
        /*virtual*/ bool ignoreRotations() const {return true;}

        // We want resetting spaces to move the parent space to the parent body
        /*virtual*/ bool parentSpaceResetsToChildSpace() const { return false; }

        // We want to unlock the translation of the parent space by default
        /*virtual*/ bool getDefaultLockParentTranslation() const { return false; }

    public:

        // Constructor, sets up the paramblockdesc2
        hkStiffSpringConstraintDescriptor(): hctConstraintDescriptor()
        {
            m_commonSpacesPBD = hctConstraintModifier::setupCommonSpacesPBD(this);

            hctConstraintModifier::addCommonFPInterface(this);
        }
};

static hkStiffSpringConstraintDescriptor g_stiffSpringConstraintDescriptor;

hctConstraintDescriptor* hctStiffSpringConstraintModifier::getConstraintDescriptor()
{
    return &g_stiffSpringConstraintDescriptor;
}

static ParamBlockDesc2 hkStiffSpring_ParamBlockDesc
    ( PB_STIFF_SPRING_MOD_PBLOCK, TEXT("hkStiffSpringConstraintMerge"),  0, getHkStiffSpringConstraintModifierDesc(), P_AUTO_CONSTRUCT + P_AUTO_UI, PB_STIFF_SPRING_MOD_PBLOCK,

    // Rollout; we use the default combobox handler dlg proc to handle combobox changes
    IDD_STIFF_SPRING_MODIFIER_ROLLOUT_PROPERTIES,
    IDS_STIFF_SPRING_MODIFIER_ROLLOUT_PROPERTIES,
    0, 0, NULL,

    PA_STIFF_SPRING_MOD_CHANGE_REST_LENGTH,
        _T("changeRestLength"), TYPE_BOOL, P_RESET_DEFAULT | P_ANIMATABLE, IDS_STIFF_SPRING_MODIFIER_PA_CHANGE_REST_LENGTH,
        p_default,      FALSE,
        p_ui,           TYPE_SINGLECHEKBOX, IDC_CB_CHANGE_REST_LENGTH,
        p_enable_ctrls, 1,  PA_STIFF_SPRING_MOD_REST_LENGTH,
        p_end,
    PA_STIFF_SPRING_MOD_REST_LENGTH,
        _T("restLength"), TYPE_WORLD, P_RESET_DEFAULT | P_ANIMATABLE, IDS_STIFF_SPRING_MODIFIER_PA_REST_LENGTH,
        p_default,      0.0f,
        p_range,        0.0f, 10000000.0f,
        p_ui,           TYPE_SPINNER, EDITTYPE_UNIVERSE,
                        IDC_ED_REST_LENGTH, IDC_SP_REST_LENGTH,
                        SPIN_AUTOSCALE,
        p_end,
    p_end
    );

//Constructor/Destructor
hctStiffSpringConstraintModifier::hctStiffSpringConstraintModifier(ClassDesc2* theClassDesc)
: hctConstraintModifier(theClassDesc)
{
    setupRodMesh();
}

hctStiffSpringConstraintModifier::~hctStiffSpringConstraintModifier()
{

}

void hctStiffSpringConstraintModifier::getRodDisplayTransform (TimeValue t, INode* inode, ViewExp* vpt, Matrix3& transformOut)
{
    // Constraint Spaces
    Matrix3 parentSpaceTM;
    getSpaceInWorld(SOBJ_CONSTRAINT_MOD_PARENT_SPACE, t, inode, parentSpaceTM);

    Matrix3 childSpaceTM;
    getSpaceInWorld(SOBJ_CONSTRAINT_MOD_CHILD_SPACE, t, inode, childSpaceTM);

    // Positions and center
    const Point3 parentPos = parentSpaceTM.GetTrans();
    const Point3 childPos = childSpaceTM.GetTrans();
    const Point3 center = (parentPos+childPos) * 0.5f;

    // Direction
    const float currentDistance = (childPos - parentPos).Length();
    const Point3 direction = (currentDistance > 0.0f) ? (childPos - parentPos).Normalize() : Point3(1,0,0);

    // Rest length
    IParamBlock2* pblock2 = GetParamBlock(PB_STIFF_SPRING_MOD_PBLOCK);
    const bool changeRestLength = pblock2->GetInt(PA_STIFF_SPRING_MOD_CHANGE_REST_LENGTH, t) != FALSE;
    const float restLength = changeRestLength? pblock2->GetFloat(PA_STIFF_SPRING_MOD_REST_LENGTH,t) : currentDistance;

    const Point3 zAxis = direction;
    const Point3 xAxis = hctMaxUtils::calculatePerpendicularUnitVector(zAxis);
    const Point3 yAxis = CrossProd(zAxis, xAxis);

    transformOut.SetRow(0, xAxis);
    transformOut.SetRow(1, yAxis);
    transformOut.SetRow(2, zAxis);
    transformOut.SetRow(3, center);

    const float scale = 0.1f * getScaleDisplay(center, vpt);
    const Point3 scaleV (scale,scale, restLength);

    transformOut.PreScale(scaleV, FALSE);

}

int hctStiffSpringConstraintModifier::Display(TimeValue t, INode* inode, ViewExp *vpt, int flagst, ModContext *mc)
{
    // Colors
    const Point3 parentColor = hctConstraintModifier::m_parentSpaceMaterial.Kd;
    const Point3 childColor = hctConstraintModifier::m_childSpaceMaterial.Kd;

    // Constraint Spaces
    Matrix3 parentSpaceTM;
    getSpaceInWorld(SOBJ_CONSTRAINT_MOD_PARENT_SPACE, t, inode, parentSpaceTM);

    Matrix3 childSpaceTM;
    getSpaceInWorld(SOBJ_CONSTRAINT_MOD_CHILD_SPACE, t, inode, childSpaceTM);

    GraphicsWindow *gw=vpt->getGW();
    const DWORD savedLimits=gw->getRndLimits();

    gw->setRndLimits(GW_WIREFRAME|GW_BACKCULL);

    // Draw parent space as a box marker
    {
        gw->setColor(LINE_COLOR, parentColor);
        gw->setTransform(parentSpaceTM);

        Point3 p(0,0,0);
        IPoint3 markerPos;
        bool notClipped = (gw->wTransPoint(&p, &markerPos) == 0);
        if (notClipped) // EXP-565, EXP-908
        {
            gw->wMarker(&markerPos, BOX6_MRKR);
        }
    }

    // Draw child space as a box marker
    {
        gw->setColor(LINE_COLOR, childColor);
        gw->setTransform(childSpaceTM);

        Point3 p(0,0,0);
        IPoint3 markerPos;
        bool notClipped = (gw->wTransPoint(&p, &markerPos) == 0);
        if (notClipped) // EXP-565, EXP-908
        {
            gw->wMarker(&markerPos, BOX4_MRKR);
        }
    }

    // Draw rod
    {
        Matrix3 volumeTM; getRodDisplayTransform(t, inode, vpt, volumeTM);
        gw->setTransform(volumeTM);
        {
            Material limitsMaterialsArray[] = {m_limitsMaterial};

            gw->setRndLimits(GW_BACKCULL | GW_LIGHTING | /*GW_Z_BUFFER |*/ GW_TRANSPARENCY | GW_TRANSPARENT_PASS );
            gw->setTransparency(GW_TRANSPARENCY | GW_TRANSPARENT_PASS);
            gw->setMaterial(m_limitsMaterial);
            m_rodMesh.render(gw, limitsMaterialsArray, NULL, COMP_ALL);
            gw->setTransparency(0);

            // note : do not use GW_LIGHTING with wireframe and alpha
            gw->setRndLimits(GW_BACKCULL | GW_WIREFRAME);
            gw->setMaterial(m_limitsMaterial);
            m_rodMesh.render(gw, limitsMaterialsArray, NULL, COMP_ALL);
        }

    }

    gw->setRndLimits(savedLimits);

    return 0;

}

void hctStiffSpringConstraintModifier::GetWorldBoundBox(TimeValue t,INode* inode, ViewExp *vpt, Box3& box3, ModContext *mc)
{
    Matrix3 parentSpaceTM;
    getSpaceInWorld(SOBJ_CONSTRAINT_MOD_PARENT_SPACE, t, inode, parentSpaceTM);

    Matrix3 childSpaceTM;
    getSpaceInWorld(SOBJ_CONSTRAINT_MOD_CHILD_SPACE, t, inode, childSpaceTM);

    Box3 rodBoxLocal = m_rodMesh.getBoundingBox();
    Matrix3 rodTM;
    getRodDisplayTransform(t, inode, vpt, rodTM);

    Box3 rodBoxWorld = rodBoxLocal * rodTM;

    box3.Init();
    box3 += parentSpaceTM.GetTrans();
    box3 += childSpaceTM.GetTrans();
    box3 += rodBoxWorld;

}

void hctStiffSpringConstraintModifier::setupRodMesh()
{
    if (m_rodMeshSetup)
    {
        return;
    }

    hctMaxUtils::createDiscMesh(Point3(0,0,1), Point3(1,0,0), 1.0f, 1.0f, 0.0f, TWOPI, 2, false, m_rodMesh);

    m_rodMeshSetup = true;
}

void hctStiffSpringConstraintModifier::setRestLengthBasedOnCurrentDistance()
{
    IParamBlock2* pblock2 = GetParamBlock(PB_STIFF_SPRING_MOD_PBLOCK);

    INode* inode = hctMaxUtils::findNodeRef(this);

    if (inode)
    {
        TimeValue now = GetCurrentTime();

        // Constraint Spaces
        Matrix3 parentSpaceTM;
        getSpaceInWorld(SOBJ_CONSTRAINT_MOD_PARENT_SPACE, now, inode, parentSpaceTM);

        Matrix3 childSpaceTM;
        getSpaceInWorld(SOBJ_CONSTRAINT_MOD_CHILD_SPACE, now, inode, childSpaceTM);

        // Positions and center
        const Point3 parentPos = parentSpaceTM.GetTrans();
        const Point3 childPos = childSpaceTM.GetTrans();
        const Point3 center = (parentPos+childPos) * 0.5f;

        // Direction
        const float currentDistance = (childPos - parentPos).Length();
        pblock2->SetValue(PA_STIFF_SPRING_MOD_REST_LENGTH, now, currentDistance);
    }

}

#if MAX_VERSION_MAJOR>=17
    RefResult hctStiffSpringConstraintModifier::NotifyRefChanged( const Interval& changeInt, RefTargetHandle hTarget, PartID& partID,  RefMessage message, BOOL propagate )
#else
    RefResult hctStiffSpringConstraintModifier::NotifyRefChanged( Interval changeInt, RefTargetHandle hTarget, PartID& partID, RefMessage message )
#endif
{
    IParamBlock2* pblock2 = GetParamBlock(PB_STIFF_SPRING_MOD_PBLOCK);
    // Avoid recursion
    if ((hTarget != pblock2) || (pblock2->LastNotifyParamID()!=PA_STIFF_SPRING_MOD_REST_LENGTH))
    {
        // Calculate rest length if not user-driven
        if (pblock2->GetInt(PA_STIFF_SPRING_MOD_CHANGE_REST_LENGTH)==FALSE)
        {
            setRestLengthBasedOnCurrentDistance();
        }
    }

    return hctConstraintModifier::NotifyRefChanged(changeInt, hTarget, partID, message);
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
