// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Max/MaxSceneExport/resource.h>
#include <ContentTools/Max/MaxSceneExport/Modifiers/Constraints/hctConstraintModifier.h>
#include <ContentTools/Max/MaxFpInterfaces/Physics/Constraints/hctRagdollConstraintModifierInterface.h>


// The two rollouts used for the common parameters
enum
{
    MAP_RAGDOLL_PROPERTIES,
    MAP_RAGDOLL_DISPLAY,
};

// Motor Types (combo box)
enum
{
    RMT_NONE,
    RMT_POSITION,
    RMT_VELOCITY,
    RMT_SPRING_DAMPER,
};

class hctRagdollConstraintModifier : public hctConstraintModifier
{
    public:

        //Constructor/Destructor
        hctRagdollConstraintModifier(ClassDesc2* theClassDesc);
        /*virtual*/  ~hctRagdollConstraintModifier();

        /*virtual*/ hctConstraintDescriptor* getConstraintDescriptor();

        /*
        ** From Basic Modifier. We have one combo box (motor type)
        */
        /*virtual*/ int getNumComboBoxes () { return 1; }
        /*virtual*/ ComboBoxDescriptor* getComboBoxDescriptor (int comboBoxID);

        // From Object - Display stuff
        /*virtual*/ int Display(TimeValue t, INode* inode, ViewExp *vpt, int flagst, ModContext *mc);
        /*virtual*/ void GetWorldBoundBox(TimeValue t,INode* inode, ViewExp *vpt, Box3& box, ModContext *mc);

        // From Reference Maker
        // We only construct the mesh representing the limits whenever is necessary. We need to keep track of changes
        // in order to update the validity
#if MAX_VERSION_MAJOR>=17
        /*virtual*/ RefResult NotifyRefChanged( const Interval& changeInt, RefTargetHandle hTarget, PartID& partID,  RefMessage message, BOOL propagate );
#else
        /*virtual*/ RefResult NotifyRefChanged( Interval changeInt, RefTargetHandle hTarget, PartID& partID,  RefMessage message );
#endif


    private:

        // The limits meshes is per-instance since it depends on parameters
        MNMesh m_limitVolumeMesh;
        Mesh m_limitDiscMesh;
        Mesh m_minPlaneMesh;
        Mesh m_maxPlaneMesh;
        Interval m_limitMeshesValidity;
        void updateLimitMeshes(TimeValue t);

        static MNMesh m_limitSphereMNMesh;
        static bool m_limitSphereMNMeshSetup;
        void setupLimitSphereMNMesh();

        // These meshes are static since they are reused by all ragdolls
        static Mesh m_twistAxisMesh;
        static Mesh m_twistBoxMesh;
        static bool m_ragdollAxisMeshesSetup;
        void setupRagdollAxisMeshes();
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
