// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>

#include <ContentTools/Max/MaxSceneExport/Modifiers/Constraints/Hinge/hctHingeConstraintModifier.h>
#include <ContentTools/Max/MaxSceneExport/Modifiers/Constraints/Ragdoll/hctRagdollConstraintModifier.h>

// Mesh representing the rotation axis and the zero/perpendicular axis
/*static*/ Mesh hctRagdollConstraintModifier::m_twistAxisMesh;
/*static*/ Mesh hctRagdollConstraintModifier::m_twistBoxMesh;
/*static*/ bool hctRagdollConstraintModifier::m_ragdollAxisMeshesSetup = false;
/*static*/ MNMesh hctRagdollConstraintModifier::m_limitSphereMNMesh;
/*static*/ bool hctRagdollConstraintModifier::m_limitSphereMNMeshSetup = false;

class hkRagdollConstraintModifierDesc : public ClassDesc2
{
    public:
        int             IsPublic() { return TRUE; }
        void *          Create (BOOL loading = FALSE) { return new hctRagdollConstraintModifier(this); }
        const MCHAR *   ClassName() { return GetString(IDS_RAGDOLL_MODIFIER_CLASS_NAME); }
        SClass_ID       SuperClassID() { return OSM_CLASS_ID; }
        Class_ID        ClassID() { return HK_CONSTRAINT_RAGDOLL_CLASS_ID; }
        const MCHAR*    Category() { return GetString(IDS_HAVOK_MODIFIERS_CATEGORY); }
        const MCHAR*    InternalName() { return _T("hkRagdollConstraintModifier"); }
        HINSTANCE       HInstance() { return hInstance; }
};

ClassDesc2* getHkRagdollConstraintModifierDesc()
{
    static hkRagdollConstraintModifierDesc modifierDesc;
    return &modifierDesc;
}

class hkRagdollConstraintDescriptor : public hctConstraintDescriptor
{
    public:

        // Return the Class Descriptor of the modifier implementing the constraint
        /*virtual*/ ClassDesc2* getClassDesc() const {return getHkRagdollConstraintModifierDesc();}

        // Return the constraint name (name for the pblock)
        /*virtual*/ MCHAR* getConstraintName() const {return TEXT("hkRagdollConstraint");}

        // Return a string ID for the Class Name
        /*virtual*/ int getClassNameStringID () const {return IDS_RAGDOLL_MODIFIER_CLASS_NAME;}

        // Return a string ID for the Object NAme
        /*virtual*/ int getObjectNameStringID () const {return IDS_RAGDOLL_MODIFIER_OBJECT_NAME;}

    public:

        // Constructor, sets up the paramblockdesc2
        hkRagdollConstraintDescriptor(): hctConstraintDescriptor()
        {
            m_commonSpacesPBD = hctConstraintModifier::setupCommonSpacesPBD(this);

            hctConstraintModifier::addCommonFPInterface(this);
        }

};

static hkRagdollConstraintDescriptor g_ragdollConstraintDescriptor;

hctConstraintDescriptor* hctRagdollConstraintModifier::getConstraintDescriptor()
{
    return &g_ragdollConstraintDescriptor;
}

// Null class so order is as we want it
static ParamBlockDesc2 hkRagdoll_ParamBlockDesc
    ( PB_RAGDOLL_MOD_PBLOCK, TEXT("hkRagdollConstraintMerge"),  0, getHkRagdollConstraintModifierDesc(), P_MULTIMAP + P_AUTO_CONSTRUCT + P_AUTO_UI, PB_RAGDOLL_MOD_PBLOCK,

    // Two rollouts
    2,
    MAP_RAGDOLL_PROPERTIES,
        IDD_RAGDOLL_MODIFIER_ROLLOUT_PROPERTIES,
        IDS_RAGDOLL_MODIFIER_ROLLOUT_PROPERTIES,
        0,0,
        hctBasicModifier::getComboBoxHandlerDlgProc(),
    MAP_RAGDOLL_DISPLAY,
        IDD_RAGDOLL_MODIFIER_ROLLOUT_DISPLAY,
        IDS_RAGDOLL_MODIFIER_ROLLOUT_DISPLAY,
        0, 0,
        NULL,

    PA_RAGDOLL_MOD_CONE_ANGLE,
        _T("coneAngle"), TYPE_ANGLE, P_RESET_DEFAULT | P_ANIMATABLE, IDS_RAGDOLL_MODIFIER_PA_CONE_ANGLE,
        p_default,      PI * 0.25f, //45deg
        p_range,        0.0f, 180.0f, // max is inconsistent here, range is specified in degrees, default in radians
        p_ui,           MAP_RAGDOLL_PROPERTIES, TYPE_SPINNER, EDITTYPE_FLOAT,
                        IDC_ED_CONE_ANGLE, IDC_SP_CONE_ANGLE,
                        SPIN_AUTOSCALE,
        p_end,

    PA_RAGDOLL_MOD_PLANE_MIN,
        _T("planeAngleMin"), TYPE_ANGLE, P_RESET_DEFAULT | P_ANIMATABLE, IDS_RAGDOLL_MODIFIER_PA_PLANE_MIN,
        p_default,      -PI * 0.166666f, //-30deg
        p_range,        -90.0f, 0.0f, // max is inconsistent here, range is specified in degrees, default in radians
        p_ui,           MAP_RAGDOLL_PROPERTIES, TYPE_SPINNER, EDITTYPE_FLOAT,
                        IDC_ED_PLANE_MIN, IDC_SP_PLANE_MIN,
                        SPIN_AUTOSCALE,
        p_end,

    PA_RAGDOLL_MOD_PLANE_MAX,
        _T("planeAngleMax"), TYPE_ANGLE, P_RESET_DEFAULT | P_ANIMATABLE, IDS_RAGDOLL_MODIFIER_PA_PLANE_MAX,
        p_default,      PI * 0.166666f, //30deg
        p_range,        0.0f, 90.0f, // max is inconsistent here, range is specified in degrees, default in radians
        p_ui,           MAP_RAGDOLL_PROPERTIES, TYPE_SPINNER, EDITTYPE_FLOAT,
                        IDC_ED_PLANE_MAX, IDC_SP_PLANE_MAX,
                        SPIN_AUTOSCALE,
        p_end,

    PA_RAGDOLL_MOD_TWIST_MIN,
        _T("twistMin"), TYPE_ANGLE, P_RESET_DEFAULT | P_ANIMATABLE, IDS_RAGDOLL_MODIFIER_PA_TWIST_MIN,
        p_default,      -PI, //-180deg
        p_range,        -180.0f, 180.0f, // max is inconsistent here, range is specified in degrees, default in radians
        p_ui,           MAP_RAGDOLL_PROPERTIES, TYPE_SPINNER, EDITTYPE_FLOAT,
                        IDC_ED_TWIST_MIN, IDC_SP_TWIST_MIN,
                        SPIN_AUTOSCALE,
        p_end,

    PA_RAGDOLL_MOD_TWIST_MAX,
        _T("twistMax"), TYPE_ANGLE, P_RESET_DEFAULT | P_ANIMATABLE, IDS_RAGDOLL_MODIFIER_PA_TWIST_MAX,
        p_default,      PI, // 180deg
        p_range,        -180.0f, 180.0f, // max is inconsistent here, range is specified in degrees, default in radians
        p_ui,           MAP_RAGDOLL_PROPERTIES, TYPE_SPINNER, EDITTYPE_FLOAT,
                        IDC_ED_TWIST_MAX, IDC_SP_TWIST_MAX,
                        SPIN_AUTOSCALE,
        p_end,
    PA_RAGDOLL_MOD_MAX_FRICTION_TORQUE,
        _T("maxFrictionTorque"), TYPE_FLOAT, P_RESET_DEFAULT | P_ANIMATABLE, IDS_RAGDOLL_MODIFIER_PA_MAX_FRICTION_TORQUE,
        p_default,      0.0f,
        p_range,        0.0f, 1000000.0f,
        p_ui,           MAP_RAGDOLL_PROPERTIES, TYPE_SPINNER, EDITTYPE_FLOAT,
                        IDC_ED_MAX_FRICTION_TORQUE, IDC_SP_MAX_FRICTION_TORQUE,
                        SPIN_AUTOSCALE,
        p_end,


    PA_RAGDOLL_MOD_MOTOR_TYPE,
        _T("motorType"), TYPE_INT, P_RESET_DEFAULT | P_ANIMATABLE, IDS_RAGDOLL_MODIFIER_PA_MOTOR_TYPE,
        p_default,      RMT_NONE,
        p_end,


    // Display
    PA_RAGDOLL_MOD_DISPLAY_TWIST,
        _T("displayTwistLimits"), TYPE_BOOL, 0, IDS_RAGDOLL_MODIFIER_PA_DISPLAY_TWIST,
        p_default,  TRUE,
        p_ui,       MAP_RAGDOLL_DISPLAY, TYPE_SINGLECHEKBOX, IDC_CB_DISPLAY_TWIST,
        p_end,

    PA_RAGDOLL_MOD_DISPLAY_PLANE,
        _T("displayPlaneLimits"), TYPE_BOOL, 0, IDS_RAGDOLL_MODIFIER_PA_DISPLAY_PLANE,
        p_default,  FALSE,
        p_ui,       MAP_RAGDOLL_DISPLAY, TYPE_SINGLECHEKBOX, IDC_CB_DISPLAY_PLANE,
        p_end,

    p_end
    );


class RagdollMotorTypeComboBoxDescriptor : public hctBasicModifier::ComboBoxDescriptor
{
    public:

        /*virtual*/ BlockID getParamBlockID() {return PB_RAGDOLL_MOD_PBLOCK;}
        /*virtual*/ ParamID getParamID() {return PA_RAGDOLL_MOD_MOTOR_TYPE;}
        /*virtual*/ MapID getParamMapID() {return MAP_RAGDOLL_PROPERTIES;}
        /*virtual*/ int getControlID() {return IDC_COMBO_MOTOR_TYPE;}
        /*virtual*/ int getNumElements() {return 4;}
        /*virtual*/ const char* getElementString (int i)
        {
            static const char* m_elementStrings [] = {"None", "Position", "Velocity","Spring Damper"};
            return m_elementStrings[i];
        }

        /*virtual*/ const int getElementValue (int i) {return i;}
};

//Constructor/Destructor
hctRagdollConstraintModifier::hctRagdollConstraintModifier(ClassDesc2* theClassDesc)
: hctConstraintModifier(theClassDesc), m_limitMeshesValidity(NEVER)
{
    setupRagdollAxisMeshes();
    setupLimitSphereMNMesh();

}

hctRagdollConstraintModifier::~hctRagdollConstraintModifier()
{

}

hctBasicModifier::ComboBoxDescriptor* hctRagdollConstraintModifier::getComboBoxDescriptor (int comboBoxID)
{
    static RagdollMotorTypeComboBoxDescriptor motorTypeComboBox;

    return &motorTypeComboBox;
}

int hctRagdollConstraintModifier::Display(TimeValue t, INode* inode, ViewExp *vpt, int flagst, ModContext *mc)
{
    // Default display : two axis
    const float scale = getScaleDisplay(t, inode, vpt);
    const Point3 scaleV (scale,scale,scale);

    GraphicsWindow *gw=vpt->getGW();

    // Backup original limits
    const DWORD savedLimits=gw->getRndLimits();

    Matrix3 childSpaceTM; getSubobjectTransform(SOBJ_CONSTRAINT_MOD_CHILD_SPACE, t, inode, childSpaceTM);
    Matrix3 parentSpaceTM; getSubobjectTransform(SOBJ_CONSTRAINT_MOD_PARENT_SPACE, t, inode, parentSpaceTM);

    IParamBlock2* pblock2 = GetParamBlock(PB_RAGDOLL_MOD_PBLOCK);
    const bool displayTwistLimits = pblock2->GetInt(PA_RAGDOLL_MOD_DISPLAY_TWIST,t) != FALSE;
    const bool displayPlaneLimits = pblock2->GetInt(PA_RAGDOLL_MOD_DISPLAY_PLANE,t) != FALSE;

    // Draw child space
    {
        Material childMaterialsArray[] = {m_childSpaceMaterial};

        // Twist Axis
        {
            Matrix3 scaledTM = childSpaceTM;
            scaledTM.PreScale(scaleV, FALSE);
            gw->setTransform(scaledTM);

            gw->setRndLimits(GW_BACKCULL | (GW_LIGHTING) | GW_WIREFRAME);
            gw->setMaterial(m_childSpaceMaterial);
            m_twistAxisMesh.render(gw, childMaterialsArray, NULL, COMP_ALL);

            gw->setRndLimits(GW_BACKCULL | (GW_LIGHTING) | GW_Z_BUFFER);
            gw->setMaterial(m_childSpaceMaterial);
            m_twistAxisMesh.render(gw, childMaterialsArray, NULL, COMP_ALL);
        }

        // Current twist - it's actually displayed on the parent space
        if (displayTwistLimits)
        {
            const float childTwist = hctMaxUtils::getRagdollTwist(parentSpaceTM, childSpaceTM);

            Matrix3 twistRot; twistRot.SetRotate(AngAxis(Point3(1,0,0), childTwist));

            Matrix3 rotatedParentTM = twistRot * parentSpaceTM;

            Matrix3 scaledTM = rotatedParentTM;
            scaledTM.PreScale(scaleV, FALSE);
            gw->setTransform(scaledTM);

            gw->setRndLimits(GW_BACKCULL | (GW_LIGHTING) | GW_WIREFRAME);
            gw->setMaterial(m_childSpaceMaterial);
            m_twistBoxMesh.render(gw, childMaterialsArray, NULL, COMP_ALL);

            gw->setRndLimits(GW_BACKCULL | (GW_LIGHTING) | GW_FLAT | GW_Z_BUFFER);
            gw->setMaterial(m_childSpaceMaterial);
            m_twistBoxMesh.render(gw, childMaterialsArray, NULL, COMP_ALL);
        }
    }

    // Draw parent space
    {
        Material parentMaterialsArray[] = {m_parentSpaceMaterial};

        Matrix3 scaledTM = parentSpaceTM;
        scaledTM.PreScale(scaleV, FALSE);
        gw->setTransform(scaledTM);

        // Draw axis
        {
            gw->setRndLimits(GW_BACKCULL | (GW_LIGHTING) | GW_WIREFRAME);
            gw->setMaterial(m_parentSpaceMaterial);
            m_twistAxisMesh.render(gw, parentMaterialsArray, NULL, COMP_ALL);

            gw->setRndLimits(GW_BACKCULL | (GW_LIGHTING) | GW_FLAT | GW_Z_BUFFER);
            gw->setMaterial(m_parentSpaceMaterial);
            m_twistAxisMesh.render(gw, parentMaterialsArray, NULL, COMP_ALL);
        }

        // Draw twist
         if (displayTwistLimits)
        {
            gw->setRndLimits(GW_BACKCULL | (GW_LIGHTING) | GW_WIREFRAME);
            gw->setMaterial(m_parentSpaceMaterial);
            m_twistBoxMesh.render(gw, parentMaterialsArray, NULL, COMP_ALL);

            gw->setRndLimits(GW_BACKCULL | (GW_LIGHTING) | GW_FLAT | GW_Z_BUFFER);
            gw->setMaterial(m_parentSpaceMaterial);
            m_twistBoxMesh.render(gw, parentMaterialsArray, NULL, COMP_ALL);
        }

        // Draw limits
        {
            updateLimitMeshes(t);

            Material limitsMaterialArray[] = {m_limitsMaterial};

            Mesh volumeMesh;
            m_limitVolumeMesh.OutToTri(volumeMesh);

            // Plane Cones
            if (displayPlaneLimits)
            {
                // note : do not use GW_LIGHTING with wireframe and alpha
                gw->setRndLimits(GW_BACKCULL | GW_WIREFRAME);
                gw->setMaterial(m_limitsMaterial);
                m_minPlaneMesh.render(gw, limitsMaterialArray, NULL, COMP_ALL);

                gw->setRndLimits(GW_BACKCULL | GW_WIREFRAME);
                gw->setMaterial(m_limitsMaterial);
                m_maxPlaneMesh.render(gw, limitsMaterialArray, NULL, COMP_ALL);
            }

            // note : do not use GW_LIGHTING with wireframe and alpha
            if (displayTwistLimits)
            {
                gw->setRndLimits(GW_BACKCULL | GW_WIREFRAME);
                gw->setMaterial(m_limitsMaterial);
                m_limitDiscMesh.render(gw, limitsMaterialArray, NULL, COMP_ALL);

                gw->setRndLimits(GW_BACKCULL | GW_LIGHTING |  GW_TRANSPARENCY | GW_TRANSPARENT_PASS );
                gw->setTransparency(GW_TRANSPARENCY | GW_TRANSPARENT_PASS);
                gw->setMaterial(m_limitsMaterial);
                m_limitDiscMesh.render(gw, limitsMaterialArray, NULL, COMP_ALL);
                gw->setTransparency(0);
            }

            gw->setRndLimits(GW_BACKCULL | GW_WIREFRAME);
            gw->setMaterial(m_limitsMaterial);
            volumeMesh.render(gw, limitsMaterialArray, NULL, COMP_ALL);

            gw->setRndLimits(GW_BACKCULL | GW_LIGHTING |  GW_TRANSPARENCY | GW_TRANSPARENT_PASS );
            gw->setTransparency(GW_TRANSPARENCY | GW_TRANSPARENT_PASS);
            gw->setMaterial(m_limitsMaterial);
            volumeMesh.render(gw, limitsMaterialArray, NULL, COMP_ALL);

            gw->setTransparency(0);


        }


    }

    // Restore original limits
    gw->setRndLimits(savedLimits);

    return 0;
}

void hctRagdollConstraintModifier::GetWorldBoundBox(TimeValue t,INode* inode, ViewExp *vpt, Box3& box3, ModContext *mc)
{
    updateLimitMeshes(t);

    Box3 axisBoxLocal = m_twistAxisMesh.getBoundingBox();
    Box3 limitDiscBoxLocal = m_limitDiscMesh.getBoundingBox();
    Box3 limitVolumeBoxLocal = m_limitVolumeMesh.getBoundingBox();
    Box3 planeMinBoxLocal = m_minPlaneMesh.getBoundingBox();
    Box3 planeMaxBoxLocal = m_maxPlaneMesh.getBoundingBox();

    const float scale = getScaleDisplay(t, inode, vpt);
    const Point3 scaleV (scale,scale,scale);

    Matrix3 parentSpaceTM;
    getSubobjectTransform(SOBJ_CONSTRAINT_MOD_PARENT_SPACE, t, inode, parentSpaceTM);
    parentSpaceTM.PreScale(scaleV, FALSE);

    Matrix3 childSpaceTM;
    getSubobjectTransform(SOBJ_CONSTRAINT_MOD_CHILD_SPACE, t, inode, childSpaceTM);
    childSpaceTM.PreScale(scaleV, FALSE);

    Box3 parentBoxWorld = axisBoxLocal * parentSpaceTM;
    Box3 limitDiscBoxWorld = limitDiscBoxLocal* parentSpaceTM;
    Box3 planeMinBoxWorld = planeMinBoxLocal * parentSpaceTM;
    Box3 planeMaxBoxWorld = planeMaxBoxLocal * parentSpaceTM;
    Box3 limitVolumeBoxWorld = limitVolumeBoxLocal * parentSpaceTM;

    Box3 childBoxWorld = axisBoxLocal * childSpaceTM;

    box3 = parentBoxWorld;
    box3 += limitDiscBoxWorld;
    box3 += limitVolumeBoxWorld;
    box3 += planeMinBoxWorld;
    box3 += planeMaxBoxWorld;
    box3 += childBoxWorld;
}

#if MAX_VERSION_MAJOR>=17
    RefResult hctRagdollConstraintModifier::NotifyRefChanged( const Interval& changeInt, RefTargetHandle hTarget, PartID& partID,  RefMessage message, BOOL propagate )
#else
    RefResult hctRagdollConstraintModifier::NotifyRefChanged( Interval changeInt, RefTargetHandle hTarget, PartID& partID, RefMessage message )
#endif
{
    // If there are changes to the ragdoll parameters, we invalidate the mesh
    IParamBlock2* pblock2 = GetParamBlock(PB_RAGDOLL_MOD_PBLOCK);
    if ((message == REFMSG_CHANGE) && (hTarget == pblock2))
    {
        m_limitMeshesValidity = NEVER;
    }

    // Forward to parent class for further processing
    return hctConstraintModifier::NotifyRefChanged(changeInt, hTarget, partID, message);
}

// A disc representing the limits. Angles expressed in radians.
void hctRagdollConstraintModifier::updateLimitMeshes (TimeValue t)
{
    if (m_limitMeshesValidity.InInterval(t))
    {
        return;
    }

    // The axis of the ragdoll constraint
    const Point3 twistAxis (1,0,0);
    const Point3 planeAxis (0,1,0);
    const Point3 zeroAxis (0,0,1);

    IParamBlock2* pblock2 = GetParamBlock(PB_RAGDOLL_MOD_PBLOCK);

    m_limitMeshesValidity = FOREVER;
    pblock2->GetValidity(t, m_limitMeshesValidity);

    // Twist limits (same mesh as hinge)
    const float twistMin = pblock2->GetFloat(PA_RAGDOLL_MOD_TWIST_MIN, t);
    const float twistMax = pblock2->GetFloat(PA_RAGDOLL_MOD_TWIST_MAX, t);

    hctMaxUtils::createDiscMesh (twistAxis, zeroAxis, 0.3f, 0.1f, twistMin, twistMax, 10, true, m_limitDiscMesh);

    // Now do the volume
    MNMesh planeMaxCone;
    {
        const float planeMax = pblock2->GetFloat(PA_RAGDOLL_MOD_PLANE_MAX, t);

        Mesh temp;
        hctMaxUtils::createConeMesh (planeAxis, HALFPI-planeMax, 1.5f, true, true, temp);
        planeMaxCone = MNMesh (temp);

        const float height = 0.3f * cosf(HALFPI-planeMax);
        hctMaxUtils::createConeMesh (planeAxis, HALFPI-planeMax, height, false, false, m_maxPlaneMesh);
    }

    MNMesh planeMinCone;
    {
        const float planeMin = pblock2->GetFloat(PA_RAGDOLL_MOD_PLANE_MIN, t);

        Mesh temp;
        hctMaxUtils::createConeMesh (planeAxis * -1.0f, HALFPI+planeMin, 1.5f, true, true, temp);
        planeMinCone = MNMesh (temp);

        const float height = 0.3f * cosf(HALFPI+planeMin);
        hctMaxUtils::createConeMesh (planeAxis * -1.0f, HALFPI+planeMin, height, false, false, m_minPlaneMesh);
    }

    // The main cone: we will intersect for small cones, substract for bigger cones
    const float coneAngle = pblock2->GetFloat(PA_RAGDOLL_MOD_CONE_ANGLE, t);
    const bool useIntersection = (coneAngle<=HALFPI);

    MNMesh mainCone;
    {

        Mesh temp;
        if (useIntersection)
        {
            hctMaxUtils::createConeMesh (twistAxis, coneAngle, 1.5f, true, true, temp);
        }
        else
        {
            hctMaxUtils::createConeMesh (twistAxis * -1.0f, PI-coneAngle, 1.5, true, true, temp);
        }

        mainCone = MNMesh (temp);
    }


    // Substract/intersect full sphere with the main cone
    MNMesh temp1;
    temp1.MakeBoolean(m_limitSphereMNMesh, mainCone, useIntersection ? MESHBOOL_INTERSECTION : MESHBOOL_DIFFERENCE);

    // Then substract the plane limit cones
    MNMesh temp2;
    temp2.MakeBoolean(temp1, planeMaxCone, MESHBOOL_DIFFERENCE);
    m_limitVolumeMesh.MakeBoolean(temp2, planeMinCone, MESHBOOL_DIFFERENCE);


}

void hctRagdollConstraintModifier::setupLimitSphereMNMesh()
{
    if (m_limitSphereMNMeshSetup) return;

    Mesh sphereMeshTemp;
    hctMaxUtils::createGeoSphereMesh(1.0f, 5, true, sphereMeshTemp);

    m_limitSphereMNMesh = MNMesh(sphereMeshTemp);

    m_limitSphereMNMeshSetup = true;
}

void hctRagdollConstraintModifier::setupRagdollAxisMeshes()
{
    if (m_ragdollAxisMeshesSetup) return;

    // Twist Axis
    {
            // The axis has a length of 25.0 - Make it size 1.5f
        const float vertexScale = 1.5f/25.0f;

        static float theVertices[] = {
            -0.0000f,  0.0000f, -1.0000f ,   -0.0000f,  0.8660f, -0.5000f ,   0.0000f,  0.8660f,  0.5000f ,
            0.0000f, -0.0000f,  1.0000f ,     0.0000f, -0.8660f,  0.5000f ,  -0.0000f, -0.8660f, -0.5000f ,
            19.5714f,  0.8660f, -0.5000f ,   19.5714f,  0.0000f, -1.0000f ,  19.5714f, -0.0000f,  1.0000f ,
            19.5714f,  0.8660f,  0.5000f ,   19.5714f, -0.8660f, -0.5000f ,  19.5714f, -0.8660f,  0.5000f ,
            19.5714f,  0.0000f, -2.0000f ,   19.5714f,  1.7321f, -1.0000f ,  19.5714f,  1.7321f,  1.0000f ,
            19.5714f, -0.0000f,  2.0000f ,   19.5714f, -1.7321f,  1.0000f ,  19.5714f, -1.7321f, -1.0000f ,
            24.5714f,  0.0000f, -0.0000f };

        m_twistAxisMesh.setNumVerts(19);

        for (int v=0; v<19; v++)
        {
            m_twistAxisMesh.setVert(v, vertexScale * Point3(theVertices[v*3], theVertices[v*3+1], theVertices[v*3+2]));
        }

        static int theFaces[] = {
            1,  6,  7, 1,1,0, 4,0 ,       7,  0,  1, 1,1,0, 4,0 ,         3,  8,  9, 1,1,0, 4,0 ,
            9,  2,  3, 1,1,0, 4,0 ,       5, 10, 11, 1,1,0, 4,0 ,        11,  4,  5, 1,1,0, 4,0 ,
            4,  3,  2, 1,1,0, 1,0 ,       2,  1,  0, 1,1,0, 1,0 ,         4,  2,  0, 0,0,0, 1,0 ,
            5,  4,  0, 1,0,1, 1,0 ,       1,  2,  9, 1,1,0, 4,0 ,         9,  6,  1, 1,1,0, 4,0 ,
            3,  4, 11, 1,1,0, 4,0 ,      11,  8,  3, 1,1,0, 4,0 ,         5,  0,  7, 1,1,0, 4,0 ,
            7, 10,  5, 1,1,0, 4,0 ,      12, 13, 18, 1,1,1, 4,0 ,        13, 14, 18, 1,1,1, 4,0 ,
            14, 15, 18, 1,1,1, 4,0 ,         15, 16, 18, 1,1,1, 4,0 ,        16, 17, 18, 1,1,1, 4,0 ,
            17, 12, 18, 1,1,1, 4,0 ,         11, 10, 17, 1,0,0, 1,0 ,        11, 17, 16, 0,1,0, 1,0 ,
            8, 11, 16, 1,0,0, 1,0 ,       8, 16, 15, 0,1,0, 1,0 ,         9,  8, 15, 1,0,0, 1,0 ,
            9, 15, 14, 0,1,0, 1,0 ,       6,  9, 14, 1,0,0, 1,0 ,         6, 14, 13, 0,1,0, 1,0 ,
            7,  6, 13, 1,0,0, 1,0 ,       7, 13, 12, 0,1,0, 1,0 ,         7, 12, 17, 0,1,0, 1,0 ,
            7, 17, 10, 0,0,1, 1,0 };

        m_twistAxisMesh.setNumFaces(34);

        for (int f=0; f<34; f++)
        {
            m_twistAxisMesh.faces[f].setVerts(theFaces[f*8], theFaces[f*8+1], theFaces[f*8+2]);
            m_twistAxisMesh.faces[f].setEdgeVisFlags(theFaces[f*8+3], theFaces[f*8+4], theFaces[f*8+5]);
            m_twistAxisMesh.faces[f].setSmGroup(theFaces[f*8+6]);
            m_twistAxisMesh.faces[f].setMatID((MtlID)theFaces[f*8+7]);
        }

        m_twistAxisMesh.buildNormals();
        m_twistAxisMesh.BuildStripsAndEdges();

    }

    // Twist box3
    {
            // The axis has a length of 13.0 - Make it size 0.3f
        const float vertexScale = 0.3f/13.0f;

        static float theVertices[] = {
                1.2700f,  0.4974f,  0.0038f ,     1.2700f,  0.4974f, 13.0038f ,  -1.2800f,  0.4974f,  0.0038f ,
                -1.2800f,  0.4974f, 13.0038f ,    1.2700f, -0.3775f,  0.0038f ,   1.2700f, -0.3775f, 13.0038f ,
                -1.2800f, -0.3775f,  0.0038f ,   -1.2800f, -0.3775f, 13.0038f };

        m_twistBoxMesh.setNumVerts(8);

        for (int v=0; v<8; v++)
        {
            m_twistBoxMesh.setVert(v, vertexScale * Point3(theVertices[v*3], theVertices[v*3+1], theVertices[v*3+2]));
        }

        static int theFaces[] = {
            0,  2,  3, 1,1,0, 2,1 ,       3,  1,  0, 1,1,0, 2,1 ,         4,  5,  7, 1,1,0, 3,1 ,
            7,  6,  4, 1,1,0, 3,1 ,       0,  1,  5, 1,1,0, 4,1 ,         5,  4,  0, 1,1,0, 4,1 ,
            1,  3,  7, 1,1,0, 5,1 ,       7,  5,  1, 1,1,0, 5,1 ,         3,  2,  6, 1,1,0, 6,1 ,
            6,  7,  3, 1,1,0, 6,1 ,       2,  0,  4, 1,1,0, 7,1 ,         4,  6,  2, 1,1,0, 7,1 };

        m_twistBoxMesh.setNumFaces(12);

        for (int f=0; f<12; f++)
        {
            m_twistBoxMesh.faces[f].setVerts(theFaces[f*8], theFaces[f*8+1], theFaces[f*8+2]);
            m_twistBoxMesh.faces[f].setEdgeVisFlags(theFaces[f*8+3], theFaces[f*8+4], theFaces[f*8+5]);
            m_twistBoxMesh.faces[f].setSmGroup(theFaces[f*8+6]);
            m_twistBoxMesh.faces[f].setMatID((MtlID)theFaces[f*8+7]);
        }

        m_twistBoxMesh.buildNormals();
        m_twistBoxMesh.BuildStripsAndEdges();
    }

    m_ragdollAxisMeshesSetup = true;

}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
