// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Max/MaxSceneExport/resource.h>
#include <ContentTools/Max/MaxSceneExport/Modifiers/Constraints/hctConstraintModifier.h>
#include <ContentTools/Max/MaxFpInterfaces/Physics/Constraints/hctPrismaticConstraintModifierInterface.h>

// Motor Types (combo box)
enum
{
    PMT_NONE,
    PMT_POSITION,
    PMT_VELOCITY,
    PMT_SPRING_DAMPER,
};

class hctPrismaticConstraintModifier : public hctConstraintModifier
{
    public:

        //Constructor/Destructor
        hctPrismaticConstraintModifier(ClassDesc2* theClassDesc);
        /*virtual*/  ~hctPrismaticConstraintModifier();

        /*virtual*/ hctConstraintDescriptor* getConstraintDescriptor();

        /*
        ** From Basic Modifier. We have one combo box (motor type)
        */
        /*virtual*/ int getNumComboBoxes () { return 1; }
        /*virtual*/ ComboBoxDescriptor* getComboBoxDescriptor (int comboBoxID);

        // From Object - Display stuff. We want to display just two markers.
        /*virtual*/ int Display(TimeValue t, INode* inode, ViewExp *vpt, int flagst, ModContext *mc);
        /*virtual*/ void GetWorldBoundBox(TimeValue t,INode* inode, ViewExp *vpt, Box3& box, ModContext *mc);

    private:

        enum Side {TOP_SIDE, BOTTOM_SIDE};

        // The axis mesh is static since it is reused by all prismatic constraints
        static Mesh m_prismaticAxisMesh;
        static Mesh m_prismaticVolumeMeshes[2];
        static bool m_prismaticMeshesSetup;
        void setupPrismaticMeshes();

        void getVolumeDisplayTransform (Side whichSide, TimeValue t, INode* inode, ViewExp* vpt, Matrix3& transformOut);

        bool getIsLimitOn (Side whichSide, TimeValue t=0);
        float getLimitValue (Side whichSide, TimeValue t=0);

};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
