// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>
#include <ContentTools/Max/MaxSceneExport/Modifiers/Constraints/Prismatic/hctPrismaticConstraintModifier.h>

/*static*/ Mesh hctPrismaticConstraintModifier::m_prismaticAxisMesh;
/*static*/ Mesh hctPrismaticConstraintModifier::m_prismaticVolumeMeshes[2];
/*static*/ bool hctPrismaticConstraintModifier::m_prismaticMeshesSetup = false;

class hkPrismaticConstraintModifierDesc : public ClassDesc2
{
    public:
        int             IsPublic() { return TRUE; }
        void *          Create (BOOL loading = FALSE) { return new hctPrismaticConstraintModifier(this); }
        const MCHAR *   ClassName() { return GetString(IDS_PRISMATIC_MODIFIER_CLASS_NAME); }
        SClass_ID       SuperClassID() { return OSM_CLASS_ID; }
        Class_ID        ClassID() { return HK_CONSTRAINT_PRISMATIC_CLASS_ID; }
        const MCHAR*    Category() { return GetString(IDS_HAVOK_MODIFIERS_CATEGORY); }
        const MCHAR*    InternalName() { return _T("hkPrismaticConstraintModifier");; }
        HINSTANCE       HInstance() { return hInstance; }
};

ClassDesc2* getHkPrismaticConstraintModifierDesc()
{
    static hkPrismaticConstraintModifierDesc modifierDesc;
    return &modifierDesc;
}

class hkPrismaticConstraintDescriptor : public hctConstraintDescriptor
{
    public:

        // Return the Class Descriptor of the modifier implementing the constraint
        /*virtual*/ ClassDesc2* getClassDesc() const {return getHkPrismaticConstraintModifierDesc();}

        // Return the constraint name (name for the pblock)
        /*virtual*/ MCHAR* getConstraintName() const {return TEXT("hkPrismaticConstraint");}

        // Return a string ID for the Class Name
        /*virtual*/ int getClassNameStringID () const {return IDS_PRISMATIC_MODIFIER_CLASS_NAME;}

        // Return a string ID for the Object NAme
        /*virtual*/ int getObjectNameStringID () const {return IDS_PRISMATIC_MODIFIER_OBJECT_NAME;}

    public:

        // Constructor, sets up the paramblockdesc2
        hkPrismaticConstraintDescriptor(): hctConstraintDescriptor()
        {
            m_commonSpacesPBD = hctConstraintModifier::setupCommonSpacesPBD(this);

            hctConstraintModifier::addCommonFPInterface(this);
        }
};

static hkPrismaticConstraintDescriptor g_prismaticConstraintDescriptor;

hctConstraintDescriptor* hctPrismaticConstraintModifier::getConstraintDescriptor()
{
    return &g_prismaticConstraintDescriptor;
}

// Null class so order is as we want it
static ParamBlockDesc2 hkPrismatic_ParamBlockDesc
    ( PB_PRISMATIC_MOD_PBLOCK, TEXT("hkPrismaticConstraintMerge"),  0, getHkPrismaticConstraintModifierDesc(), P_AUTO_CONSTRUCT + P_AUTO_UI, PB_PRISMATIC_MOD_PBLOCK,

    // Rollout; we use the default combobox handler dlg proc to handle combobox changes
    IDD_PRISMATIC_MODIFIER_ROLLOUT_PROPERTIES,
    IDS_PRISMATIC_MODIFIER_ROLLOUT_PROPERTIES,
    0, 0, hctBasicModifier::getComboBoxHandlerDlgProc(),

    PA_PRISMATIC_MOD_CHANGE_LIMIT_MIN,
        _T("changeMinLinearLimit"), TYPE_BOOL, P_RESET_DEFAULT | P_ANIMATABLE, IDS_PRISMATIC_MODIFIER_PA_CHANGE_LIMIT_MIN,
        p_default,      FALSE,
        p_ui,           TYPE_SINGLECHEKBOX, IDC_CB_LIMIT_MIN,
        p_enable_ctrls, 1,  PA_PRISMATIC_MOD_LIMIT_MIN,
        p_end,

    PA_PRISMATIC_MOD_LIMIT_MIN,
        _T("minLinearLimit"), TYPE_WORLD, P_RESET_DEFAULT | P_ANIMATABLE, IDS_PRISMATIC_MODIFIER_PA_LIMIT_MIN,
        p_default,      -1.0f, // Meters - will be scaled in the constructor (EXP-1006)
        p_range,        -10000000.0f, 0.0f,
        p_ui,           TYPE_SPINNER, EDITTYPE_UNIVERSE,
            IDC_ED_LIMIT_MIN, IDC_SP_LIMIT_MIN,
            SPIN_AUTOSCALE,
        p_end,

    PA_PRISMATIC_MOD_CHANGE_LIMIT_MAX,
        _T("changeMaxLinearLimit"), TYPE_BOOL, P_RESET_DEFAULT | P_ANIMATABLE, IDS_PRISMATIC_MODIFIER_PA_CHANGE_LIMIT_MAX,
        p_default,      FALSE,
        p_ui,           TYPE_SINGLECHEKBOX, IDC_CB_LIMIT_MAX,
        p_enable_ctrls, 1,  PA_PRISMATIC_MOD_LIMIT_MAX,
        p_end,

    PA_PRISMATIC_MOD_LIMIT_MAX,
        _T("maxLinearLimit"), TYPE_WORLD, P_RESET_DEFAULT | P_ANIMATABLE, IDS_PRISMATIC_MODIFIER_PA_LIMIT_MAX,
        p_default,      1.0f, // Meters - will be scaled in the constructor (EXP-1006)
        p_range,        0.0f, 10000000.0f,
        p_ui,           TYPE_SPINNER, EDITTYPE_UNIVERSE,
            IDC_ED_LIMIT_MAX, IDC_SP_LIMIT_MAX,
            SPIN_AUTOSCALE,
        p_end,

    PA_PRISMATIC_MOD_MAX_FRICTION_TORQUE,
        _T("maxFrictionForce"), TYPE_FLOAT, P_RESET_DEFAULT | P_ANIMATABLE, IDS_PRISMATIC_MODIFIER_PA_MAX_FRICTION_FORCE,
        p_default,      0.0f,
        p_range,        0.0f, 1000000.0f,
        p_ui,           TYPE_SPINNER, EDITTYPE_FLOAT,
            IDC_ED_MAX_FRICTION_FORCE, IDC_SP_MAX_FRICTION_FORCE,
            SPIN_AUTOSCALE,
        p_end,

    PA_PRISMATIC_MOD_MOTOR_TYPE,
        _T("motorType"), TYPE_INT, P_RESET_DEFAULT | P_ANIMATABLE, IDS_PRISMATIC_MODIFIER_PA_MOTOR_TYPE,
        p_default,      PMT_NONE,
        p_end,
        p_end
 );


class PrismaticMotorTypeComboBoxDescriptor : public hctBasicModifier::ComboBoxDescriptor
{
    public:

        /*virtual*/ BlockID getParamBlockID() {return PB_PRISMATIC_MOD_PBLOCK;}
        /*virtual*/ ParamID getParamID() {return PA_PRISMATIC_MOD_MOTOR_TYPE;}
        /*virtual*/ MapID getParamMapID() {return 0;}
        /*virtual*/ int getControlID() {return IDC_COMBO_MOTOR_TYPE;}
        /*virtual*/ int getNumElements() {return 4;}
        /*virtual*/ const char* getElementString (int i)
        {
            static const char* m_elementStrings [] = {"None", "Position", "Velocity","Spring Damper"};
            return m_elementStrings[i];
        }

        /*virtual*/ const int getElementValue (int i) {return i;}
};



//Constructor/Destructor
hctPrismaticConstraintModifier::hctPrismaticConstraintModifier(ClassDesc2* theClassDesc)
: hctConstraintModifier(theClassDesc)
{
    // The prismatic constraint created will setup the axis mesh
    setupPrismaticMeshes();

    // EXP-1006 : Set the max/max linear limit default based on system units
    const float metersPerUnit = float(GetMasterScale(UNITS_METERS));
    IParamBlock2* pblock2 = GetParamBlock(PB_PRISMATIC_MOD_PBLOCK);
    if (pblock2)
    {
        // Limit min
        {
            const float meters = pblock2->GetFloat(PA_PRISMATIC_MOD_LIMIT_MIN);
            const float units = meters / metersPerUnit;
            pblock2->SetValue(PA_PRISMATIC_MOD_LIMIT_MIN, 0, units);
        }

        // Limit max
        {
            const float meters = pblock2->GetFloat(PA_PRISMATIC_MOD_LIMIT_MAX);
            const float units = meters / metersPerUnit;
            pblock2->SetValue(PA_PRISMATIC_MOD_LIMIT_MAX, 0, units);
        }

    }


}

hctPrismaticConstraintModifier::~hctPrismaticConstraintModifier()
{

}

hctBasicModifier::ComboBoxDescriptor* hctPrismaticConstraintModifier::getComboBoxDescriptor (int comboBoxID)
{
    static PrismaticMotorTypeComboBoxDescriptor motorTypeComboBox;

    return &motorTypeComboBox;
}

bool hctPrismaticConstraintModifier::getIsLimitOn (Side whichSide, TimeValue t)
{
    IParamBlock2* pblock2 = GetParamBlock(PB_PRISMATIC_MOD_PBLOCK);

    if (whichSide==TOP_SIDE)
    {
        return pblock2->GetInt(PA_PRISMATIC_MOD_CHANGE_LIMIT_MAX, t) != FALSE;
    }
    else
    {
        return pblock2->GetInt(PA_PRISMATIC_MOD_CHANGE_LIMIT_MIN, t) != FALSE;
    }
}
float hctPrismaticConstraintModifier::getLimitValue (Side whichSide, TimeValue t)
{
    IParamBlock2* pblock2 = GetParamBlock(PB_PRISMATIC_MOD_PBLOCK);

    if (whichSide==TOP_SIDE)
    {
        return pblock2->GetFloat(PA_PRISMATIC_MOD_LIMIT_MAX, t);
    }
    else
    {
        return pblock2->GetFloat(PA_PRISMATIC_MOD_LIMIT_MIN, t);
    }

}

void hctPrismaticConstraintModifier::getVolumeDisplayTransform(Side whichSide, TimeValue t, INode* inode, ViewExp* vpt, Matrix3& transformOut)
{
    const bool hasLimit = getIsLimitOn(whichSide, t);

    const float limitAbs = fabs(getLimitValue(whichSide, t));

    const float scale = getScaleDisplay(t, inode, vpt);

    const float zScale = hasLimit ? limitAbs*2 : scale*2;

    const Point3 scaleV (scale,scale,zScale);

    getSubobjectTransform(SOBJ_CONSTRAINT_MOD_PARENT_SPACE, t, inode, transformOut);
    transformOut.PreScale(scaleV, FALSE);
}

int hctPrismaticConstraintModifier::Display(TimeValue t, INode* inode, ViewExp *vpt, int flagst, ModContext *mc)
{
    // Default display : two axis
    const float scale = getScaleDisplay(t, inode, vpt);
    const Point3 scaleV (scale,scale,scale);

    GraphicsWindow *gw=vpt->getGW();

    // Backup original limits
    const DWORD savedLimits=gw->getRndLimits();


    // Draw child axis
    {
        Matrix3 childSpaceTM; getSubobjectTransform(SOBJ_CONSTRAINT_MOD_CHILD_SPACE, t, inode, childSpaceTM);
        Matrix3 scaledTM = childSpaceTM;
        scaledTM.PreScale(scaleV, FALSE);
        gw->setTransform(scaledTM);

        Material childMaterialsArray[] = {m_childSpaceMaterial};

        gw->setRndLimits(GW_BACKCULL | (GW_LIGHTING) | GW_WIREFRAME);
        gw->setMaterial(m_childSpaceMaterial);
        m_prismaticAxisMesh.render(gw, childMaterialsArray, NULL, COMP_ALL);

        gw->setRndLimits(GW_BACKCULL | (GW_LIGHTING) | GW_Z_BUFFER);
        gw->setMaterial(m_childSpaceMaterial);
        m_prismaticAxisMesh.render(gw, childMaterialsArray, NULL, COMP_ALL);

    }

    // Draw parent space
    {
        Matrix3 parentSpaceTM; getSubobjectTransform(SOBJ_CONSTRAINT_MOD_PARENT_SPACE, t, inode, parentSpaceTM);

        Matrix3 scaledTM = parentSpaceTM;
        scaledTM.PreScale(scaleV, FALSE);
        gw->setTransform(scaledTM);

        // Draw axis
        {

            Material parentMaterialsArray[] = {m_parentSpaceMaterial};

            gw->setRndLimits(GW_BACKCULL | (GW_LIGHTING) | GW_WIREFRAME);
            gw->setMaterial(m_parentSpaceMaterial);
            m_prismaticAxisMesh.render(gw, parentMaterialsArray, NULL, COMP_ALL);

            gw->setRndLimits(GW_BACKCULL | (GW_LIGHTING) | GW_FLAT | GW_Z_BUFFER);
            gw->setMaterial(m_parentSpaceMaterial);
            m_prismaticAxisMesh.render(gw, parentMaterialsArray, NULL, COMP_ALL);
        }

    }

    // Draw volumes
    for (int sideIt = TOP_SIDE; sideIt<=BOTTOM_SIDE; sideIt++)
    {
        Side side = (Side) sideIt;
        const bool hasLimit = getIsLimitOn(side, t);

        Matrix3 volumeTM; getVolumeDisplayTransform(side, t, inode, vpt, volumeTM);
        gw->setTransform(volumeTM);
        {
            Material parentMaterialsArray[] = {m_parentSpaceMaterial};
            Material limitsMaterialsArray[] = {m_limitsMaterial};

            if (hasLimit)
            {
                gw->setRndLimits(GW_BACKCULL | GW_LIGHTING | /*GW_Z_BUFFER |*/ GW_TRANSPARENCY | GW_TRANSPARENT_PASS );
                gw->setTransparency(GW_TRANSPARENCY | GW_TRANSPARENT_PASS);
                gw->setMaterial(m_limitsMaterial);
                m_prismaticVolumeMeshes[side].render(gw, limitsMaterialsArray, NULL, COMP_ALL);
                gw->setTransparency(0);

                // note : do not use GW_LIGHTING with wireframe and alpha
                gw->setRndLimits(GW_BACKCULL | GW_WIREFRAME);
                gw->setMaterial(m_parentSpaceMaterial);
                m_prismaticVolumeMeshes[side].render(gw, parentMaterialsArray, NULL, COMP_ALL);
            }
            else
            {
                // No limits - display dashed lines
                gw->setRndLimits(GW_BACKCULL | GW_WIREFRAME);
                gw->setMaterial(m_parentSpaceMaterial);
                for (int line=0; line<3; line++)
                {
                    const Point3& start = m_prismaticVolumeMeshes[side].verts[line];
                    const Point3& p_end = m_prismaticVolumeMeshes[side].verts[line+3];

                    hctMaxUtils::drawDashedLine(gw, start, p_end);
                }
            }

        }
    }

    // Restore original limits
    gw->setRndLimits(savedLimits);

    return 0;
}




void hctPrismaticConstraintModifier::GetWorldBoundBox(TimeValue t,INode* inode, ViewExp *vpt, Box3& box3, ModContext *mc)
{
    Box3 axisBoxLocal = m_prismaticAxisMesh.getBoundingBox();
    Box3 topVolumeBoxLocal = m_prismaticVolumeMeshes[TOP_SIDE].getBoundingBox();
    Box3 bottomVolumeBoxLocal = m_prismaticVolumeMeshes[BOTTOM_SIDE].getBoundingBox();

    const float scale = getScaleDisplay(t, inode, vpt);
    const Point3 scaleV (scale,scale,scale);

    Matrix3 parentSpaceTM;
    getSubobjectTransform(SOBJ_CONSTRAINT_MOD_PARENT_SPACE, t, inode, parentSpaceTM);
    parentSpaceTM.PreScale(scaleV, FALSE);

    Matrix3 childSpaceTM;
    getSubobjectTransform(SOBJ_CONSTRAINT_MOD_CHILD_SPACE, t, inode, childSpaceTM);
    childSpaceTM.PreScale(scaleV, FALSE);

    Matrix3 topVolumeTM;
    getVolumeDisplayTransform(TOP_SIDE, t, inode, vpt, topVolumeTM);
    Matrix3 bottomVolumeTM;
    getVolumeDisplayTransform(BOTTOM_SIDE, t, inode, vpt, bottomVolumeTM);

    Box3 parentBoxWorld = axisBoxLocal * parentSpaceTM;
    Box3 childBoxWorld = axisBoxLocal * childSpaceTM;
    Box3 topVolumeBoxWorld = topVolumeBoxLocal* topVolumeTM;
    Box3 bottomVolumeBoxWorld = bottomVolumeBoxLocal * bottomVolumeTM;

    box3 = parentBoxWorld;
    box3 += childBoxWorld;
    box3 += topVolumeBoxWorld;
    box3 += bottomVolumeBoxWorld;
}

void hctPrismaticConstraintModifier::setupPrismaticMeshes()
{
    if (m_prismaticMeshesSetup) return;

    // Axis (triangle with arrow)
    {
        const float vertexScale = 1.0f/200.0f;

        static float theVertices[] = {
                60.0000f,  0.0000f, -1.1408f ,  -40.0000f,100.0000f, -1.1408f , -40.0000f,-100.0000f, -1.1408f ,
                60.0000f,  0.0000f, -0.2208f ,  -40.0000f,100.0000f, -0.2208f , -40.0000f,-100.0000f, -0.2208f ,
                0.0000f,  0.0000f,  0.0000f ,     8.0000f,  0.0000f,  0.0000f ,   5.6569f,  5.6569f,  0.0000f ,
                -0.0000f,  8.0000f,  0.0000f ,   -5.6569f,  5.6569f,  0.0000f ,  -8.0000f, -0.0000f,  0.0000f ,
                -5.6569f, -5.6569f,  0.0000f ,    0.0000f, -8.0000f,  0.0000f ,   5.6569f, -5.6569f,  0.0000f ,
                8.0000f,  0.0000f, 30.0000f ,     5.6569f,  5.6569f, 30.0000f ,  -0.0000f,  8.0000f, 30.0000f ,
                -5.6569f,  5.6569f, 30.0000f ,   -8.0000f, -0.0000f, 30.0000f ,  -5.6569f, -5.6569f, 30.0000f ,
                0.0000f, -8.0000f, 30.0000f ,     5.6569f, -5.6569f, 30.0000f ,   0.0000f,  0.0000f, 30.0000f ,
                0.0000f, -0.0000f, 27.6436f ,    15.0000f, -0.0000f, 27.6436f ,  10.6066f, 10.6066f, 27.6436f ,
                -0.0000f, 15.0000f, 27.6436f ,  -10.6066f, 10.6066f, 27.6436f , -15.0000f, -0.0000f, 27.6436f ,
                -10.6066f,-10.6066f, 27.6436f ,   0.0000f,-15.0000f, 27.6436f ,  10.6066f,-10.6066f, 27.6436f ,
                0.0000f, -0.0000f, 57.6436f ,     0.0000f, -0.0000f, 57.6436f ,   0.0000f, -0.0000f, 57.6436f ,
                0.0000f, -0.0000f, 57.6436f ,     0.0000f, -0.0000f, 57.6436f ,   0.0000f, -0.0000f, 57.6436f ,
                0.0000f, -0.0000f, 57.6436f ,     0.0000f, -0.0000f, 57.6436f ,   0.0000f, -0.0000f, 57.6436f };

        m_prismaticAxisMesh.setNumVerts(42);

        for (int v=0; v<42; v++)
        {
            m_prismaticAxisMesh.setVert(v, vertexScale * Point3(theVertices[v*3], theVertices[v*3+1], theVertices[v*3+2]));
        }

        static int theFaces[] = {
            3,  4,  5, 1,1,1, 1,0 ,       4,  3,  0, 1,1,0, 15,0 ,        0,  1,  4, 1,1,0, 15,0 ,
            5,  4,  1, 1,1,0, 16,0 ,      1,  2,  5, 1,1,0, 16,0 ,        3,  5,  2, 1,1,0, 14,0 ,
            2,  0,  3, 1,1,0, 14,0 ,      0,  2,  1, 1,1,1, 2,1 ,         6,  8,  7, 0,1,0, 1,1 ,
            6,  9,  8, 0,1,0, 1,1 ,       6, 10,  9, 0,1,0, 1,1 ,         6, 11, 10, 0,1,0, 1,1 ,
            6, 12, 11, 0,1,0, 1,1 ,       6, 13, 12, 0,1,0, 1,1 ,         6, 14, 13, 0,1,0, 1,1 ,
            6,  7, 14, 0,1,0, 1,1 ,       7, 16, 15, 0,1,1, 4,2 ,         7,  8, 16, 1,1,0, 4,2 ,
            8, 17, 16, 0,1,1, 4,2 ,       8,  9, 17, 1,1,0, 4,2 ,         9, 18, 17, 0,1,1, 4,2 ,
            9, 10, 18, 1,1,0, 4,2 ,      10, 19, 18, 0,1,1, 4,2 ,        10, 11, 19, 1,1,0, 4,2 ,
            11, 20, 19, 0,1,1, 4,2 ,     11, 12, 20, 1,1,0, 4,2 ,        12, 21, 20, 0,1,1, 4,2 ,
            12, 13, 21, 1,1,0, 4,2 ,     13, 22, 21, 0,1,1, 4,2 ,        13, 14, 22, 1,1,0, 4,2 ,
            14, 15, 22, 0,1,1, 4,2 ,     14,  7, 15, 1,1,0, 4,2 ,        23, 15, 16, 0,1,0, 1,0 ,
            23, 16, 17, 0,1,0, 1,0 ,     23, 17, 18, 0,1,0, 1,0 ,        23, 18, 19, 0,1,0, 1,0 ,
            23, 19, 20, 0,1,0, 1,0 ,     23, 20, 21, 0,1,0, 1,0 ,        23, 21, 22, 0,1,0, 1,0 ,
            23, 22, 15, 0,1,0, 1,0 ,     24, 26, 25, 0,1,0, 1,1 ,        24, 27, 26, 0,1,0, 1,1 ,
            24, 28, 27, 0,1,0, 1,1 ,     24, 29, 28, 0,1,0, 1,1 ,        24, 30, 29, 0,1,0, 1,1 ,
            24, 31, 30, 0,1,0, 1,1 ,     24, 32, 31, 0,1,0, 1,1 ,        24, 25, 32, 0,1,0, 1,1 ,
            25, 34, 33, 0,1,1, 4,2 ,     25, 26, 34, 1,1,0, 4,2 ,        26, 35, 34, 0,1,1, 4,2 ,
            26, 27, 35, 1,1,0, 4,2 ,     27, 36, 35, 0,1,1, 4,2 ,        27, 28, 36, 1,1,0, 4,2 ,
            28, 37, 36, 0,1,1, 4,2 ,     28, 29, 37, 1,1,0, 4,2 ,        29, 38, 37, 0,1,1, 4,2 ,
            29, 30, 38, 1,1,0, 4,2 ,     30, 39, 38, 0,1,1, 4,2 ,        30, 31, 39, 1,1,0, 4,2 ,
            31, 40, 39, 0,1,1, 4,2 ,     31, 32, 40, 1,1,0, 4,2 ,        32, 33, 40, 0,1,1, 4,2 ,
            32, 25, 33, 1,1,0, 4,2 ,     41, 33, 34, 0,1,0, 1,0 ,        41, 34, 35, 0,1,0, 1,0 ,
            41, 35, 36, 0,1,0, 1,0 ,     41, 36, 37, 0,1,0, 1,0 ,        41, 37, 38, 0,1,0, 1,0 ,
            41, 38, 39, 0,1,0, 1,0 ,     41, 39, 40, 0,1,0, 1,0 ,        41, 40, 33, 0,1,0, 1,0 };

        m_prismaticAxisMesh.setNumFaces(72);

        for (int f=0; f<72; f++)
        {
            m_prismaticAxisMesh.faces[f].setVerts(theFaces[f*8], theFaces[f*8+1], theFaces[f*8+2]);
            m_prismaticAxisMesh.faces[f].setEdgeVisFlags(theFaces[f*8+3], theFaces[f*8+4], theFaces[f*8+5]);
            m_prismaticAxisMesh.faces[f].setSmGroup(theFaces[f*8+6]);
            m_prismaticAxisMesh.faces[f].setMatID((MtlID)theFaces[f*8+7]);
        }

        m_prismaticAxisMesh.buildNormals();
        m_prismaticAxisMesh.BuildStripsAndEdges();
    }

    // Volume (top)
    {
        const float vertexScale = 1.0f/200.0f;

        static float theVertices[] = {
            60.0000f,  0.0000f,100.0000f ,  -40.0000f,100.0000f,100.0000f , -40.0000f,-100.0000f,100.0000f ,
            60.0000f,  0.0000f,  0.0000f ,  -40.0000f,100.0000f,  0.0000f , -40.0000f,-100.0000f,  0.0000f };

        m_prismaticVolumeMeshes[TOP_SIDE].setNumVerts(6);

        for (int v=0; v<6; v++)
        {
            m_prismaticVolumeMeshes[TOP_SIDE].setVert(v, vertexScale * Point3(theVertices[v*3], theVertices[v*3+1], theVertices[v*3+2]));
        }

        static int theFaces[] = {
            0,  1,  2, 1,1,1, 1,0 ,       0,  3,  4, 1,1,0, 15,0 ,        4,  1,  0, 1,1,0, 15,0 ,
            1,  4,  5, 1,1,0, 16,0 ,      5,  2,  1, 1,1,0, 16,0 ,        2,  5,  3, 1,1,0, 14,0 ,
            3,  0,  2, 1,1,0, 14,0 };

        m_prismaticVolumeMeshes[TOP_SIDE].setNumFaces(7);

        for (int f=0; f<7; f++)
        {
            m_prismaticVolumeMeshes[TOP_SIDE].faces[f].setVerts(theFaces[f*8], theFaces[f*8+1], theFaces[f*8+2]);
            m_prismaticVolumeMeshes[TOP_SIDE].faces[f].setEdgeVisFlags(theFaces[f*8+3], theFaces[f*8+4], theFaces[f*8+5]);
            m_prismaticVolumeMeshes[TOP_SIDE].faces[f].setSmGroup(0); // no smoothing
            m_prismaticVolumeMeshes[TOP_SIDE].faces[f].setMatID((MtlID)theFaces[f*8+7]);
        }

        m_prismaticVolumeMeshes[TOP_SIDE].buildNormals();
        m_prismaticVolumeMeshes[TOP_SIDE].BuildStripsAndEdges();

    }

    // Volume (bottom)
    {
        const float vertexScale = 1.0f/200.0f;

        static float theVertices[] = {
            60.0000f,  0.0000f,-100.0000f , -40.0000f,100.0000f,-100.0000f ,    -40.0000f,-100.0000f,-100.0000f ,
            60.0000f,  0.0000f,  0.0000f ,  -40.0000f,100.0000f,  0.0000f ,     -40.0000f,-100.0000f,  0.0000f };

        m_prismaticVolumeMeshes[BOTTOM_SIDE].setNumVerts(6);

        for (int v=0; v<6; v++)
        {
            m_prismaticVolumeMeshes[BOTTOM_SIDE].setVert(v, vertexScale * Point3(theVertices[v*3], theVertices[v*3+1], theVertices[v*3+2]));
        }

        static int theFaces[] = {
            0,  2,  1, 1,1,1, 2,1 ,       0,  1,  4, 1,1,0, 15,0 ,        4,  3,  0, 1,1,0, 15,0 ,
            1,  2,  5, 1,1,0, 16,0 ,      5,  4,  1, 1,1,0, 16,0 ,        2,  0,  3, 1,1,0, 14,0 ,
            3,  5,  2, 1,1,0, 14,0 };

        m_prismaticVolumeMeshes[BOTTOM_SIDE].setNumFaces(7);

        for (int f=0; f<7; f++)
        {
            m_prismaticVolumeMeshes[BOTTOM_SIDE].faces[f].setVerts(theFaces[f*8], theFaces[f*8+1], theFaces[f*8+2]);
            m_prismaticVolumeMeshes[BOTTOM_SIDE].faces[f].setEdgeVisFlags(theFaces[f*8+3], theFaces[f*8+4], theFaces[f*8+5]);
            m_prismaticVolumeMeshes[BOTTOM_SIDE].faces[f].setSmGroup(0); // no smoothing
            m_prismaticVolumeMeshes[BOTTOM_SIDE].faces[f].setMatID((MtlID)theFaces[f*8+7]);
        }

        m_prismaticVolumeMeshes[BOTTOM_SIDE].buildNormals();
        m_prismaticVolumeMeshes[BOTTOM_SIDE].BuildStripsAndEdges();

    }

    m_prismaticMeshesSetup = true;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
