// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Max/MaxSceneExport/resource.h>
#include <ContentTools/Max/MaxSceneExport/Modifiers/Constraints/hctConstraintModifier.h>
#include <ContentTools/Max/MaxFpInterfaces/Physics/Constraints/hctHingeConstraintModifierInterface.h>

// Motor Types (combo box)
enum
{
    HMT_NONE,
    HMT_POSITION,
    HMT_VELOCITY,
    HMT_SPRING_DAMPER,
};

class hctHingeConstraintModifier : public hctConstraintModifier
{
    public:

        //Constructor/Destructor
        hctHingeConstraintModifier(ClassDesc2* theClassDesc);
        /*virtual*/  ~hctHingeConstraintModifier();

        /*virtual*/ hctConstraintDescriptor* getConstraintDescriptor();

        /*
        ** From Basic Modifier. We have one combo box (motor type)
        */
        /*virtual*/ int getNumComboBoxes () { return 1; }
        /*virtual*/ ComboBoxDescriptor* getComboBoxDescriptor (int comboBoxID);

        // Update UI - Enables some controls, etc
        /*virtual*/ void updateUI ();

        // From Object - Display stuff
        /*virtual*/ int Display(TimeValue t, INode* inode, ViewExp *vpt, int flagst, ModContext *mc);
        /*virtual*/ void GetWorldBoundBox(TimeValue t,INode* inode, ViewExp *vpt, Box3& box, ModContext *mc);

        // From Reference Maker
        // We only construct the mesh representing the limits whenever is necessary. We need to keep track of changes
        // in order to update the validity
#if MAX_VERSION_MAJOR>=17
        /*virtual*/ RefResult NotifyRefChanged( const Interval& changeInt, RefTargetHandle hTarget, PartID& partID,  RefMessage message, BOOL propagate );
#else
        /*virtual*/ RefResult NotifyRefChanged( Interval changeInt, RefTargetHandle hTarget, PartID& partID,  RefMessage message );
#endif


    private:

        // The limit disc mesh is per-instance since it depends on parameters
        Mesh m_limitDiscMesh;
        Interval m_limitDiscMeshValidity;
        void updateLimitDiscMesh(TimeValue t);

        // The axis mesh is static since it is reused by all hinges
        static Mesh m_hingeAxisMesh;
        static bool m_hingeAxisMeshSetup;
        void setupHingeAxisMesh();
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
