// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>
#include <ContentTools/Max/MaxSceneExport/Modifiers/Constraints/Hinge/hctHingeConstraintModifier.h>

// Mesh representing the rotation axis and the zero/perpendicular axis
/*static*/ Mesh hctHingeConstraintModifier::m_hingeAxisMesh;
/*static*/ bool hctHingeConstraintModifier::m_hingeAxisMeshSetup = false;

class hkHingeConstraintModifierDesc : public ClassDesc2
{
    public:
        int             IsPublic() { return TRUE; }
        void *          Create (BOOL loading = FALSE) { return new hctHingeConstraintModifier(this); }
        const MCHAR *   ClassName() { return GetString(IDS_HINGE_MODIFIER_CLASS_NAME); }
        SClass_ID       SuperClassID() { return OSM_CLASS_ID; }
        Class_ID        ClassID() { return HK_CONSTRAINT_HINGE_CLASS_ID; }
        const MCHAR*    Category() { return GetString(IDS_HAVOK_MODIFIERS_CATEGORY); }
        const MCHAR*    InternalName() { return _T("hkHingeConstraintModifier"); }
        HINSTANCE       HInstance() { return hInstance; }
};

ClassDesc2* getHkHingeConstraintModifierDesc()
{
    static hkHingeConstraintModifierDesc modifierDesc;
    return &modifierDesc;
}

class hkHingeConstraintDescriptor : public hctConstraintDescriptor
{
    public:

        // Return the Class Descriptor of the modifier implementing the constraint
        /*virtual*/ ClassDesc2* getClassDesc() const {return getHkHingeConstraintModifierDesc();}

        // Return the constraint name (name for the pblock)
        /*virtual*/ MCHAR* getConstraintName() const {return TEXT("hkHingeConstraint");}

        // Return a string ID for the Class Name
        /*virtual*/ int getClassNameStringID () const {return IDS_HINGE_MODIFIER_CLASS_NAME;}

        // Return a string ID for the Object NAme
        /*virtual*/ int getObjectNameStringID () const {return IDS_HINGE_MODIFIER_OBJECT_NAME;}

    public:

        // Constructor, sets up the paramblockdesc2
        hkHingeConstraintDescriptor(): hctConstraintDescriptor()
        {
            m_commonSpacesPBD = hctConstraintModifier::setupCommonSpacesPBD(this);

            hctConstraintModifier::addCommonFPInterface(this);
        }

};

static hkHingeConstraintDescriptor g_hingeConstraintDescriptor;

hctConstraintDescriptor* hctHingeConstraintModifier::getConstraintDescriptor()
{
    return &g_hingeConstraintDescriptor;
}

// Null class so order is as we want it
static ParamBlockDesc2 hkHinge_ParamBlockDesc
    ( PB_HINGE_MOD_PBLOCK, TEXT("hkHingeConstraintMerge"),  0, getHkHingeConstraintModifierDesc(), P_AUTO_CONSTRUCT + P_AUTO_UI, PB_HINGE_MOD_PBLOCK,

    // Rollout; we use the default combobox handler dlg proc to handle combobox changes
    IDD_HINGE_MODIFIER_ROLLOUT_PROPERTIES,
    IDS_HINGE_MODIFIER_ROLLOUT_PROPERTIES,
    0, 0, hctBasicModifier::getComboBoxHandlerDlgProc(),

    PA_HINGE_MOD_IS_LIMITED,
        _T("isLimited"), TYPE_BOOL, P_RESET_DEFAULT | P_ANIMATABLE, IDS_HINGE_MODIFIER_PA_IS_LIMITED,
        p_default,      FALSE,
        p_ui,           TYPE_SINGLECHEKBOX, IDC_CB_IS_LIMITED,
        p_enable_ctrls, 3,  PA_HINGE_MOD_LIMIT_MIN, PA_HINGE_MOD_LIMIT_MAX, PA_HINGE_MOD_MAX_FRICTION_TORQUE,
        p_end,
    PA_HINGE_MOD_LIMIT_MIN,
        _T("limitMin"), TYPE_ANGLE, P_RESET_DEFAULT | P_ANIMATABLE, IDS_HINGE_MODIFIER_PA_LIMIT_MIN,
        p_default,      -HALFPI,
        p_range,        -180.0f, 180.0f, // max is inconsistent here, range is specified in degrees, default in radians
        p_ui,           TYPE_SPINNER, EDITTYPE_FLOAT,
                        IDC_ED_LIMIT_MIN, IDC_SP_LIMIT_MIN,
                        SPIN_AUTOSCALE,
        p_end,
    PA_HINGE_MOD_LIMIT_MAX,
        _T("limitMax"), TYPE_ANGLE, P_RESET_DEFAULT | P_ANIMATABLE, IDS_HINGE_MODIFIER_PA_LIMIT_MAX,
        p_default,      HALFPI,
        p_range,        -180.0f, 180.0f, // max is inconsistent here, range is specified in degrees, default in radians
        p_ui,           TYPE_SPINNER, EDITTYPE_FLOAT,
                        IDC_ED_LIMIT_MAX, IDC_SP_LIMIT_MAX,
                        SPIN_AUTOSCALE,
        p_end,
    PA_HINGE_MOD_MAX_FRICTION_TORQUE,
        _T("maxFrictionTorque"), TYPE_FLOAT, P_RESET_DEFAULT | P_ANIMATABLE, IDS_HINGE_MODIFIER_PA_MAX_FRICTION_TORQUE,
        p_default,      0.0f,
        p_range,        0.0f, 1000000.0f,
        p_ui,           TYPE_SPINNER, EDITTYPE_FLOAT,
                        IDC_ED_MAX_FRICTION_TORQUE, IDC_SP_MAX_FRICTION_TORQUE,
                        SPIN_AUTOSCALE,
        p_end,

    PA_HINGE_MOD_MOTOR_TYPE,
        _T("motorType"), TYPE_INT, P_RESET_DEFAULT | P_ANIMATABLE, IDS_HINGE_MODIFIER_PA_MOTOR_TYPE,
        p_default,      HMT_NONE,
        p_end,
    p_end
    );


class HingeMotorTypeComboBoxDescriptor : public hctBasicModifier::ComboBoxDescriptor
{
    public:

        /*virtual*/ BlockID getParamBlockID() {return PB_HINGE_MOD_PBLOCK;}
        /*virtual*/ ParamID getParamID() {return PA_HINGE_MOD_MOTOR_TYPE;}
        /*virtual*/ MapID getParamMapID() {return 0;}
        /*virtual*/ int getControlID() {return IDC_COMBO_MOTOR_TYPE;}
        /*virtual*/ int getNumElements() {return 4;}
        /*virtual*/ const char* getElementString (int i)
        {
            static const char* m_elementStrings [] = {"None", "Position", "Velocity","Spring Damper"};
            return m_elementStrings[i];
        }

        /*virtual*/ const int getElementValue (int i) {return i;}
};

//Constructor/Destructor
hctHingeConstraintModifier::hctHingeConstraintModifier(ClassDesc2* theClassDesc)
: hctConstraintModifier(theClassDesc), m_limitDiscMeshValidity(NEVER)
{
    setupHingeAxisMesh();

}

hctHingeConstraintModifier::~hctHingeConstraintModifier()
{

}

hctBasicModifier::ComboBoxDescriptor* hctHingeConstraintModifier::getComboBoxDescriptor (int comboBoxID)
{
    static HingeMotorTypeComboBoxDescriptor motorTypeComboBox;

    return &motorTypeComboBox;
}

// Update UI - Enables some controls, etc
void hctHingeConstraintModifier::updateUI ()
{
    if (!m_interface) return;

    const TimeValue now = m_interface->GetTime();

    IParamBlock2* pblock2 = GetParamBlock(PB_HINGE_MOD_PBLOCK);
    IParamMap2* map2 = pblock2->GetMap();
    if (!map2) return;

    HWND dialogWnd = map2->GetHWnd();
    HWND cbWnd = GetDlgItem(dialogWnd, IDC_COMBO_MOTOR_TYPE);

    const BOOL isLimited = pblock2->GetInt(PA_HINGE_MOD_IS_LIMITED, now, 0);

    EnableWindow(cbWnd, isLimited);
}

int hctHingeConstraintModifier::Display(TimeValue t, INode* inode, ViewExp *vpt, int flagst, ModContext *mc)
{
    // Default display : two axis
    const float scale = getScaleDisplay(t, inode, vpt);
    const Point3 scaleV (scale,scale,scale);

    GraphicsWindow *gw=vpt->getGW();

    // Backup original limits
    const DWORD savedLimits=gw->getRndLimits();


    // Draw child axis
    {
        Matrix3 childSpaceTM; getSubobjectTransform(SOBJ_CONSTRAINT_MOD_CHILD_SPACE, t, inode, childSpaceTM);
        Matrix3 scaledTM = childSpaceTM;
        scaledTM.PreScale(scaleV, FALSE);
        gw->setTransform(scaledTM);

        Material childMaterialsArray[] = {m_childSpaceMaterial};

        gw->setRndLimits(GW_BACKCULL | (GW_LIGHTING) | GW_WIREFRAME);
        gw->setMaterial(m_childSpaceMaterial);
        m_hingeAxisMesh.render(gw, childMaterialsArray, NULL, COMP_ALL);

        gw->setRndLimits(GW_BACKCULL | (GW_LIGHTING) | GW_Z_BUFFER);
        gw->setMaterial(m_childSpaceMaterial);
        m_hingeAxisMesh.render(gw, childMaterialsArray, NULL, COMP_ALL);

    }

    // Draw parent space
    {
        Matrix3 parentSpaceTM; getSubobjectTransform(SOBJ_CONSTRAINT_MOD_PARENT_SPACE, t, inode, parentSpaceTM);

        Matrix3 scaledTM = parentSpaceTM;
        scaledTM.PreScale(scaleV, FALSE);
        gw->setTransform(scaledTM);

        // Draw axis
        {

            Material parentMaterialsArray[] = {m_parentSpaceMaterial};

            gw->setRndLimits(GW_BACKCULL | (GW_LIGHTING) | GW_WIREFRAME);
            gw->setMaterial(m_parentSpaceMaterial);
            m_hingeAxisMesh.render(gw, parentMaterialsArray, NULL, COMP_ALL);

            gw->setRndLimits(GW_BACKCULL | (GW_LIGHTING) | GW_FLAT | GW_Z_BUFFER);
            gw->setMaterial(m_parentSpaceMaterial);
            m_hingeAxisMesh.render(gw, parentMaterialsArray, NULL, COMP_ALL);
        }

        // Draw limits
        {
            updateLimitDiscMesh(t);

            Material limitsMaterialsArray[] = {m_limitsMaterial};

            // note : do not use GW_LIGHTING with wireframe and alpha
            gw->setRndLimits(GW_BACKCULL | GW_WIREFRAME);
            gw->setMaterial(m_limitsMaterial);
            m_limitDiscMesh.render(gw, limitsMaterialsArray, NULL, COMP_ALL);

            gw->setRndLimits(GW_BACKCULL | GW_LIGHTING | /*GW_Z_BUFFER |*/ GW_TRANSPARENCY | GW_TRANSPARENT_PASS );
            gw->setTransparency(GW_TRANSPARENCY | GW_TRANSPARENT_PASS);
            gw->setMaterial(m_limitsMaterial);
            m_limitDiscMesh.render(gw, limitsMaterialsArray, NULL, COMP_ALL);
            gw->setTransparency(0);

        }


    }

    // Restore original limits
    gw->setRndLimits(savedLimits);

    return 0;
}

void hctHingeConstraintModifier::GetWorldBoundBox(TimeValue t,INode* inode, ViewExp *vpt, Box3& box3, ModContext *mc)
{
    updateLimitDiscMesh(t);

    Box3 axisBoxLocal = m_hingeAxisMesh.getBoundingBox();
    Box3 limitsBoxLocal = m_limitDiscMesh.getBoundingBox();

    const float scale = getScaleDisplay(t, inode, vpt);
    const Point3 scaleV (scale,scale,scale);

    Matrix3 parentSpaceTM;
    getSubobjectTransform(SOBJ_CONSTRAINT_MOD_PARENT_SPACE, t, inode, parentSpaceTM);
    parentSpaceTM.PreScale(scaleV, FALSE);

    Matrix3 childSpaceTM;
    getSubobjectTransform(SOBJ_CONSTRAINT_MOD_CHILD_SPACE, t, inode, childSpaceTM);
    childSpaceTM.PreScale(scaleV, FALSE);

    Box3 parentBoxWorld = axisBoxLocal * parentSpaceTM;
    Box3 limitsBoxWorld = limitsBoxLocal* parentSpaceTM;
    Box3 childBoxWorld = axisBoxLocal * childSpaceTM;

    box3 = parentBoxWorld;
    box3 += limitsBoxWorld;
    box3 += childBoxWorld;
}

#if MAX_VERSION_MAJOR>=17
    RefResult hctHingeConstraintModifier::NotifyRefChanged( const Interval& changeInt, RefTargetHandle hTarget, PartID& partID,  RefMessage message, BOOL propagate )
#else
    RefResult hctHingeConstraintModifier::NotifyRefChanged( Interval changeInt, RefTargetHandle hTarget, PartID& partID, RefMessage message )
#endif
{
    // If there are changes to the hinge parameters, we invalidate the mesh
    IParamBlock2* pblock2 = GetParamBlock(PB_HINGE_MOD_PBLOCK);
    if ((message == REFMSG_CHANGE) && (hTarget == pblock2))
    {
        m_limitDiscMeshValidity = NEVER;
    }

    // Forward to parent class for further processing
    return hctConstraintModifier::NotifyRefChanged(changeInt, hTarget, partID, message);
}

// A disc representing the limits. Angles expressed in radians.
void hctHingeConstraintModifier::updateLimitDiscMesh (TimeValue t)
{
    // If no parameters changed, nothing to do
    if (m_limitDiscMeshValidity.InInterval(t))
    {
        return;
    }

    // Otherwise recalculate the mesh
    IParamBlock2* pblock2 = GetParamBlock(PB_HINGE_MOD_PBLOCK);

    m_limitDiscMeshValidity = FOREVER;
    pblock2->GetValidity(t, m_limitDiscMeshValidity);

    float limitMin, limitMax;
    {
        const bool isLimited = pblock2->GetInt(PA_HINGE_MOD_IS_LIMITED,t)!=FALSE;
        if (!isLimited)
        {
            limitMin = 0.0f;
            limitMax = TWOPI;
        }
        else
        {
            limitMin = pblock2->GetFloat(PA_HINGE_MOD_LIMIT_MIN,t);
            limitMax = pblock2->GetFloat(PA_HINGE_MOD_LIMIT_MAX,t);
        }
    }

    hctMaxUtils::createDiscMesh(Point3(0,0,1), Point3(1,0,0), 0.5f, 0.2f, limitMin, limitMax, 10, true, m_limitDiscMesh);
}

void hctHingeConstraintModifier::setupHingeAxisMesh()
{
    if (m_hingeAxisMeshSetup) return;

        // The axis has a length of 25.0 - Make it unit size
    const float vertexScale = 1.0f/25.0f;

    static float theVertices[] = {
          1.0000f,  0.0000f, -1.2181f ,   0.5000f,  0.8660f, -1.2181f ,  -0.5000f,  0.8660f, -1.2181f ,
         -1.0000f, -0.0000f, -1.2181f ,  -0.5000f, -0.8660f, -1.2181f ,   0.5000f, -0.8660f, -1.2181f ,
          0.5000f,  0.8660f, 11.8569f ,   1.0000f,  0.0000f, 11.8569f ,  -1.0000f,  0.0000f, 11.8569f ,
         -0.5000f,  0.8660f, 11.8569f ,   0.5000f, -0.8660f, 11.8569f ,  -0.5000f, -0.8660f, 11.8569f ,
          2.0000f,  0.0000f, 11.8569f ,   1.0000f,  1.7321f, 11.8569f ,  -1.0000f,  1.7321f, 11.8569f ,
         -2.0000f,  0.0000f, 11.8569f ,  -1.0000f, -1.7321f, 11.8569f ,   1.0000f, -1.7321f, 11.8569f ,
         -0.0000f,  0.0000f, 16.9134f ,   0.7128f,  0.4974f,  1.3690f ,   0.7128f,  0.4974f, -1.1810f ,
          0.7821f, -0.3775f, -1.1810f ,   0.7821f, -0.3775f,  1.3690f ,   1.0000f,  0.0000f, -1.1810f ,
          1.0000f,  0.0000f,  1.3690f ,  13.0038f,  0.4974f, -1.1810f ,  13.0038f,  0.4974f,  1.3690f ,
         13.0038f, -0.3775f, -1.1810f ,  13.0038f, -0.3775f,  1.3690f };

    m_hingeAxisMesh.setNumVerts(29);

    for (int v=0; v<29; v++)
    {
        m_hingeAxisMesh.setVert(v, vertexScale * Point3(theVertices[v*3], theVertices[v*3+1], theVertices[v*3+2]));
    }

    static int theFaces[] = {
          3,  8,  9, 1,1,0, 4,2 ,         9,  2,  3, 1,1,0, 4,2 ,         5, 10, 11, 1,1,0, 4,2 ,
         11,  4,  5, 1,1,0, 4,2 ,         4,  3,  2, 1,1,0, 1,1 ,         2,  1,  0, 1,1,0, 1,1 ,
          4,  2,  0, 0,0,0, 1,1 ,         5,  4,  0, 1,0,1, 1,1 ,         1,  2,  9, 1,1,0, 4,2 ,
          9,  6,  1, 1,1,0, 4,2 ,         3,  4, 11, 1,1,0, 4,2 ,        11,  8,  3, 1,1,0, 4,2 ,
         12, 13, 18, 1,1,1, 4,2 ,        13, 14, 18, 1,1,1, 4,2 ,        14, 15, 18, 1,1,1, 4,2 ,
         15, 16, 18, 1,1,1, 4,2 ,        16, 17, 18, 1,1,1, 4,2 ,        17, 12, 18, 1,1,1, 4,2 ,
          7,  6, 13, 1,1,0, 1,1 ,        13, 12,  7, 1,1,0, 1,1 ,         6,  9, 14, 1,1,0, 1,1 ,
         14, 13,  6, 1,1,0, 1,1 ,         9,  8, 15, 1,1,0, 1,1 ,        15, 14,  9, 1,1,0, 1,1 ,
          8, 11, 16, 1,1,0, 1,1 ,        16, 15,  8, 1,1,0, 1,1 ,         7, 12, 17, 1,1,0, 1,1 ,
         10,  7, 17, 1,0,0, 1,1 ,        11, 10, 17, 1,0,0, 1,1 ,        11, 17, 16, 0,1,1, 1,1 ,
         22, 24,  7, 1,1,0, 4,2 ,        22,  7, 10, 0,1,0, 4,2 ,        22, 10,  5, 0,1,0, 4,2 ,
         21, 22,  5, 1,0,0, 4,2 ,        21,  5,  0, 0,1,0, 4,2 ,        21,  0, 23, 0,1,1, 4,2 ,
         20, 23,  0, 1,1,0, 4,2 ,        20,  0,  1, 0,1,0, 4,2 ,        19, 20,  1, 1,0,0, 4,2 ,
         19,  1,  6, 0,1,0, 4,2 ,        19,  6,  7, 0,1,0, 4,2 ,        19,  7, 24, 0,1,1, 4,2 ,
         26, 25, 20, 1,1,0, 2,1 ,        20, 19, 26, 1,1,0, 2,1 ,        27, 28, 22, 1,1,0, 3,0 ,
         22, 21, 27, 1,1,0, 3,0 ,        25, 26, 28, 1,1,0, 5,3 ,        28, 27, 25, 1,1,0, 5,3 ,
         26, 19, 24, 1,1,0, 6,5 ,        24, 22, 28, 1,1,0, 6,5 ,        26, 24, 28, 0,0,1, 6,5 ,
         27, 21, 23, 1,1,0, 1,4 ,        25, 27, 23, 1,0,0, 1,4 ,        20, 25, 23, 1,0,1, 1,4 };

    m_hingeAxisMesh.setNumFaces(54);

    for (int f=0; f<54; f++)
    {
        m_hingeAxisMesh.faces[f].setVerts(theFaces[f*8], theFaces[f*8+1], theFaces[f*8+2]);
        m_hingeAxisMesh.faces[f].setEdgeVisFlags(theFaces[f*8+3], theFaces[f*8+4], theFaces[f*8+5]);
        m_hingeAxisMesh.faces[f].setSmGroup(theFaces[f*8+6]);
        m_hingeAxisMesh.faces[f].setMatID((MtlID)theFaces[f*8+7]);
    }

    m_hingeAxisMesh.buildNormals();
    m_hingeAxisMesh.BuildStripsAndEdges();

    m_hingeAxisMeshSetup = true;

}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
