// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>
#include <ContentTools/Max/MaxSceneExport/Modifiers/Constraints/Fixed/hctFixedConstraintModifier.h>

class hkFixedConstraintModifierDesc : public ClassDesc2
{
    public:
        int             IsPublic() { return TRUE; }
        void *          Create (BOOL loading = FALSE) { return new hctFixedConstraintModifier(this); }
        const MCHAR *   ClassName() { return GetString(IDS_FIXED_MODIFIER_CLASS_NAME); }
        SClass_ID       SuperClassID() { return OSM_CLASS_ID; }
        Class_ID        ClassID() { return HK_CONSTRAINT_FIXED_CLASS_ID; }
        const MCHAR*    Category() { return GetString(IDS_HAVOK_MODIFIERS_CATEGORY); }
        const MCHAR*    InternalName() { return _T("hkFixedConstraintModifier"); }
        HINSTANCE       HInstance() { return hInstance; }
};

ClassDesc2* getHkFixedConstraintModifierDesc()
{
    static hkFixedConstraintModifierDesc modifierDesc;
    return &modifierDesc;
}

class hkFixedConstraintDescriptor : public hctConstraintDescriptor
{
    public:

        // Return the Class Descriptor of the modifier implementing the constraint
        /*virtual*/ ClassDesc2* getClassDesc() const {return getHkFixedConstraintModifierDesc();}

        // Return the constraint name (name for the pblock)
        /*virtual*/ MCHAR* getConstraintName() const {return TEXT("hkFixedConstraint");}

        // Return a string ID for the Class Name
        /*virtual*/ int getClassNameStringID () const {return IDS_FIXED_MODIFIER_CLASS_NAME;}

        // Return a string ID for the Object NAme
        /*virtual*/ int getObjectNameStringID () const {return IDS_FIXED_MODIFIER_OBJECT_NAME;}

    public:

        // Constructor, sets up the paramblockdesc2
        hkFixedConstraintDescriptor(): hctConstraintDescriptor()
        {
            m_commonSpacesPBD = hctConstraintModifier::setupCommonSpacesPBD(this);

            hctConstraintModifier::addCommonFPInterface(this);
        }

};

static hkFixedConstraintDescriptor g_fixedConstraintDescriptor;

hctConstraintDescriptor* hctFixedConstraintModifier::getConstraintDescriptor()
{
    return &g_fixedConstraintDescriptor;
}

// Null class so order is as we want it
static ParamBlockDesc2 hkFixed_ParamBlockDesc
    ( PB_FIXED_MOD_PBLOCK, TEXT("hkFixedConstraintMerge"),  0, getHkFixedConstraintModifierDesc(), P_AUTO_CONSTRUCT + P_AUTO_UI, PB_FIXED_MOD_PBLOCK,

    // Rollout; we use the default combobox handler dlg proc to handle combobox changes
    IDD_FIXED_MODIFIER_ROLLOUT_PROPERTIES,
    IDS_FIXED_MODIFIER_ROLLOUT_PROPERTIES,
    0, 0, NULL,

    PA_FIXED_MOD_MAX_LIN_IMPULSE,
        _T("maxLinearImpulse"), TYPE_FLOAT, P_RESET_DEFAULT | P_ANIMATABLE, IDS_FIXED_MODIFIER_PA_MAX_LIN_IMPULSE,
        p_default,      0.0f,
        p_range,        0.0f, 1000000.0f,
        p_ui,           TYPE_SPINNER, EDITTYPE_FLOAT,
                        IDC_ED_MAX_LIN_IMPULSE, IDC_SP_MAX_LIN_IMPULSE,
                        SPIN_AUTOSCALE,
        p_end,
    PA_FIXED_MOD_MAX_ANG_IMPULSE,
        _T("maxAngularImpulse"), TYPE_FLOAT, P_RESET_DEFAULT | P_ANIMATABLE, IDS_FIXED_MODIFIER_PA_MAX_ANG_IMPULSE,
        p_default,      0.0f,
        p_range,        0.0f, 1000000.0f,
        p_ui,           TYPE_SPINNER, EDITTYPE_FLOAT,
        IDC_ED_MAX_ANG_IMPULSE, IDC_SP_MAX_ANG_IMPULSE,
        SPIN_AUTOSCALE,
        p_end,
    p_end
    );

//
//  Constructor

hctFixedConstraintModifier::hctFixedConstraintModifier(ClassDesc2* theClassDesc)
:   hctConstraintModifier(theClassDesc)
{}

//
//  Destructor

hctFixedConstraintModifier::~hctFixedConstraintModifier()
{}

//
//  Display

int hctFixedConstraintModifier::Display(TimeValue t, INode* inode, ViewExp *vpt, int flags, ModContext *mc)
{
    // We want the same display done by the XTC object - rather than duplicating the code, create a temporary instance and use it
    ConstraintSpaceData data;
    getConstraintSpaceData(t, inode, data);

    hctConstraintXTCObject xtcObject(data);
    xtcObject.Display(t, inode, vpt, flags, NULL);

    return 0;
}

//
//  Bounding box

void hctFixedConstraintModifier::GetWorldBoundBox(TimeValue t,INode* inode, ViewExp *vpt, Box3& box3, ModContext *mc)
{
    Matrix3 parentSpaceTM;
    getSpaceInWorld(SOBJ_CONSTRAINT_MOD_PARENT_SPACE, t, inode, parentSpaceTM);

    Matrix3 childSpaceTM;
    getSpaceInWorld(SOBJ_CONSTRAINT_MOD_CHILD_SPACE, t, inode, childSpaceTM);

    box3.Init();
    box3 += parentSpaceTM.GetTrans();
    box3 += childSpaceTM.GetTrans();
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
