// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>
#include <ContentTools/Max/MaxSceneExport/Modifiers/Constraints/BallAndSocket/hctBallAndSocketConstraintModifier.h>

class hkBallAndSocketConstraintModifierDesc : public ClassDesc2
{
    public:
        int             IsPublic() { return TRUE; }
        void *          Create (BOOL loading = FALSE) { return new hctBallAndSocketConstraintModifier(this); }
        const MCHAR *   ClassName() { return GetString(IDS_BALL_AND_SOCKET_MODIFIER_CLASS_NAME); }
        SClass_ID       SuperClassID() { return OSM_CLASS_ID; }
        Class_ID        ClassID() { return HK_CONSTRAINT_BALL_AND_SOCKET_CLASS_ID; }
        const MCHAR*    Category() { return GetString(IDS_HAVOK_MODIFIERS_CATEGORY); }
        const MCHAR*    InternalName() { return _T("hkBallAndSocketConstraintModifier");; }
        HINSTANCE       HInstance() { return hInstance; }
};

ClassDesc2* getHkBallAndSocketConstraintModifierDesc()
{
    static hkBallAndSocketConstraintModifierDesc modifierDesc;
    return &modifierDesc;
}

class hkBallAndSocketConstraintDescriptor : public hctConstraintDescriptor
{
    public:

        // Return the Class Descriptor of the modifier implementing the constraint
        /*virtual*/ ClassDesc2* getClassDesc() const {return getHkBallAndSocketConstraintModifierDesc();}

        // Return the constraint name (name for the pblock)
        /*virtual*/ MCHAR* getConstraintName() const {return TEXT("hkBallAndSocketConstraint");}

        // Return a string ID for the Class Name
        /*virtual*/ int getClassNameStringID () const {return IDS_BALL_AND_SOCKET_MODIFIER_CLASS_NAME;}

        // Return a string ID for the Object NAme
        /*virtual*/ int getObjectNameStringID () const {return IDS_BALL_AND_SOCKET_MODIFIER_OBJECT_NAME;}

        // We want to ignore rotations
        /*virtual*/ bool ignoreRotations() const {return true;}

    public:

        // Constructor, sets up the paramblockdesc2
        hkBallAndSocketConstraintDescriptor(): hctConstraintDescriptor()
        {
            m_commonSpacesPBD = hctConstraintModifier::setupCommonSpacesPBD(this);

            hctConstraintModifier::addCommonFPInterface(this);
        }
};

static hkBallAndSocketConstraintDescriptor g_ballAndSocketConstraintDescriptor;

hctConstraintDescriptor* hctBallAndSocketConstraintModifier::getConstraintDescriptor()
{
    return &g_ballAndSocketConstraintDescriptor;
}

//Constructor/Destructor
hctBallAndSocketConstraintModifier::hctBallAndSocketConstraintModifier(ClassDesc2* theClassDesc)
: hctConstraintModifier(theClassDesc)
{

}

hctBallAndSocketConstraintModifier::~hctBallAndSocketConstraintModifier()
{

}

int hctBallAndSocketConstraintModifier::Display(TimeValue t, INode* inode, ViewExp *vpt, int flags, ModContext *mc)
{
    // We want the same display done by the XTC object - rather than duplicating the code, create a temporary instance and use it
    ConstraintSpaceData data;
    getConstraintSpaceData(t, inode, data);

    hctConstraintXTCObject xtcObject(data);
    xtcObject.Display(t, inode, vpt, flags, NULL);

    return 0;

}

void hctBallAndSocketConstraintModifier::GetWorldBoundBox(TimeValue t,INode* inode, ViewExp *vpt, Box3& box3, ModContext *mc)
{
    Matrix3 parentSpaceTM;
    getSpaceInWorld(SOBJ_CONSTRAINT_MOD_PARENT_SPACE, t, inode, parentSpaceTM);

    Matrix3 childSpaceTM;
    getSpaceInWorld(SOBJ_CONSTRAINT_MOD_CHILD_SPACE, t, inode, childSpaceTM);

    box3.Init();
    box3 += parentSpaceTM.GetTrans();
    box3 += childSpaceTM.GetTrans();
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
