// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>
#include <ContentTools/Max/MaxSceneExport/Modifiers/ClothCollidable/hctClothCollidableModifier.h>

class hkClothCollidableModifierDesc : public ClassDesc2
{
    public:
        int             IsPublic() { return TRUE; }
        void *          Create (BOOL loading = FALSE) { return new hctClothCollidableModifier(this); };
        const MCHAR *   ClassName() { return GetString(IDS_CLOTH_COLLIDABLE_MODIFIER_CLASS_NAME); }
        SClass_ID       SuperClassID() { return OSM_CLASS_ID; }
        Class_ID        ClassID() { return HK_CLOTH_COLLIDABLE_MODIFIER_CLASS_ID; }
        const MCHAR*    Category() { return GetString(IDS_HAVOK_MODIFIERS_CATEGORY); }
        const MCHAR*    InternalName() { return TEXT("hkClothCollidableModifier"); }
        HINSTANCE       HInstance() { return hInstance; }
};

ClassDesc2* getHkClothCollidableModifierDesc()
{
    static hkClothCollidableModifierDesc clothCollidableModifierDesc;
    return &clothCollidableModifierDesc;
}

hctClothCollidableXTCObject::hctClothCollidableXTCObject()
{
    m_labelColor = GetColorManager()->GetColorAsPoint3( HK_COLOR_CLOTH );
}

static ParamBlockDesc2 hkClothCollidable_ParamBlockDesc (
    PB_CLOTH_COLLIDABLE_MOD_PBLOCK, _T("hkClothCollidable"),  0, getHkClothCollidableModifierDesc(),
    P_AUTO_CONSTRUCT + P_AUTO_UI, PB_CLOTH_COLLIDABLE_MOD_PBLOCK,

    // Rollout
    // We use the default dlg proc that handles combo boxes, defined in hctBasicModifier
    IDD_CLOTH_COLLIDABLE_MODIFIER_ROLLOUT_PROPERTIES,
    IDS_CLOTH_COLLIDABLE_MODIFIER_ROLLOUT_PROPERTIES,
    0, 0, hctBasicModifier::getComboBoxHandlerDlgProc(),

    // GENERAL PROPERTIES PARAMETERS

    // Shape Type
    PA_CLOTH_COLLIDABLE_MOD_SHAPE_TYPE,
    _T("collidableShapeType"), TYPE_INT, P_ANIMATABLE | P_RESET_DEFAULT, IDS_CLOTH_COLLIDABLE_MODIFIER_PA_SHAPE_TYPE,
    p_default,      CT_SPHERE,
    p_range,        0, 4,
    p_end,

    PA_CLOTH_COLLIDABLE_MOD_RESOLUTION,
    _T("heightfieldResolution"), TYPE_INT, P_ANIMATABLE | P_RESET_DEFAULT, IDS_CLOTH_COLLIDABLE_MODIFIER_PA_RESOLUTION,
    p_default,      32,
    p_range,        16, 1024,
    p_ui,   TYPE_SPINNER, EDITTYPE_INT, IDC_ED_RESOLUTION, IDC_SP_RESOLUTION, SPIN_AUTOSCALE,
    p_end,

    p_end
    );

class ClothCollidableShapeTypeComboBoxDescriptor : public hctBasicModifier::ComboBoxDescriptor
{
public:

    /*virtual*/ BlockID getParamBlockID() { return PB_CLOTH_COLLIDABLE_MOD_PBLOCK; }
    /*virtual*/ ParamID getParamID() { return PA_CLOTH_COLLIDABLE_MOD_SHAPE_TYPE; }
    /*virtual*/ MapID getParamMapID() { return 0; }
    /*virtual*/ int getControlID() { return IDC_COMBO_CLOTH_COLLIDABLE_SHAPE_TYPE; }
    /*virtual*/ int getNumElements() { return 5; }
    /*virtual*/ const char* getElementString (int i)
    {
        static const char* m_elementStrings [] = {"Sphere", "Plane", "Capsule", "Convex Geometry",
                                                    "Convex Heightfield"};
        return m_elementStrings[i];
    }

    /*virtual*/ const int getElementValue (int i) { return i; }
};

hctClothCollidableModifier::hctClothCollidableModifier(ClassDesc2* theClassDesc)
: hctBasicModifier(theClassDesc)
{
}

hctClothCollidableModifier::~hctClothCollidableModifier()
{
}

hctBasicModifier::ComboBoxDescriptor* hctClothCollidableModifier::getComboBoxDescriptor (int comboBoxID)
{
    static ClothCollidableShapeTypeComboBoxDescriptor clothCollidableTypeComboBox;

    return &clothCollidableTypeComboBox;
}

void hctClothCollidableModifier::updateUI ()
{
    if ( !m_interface ) return;

    IParamBlock2* pblock = GetParamBlock (PB_CLOTH_COLLIDABLE_MOD_PBLOCK);
    HWND dlgWnd = pblock->GetMap()->GetHWnd();

    const int shapeType = pblock->GetInt(PA_CLOTH_COLLIDABLE_MOD_SHAPE_TYPE);

    const BOOL hasResolution = (shapeType==CT_CONVEX_HEIGHTFIELD);

    const HWND resLabWnd = GetDlgItem (dlgWnd, IDC_LAB_RESOLUTION);
    EnableWindow(resLabWnd, hasResolution);

    {
        ICustEdit* ed = GetICustEdit (GetDlgItem(dlgWnd, IDC_ED_RESOLUTION));
        ed->Enable(hasResolution);
        ReleaseICustEdit(ed);
    }

    {
        ISpinnerControl* sp = GetISpinner(GetDlgItem(dlgWnd, IDC_SP_RESOLUTION));
        sp->Enable(hasResolution);
        ReleaseISpinner(sp);
    }
}


hctBasicXTCObject* hctClothCollidableModifier::getXTCObject (int number, TimeValue t, ModContext &mc, ObjectState * os, INode *node)
{
    return new hctClothCollidableXTCObject();
}


/*
** EXTENSION CHANNEL OBJECT
*/

int hctClothCollidableXTCObject::Display (TimeValue t, INode* inode, ViewExp *vpt, int flags, Object *pObj)
{
    GraphicsWindow *gw=vpt->getGW();
    const DWORD savedLimits=gw->getRndLimits();

    // Write the text in the middle of the bounding box
    Box3 box3;
    pObj->GetDeformBBox(t, box3);
    Point3 centerWorld = box3.Center() * inode->GetObjectTM(t);;

    Matrix3 tm(1); tm.SetTrans(centerWorld);

    gw->setTransform(tm);
    gw->setRndLimits(GW_WIREFRAME|GW_BACKCULL);

    MCHAR* rbText = TEXT("CC");

    Point3 p(0,0,0);
    IPoint3 markerPos;
    const bool notClipped = ( gw->wTransPoint(&p, &markerPos) == 0);
    if (notClipped)  // EXP-565
    {
        gw->wMarker(&markerPos, X_MRKR);

        // Try to center text
        markerPos.x-= 7;
        markerPos.y+= 10;
        // Display it twice, first black then yellow
        markerPos.x++;
        markerPos.y++;
        gw->setColor( TEXT_COLOR, m_labelColor );
        gw->wText(&markerPos, rbText);
        markerPos.x--;
        markerPos.y--;
        gw->setColor( TEXT_COLOR, m_labelColor );
        gw->wText(&markerPos, rbText);
    }

    gw->setRndLimits(savedLimits);

    return 1;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
