// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
#pragma once


#include <ContentTools/Common/SceneExport/Error/hctSceneExportError.h>

#include <ContentTools/Common/SceneExport/Importer/MeshImport/hctModelerMeshBuilder.h>


/// The 3dsMax-specific implementation of the abstract modeler mesh builder interface.
class hctMaxMeshBuilder : public hctModelerMeshBuilder
{
    public:

        hctMaxMeshBuilder(INode* maxNode, MNMesh& maxMesh, const char* meshName, hkMatrix4& transform, hkArray<int>& mapChannelsInUse, INode* parentMaxNode);

        /// This function needs to be called before the respective material can be assigned to a triangle.
        void                registerMaterial(Mtl* modelerMaterial);

        //
        // Implementation of hctModelerMeshBuilder interface.
        //

        virtual VertexId    addMeshVertexDelayed(const hkVector4& position);
        virtual int         addMeshTriangleDelayed(VertexId triangleVertex0, VertexId triangleVertex1, VertexId triangleVertex2);
        virtual void        realizeDelayedMesh();

        virtual void        selectColorChannel(int channel);

        virtual ColorId     addVertexColorImmediate(float r, float g, float b);
        virtual ColorId     addVertexColorDelayed  (float r, float g, float b);
        virtual void        realizeDelayedVertexColors();

        virtual int         addVertexColorTriangleImmediate(int triangleIndex, ColorId triangleVertex0, ColorId triangleVertex1, ColorId triangleVertex2);
        virtual int         addVertexColorTriangleDelayed                     (ColorId triangleVertex0, ColorId triangleVertex1, ColorId triangleVertex2);
        virtual void        realizeDelayedVertexColorTriangles();

        virtual void        selectUvChannel(int channel);

        virtual UvId        addVertexUvImmediate(float u, float v);
        virtual UvId        addVertexUvDelayed  (float u, float v);
        virtual void        realizeDelayedVertexUvs();

        virtual int         addVertexUvTriangleImmediate(int triangleIndex, UvId triangleVertex0, UvId triangleVertex1, UvId triangleVertex2);
        virtual int         addVertexUvTriangleDelayed                     (UvId triangleVertex0, UvId triangleVertex1, UvId triangleVertex2);
        virtual void        realizeDelayedVertexUvTriangles();

        virtual NormalId    addNormalDelayed(const hkVector4& normal);
        virtual int         addNormalTriangleDelayed(NormalId triangleVertex0, NormalId triangleVertex1, NormalId triangleVertex2);
        virtual void        realizeDelayedNormals();

        virtual void        setTriangleMaterialImmediate(int triangleIndex, const char* materialName);
        virtual void        setTriangleMaterialDelayed  (int triangleIndex, const char* materialName);
        virtual void        realizeDelayedTriangleMaterials();

    protected:

        struct TriangleData
        {
            int m_positionIndex0;
            int m_positionIndex1;
            int m_positionIndex2;
        };

    protected:

        virtual int mapVirtualToActualUvChannel(int virtualChannelId);

    protected:

        MNMesh&                 m_maxMesh;
        hkArray<hkVector4>      m_vertices;
        hkArray<TriangleData>   m_triangles;
        int                     m_colorChannel;
        int                     m_uvChannel;
        hkArray<int>&           m_mapChannelsInUse;
        hkArray<hkVector4>      m_normals;
        hkArray<int>            m_normalTriangleIndices;
        Mtl*                    m_modelerMaterial;
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
