// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

// Base class for havok helpers, handles basic stuff like parameter blocks and references
class hctBasicHelper : public HelperObject
{
    public:

        // Constructor
        hctBasicHelper (ClassDesc2* theClassDesc);

        // Destructor
        virtual ~hctBasicHelper();

        // Implement it with any code that updates the state of controls, etc..
        virtual void updateUI() {}

        //
        // Overrides from max sdk calls - so classes inheriting from this one no need to care about them
        //

        // From Object
        /*virtual*/ ObjectState Eval(TimeValue time);

        // We don't convert to anything
        /*virtual*/ int CanConvertToType(Class_ID obtype) {return FALSE;}
        /*virtual*/ Object* ConvertToType(TimeValue t, Class_ID obtype) { return NULL; }

        // Does basic setup. Needs to be called by inheriting plugins.
        /*virtual*/ void BeginEditParams(IObjParam *ip, ULONG flags,Animatable *prev);
        /*virtual*/ void EndEditParams(IObjParam *ip, ULONG flags,Animatable *next);

        // Reference maker
        /*virtual*/ RefTargetHandle Clone( RemapDir &remap );
        /*virtual*/ void BaseClone(ReferenceTarget* from, ReferenceTarget* to, RemapDir& remap);

        /*virtual*/ int NumRefs();
        /*virtual*/ RefTargetHandle GetReference(int i);
        /*virtual*/ void SetReference(int i, RefTargetHandle rtarg);
#if MAX_VERSION_MAJOR>=17
        /*virtual*/ RefResult NotifyRefChanged( const Interval& changeInt, RefTargetHandle hTarget, PartID& partID,  RefMessage message, BOOL propagate );
#else
        /*virtual*/ RefResult NotifyRefChanged( Interval changeInt, RefTargetHandle hTarget, PartID& partID,  RefMessage message );
#endif

        /*virtual*/ int NumParamBlocks() { return m_pblocks.Count(); }  // return number of ParamBlocks in this instance
        /*virtual*/ IParamBlock2* GetParamBlock(int i) { if (i < m_pblocks.Count()) { return m_pblocks[i]; } else { return NULL; } } // return i'th ParamBlock
        /*virtual*/ IParamBlock2* GetParamBlockByID(BlockID id);

        // From Animatable
        /*virtual*/ int NumSubs() {return m_pblocks.Count();}
        /*virtual*/ Animatable* SubAnim(int i) {return GetParamBlock(i);}
        /*virtual*/ MSTR SubAnimName(int i) {return GetParamBlock(i)->GetLocalName();}
        /*virtual*/ int SubNumToRefNum(int subNum) {return subNum;}

        /*virtual*/ void DeleteThis() { delete this; }

        /*
        ** Force Notify Accesor : Enforces the reevaluation of helpers after a parameter change.
        ** Useful for class parameters. Add a pb_accessor clause pointing to a static instance (one for each helper class).
        */
        class ForceNotifyPBAccessor: public PBAccessor
        {
            public:

                // Called automatically by the paramblock.
                void Set(PB2Value& v, ReferenceMaker* owner, ParamID id, int tabIndex, TimeValue t);

                // Call this on construction of each helper
                void addHelper(hctBasicHelper* helper);

                // Call this on destruction of each helper
                void removeHelper(hctBasicHelper* helper);

            private:

                Tab<ReferenceMaker*> m_helpers;
        };

    public:

        // Access to the interface
        static IObjParam* m_interface;

    private:

        // Our parameter blocks
        Tab<IParamBlock2*> m_pblocks;

        // The class descriptor
        ClassDesc2* m_classDesc;

};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
