// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>
#include <ContentTools/Max/MaxSceneExport/Helpers/hctBasicHelper.h>

IObjParam*  hctBasicHelper::m_interface = NULL;

hctBasicHelper::hctBasicHelper(ClassDesc2* theClassDesc)
:  m_classDesc(theClassDesc)
{
    theClassDesc->MakeAutoParamBlocks(this);
}

hctBasicHelper::~hctBasicHelper()
{

}

int hctBasicHelper::NumRefs()
{
    return m_pblocks.Count();
}

IParamBlock2* hctBasicHelper::GetParamBlockByID(BlockID id)
{
    for (int i=0; i < m_pblocks.Count(); ++i)
    {
        if (m_pblocks[i] && m_pblocks[i]->ID() == id)
        {
            return m_pblocks[i];
        }
    }
    return NULL;
}

void hctBasicHelper::SetReference(int i, RefTargetHandle rtarg)
{
    const int c = m_pblocks.Count();
    if ( c <= i )
    {
        m_pblocks.SetCount(i+1);
        for (int j=c; j < i; ++j)
        {
            m_pblocks[j] = NULL;
        }
    }
    m_pblocks[i] = (IParamBlock2*)rtarg;
}

RefTargetHandle hctBasicHelper::GetReference(int i)
{
    if (i>=0 && i<m_pblocks.Count())
    {
        return m_pblocks[i];
    }
    else
    {
        return NULL;
    }
}

RefTargetHandle hctBasicHelper::Clone( RemapDir &remap )
{
    hctBasicHelper* newhelper = (hctBasicHelper*) m_classDesc->Create(FALSE);

    BaseClone(this, newhelper, remap);

    return(newhelper);

}

void hctBasicHelper::BaseClone(ReferenceTarget* from, ReferenceTarget* to, RemapDir& remap)
{
    for (int b=0; b < m_pblocks.Count(); ++b)
    {
        to->ReplaceReference(b, m_pblocks[b]->Clone(remap));
    }

    HelperObject::BaseClone(from, to, remap);
}

ObjectState hctBasicHelper::Eval(TimeValue time)
{
    return ObjectState(this);
}

void hctBasicHelper::BeginEditParams( IObjParam *ip, ULONG flags,Animatable *prev )
{
    this->m_interface = ip;

    TimeValue t = ip->GetTime();
    NotifyDependents(Interval(t,t), PART_ALL, REFMSG_BEGIN_EDIT);

    m_classDesc->BeginEditParams(ip, this, flags, prev);
    HelperObject::BeginEditParams(ip, flags, prev);

    /* Update the state of controls */
    updateUI();

}

void hctBasicHelper::EndEditParams( IObjParam *ip, ULONG flags,Animatable *next)
{
    HelperObject::EndEditParams(ip,flags,next);
    m_classDesc->EndEditParams(ip, this, flags, next);

    TimeValue t = ip->GetTime();
    NotifyDependents(Interval(t,t), PART_ALL, REFMSG_END_EDIT);

    this->m_interface = NULL;

}

#if MAX_VERSION_MAJOR>=17
    RefResult hctBasicHelper::NotifyRefChanged( const Interval& changeInt, RefTargetHandle hTarget, PartID& partID,  RefMessage message, BOOL propagate )
#else
    RefResult hctBasicHelper::NotifyRefChanged( Interval changeInt, RefTargetHandle hTarget, PartID& partID, RefMessage message )
#endif
{
    //TODO: Add code to handle the various reference changed messages
    switch (message)
    {
    case REFMSG_CHANGE:
        {
            if (m_interface && hTarget)
            {
                // see if we know of the target
                for (int i=0; i < m_pblocks.Count(); ++i)
                {
                    if (m_pblocks[i] == hTarget)
                    {
                        m_pblocks[i]->GetDesc()->InvalidateUI(m_pblocks[i]->LastNotifyParamID());

                        break; // for loop
                    }
                }

                // Update the state of controls
                updateUI();
            }
            break;
        }
    }

    return REF_SUCCEED;
}

/*
** FORCE NOTIFY ACCESOR
*/

void hctBasicHelper::ForceNotifyPBAccessor::Set(PB2Value& v, ReferenceMaker* owner, ParamID id, int tabIndex, TimeValue t)
{
    for (int i=0; i<m_helpers.Count(); ++i)
    {
        (reinterpret_cast<hctBasicHelper*> (m_helpers[i]))->ForceNotify(Interval(t,t));
    }
}

void hctBasicHelper::ForceNotifyPBAccessor::addHelper(hctBasicHelper* helper)
{
    ReferenceMaker* refmaker = helper;
    m_helpers.Append(1,&refmaker);
}

void hctBasicHelper::ForceNotifyPBAccessor::removeHelper(hctBasicHelper* helper)
{
    for (int i=m_helpers.Count()-1; i>=0; i--)
    {
        if (m_helpers[i]==helper)
        {
            m_helpers.Delete(i,1);
        }
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
