// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>
#include <ContentTools/Max/MaxSceneExport/GUP/Viewport/hctMaxViewWindow.h>

#define HAVOK_MAX_VIEWPORT_CLASS_ID Class_ID(0xf567349, 0x231d238d)

class hctMaxViewportClassDesc : public ClassDesc2
{
public:
    int             IsPublic() {return 1;}
    void *          Create(BOOL loading = FALSE) { return new hctMaxViewport(); }
    const MCHAR *   ClassName() {return GetString(IDS_CLASS_NAME);}
    SClass_ID       SuperClassID() {return GUP_CLASS_ID;}
    Class_ID        ClassID() {return HAVOK_MAX_VIEWPORT_CLASS_ID;}
    const MCHAR*    Category() {return GetString(IDS_CATEGORY);}
    const MCHAR*    InternalName() { return _T("hctMaxViewport"); } // returns fixed parsable name (scripter-visible name)
    HINSTANCE       HInstance() { return hInstance; }               // returns owning module handle
};

static hctMaxViewportClassDesc hctMaxViewportDesc;
ClassDesc2* GetHctMaxViewportDesc() {return &hctMaxViewportDesc;}

hctMaxViewport::hctMaxViewport()
: m_viewWindow(NULL)
{

}


hctMaxViewport::~hctMaxViewport()
{
    Stop();
}

DWORD hctMaxViewport::Start( )
{
    if (!m_viewWindow)
    {
        m_viewWindow = new hctMaxViewWindow();
    }

    m_viewWindow->SetUtility( this );
    Max()->RegisterViewWindow( m_viewWindow );

    return GUPRESULT_KEEP;
}

void hctMaxViewport::Stop( )
{
    if (m_viewWindow)
    {
        Max()->UnRegisterViewWindow( m_viewWindow );

        delete m_viewWindow;
        m_viewWindow = NULL;
    }
}

DWORD_PTR hctMaxViewport::Control( DWORD parameter )
{
    return 0;
}

IOResult hctMaxViewport::Save(ISave *isave)
{
    return IO_OK;
}

IOResult hctMaxViewport::Load(ILoad *iload)
{
    return IO_OK;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
