// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0


#pragma once

#include <ContentTools/Max/MaxSceneExport/gup/Viewport/hctMaxViewport.h>

#define HK_MAX_VIEW_WINDOW_CLASS_ID Class_ID(0x40ae2347, 0x37e7fe57)

class hctMaxViewWindow : public ViewWindow
{

   public:

      hctMaxViewWindow();
      ~hctMaxViewWindow();

      CONST15 MCHAR* GetName() { return _T("Havok Preview"); }

      HWND CreateViewWindow(HWND hParent, int x, int y, int w, int h);
      void DestroyViewWindow(HWND hWnd);
      BOOL CanCreate();

      bool IsActive();
      void ResetNode();
      void Redraw();

      // Refresh the content in the View:
      void UpdateScene();
      void Restart();

      void Resize(int w, int h);

      void SetUtility( hctMaxViewport* util);

      void setupContextMenu(HWND hWnd );
      void showContextMenu(HWND hWnd, int x, int y );

      static LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

#if MAX_VERSION_MAJOR >= 15
      virtual Class_ID ClassID() const
      {
          return HK_MAX_VIEW_WINDOW_CLASS_ID;
      }

      virtual ViewWindowMetaData GetMetaData()
      {
          return ViewWindowMetaData(ViewWindowMetaData::SINGLETON);
      }
#endif

   private:

      void loadViewportDLL();
      void unloadViewportDLL();

      // Parent Utility Access
      hctMaxViewport *m_utility;

      bool m_active;
      HWND m_hWnd;
      HWND m_hIntermediateParent;
      HMENU m_contextMenu;
      HMODULE m_viewportDll;
      class hctBaseDll* m_viewportBase;
      class hctViewportUtils* m_viewportUtils;

};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
