// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Max/MaxSceneExport/GUP/Toolbar/hctToolbarGUP.h>
#include <ContentTools/Max/MaxFpInterfaces/Toolbar/hctToolbarGUPInterface.h>

#if MAX_VERSION_MAJOR >= 20
namespace MaxSDK
{
    class QmaxToolBar;
    class QmaxDockingWinHost;
}
#endif

// Access to the class descriptor
extern ClassDesc2* getHkToolbarGUPDesc();
extern ClassDesc2* getHkdToolbarGUPDesc();

// Access the only instance of the utility
class hctToolbarGUP* getToolbarGUPInstance();

/*===========================================================================*\
 | Definitions for the toolbar items themselves
\*===========================================================================*/
class hctBaseToolbarGUP : public GUP
{
    public:

        //static HWND hParams;

#if MAX_VERSION_MAJOR < 20
        ICUIFrame* GetICUIFrame();
#endif

        // GUP Methods
        DWORD   Start();
        void    Stop();
        DWORD_PTR   Control( DWORD parameter ) {return 0;}

        //Constructor/Destructor
        hctBaseToolbarGUP(){}
        ~hctBaseToolbarGUP(){}

        // Interface Methods (interface forwards here)
        void hide();
        void show();
        void dock(RECT* where=NULL,  int panel=CUI_LEFT_DOCK);
        void undock(RECT* where=NULL);
        BOOL isVisible();
        BOOL isDocked();
        void addMacro( CONST15 MCHAR* category, CONST15 MCHAR* name);
        void addSeparator();

        // Configuration save/load (whether toolbar is hidden or not)
        void loadAndExecuteConfiguration();
        void saveConfiguration();

        virtual void DeleteThis() {};

    private:

        virtual MSTR getToolbarTitle() = 0;
        virtual const char* getToolbarConfigurationFilename() = 0;
        virtual ExitMAXCallback* getSaveConfigurationCallback() = 0;

    private:

        void resizeToolbar(ICustToolbar* iToolBar);
        void getCurrentPosition(RECT& posOut, int& panelOut);

        HWND m_toolbarWnd; // CUIFrameWindow handle
#if MAX_VERSION_MAJOR >= 20
        MaxSDK::QmaxToolBar* m_toolbar = 0;
        MaxSDK::QmaxDockingWinHost* m_winHost = 0;
        int m_numToolbarButtons = 0;
        int m_numToolbarSeparators = 0;
#endif
};


class hctToolbarGUP : public hctBaseToolbarGUP
{
    public:

        hctToolbarGUP() : hctBaseToolbarGUP()
        {
        }

        ~hctToolbarGUP()
        {
        }

    private:

        MSTR getToolbarTitle();
        const char* getToolbarConfigurationFilename();
        ExitMAXCallback* getSaveConfigurationCallback();
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
