// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>

#include <ContentTools/Max/MaxSceneExport/GUP/Toolbar/hctToolbarGUP.h>

#if MAX_VERSION_MAJOR >= 20
#include "GetCOREInterface.h"
#include "MaxIcon.h"

#include "Qt/QmaxMainWindow.h"
#include "Qt/QmaxToolBar.h"
#include "Qt/QmaxDockingWinHost.h"
#include "Qt/QmaxDockingWinHostDelegate.h"
#endif

#define TBITEM(type, pIcon, cmd, label) \
    ToolButtonItem(type,pIcon,GetCUIFrameMgr()->GetImageSize(),GetCUIFrameMgr()->GetImageSize(),GetCUIFrameMgr()->GetButtonWidth(),GetCUIFrameMgr()->GetButtonHeight(),cmd, 0, label)
#define TBMACRO(md) \
    ToolMacroItem(0, GetCUIFrameMgr()->GetButtonHeight(), md)

/*===========================================================================*\
 | Class Descriptor for the CUITest plugin
\*===========================================================================*/


class hkToolbarGUPClassDesc:public ClassDesc2
{
    public:
        int             IsPublic() { return 1; }
        void *          Create(BOOL loading = FALSE) { return getToolbarGUPInstance(); }
        const MCHAR *   ClassName() { return GetString(IDS_TOOLBAR_GUP_CLASS_NAME); }
        SClass_ID       SuperClassID() { return GUP_CLASS_ID; }
        Class_ID        ClassID() { return HK_TOOLBAR_GUP_CLASS_ID; }
        const MCHAR*    Category() { return GetString(IDS_TOOLBAR_GUP_CATEGORY); }
        const MCHAR*    InternalName() { return _T("hkToolbarGUP"); }   // returns fixed parsable name (scripter-visible name)
        HINSTANCE       HInstance() { return hInstance; }               // returns owning module handle
};

ClassDesc2* getHkToolbarGUPDesc()
{
    static hkToolbarGUPClassDesc toolbarGUPClassDesc;
    return &toolbarGUPClassDesc;
}

extern ClassDesc2* s_destructionToolbarGUPClassDesc = 0;
ClassDesc2* getHkdToolbarGUPDesc()
{
    return s_destructionToolbarGUPClassDesc;
}


// Access the only instance of the GUP
hctToolbarGUP* getToolbarGUPInstance()
{
    static hctToolbarGUP theInstance;
    return &theInstance;
}

/*===========================================================================*\
 | The Begin/EndEditParams calls, which create and destroy the toolbar
\*===========================================================================*/

DWORD hctBaseToolbarGUP::Start()
{
    HCT_SCOPED_CONVERSIONS;

    ExitMAXCallback* saveConfigurationCallback = getSaveConfigurationCallback();
    Max()->RegisterExitMAXCallback(saveConfigurationCallback);

#if MAX_VERSION_MAJOR < 20
    // Create a simple toolbar
    // -- First create the frame
    HWND hParent = MaxWnd(); //Max()->GetMAXHWnd();
    HWND hWnd = CreateCUIFrameWindow(hParent, getToolbarTitle(), 0, 0, 250, 100);
    // iFrame->SetName();
    ICUIFrame* iFrame = ::GetICUIFrame(hWnd);
    iFrame->SetContentType(CUI_TOOLBAR);
    iFrame->SetPosType(CUI_HORIZ_DOCK | CUI_VERT_DOCK | CUI_FLOATABLE | CUI_SM_HANDLES);

    // -- Now create the toolbar window
    HWND hToolbar = CreateWindow(
            CUSTTOOLBARWINDOWCLASS,
            NULL,
            WS_CHILD | WS_VISIBLE,
            0, 0, 250, 100,
            hWnd,
            NULL,
            hInstance,
            NULL);
    m_toolbarWnd = hToolbar;

    // -- Now link the toolbar to the CUI frame
    ICustToolbar *iToolBar = GetICustToolbar(hToolbar);
    iToolBar->LinkToCUIFrame(hWnd, NULL);
    iToolBar->SetBottomBorder(FALSE);
    iToolBar->SetTopBorder(FALSE);

    // Now we hide the toolbar if it was saved as hidden
    loadAndExecuteConfiguration();

    // We are done, release the toolbar and frame handles
    ReleaseICustToolbar(iToolBar);
    iToolBar = NULL;
    ReleaseICUIFrame(iFrame);

#else

    // Create Qt toolbar
    auto mainWindow = GetCOREInterface()->GetQmaxMainWindow();
    m_toolbar = new MaxSDK::QmaxToolBar(getToolbarTitle(), getToolbarTitle(), mainWindow);

    // Create docking win host for hosting the legacy CustToolbar
    m_winHost = new MaxSDK::QmaxDockingWinHost(m_toolbar);
    m_toolbar->setWidget(m_winHost);

    // -- Now create the toolbar window
    m_toolbarWnd = CreateWindow(
        CUSTTOOLBARWINDOWCLASS,
        NULL,
        WS_CHILD | WS_VISIBLE,
        0, 0, 250, 100,
        reinterpret_cast<HWND>(m_winHost->winId()),
        NULL,
        hInstance,
        NULL);

    // -- Now link the toolbar to the CUI frame
    ICustToolbar *iToolBar = GetICustToolbar(m_toolbarWnd);
    iToolBar->SetBottomBorder(FALSE);
    iToolBar->SetTopBorder(FALSE);

    m_winHost->setHostedWindow(m_toolbarWnd);

    // need to be added once to the mainwindow toolbar layout before we can float it
    mainWindow->addToolBar(Qt::ToolBarArea::TopToolBarArea, m_toolbar);

    // Now we hide the toolbar if it was saved as hidden
    loadAndExecuteConfiguration();

    // We are done, release the toolbar
    ReleaseICustToolbar(iToolBar);
#endif
    return GUPRESULT_KEEP;
}

void hctBaseToolbarGUP::resizeToolbar(ICustToolbar* iToolBar)
{
#if MAX_VERSION_MAJOR < 20
    ICUIFrame* iFrame = GetICUIFrame();
    HWND hWnd = iFrame->GetHwnd();

    // -- Set the initial floating position
    SIZE sz;
    RECT rect;
    int panel;
    getCurrentPosition(rect, panel);

    // If the toolbar wasn't docked, we make sure it's in a nice place
    if (!isDocked())
    {
        rect.top = 80; rect.left = 200;
    }
    iToolBar->GetFloatingCUIFrameSize(&sz);
    rect.right = rect.left+sz.cx; rect.bottom = rect.top+sz.cy;
    MoveWindow(hWnd, rect.left, rect.right, sz.cx, sz.cy, TRUE);

    if (!iFrame->IsFloating())
    {
        GetCUIFrameMgr()->RecalcLayout(TRUE);
    }
#else
    QSize minSize;
    int buttonWidth;
    if (isDocked())
    {
        buttonWidth = 48;
    }
    else
    {
        buttonWidth = GetCUIFrameMgr()->GetButtonWidth(CUI_SIZE_24);
    }
    minSize.setWidth(buttonWidth * m_numToolbarButtons + 8 * m_numToolbarSeparators);
    minSize.setHeight(GetCUIFrameMgr()->GetButtonHeight());
    m_winHost->setMinimumSize(minSize);
#endif
}

void hctBaseToolbarGUP::Stop()
{
}

#if MAX_VERSION_MAJOR < 20
ICUIFrame* hctBaseToolbarGUP::GetICUIFrame()
{
    HWND hFrameWnd = GetParent(m_toolbarWnd);
    return  ::GetICUIFrame(hFrameWnd);
}
#endif

// Interface Methods (interface forwards here)
void hctBaseToolbarGUP::hide()
{
#if MAX_VERSION_MAJOR < 20
    ICUIFrame* iFrame = GetICUIFrame();
    if (iFrame)
    {
        iFrame->Hide(TRUE);
        // If the toolbar was docked we need to recalc the layout
        // so the toolbar will be removed.
        if (!iFrame->IsFloating())
        {
            GetCUIFrameMgr()->RecalcLayout(TRUE);
        }
    }
#else
    if (m_toolbar)
    {
        m_toolbar->setVisible(false);
    }
#endif
}
void hctBaseToolbarGUP::show()
{
#if MAX_VERSION_MAJOR < 20
    ICUIFrame* iFrame = GetICUIFrame();

    if (iFrame)
    {
        // We have the toolbar already, just show it...(EndEditParams() hid it)
        iFrame->Hide(FALSE);

        // Refresh it
        ICustToolbar *iToolBar = GetICustToolbar(m_toolbarWnd);
        resizeToolbar(iToolBar);
        ReleaseICustToolbar(iToolBar);
    }
#else
    if (m_toolbar)
    {
        m_toolbar->setVisible(true);
    }
#endif
}

void hctBaseToolbarGUP::dock(RECT* where, int panel)
{
#if MAX_VERSION_MAJOR < 20
    ICUIFrame* pFrame = GetICUIFrame();
    // Don't do anything of it's on the tab panel
    if (pFrame && !pFrame->GetTabbedToolbar())
    {
        if (pFrame->IsFloating())
        {
            GetCUIFrameMgr()->DockCUIWindow(GetParent(pFrame->GetContentHandle()), panel, where);
            GetCUIFrameMgr()->RecalcLayout(TRUE);
        }
    }
#else
    if (m_toolbar && m_toolbar->isFloating())
    {
        GetCOREInterface()->GetQmaxMainWindow()->addToolBar(Qt::ToolBarArea::TopToolBarArea, m_toolbar);
        ICustToolbar *iToolBar = GetICustToolbar(m_toolbarWnd);
        resizeToolbar(iToolBar);
        ReleaseICustToolbar(iToolBar);
    }
#endif
}
void hctBaseToolbarGUP::undock(RECT* where)
{
#if MAX_VERSION_MAJOR < 20
    ICUIFrame* pFrame = GetICUIFrame();
    // Don't do anything of it's on the tab panel
    if (pFrame && !pFrame->GetTabbedToolbar())
    {
        if ( ! pFrame->IsFloating() )
        {
            GetCUIFrameMgr()->FloatCUIWindow(GetParent(pFrame->GetContentHandle()), where);
            GetCUIFrameMgr()->RecalcLayout(TRUE);
        }
    }
#else
    if (m_toolbar && !m_toolbar->isFloating())
    {
        MaxSDK::QmaxMainWindow::makeToolBarFloating(m_toolbar, QCursor::pos());
        ICustToolbar *iToolBar = GetICustToolbar(m_toolbarWnd);
        resizeToolbar(iToolBar);
        ReleaseICustToolbar(iToolBar);
    }
#endif
}
BOOL hctBaseToolbarGUP::isVisible()
{
#if MAX_VERSION_MAJOR < 20
    ICUIFrame* pFrame = GetICUIFrame();

    if(pFrame)
    {
        return !pFrame->IsHidden();
    }
#else
    return m_toolbar ? m_toolbar->isVisible() : false;
#endif
}

BOOL hctBaseToolbarGUP::isDocked()
{
#if MAX_VERSION_MAJOR < 20
    ICUIFrame* pFrame = GetICUIFrame();
    return ! pFrame->IsFloating();
#else
    return m_toolbar ? !m_toolbar->isFloating() : false;
#endif
}

void hctBaseToolbarGUP::addMacro( CONST15 MCHAR* category, CONST15 MCHAR* name)
{
    // -- Now link the toolbar to the CUI frame
    ICustToolbar *iToolBar = GetICustToolbar(m_toolbarWnd);

    MacroEntry *me = GetMacroScriptDir().FindMacro(category, name);
    if (me)
    {
        MacroID mID = me->GetID();
        int imageId = me->GetButtonIconIndex();
        MSTR imageName = me->GetButtonIconFile();
        MSTR buttonName = me->GetButtonText();

        //Get the action table
        ActionTable *actionTable =  GetCOREInterface()->GetActionManager()->FindTable(kActionMacroScripts);
        if (!actionTable) return;

        //Constructor with as first param the Id of the action Table
        MacroButtonData md2(actionTable->GetId(), mID, buttonName, me->GetToolTip(), imageId, imageName );

        iToolBar->AddTool(TBMACRO(&md2));

#if MAX_VERSION_MAJOR < 20
        //Redraw all the visible CUI buttons in 3ds Max, calling the "IsEnabled" and
        //"IsChecked" handlers on the ActionItems associated with each button
        GetCUIFrameMgr()->SetMacroButtonStates(TRUE);
#else
        ++m_numToolbarButtons;
#endif
    }

#if MAX_VERSION_MAJOR < 20
    if (isVisible()) // Always call resize when using Qt toolbar. Getting the recommended size via CUIFrame does not work anymore so we always have to adjust when adding icons
#endif
    {
        // Resize
        resizeToolbar(iToolBar);
    }

    // We are done, release the toolbar and frame handles
    ReleaseICustToolbar(iToolBar);
    iToolBar = NULL;
}

void hctBaseToolbarGUP::addSeparator()
{
#if MAX_VERSION_MAJOR < 20
    // -- Now link the toolbar to the CUI frame
    ICustToolbar *iToolBar = GetICustToolbar(m_toolbarWnd);

    // Add a separator
    iToolBar->AddTool(ToolSeparatorItem(8));

    if (isVisible())
    {
        // Resize
        resizeToolbar(iToolBar);
    }

    // We are done, release the toolbar and frame handles
    ReleaseICustToolbar(iToolBar);
    iToolBar = NULL;
#else
    ICustToolbar *iToolBar = GetICustToolbar(m_toolbarWnd);
    iToolBar->AddTool(ToolSeparatorItem(8));
    int width = iToolBar->GetNeededWidth(0);
    ReleaseICustToolbar(iToolBar);
    iToolBar = NULL;
    ++m_numToolbarSeparators;
#endif
}


void hctBaseToolbarGUP::loadAndExecuteConfiguration()
{
    HCT_SCOPED_CONVERSIONS;

    // We check if we have saved the current user choice
    const char *dir = FROM_MAX ( GetCOREInterface()->GetDir ( APP_PLUGCFG_DIR ) );
    if (!dir) return;

    char filename [500];
    sprintf ( filename, "%s\\%s", dir, getToolbarConfigurationFilename() );

    FILE* fp;
    if ( ( fp = fopen(filename, "r") ) != NULL )
    {
        char state[30];


        bool visible;
        {
            fscanf ( fp, "%s", state );
            visible = (strcmp(state, "CLOSED")!=0);
        }

        bool docked;
        {
            fscanf ( fp, "%s", state );
            docked =  (strcmp(state, "DOCKED")==0);
        }

        RECT position;
        int panel;
        {
            fscanf ( fp, "%d %d %d %d %d", &position.left, &position.top, &position.right, &position.bottom, &panel);
        }

        if (docked)
        {
            dock(&position, panel);
        }
        else
        {
            undock(&position);
        }

        if (visible)
        {
            show();
        }
        else
        {
            hide();
        }

        fclose (fp);
    }
    else
    {
        dock(NULL, CUI_LEFT_DOCK);
        show();
    }

}

void hctBaseToolbarGUP::saveConfiguration()
{
    HCT_SCOPED_CONVERSIONS;

    // We check if we have saved the current user choice
    const char *dir = FROM_MAX ( GetCOREInterface()->GetDir ( APP_PLUGCFG_DIR ) );
    if (!dir) return;

    char filename [500];
    sprintf ( filename, "%s\\%s", dir, getToolbarConfigurationFilename() );

    FILE *fp;
    if ( ( fp = fopen(filename, "w") ) != NULL )
    {
        if (isVisible())
        {
            fprintf(fp, "OPEN\n");
        }
        else
        {
            fprintf(fp, "CLOSED\n");
        }

        if (isDocked())
        {
            fprintf(fp, "DOCKED\n");
        }
        else
        {
            fprintf(fp,"UNDOCKED\n");
        }

        RECT currentPos;
        int currentPanel;
        getCurrentPosition (currentPos, currentPanel);
        fprintf (fp, "%d %d %d %d %d\n",currentPos.left, currentPos.top, currentPos.right, currentPos.bottom, currentPanel);

        fclose (fp);
    }
}

void hctBaseToolbarGUP::getCurrentPosition (RECT& posOut, int& panelOut)
{
#if MAX_VERSION_MAJOR < 20
    ICUIFrame* iFrame = GetICUIFrame();
    HWND hWnd = iFrame->GetHwnd();

    GetWindowRect(hWnd, &posOut);
    panelOut = iFrame->GetCurPosition();
#else

    GetWindowRect(m_toolbarWnd, &posOut);
    panelOut = 0; // Deprecated
#endif
}


MSTR hctToolbarGUP::getToolbarTitle()
{
    return TEXT("Havok Content Tools");
}


const char* hctToolbarGUP::getToolbarConfigurationFilename()
{
    return "hct_toolbar.dat";
}


class SaveConfigurationCallback : public ExitMAXCallback
{
    BOOL Exit (HWND hWnd)
    {
        getToolbarGUPInstance()->saveConfiguration();
        return TRUE;
    }
};


ExitMAXCallback* hctToolbarGUP::getSaveConfigurationCallback()
{
    static SaveConfigurationCallback saveConfigurationCallback;
    return &saveConfigurationCallback;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
