// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

/* FPI Interface */
class hctSelectionUtilGUPInterfaceImplementation : public hctSelectionUtilGUPInterface
{
public:

    DECLARE_DESCRIPTOR (hctSelectionUtilGUPInterfaceImplementation)

    BEGIN_FUNCTION_MAP
        FN_1 ( FPI_GetVertSelectionsNames, TYPE_STRING_TAB, iGetVertSelectionsNames, TYPE_INODE )
        FN_1 ( FPI_GetFaceSelectionsNames, TYPE_STRING_TAB, iGetFaceSelectionsNames, TYPE_INODE )
        FN_1 ( FPI_GetEdgeSelectionsNames, TYPE_STRING_TAB, iGetEdgeSelectionsNames, TYPE_INODE )
        FN_2 ( FPI_CreateNamedSelectionFromCurrent, TYPE_BOOL, iCreateNamedSelectionFromCurrent, TYPE_INODE, TYPE_STRING )
        FN_2 ( FPI_OverwriteNamedVertSelectionFromCurrent, TYPE_BOOL, iOverwriteNamedVertSelectionFromCurrent, TYPE_INODE, TYPE_STRING )
        FN_2 ( FPI_OverwriteNamedFaceSelectionFromCurrent, TYPE_BOOL, iOverwriteNamedFaceSelectionFromCurrent, TYPE_INODE, TYPE_STRING )
        FN_2 ( FPI_OverwriteNamedEdgeSelectionFromCurrent, TYPE_BOOL, iOverwriteNamedEdgeSelectionFromCurrent, TYPE_INODE, TYPE_STRING )
        FN_3 ( FPI_RenameVertSelection, TYPE_BOOL, iRenameVertSelection, TYPE_INODE, TYPE_STRING, TYPE_STRING )
        FN_3 ( FPI_RenameFaceSelection, TYPE_BOOL, iRenameFaceSelection, TYPE_INODE, TYPE_STRING, TYPE_STRING )
        FN_3 ( FPI_RenameEdgeSelection, TYPE_BOOL, iRenameEdgeSelection, TYPE_INODE, TYPE_STRING, TYPE_STRING )
        FN_2 ( FPI_DeleteVertSelection, TYPE_BOOL, iDeleteVertSelection, TYPE_INODE, TYPE_STRING )
        FN_2 ( FPI_DeleteFaceSelection, TYPE_BOOL, iDeleteFaceSelection, TYPE_INODE, TYPE_STRING )
        FN_2 ( FPI_DeleteEdgeSelection, TYPE_BOOL, iDeleteEdgeSelection, TYPE_INODE, TYPE_STRING )
        FN_2 ( FPI_LoadVertSelection, TYPE_BOOL, iLoadVertSelection, TYPE_INODE, TYPE_STRING )
        FN_2 ( FPI_LoadFaceSelection, TYPE_BOOL, iLoadFaceSelection, TYPE_INODE, TYPE_STRING )
        FN_2 ( FPI_LoadEdgeSelection, TYPE_BOOL, iLoadEdgeSelection, TYPE_INODE, TYPE_STRING )
    END_FUNCTION_MAP

    Tab<const MCHAR*>* iGetVertSelectionsNames( INode* selectedNode );
    Tab<const MCHAR*>* iGetFaceSelectionsNames( INode* selectedNode );
    Tab<const MCHAR*>* iGetEdgeSelectionsNames( INode* selectedNode );
    BOOL iCreateNamedSelectionFromCurrent( INode* selectedNode, const MCHAR* selectionName );
    BOOL iOverwriteNamedVertSelectionFromCurrent( INode* selectedNode, const MCHAR* selectionName );
    BOOL iOverwriteNamedFaceSelectionFromCurrent( INode* selectedNode, const MCHAR* selectionName );
    BOOL iOverwriteNamedEdgeSelectionFromCurrent( INode* selectedNode, const MCHAR* selectionName );
    BOOL iRenameVertSelection( INode* selectedNode, const MCHAR* oldName, const MCHAR* newName );
    BOOL iRenameFaceSelection( INode* selectedNode, const MCHAR* oldName, const MCHAR* newName );
    BOOL iRenameEdgeSelection( INode* selectedNode, const MCHAR* oldName, const MCHAR* newName );
    BOOL iDeleteVertSelection( INode* selectedNode, const MCHAR* name );
    BOOL iDeleteFaceSelection( INode* selectedNode, const MCHAR* name );
    BOOL iDeleteEdgeSelection( INode* selectedNode, const MCHAR* name );
    BOOL iLoadVertSelection( INode* selectedNode, const MCHAR* name );
    BOOL iLoadFaceSelection( INode* selectedNode, const MCHAR* name );
    BOOL iLoadEdgeSelection( INode* selectedNode, const MCHAR* name );
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
