// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>

#include <ContentTools/Max/MaxSceneExport/GUP/SelectionUtil/hctSelectionUtilGUP.h>
#include <ContentTools/Max/MaxSceneExport/GUP/SelectionUtil/hctSelectionUtilGUP_FPI.h>


// Please see the following header file for class information
/* FPI Interface */

static hctSelectionUtilGUPInterfaceImplementation g_selectionUtilGUPInterface
(
    HK_SELECTION_UTIL_GUP_FPINTERFACE_ID, _T("hkSelectionUtilGUPInterface"), 0, getHkSelectionUtilGUPDesc(), 0,
    FPI_GetVertSelectionsNames, _T("getVertSelectionNames"), 0, TYPE_STRING_TAB, 0, 1, _T("selectedNode"), 0, TYPE_INODE,
    FPI_GetFaceSelectionsNames, _T("getFaceSelectionNames"), 0, TYPE_STRING_TAB, 0, 1, _T("selectedNode"), 0, TYPE_INODE,
    FPI_GetEdgeSelectionsNames, _T("getEdgeSelectionNames"), 0, TYPE_STRING_TAB, 0, 1, _T("selectedNode"), 0, TYPE_INODE,
    FPI_CreateNamedSelectionFromCurrent, _T("createNamedSelectionFromCurrent"), 0, TYPE_BOOL, 0, 2, _T("selectedNode"), 0, TYPE_INODE, _T("selectionName"), 0, TYPE_STRING,
    FPI_OverwriteNamedVertSelectionFromCurrent, _T("overwriteNamedVertSelectionFromCurrent"), 0, TYPE_BOOL, 0, 2, _T("selectedNode"), 0, TYPE_INODE, _T("selectionName"), 0, TYPE_STRING,
    FPI_OverwriteNamedFaceSelectionFromCurrent, _T("overwriteNamedFaceSelectionFromCurrent"), 0, TYPE_BOOL, 0, 2, _T("selectedNode"), 0, TYPE_INODE, _T("selectionName"), 0, TYPE_STRING,
    FPI_OverwriteNamedEdgeSelectionFromCurrent, _T("overwriteNamedEdgeSelectionFromCurrent"), 0, TYPE_BOOL, 0, 2, _T("selectedNode"), 0, TYPE_INODE, _T("selectionName"), 0, TYPE_STRING,
    FPI_RenameVertSelection, _T("renameVertSelection"), 0, TYPE_BOOL, 0, 3, _T("selectedNode"), 0, TYPE_INODE, _T("oldName"), 0, TYPE_STRING, _T("newName"), 0, TYPE_STRING,
    FPI_RenameFaceSelection, _T("renameFaceSelection"), 0, TYPE_BOOL, 0, 3, _T("selectedNode"), 0, TYPE_INODE, _T("oldName"), 0, TYPE_STRING, _T("newName"), 0, TYPE_STRING,
    FPI_RenameEdgeSelection, _T("renameEdgeSelection"), 0, TYPE_BOOL, 0, 3, _T("selectedNode"), 0, TYPE_INODE, _T("oldName"), 0, TYPE_STRING, _T("newName"), 0, TYPE_STRING,
    FPI_DeleteVertSelection, _T("deleteVertSelection"), 0, TYPE_BOOL, 0, 2, _T("selectedNode"), 0, TYPE_INODE, _T("name"), 0, TYPE_STRING,
    FPI_DeleteFaceSelection, _T("deleteFaceSelection"), 0, TYPE_BOOL, 0, 2, _T("selectedNode"), 0, TYPE_INODE, _T("name"), 0, TYPE_STRING,
    FPI_DeleteEdgeSelection, _T("deleteEdgeSelection"), 0, TYPE_BOOL, 0, 2, _T("selectedNode"), 0, TYPE_INODE, _T("name"), 0, TYPE_STRING,
    FPI_LoadVertSelection, _T("loadVertSelection"), 0, TYPE_BOOL, 0, 2, _T("selectedNode"), 0, TYPE_INODE, _T("name"), 0, TYPE_STRING,
    FPI_LoadFaceSelection, _T("loadFaceSelection"), 0, TYPE_BOOL, 0, 2, _T("selectedNode"), 0, TYPE_INODE, _T("name"), 0, TYPE_STRING,
    FPI_LoadEdgeSelection, _T("loadEdgeSelection"), 0, TYPE_BOOL, 0, 2, _T("selectedNode"), 0, TYPE_INODE, _T("name"), 0, TYPE_STRING,
    p_end
);


Tab<const MCHAR*>* hctSelectionUtilGUPInterfaceImplementation::iGetVertSelectionsNames( INode* selectedNode )
{
    return getSelectionUtilGUPInstance()->getVertSelectionsNames( selectedNode );
}

Tab<const MCHAR*>* hctSelectionUtilGUPInterfaceImplementation::iGetFaceSelectionsNames( INode* selectedNode )
{
    return getSelectionUtilGUPInstance()->getFaceSelectionsNames( selectedNode );
}

Tab<const MCHAR*>* hctSelectionUtilGUPInterfaceImplementation::iGetEdgeSelectionsNames( INode* selectedNode )
{
    return getSelectionUtilGUPInstance()->getEdgeSelectionsNames( selectedNode );
}

BOOL hctSelectionUtilGUPInterfaceImplementation::iCreateNamedSelectionFromCurrent( INode* selectedNode, const MCHAR* selectionName )
{
    return getSelectionUtilGUPInstance()->createNamedSelectionFromCurrent( selectedNode, selectionName );
}

BOOL hctSelectionUtilGUPInterfaceImplementation::iOverwriteNamedVertSelectionFromCurrent( INode* selectedNode, const MCHAR* selectionName )
{
    return getSelectionUtilGUPInstance()->overwriteNamedVertSelectionFromCurrent( selectedNode, selectionName );
}

BOOL hctSelectionUtilGUPInterfaceImplementation::iOverwriteNamedFaceSelectionFromCurrent( INode* selectedNode, const MCHAR* selectionName )
{
    return getSelectionUtilGUPInstance()->overwriteNamedFaceSelectionFromCurrent( selectedNode, selectionName );
}

BOOL hctSelectionUtilGUPInterfaceImplementation::iOverwriteNamedEdgeSelectionFromCurrent( INode* selectedNode, const MCHAR* selectionName )
{
    return getSelectionUtilGUPInstance()->overwriteNamedEdgeSelectionFromCurrent( selectedNode, selectionName );
}

BOOL hctSelectionUtilGUPInterfaceImplementation::iRenameVertSelection( INode* selectedNode, const MCHAR* oldName, const MCHAR* newName )
{
    return getSelectionUtilGUPInstance()->renameVertSelection( selectedNode, oldName, newName );
}

BOOL hctSelectionUtilGUPInterfaceImplementation::iRenameFaceSelection( INode* selectedNode, const MCHAR* oldName, const MCHAR* newName )
{
    return getSelectionUtilGUPInstance()->renameFaceSelection( selectedNode, oldName, newName );
}

BOOL hctSelectionUtilGUPInterfaceImplementation::iRenameEdgeSelection( INode* selectedNode, const MCHAR* oldName, const MCHAR* newName )
{
    return getSelectionUtilGUPInstance()->renameEdgeSelection( selectedNode, oldName, newName );
}

BOOL hctSelectionUtilGUPInterfaceImplementation::iDeleteVertSelection( INode* selectedNode, const MCHAR* name )
{
    return getSelectionUtilGUPInstance()->deleteVertSelection( selectedNode, name );
}

BOOL hctSelectionUtilGUPInterfaceImplementation::iDeleteFaceSelection( INode* selectedNode, const MCHAR* name )
{
    return getSelectionUtilGUPInstance()->deleteFaceSelection( selectedNode, name );
}

BOOL hctSelectionUtilGUPInterfaceImplementation::iDeleteEdgeSelection( INode* selectedNode, const MCHAR* name )
{
    return getSelectionUtilGUPInstance()->deleteEdgeSelection( selectedNode, name );
}

BOOL hctSelectionUtilGUPInterfaceImplementation::iLoadVertSelection( INode* selectedNode, const MCHAR* name )
{
    return getSelectionUtilGUPInstance()->loadVertSelection( selectedNode, name );
}

BOOL hctSelectionUtilGUPInterfaceImplementation::iLoadFaceSelection( INode* selectedNode, const MCHAR* name )
{
    return getSelectionUtilGUPInstance()->loadFaceSelection( selectedNode, name );
}

BOOL hctSelectionUtilGUPInterfaceImplementation::iLoadEdgeSelection( INode* selectedNode, const MCHAR* name )
{
    return getSelectionUtilGUPInstance()->loadEdgeSelection( selectedNode, name );
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
