// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once


#include <ContentTools/Max/MaxFpInterfaces/SelectionUtil/hctSelectionUtilGUPInterface.h>

// Access to the class descriptor
extern ClassDesc2* getHkSelectionUtilGUPDesc();

// Access the only instance of the utility
class hctSelectionUtilGUP* getSelectionUtilGUPInstance ();

/*===========================================================================*\
| Definitions for the toolbar items themselves
\*===========================================================================*/
class hctSelectionUtilGUP : public GUP
{
public:

    // GUP Methods
    DWORD   Start();
    void    Stop();
    DWORD_PTR   Control( DWORD parameter ) {return 0;}

    //Constructor/Destructor
    hctSelectionUtilGUP(){}
    ~hctSelectionUtilGUP(){}

    virtual void DeleteThis () {};

    static void getSupportedVertSelectionsClassIds( Tab<Class_ID>& supportedClassIds );
    static void getSupportedFaceSelectionsClassIds( Tab<Class_ID>& supportedClassIds );
    static void getSupportedEdgeSelectionsClassIds( Tab<Class_ID>& supportedClassIds );

    // Interface Methods (interface forwards here)

    // Retrieves names of named selection sets in currently selected node
    Tab<const MCHAR*>* getVertSelectionsNames( INode* selectedNode );
    Tab<const MCHAR*>* getFaceSelectionsNames( INode* selectedNode );
    Tab<const MCHAR*>* getEdgeSelectionsNames( INode* selectedNode );

    // Creates a new named selection set from current selection, returns true if succeeds
    BOOL createNamedSelectionFromCurrent( INode* selectedNode, const MCHAR* selectionName );

    // Overwrites the selection with the currently selected set
    BOOL overwriteNamedVertSelectionFromCurrent( INode* selectedNode, const MCHAR* selectionName );
    BOOL overwriteNamedFaceSelectionFromCurrent( INode* selectedNode, const MCHAR* selectionName );
    BOOL overwriteNamedEdgeSelectionFromCurrent( INode* selectedNode, const MCHAR* selectionName );

    // Renames a named selection set of the selected node, returns true if found
    BOOL renameVertSelection( INode* selectedNode, const MCHAR* oldName, const MCHAR* newName );
    BOOL renameFaceSelection( INode* selectedNode, const MCHAR* oldName, const MCHAR* newName );
    BOOL renameEdgeSelection( INode* selectedNode, const MCHAR* oldName, const MCHAR* newName );

    // Deletes the set with the provided name, returns true if found
    BOOL deleteVertSelection( INode* selectedNode, const MCHAR* name );
    BOOL deleteFaceSelection( INode* selectedNode, const MCHAR* name );
    BOOL deleteEdgeSelection( INode* selectedNode, const MCHAR* name );

    // Loads the selection in the scene, returns true if found
    BOOL loadVertSelection( INode* selectedNode, const MCHAR* name );
    BOOL loadFaceSelection( INode* selectedNode, const MCHAR* name );
    BOOL loadEdgeSelection( INode* selectedNode, const MCHAR* name );

    // Retrieve the vertex current selection as a bit array. Returns true if a selection is found.
    BOOL findCurrentVertexSelection( INode* selectedNode, BitArray& selectionOut );
    // Retrieve the face current selection as a bit array. Returns true if a selection is found.
    BOOL findCurrentFaceSelection( INode* selectedNode, BitArray& selectionOut );
    // Retrieve the current edge selection as a bit array. Returns true if a selection is found.
    BOOL findCurrentEdgeSelection( INode* selectedNode, BitArray& selectionOut );

    // Given a bit array representing the desired selection it loads the selection and creates a new named selection set
    // if the provided name is not NULL and not empty
    void applyAndCreateVertexSelection( INode* selectedNode, const MCHAR* SelectionName, BitArray& selState, BaseObject* selModifier );

private:
    // cached selection
    BitArray m_cachedSelState;
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
