// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>

#include <ContentTools/Max/MaxSceneExport/GUP/SelectionUtil/hctSelectionUtilGUP.h>

/*===========================================================================*\
| Class Descriptor for the CUITest plugin
\*===========================================================================*/

class hkSelectionUtilGUPClassDesc : public ClassDesc2
{
public:
    int             IsPublic() { return 1; }
    void *          Create(BOOL loading = FALSE) { return getSelectionUtilGUPInstance(); }
    const MCHAR *   ClassName() { return GetString(IDS_SELECTION_UTIL_GUP_CLASS_NAME); }
    SClass_ID       SuperClassID() { return GUP_CLASS_ID; }
    Class_ID        ClassID() { return HK_SELECTION_UTIL_GUP_CLASS_ID; }
    const MCHAR*    Category() { return GetString(IDS_SELECTION_UTIL_GUP_CATEGORY); }
    const MCHAR*    InternalName() { return _T("hkSelectionUtilGUP"); } // returns fixed parsable name (scripter-visible name)
    HINSTANCE       HInstance() { return hInstance; }               // returns owning module handle
};

ClassDesc2* getHkSelectionUtilGUPDesc()
{
    static hkSelectionUtilGUPClassDesc selectionUtilGUPDesc;
    return &selectionUtilGUPDesc;
}



// Access the only instance of the GUP
hctSelectionUtilGUP* getSelectionUtilGUPInstance ()
{
    static hctSelectionUtilGUP theInstance;
    return &theInstance;
}


/*===========================================================================*\
| The Begin/EndEditParams calls, which create and destroy the toolbar
\*===========================================================================*/

DWORD hctSelectionUtilGUP::Start()
{
    return GUPRESULT_KEEP;
}
void hctSelectionUtilGUP::Stop()
{
}


void _findAllMeshSelectDataInterfaces( INode* selectedNode, Tab<IMeshSelectData*>& dataInterfacesOut, Tab<Class_ID> supportedClassIds, Tab<IMeshSelect*>* interfacesOut = NULL, Tab<BaseObject*>* baseObjectsOut = NULL )
{
    if( selectedNode )
    {
        dataInterfacesOut.ZeroCount();
        if ( interfacesOut ) interfacesOut->ZeroCount();

        Object* curObject = selectedNode->GetObjectRef();
        while (curObject)
        {
            IDerivedObject* devObject = curObject->SuperClassID() == GEN_DERIVOB_CLASS_ID? reinterpret_cast<IDerivedObject*>(curObject) : NULL;
            if (devObject) // has modifiers
            {
                for (int m=devObject->NumModifiers()-1; m >=0 ; --m)
                {

                    Modifier* mod = devObject->GetModifier(m);
                    Class_ID modClassID = mod->ClassID();

                    // EXP-1248 : Cloth modifier gives trouble, so ignore it if found.
                    static const Class_ID maxClothModifierClassID (0x67c1cd47, 0x7782f878);
                    if (mod->IsEnabled() && (modClassID!=maxClothModifierClassID))
                    {
                        ModContext* mc = devObject->GetModContext(m);
                        if (!mc) continue;

                        LocalModData * mseldata = mc->localData;
                        if(!mseldata) continue;

                        IMeshSelectData* selectInterface = GetMeshSelectDataInterface( mseldata );
                        IMeshSelect* imod = GetMeshSelectInterface( mod );

                        if ( selectInterface && imod )
                        {
                            // not all modifiers are supported
                            for ( int i = 0; i <  supportedClassIds.Count(); ++i )
                            {
                                if( supportedClassIds[i] == modClassID )
                                {
                                    dataInterfacesOut.Append( 1, &selectInterface );
                                    if ( interfacesOut )
                                    {
                                        interfacesOut->Append( 1, &imod );
                                    }
                                    if ( baseObjectsOut )
                                    {
                                        BaseObject* p = mod;
                                        baseObjectsOut->Append( 1, &p );
                                    }
                                    break;
                                }
                            }
                        }

                    }
                }
                curObject = devObject->GetObjRef(); // drop down one level the stack
            }
            else // p_end of the line, the base object
            {
                IMeshSelectData* selectInterface = GetMeshSelectDataInterface( curObject );
                IMeshSelect* imod = GetMeshSelectInterface( curObject );

                if ( selectInterface && imod )
                {
                    Class_ID objectClassID = curObject->ClassID();

                    // not all modifiers are supported
                    for ( int i = 0; i < supportedClassIds.Count(); ++i )
                    {
                        if( supportedClassIds[i] == objectClassID )
                        {
                            dataInterfacesOut.Append( 1, &selectInterface );
                            if ( interfacesOut )
                            {
                                interfacesOut->Append( 1, &imod );
                            }
                            if ( baseObjectsOut )
                            {
                                BaseObject* p = curObject;
                                baseObjectsOut->Append( 1, &p );
                            }
                            break;
                        }
                    }
                }

                curObject = NULL; // finish
            }
        }
    }
}

// Type of the function pointer to retrieve selection names
typedef GenericNamedSelSetList& (*getNamesFunType)(IMeshSelectData*);

GenericNamedSelSetList& _getVertSelNames( IMeshSelectData* data )
{
    return data->GetNamedVertSelList();
}

GenericNamedSelSetList& _getFaceSelNames( IMeshSelectData* data )
{
    return data->GetNamedFaceSelList();
}

GenericNamedSelSetList& _getEdgeSelNames( IMeshSelectData* data )
{
    return data->GetNamedEdgeSelList();
}

getNamesFunType _getSelNameFun( int subObjectSelType )
{
    switch ( subObjectSelType )
    {
    case IMESHSEL_VERTEX :
        return &_getVertSelNames; break;
    case IMESHSEL_FACE :
        return &_getFaceSelNames; break;
    case IMESHSEL_EDGE :
        return &_getEdgeSelNames; break;
    default:
        return NULL;
    }
}

BOOL _findMeshSelectAndBaseObjectFromSelection( INode* selectedNode, const MCHAR* selectionName, IMeshSelect** interfaceOut, IMeshSelectData** dataInterfaceOut, BaseObject** baseObjectOut, getNamesFunType getNamesFunction )
{
    (*interfaceOut) = NULL;
    (*baseObjectOut) = NULL;
    (*dataInterfaceOut) = NULL;

    MSTR selectionNameStr (selectionName);

    if( selectedNode )
    {
        Object* curObject = selectedNode->GetObjectRef();
        // search the stack until we find the selection
        while ( curObject && ( (*interfaceOut)==NULL || (*baseObjectOut)==NULL ) )
        {
            IDerivedObject* devObject = curObject->SuperClassID() == GEN_DERIVOB_CLASS_ID? reinterpret_cast<IDerivedObject*>(curObject) : NULL;
            if (devObject) // has modifiers
            {
                for (int m=devObject->NumModifiers()-1; m >=0 ; --m)
                {
                    // get the modifier
                    Modifier* mod = devObject->GetModifier(m);
                    Class_ID modClassID = mod->ClassID();

                    // EXP-1248 : Cloth modifier gives trouble, so ignore it if found.
                    static const Class_ID maxClothModifierClassID (0x67c1cd47, 0x7782f878);
                    if (mod->IsEnabled() && (modClassID!=maxClothModifierClassID))
                    {
                        ModContext* mc = devObject->GetModContext(m);
                        if (!mc) continue;

                        LocalModData * mseldata = mc->localData;
                        if(!mseldata) continue;

                        // if we have a select data interface and it has the selection set we are looking for, or we are not looking for
                        // any selection, store the pointers to mesh interface and modifier
                        IMeshSelectData* selectInterface = GetMeshSelectDataInterface( mseldata );
                        if ( selectInterface )
                        {
                            if ( selectionName == NULL || ( (*getNamesFunction)(selectInterface)).GetSet( selectionNameStr ) )
                            {
                                (*interfaceOut) = GetMeshSelectInterface( mod );
                                (*dataInterfaceOut) = selectInterface;
                                (*baseObjectOut) = mod;
                            }
                        }
                    }
                }
                curObject = devObject->GetObjRef(); // drop down one level the stack
            }
            else // p_end of the line, the base object
            {
                IMeshSelectData* selectInterface = GetMeshSelectDataInterface( curObject );

                if ( selectInterface )
                {
                    if ( selectionName == NULL || ( (*getNamesFunction)(selectInterface)).GetSet( selectionNameStr ) )
                    {
                        (*interfaceOut) = GetMeshSelectInterface( curObject );
                        (*dataInterfaceOut) = selectInterface;
                        (*baseObjectOut) = curObject;
                    }
                }

                curObject = NULL; // finish
            }
        }
    }
    // return true if we found it
    return !( (*interfaceOut)==NULL || (*baseObjectOut)==NULL );
}

Tab<const MCHAR*>* _getSelectionsNames( INode* selectedNode, getNamesFunType getNamesFunction, Tab<Class_ID> supportedClassIds )
{
    Tab<const MCHAR*> tmp;
    {
        Tab<IMeshSelectData*> meshSelectDataInterfaces;
        _findAllMeshSelectDataInterfaces( selectedNode, meshSelectDataInterfaces, supportedClassIds );

        for ( int i=0; i < meshSelectDataInterfaces.Count(); ++i)
        {
            IMeshSelectData* data = meshSelectDataInterfaces[i];
            const Tab<MSTR*>& names = (*getNamesFunction)(data).names;

            for ( int nameIndex=0; nameIndex < names.Count(); ++nameIndex)
            {
                const MCHAR* s = names[nameIndex]->data();
                tmp.Append( 1, &s );
            }
        }
    }
    // copy the array
    return new Tab<const MCHAR*>( tmp );
}

void hctSelectionUtilGUP::getSupportedVertSelectionsClassIds( Tab<Class_ID>& supportedClassIds )
{
    //Supported class names:  "Mesh Select", "Poly Select", "EditMeshMod", "Editable Mesh", "Editable Poly"
    static Class_ID supported[] = { Class_ID(MESHSELECT_CLASS_ID, 0), Class_ID(0x7ce5206b, 0x31181505), Class_ID(0x00000050, 0), Class_ID(EDITTRIOBJ_CLASS_ID,0),  EPOLYOBJ_CLASS_ID };
    supportedClassIds.Append( 5, supported );
}

void hctSelectionUtilGUP::getSupportedFaceSelectionsClassIds( Tab<Class_ID>& supportedClassIds )
{
    //Supported class names: "Mesh Select", "EditMeshMod", "Editable Mesh"
    static Class_ID supported[] = { Class_ID(MESHSELECT_CLASS_ID, 0), Class_ID(0x00000050, 0), Class_ID(EDITTRIOBJ_CLASS_ID,0) };
    supportedClassIds.Append( 3, supported );
}


void hctSelectionUtilGUP::getSupportedEdgeSelectionsClassIds( Tab<Class_ID>& supportedClassIds )
{
    //Supported class names:  "Mesh Select", "Poly Select", "EditMeshMod", "Editable Mesh", "Editable Poly"
    static Class_ID supported[] = { Class_ID(MESHSELECT_CLASS_ID, 0), Class_ID(0x7ce5206b, 0x31181505), Class_ID(0x00000050, 0), Class_ID(EDITTRIOBJ_CLASS_ID,0),  EPOLYOBJ_CLASS_ID };
    supportedClassIds.Append( 5, supported );
}


Tab<const MCHAR*>* hctSelectionUtilGUP::getVertSelectionsNames( INode* selectedNode )
{
    Tab<Class_ID> supportedClassIds;
    getSupportedVertSelectionsClassIds( supportedClassIds );

    return _getSelectionsNames( selectedNode, &_getVertSelNames, supportedClassIds );
}

Tab<const MCHAR*>* hctSelectionUtilGUP::getFaceSelectionsNames( INode* selectedNode )
{
    Tab<Class_ID> supportedClassIds;
    getSupportedFaceSelectionsClassIds( supportedClassIds );

    return _getSelectionsNames( selectedNode, &_getFaceSelNames, supportedClassIds );
}

Tab<const MCHAR*>* hctSelectionUtilGUP::getEdgeSelectionsNames( INode* selectedNode )
{
    Tab<Class_ID> supportedClassIds;
    getSupportedEdgeSelectionsClassIds( supportedClassIds );

    return _getSelectionsNames( selectedNode, &_getEdgeSelNames, supportedClassIds );
}


// For all sub-object selection types
BOOL hctSelectionUtilGUP::createNamedSelectionFromCurrent( INode* selectedNode, const MCHAR* selectionName )
{
    MSTR nameStr( selectionName );
    Interface7* iFace7 = GetCOREInterface7();

    if ( !iFace7 ) return false;

    // get currently edited object
    BaseObject* baseObject = iFace7->GetCurEditObject();

    if ( baseObject )
    {
        // add the new selection and update the dropdown list
        baseObject->NewSetFromCurSel( nameStr );
        iFace7->NamedSelSetListChanged();

        return true;
    }

    return false;
}

typedef void (*getSelectionFunType)(IMeshSelectData*, BitArray&);
void _getVertSelectionFun( IMeshSelectData* data, BitArray& selectionOut )
{
    selectionOut = data->GetVertSel();
}
void _getFaceSelectionFun( IMeshSelectData* data, BitArray& selectionOut )
{
    selectionOut = data->GetFaceSel();
}
void _getEdgeSelectionFun( IMeshSelectData* data, BitArray& selectionOut )
{
    selectionOut = data->GetEdgeSel();
}

BOOL _findCurrentSelection( INode* selectedNode, BitArray& selectionOut, getSelectionFunType getSelectionFunction )
{
    BOOL found = false;
    if( selectedNode )
    {
        // Get currently edited object
        Interface* iface = GetCOREInterface();
        BaseObject* curObject = iface->GetCurEditObject();

        IMeshSelectData* selectInterface = NULL;

        // We may get a modifier or geom object
        if ( curObject->SuperClassID() == OSM_CLASS_ID )
        {
            //  it is a modifier
            Modifier* mod = reinterpret_cast<Modifier*>( curObject );

            // we need the context, start looking from the selected object
            Object* selectedObject = selectedNode->GetObjectRef();
            while ( selectedObject )
            {
                IDerivedObject* derObject = ( selectedObject->SuperClassID() == GEN_DERIVOB_CLASS_ID ) ? reinterpret_cast<IDerivedObject*>( selectedObject ) : NULL;
                if ( derObject )
                {
                    // find the context of this modifier
                    for (int m=derObject->NumModifiers()-1; m >=0; --m)
                    {
                        if ( mod == derObject->GetModifier(m) )
                        {
                            ModContext* mc = derObject->GetModContext(m);
                            if (!mc) break;

                            LocalModData * mseldata = mc->localData;
                            if(!mseldata) break;

                            selectInterface = GetMeshSelectDataInterface( mseldata );
                            break;
                        }
                    }
                    // drop down one level the stack if we could not find "us"
                    selectedObject = (selectInterface) ? NULL : derObject->GetObjRef();
                }
                else
                {
                    selectedObject = NULL; // p_end of stack
                }
            }
        }
        else if( curObject->SuperClassID() == GEOMOBJECT_CLASS_ID )
        {
            // geom object
            Object* obj = reinterpret_cast<Object*>( curObject );
            selectInterface = GetMeshSelectDataInterface( obj );
            curObject = NULL; //exit
        }

        if( selectInterface )
        {
            (*getSelectionFunction)( selectInterface, selectionOut );
            found = true;
        }
    }
    return found;
}



BOOL hctSelectionUtilGUP::findCurrentVertexSelection( INode* selectedNode, BitArray& selectionOut )
{
    return _findCurrentSelection( selectedNode, selectionOut, &_getVertSelectionFun );
}

BOOL hctSelectionUtilGUP::findCurrentFaceSelection( INode* selectedNode, BitArray& selectionOut )
{
    return _findCurrentSelection( selectedNode, selectionOut, &_getFaceSelectionFun );
}

BOOL hctSelectionUtilGUP::findCurrentEdgeSelection( INode* selectedNode, BitArray& selectionOut )
{
    return _findCurrentSelection( selectedNode, selectionOut, &_getEdgeSelectionFun );
}


typedef void (*setSelFunType)(IMeshSelectData*, BitArray&, IMeshSelect*, TimeValue);
void _setVertSelFunc( IMeshSelectData* data, BitArray& selection, IMeshSelect* imod, TimeValue t )
{
    data->SetVertSel( selection, imod, t );
}
void _setFaceSelFunc( IMeshSelectData* data, BitArray& selection, IMeshSelect* imod, TimeValue t )
{
    data->SetFaceSel( selection, imod, t );
}
void _setEdgeSelFunc( IMeshSelectData* data, BitArray& selection, IMeshSelect* imod, TimeValue t )
{
    data->SetEdgeSel( selection, imod, t );
}

BOOL _overwriteNamedSelectionFromCurrent( INode* selectedNode, const MCHAR* selectionName, getNamesFunType getNamesFunction, getSelectionFunType getSelectionFunction, setSelFunType setSelectionFunction )
{
    IMeshSelect* imod;
    IMeshSelectData* data;
    BaseObject* baseObject;

    // find the current selection
    BitArray selection;
    BOOL found = _findCurrentSelection( selectedNode, selection, getSelectionFunction );
    if ( ! found ) return false;

    // find the object containing the named set
    if ( _findMeshSelectAndBaseObjectFromSelection( selectedNode, selectionName, &imod, &data, &baseObject, getNamesFunction ) )
    {
        Interface7* iFace7 = GetCOREInterface7();

        BaseObject* oldEditObj = iFace7->GetCurEditObject();
        iFace7->SetCurEditObject( baseObject );

        // set the selection as current in the object with the named set
        (*setSelectionFunction)(data, selection, imod, iFace7->GetTime() );

        MSTR nameStr( selectionName );
        // delete the old selection and save a new one with the same name from current selection
        baseObject->RemoveSubSelSet( nameStr );
        baseObject->NewSetFromCurSel( nameStr );

        if( oldEditObj ) iFace7->SetCurEditObject( oldEditObj );
        imod->LocalDataChanged();
        iFace7->NamedSelSetListChanged();
    }
    return found;
}


BOOL hctSelectionUtilGUP::overwriteNamedVertSelectionFromCurrent( INode* selectedNode, const MCHAR* selectionName )
{
    return _overwriteNamedSelectionFromCurrent( selectedNode, selectionName, &_getVertSelNames, &_getVertSelectionFun, &_setVertSelFunc);
}

BOOL hctSelectionUtilGUP::overwriteNamedFaceSelectionFromCurrent( INode* selectedNode, const MCHAR* selectionName )
{
    return _overwriteNamedSelectionFromCurrent( selectedNode, selectionName, &_getFaceSelNames, &_getFaceSelectionFun, &_setFaceSelFunc );
}

BOOL hctSelectionUtilGUP::overwriteNamedEdgeSelectionFromCurrent( INode* selectedNode, const MCHAR* selectionName )
{
    return _overwriteNamedSelectionFromCurrent( selectedNode, selectionName, &_getEdgeSelNames, &_getEdgeSelectionFun, &_setEdgeSelFunc );
}

BOOL _renameSelection( INode* selectedNode, const MCHAR* oldName, const MCHAR* newName, int subObjSelType )
{
    IMeshSelect* imod;
    IMeshSelectData* data;
    BaseObject* baseObject;

    bool found  = false;
    // find the object containing the selection
    if ( _findMeshSelectAndBaseObjectFromSelection( selectedNode, oldName, &imod, &data, &baseObject, _getSelNameFun(subObjSelType) ) )
    {
        Interface7* iFace7 = GetCOREInterface7();

        // Change to desired state
        iFace7->SetCurEditObject( baseObject );
        GetCOREInterface()->SetCommandPanelTaskMode( TASK_MODE_MODIFY );
        imod->SetSelLevel( subObjSelType );
        //

        // rename the set
        MSTR oldNameStr( oldName );
        MSTR newNameStr( newName );
        int numSets = baseObject->NumNamedSelSets();
        for ( int i=0; i<numSets; ++i)
        {
            if( baseObject->GetNamedSelSetName( i ) == oldNameStr )
            {
                baseObject->SetNamedSelSetName( i, newNameStr );
                break;
            }
        }
        imod->LocalDataChanged();
        iFace7->NamedSelSetListChanged();
        //
    }
    return found;
}

BOOL hctSelectionUtilGUP::renameVertSelection( INode* selectedNode, const MCHAR* oldName, const MCHAR* newName )
{
    return _renameSelection( selectedNode, oldName, newName, IMESHSEL_VERTEX );
}

BOOL hctSelectionUtilGUP::renameFaceSelection( INode* selectedNode, const MCHAR* oldName, const MCHAR* newName )
{
    return _renameSelection( selectedNode, oldName, newName, IMESHSEL_FACE );
}

BOOL hctSelectionUtilGUP::renameEdgeSelection( INode* selectedNode, const MCHAR* oldName, const MCHAR* newName )
{
    return _renameSelection( selectedNode, oldName, newName, IMESHSEL_EDGE );
}

BOOL _deleteSelection( INode* selectedNode, const MCHAR* name, int subObjectLevel )
{
    IMeshSelect* imod;
    IMeshSelectData* data;
    BaseObject* baseObject;


    bool found  = false;
    if ( _findMeshSelectAndBaseObjectFromSelection( selectedNode, name, &imod, &data, &baseObject, _getSelNameFun(subObjectLevel) ) )
    {
        Interface7* iFace7 = GetCOREInterface7();

        // Save old state
        BaseObject* oldEditObj = iFace7->GetCurEditObject();
        int oldTaskMode = GetCOREInterface()->GetCommandPanelTaskMode();
        int oldModSubObjLevel = imod->GetSelLevel();
        //

        // Change to desired state
        iFace7->SetCurEditObject( baseObject );
        GetCOREInterface()->SetCommandPanelTaskMode( TASK_MODE_MODIFY );
        imod->SetSelLevel( subObjectLevel );
        //

        // Remove selection set
        found  = true;
        MSTR nameStr( name );
        baseObject->RemoveSubSelSet( nameStr );
        imod->LocalDataChanged();
        iFace7->NamedSelSetListChanged();
        //

        // restore state
        if( oldEditObj ) iFace7->SetCurEditObject( oldEditObj );
        GetCOREInterface()->SetCommandPanelTaskMode( oldTaskMode );
        imod->SetSelLevel( oldModSubObjLevel );
        //
    }
    return found;
}

BOOL hctSelectionUtilGUP::deleteVertSelection( INode* selectedNode, const MCHAR* name )
{
    return _deleteSelection( selectedNode, name, IMESHSEL_VERTEX );
}

BOOL hctSelectionUtilGUP::deleteFaceSelection( INode* selectedNode, const MCHAR* name )
{
    return _deleteSelection( selectedNode, name, IMESHSEL_FACE );
}

BOOL hctSelectionUtilGUP::deleteEdgeSelection( INode* selectedNode, const MCHAR* name )
{
    return _deleteSelection( selectedNode, name, IMESHSEL_EDGE );
}


BOOL _loadVertSelection( INode* selectedNode, const MCHAR* name, int subObjectLevel )
{
    IMeshSelect* imod;
    IMeshSelectData* data;
    BaseObject* baseObject;

    bool found  = false;
    if ( _findMeshSelectAndBaseObjectFromSelection( selectedNode, name, &imod, &data, &baseObject, _getSelNameFun(subObjectLevel)) )
    {
        Interface7* iFace7 = GetCOREInterface7();

        iFace7->SetCurEditObject( baseObject );
        GetCOREInterface()->SetCommandPanelTaskMode( TASK_MODE_MODIFY );
        imod->SetSelLevel( subObjectLevel );

        found = true;
        MSTR nameStr( name );

        baseObject->ActivateSubSelSet( nameStr );

        imod->LocalDataChanged();
        iFace7->NamedSelSetListChanged();
    }
    return found;
}

BOOL hctSelectionUtilGUP::loadVertSelection( INode* selectedNode, const MCHAR* name )
{
    return _loadVertSelection( selectedNode, name, IMESHSEL_VERTEX );
}

BOOL hctSelectionUtilGUP::loadFaceSelection( INode* selectedNode, const MCHAR* name )
{
    return _loadVertSelection( selectedNode, name, IMESHSEL_FACE );
}

BOOL hctSelectionUtilGUP::loadEdgeSelection( INode* selectedNode, const MCHAR* name )
{
    return _loadVertSelection( selectedNode, name, IMESHSEL_EDGE );
}


void hctSelectionUtilGUP::applyAndCreateVertexSelection( INode* selectedNode, const MCHAR* selectionName, BitArray& selState, BaseObject* selModifier )
{
    if( !selectedNode )
    {
        return;
    }

    Tab<Class_ID> supportedClassIds;
    getSupportedVertSelectionsClassIds( supportedClassIds );


    Tab<IMeshSelectData*> meshSelectDataInterfaces;
    Tab<IMeshSelect*> meshSelectMods;
    Tab<BaseObject*> baseObjects;
    _findAllMeshSelectDataInterfaces( selectedNode, meshSelectDataInterfaces, supportedClassIds, &meshSelectMods, &baseObjects );

    // get a selection interface, the first we find
    if (    ( meshSelectDataInterfaces.Count() > 0 ) &&
            ( ( meshSelectMods.Count() == meshSelectDataInterfaces.Count() ) && ( baseObjects.Count() == meshSelectDataInterfaces.Count() ) )
            )
    {
        Interface7* iFace7 = GetCOREInterface7();

        // try to use the provided modifier, if none is provided or it's not valid pick the first one
        int modIdx = 0;
        if ( selModifier != NULL )
        {
            IMeshSelect* imod = GetMeshSelectInterface( selModifier );
            if ( imod != NULL )
            {
                for ( int i = 0; i < meshSelectMods.Count(); ++i )
                {
                    if ( imod == meshSelectMods[i] )
                    {
                        modIdx = i;
                        break;
                    }
                }
            }
        }

        IMeshSelect* imod = meshSelectMods[ modIdx ];
        IMeshSelectData* data = meshSelectDataInterfaces[ modIdx ];
        BaseObject* baseObj = baseObjects[ modIdx ];

        // we need to be in vertex selection mode
        if ( imod )
        {
            imod->SetSelLevel( IMESHSEL_VERTEX );

            iFace7->SetCurEditObject( baseObj );
            GetCOREInterface()->SetCommandPanelTaskMode( TASK_MODE_MODIFY );

            const TimeValue now = iFace7->GetTime();

            // perform selection
            data->SetVertSel( selState, imod, now );

            imod->LocalDataChanged();

            // If we received a name we can save the named selection
            if ( selectionName != NULL )
            {
                MSTR selectionNameStr( selectionName );
                if( selectionNameStr.length()>0 )
                {
                    createNamedSelectionFromCurrent( selectedNode, selectionName );
                }
            }

        }
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
