// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>
#include <ContentTools/Max/MaxSceneExport/GUP/ConvexDecomp/hctConvexDecompUtilityInterfaceImpl.h>
#include <ContentTools/Max/MaxSceneExport/GUP/ConvexDecomp/hctConvexDecompUtility.h>

static hctConvexDecompUtilityGUPInterfaceImpl g_convexDecompUtilGUPInterface
(
    HK_CONVEX_DECOMPOSITION_UTILITY_FPINTERFACE_ID, _T("hkConvexDecompUtilityInterface"), 0, getHkConvexDecompUtilityDesc(), 0,

    FPI_CheckValidity, _T("checkValidity"), 0, TYPE_BOOL, 0, 0,

    FPI_Decompose, _T("createDecomposition"), 0, TYPE_BOOL, 0, 12,
        _T("nodesIn"), 0, TYPE_INODE_TAB_BR,
        _T("nodesOut"), 0, TYPE_INODE_TAB_BR,
        _T("detachNodes"), 0, TYPE_BOOL,
        _T("singleOut"), 0, TYPE_BOOL,
        _T("guardTolerance"), 0, TYPE_DOUBLE,
        _T("hideMesh"), 0, TYPE_BOOL,
        _T("reduceOverlapPasses"), 0, TYPE_INT,
        _T("octreeDepth"), 0, TYPE_INT,
        _T("method"), 0, TYPE_INT,
        _T("reduceMethod"), 0, TYPE_INT,
        _T("witerations"), 0, TYPE_INT,
        _T("wconcacity"), 0, TYPE_DOUBLE,

    FPI_Combine, _T("doCombine"), 0, TYPE_BOOL, 0, 9,
        _T("baseNode"), 0, TYPE_INODE,
        _T("origMeshNodes"), 0, TYPE_INODE_TAB_BR,
        _T("nodesIn"), 0, TYPE_INODE_TAB_BR,
        _T("nodesOut"), 0, TYPE_INODE_TAB_BR,
        _T("accuracyCombine"), 0, TYPE_DOUBLE,
        _T("singleOutCombine"), 0, TYPE_BOOL,
        _T("generateGuards"), 0, TYPE_BOOL,
        _T("octreeDepth"), 0, TYPE_INT,
        _T("reduceMethod"), 0, TYPE_INT,

    p_end
);

BOOL hctConvexDecompUtilityGUPInterfaceImpl::iCheckValidity()
{
    return getConvexDecompUtilityInstance()->checkValidity();
}

BOOL hctConvexDecompUtilityGUPInterfaceImpl::iDecompose( Tab< INode* >& nodesIn, Tab< INode* >& nodesOut, BOOL detachParts, BOOL singleOut, double guardTolerance, BOOL hideMesh, INT reduceOverlapPasses, INT octreeDepth, INT method, INT reduceMethod, INT witerations, double wconcavity)
{
    return getConvexDecompUtilityInstance()->decompose( nodesIn, nodesOut, detachParts, singleOut, guardTolerance, hideMesh, reduceOverlapPasses, octreeDepth, method, reduceMethod, witerations, wconcavity);
}

BOOL hctConvexDecompUtilityGUPInterfaceImpl::iCombine ( INode* baseNode, Tab< INode* >& origMeshNodes, Tab<INode*>& nodesIn, Tab< INode* >& nodesOut, double accuracyCombine, BOOL singleOutCombine, BOOL genGuards, INT octreeDepth, INT reduceMethod )
{
    return getConvexDecompUtilityInstance()->combine( baseNode, origMeshNodes, nodesIn, nodesOut, accuracyCombine, singleOutCombine, genGuards, octreeDepth, reduceMethod );
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
