// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Max/MaxFpInterfaces/ConvexDecomp/hctConvexDecompositionUtilityInterface.h>
#include <ContentTools/Common/ConvexDecompUtils/hctConvexDecompUtils.h>

class hkPseudoRandomGenerator;

// Access to the class description and the single utility instance
ClassDesc2* getHkConvexDecompUtilityDesc();
class hctConvexDecompUtilityGUP* getConvexDecompUtilityInstance();

//
// Restore object to hide decomposed meshes
//
class HideRestore : public RestoreObj
{
public:
    HideRestore( Tab< INode* > n ) : nodes(n) {}
    ~HideRestore(){}

    void Restore( int undo )
    {
        for ( int i = 0; i < nodes.Count(); ++i )
        {
            nodes[i]->Hide( false );
        }
    }
    void Redo()
    {
        for ( int i = 0; i < nodes.Count(); ++i )
        {
            nodes[i]->Hide( true );
        }
    }
    int Size()
    {
        return sizeof( Tab< INode* > );
    }
    MSTR Description()
    {
        return MSTR( _T( "Node hidden" ) );
    }
    void EndHold()
    {
        for ( int i = 0; i < nodes.Count(); ++i )
        {
            nodes[i]->ClearAFlag( A_HELD );
        }
    }

private:
    Tab< INode* > nodes;
};

//
// Implement progress bar job-handler
//
class hctMaxConvexDecompProgressHandler : hctConvexDecompProgressHandler
{
public:
    hctMaxConvexDecompProgressHandler(){}
    ~hctMaxConvexDecompProgressHandler(){}

    // Update progress bar based on job added by callback function
    virtual void processJobs();
    virtual void setupBar();
    virtual void cleanupBar( const bool result );
};

//
// Implement GUP interface
//
class hctConvexDecompUtilityGUP : public GUP
{
public:

    //
    // Results displayed in toolbox
    //
    struct hctConvexDecompResults
    {
        int nInShapes;
        int nInTriangles;
        int nInPlanes;
        int nOutShapes;
        int nOutPlanes;

        hctConvexDecompResults(){ reset(); }
        void reset()
        {
            nInShapes = nInTriangles = nInPlanes = nOutShapes = nOutPlanes = 0;
        }
    };

    //
    // GUP Methods
    //
    DWORD Start();
    void Stop();
    DWORD_PTR Control( DWORD parameter ) {return 0;}

    hctConvexDecompUtilityGUP(){ m_randomColorSeed = 0; }
    ~hctConvexDecompUtilityGUP(){}

    virtual void DeleteThis() {};

    //
    // Convex decomposition Methods
    //
    BOOL checkValidity();
    BOOL decompose (Tab< INode* >& nodesIn, Tab< INode* >& nodesOut, BOOL detachParts, BOOL singleOut, double guardTolerance, BOOL hideMesh, INT reduceOverlapPasses, INT octreeDepth, INT method, INT reduceMethod, INT witerations, double wconcavity );
    BOOL combine (INode* baseNode, Tab< INode* >& origMeshNodes, Tab< INode* >& nodesIn, Tab< INode* >& nodesOut, double accuracyCombine, BOOL singleOutCombine, BOOL genGuards, INT octreeDepth, INT reduceMethod );

private:
    static const int m_triangleWarningThreshold = 20000;
    int m_randomColorSeed;
    hctConvexDecompUtils* m_convexDecompUtils;

    bool createGeometryFromSingleNode (INode* baseMesh, INode* node, hkGeometry &geometry, hctConvexDecompResults& results );
    bool createGeometryFromBaseNode( INode* baseNode, hkGeometry& geometryFromScene, hctConvexDecompResults& results );
    BOOL createGeometryFromOrigNodes( INode* baseNode, Tab< INode* >& origMeshNodes, hkGeometry& geometryFromScene, hctConvexDecompResults& results );
    bool createVertexArrayFromNodes( INode* baseNode, Tab< INode* >& nodesIn, hkArray< hkArray< hkVector4 > >& shapesToCombine, hctConvexDecompResults& results );
    bool displayWarning( const hctConvexDecompResults& results, const bool isDecompose );
    void createOutputNodesFromPoints(INode* mainNode, hkArray< hkArray< hkVector4 > >& shapes, Tab< INode* >& nodesOut, hctConvexDecompResults& results, const BOOL& singleNodeOutput, const hkTransform* normalizedToWorld );
    void createNodeFromGeometry( hkGeometry& geometry, INode* mainNode, Tab< INode* >& nodesOut, hctConvexDecompResults& results, hkPseudoRandomGenerator& randomGenerator, const hkTransform* normalizedToWorld );
    void selectOutputNodes( Tab< INode* >& nodesOut );
    void hideOriginalMesh( Tab< INode* >& nodesIn );
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
