// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Max/MaxFpInterfaces/ConversionUtil/hctConversionUtilGUPInterface.h>

// Access to the class descriptor
extern ClassDesc2* getHkConversionUtilGUPDesc();

// Access the only instance of the utility
class hctConversionUtilGUP* getConversionUtilGUPInstance ();

/*===========================================================================*\
 | Definitions for the toolbar items themselves
\*===========================================================================*/
class hctConversionUtilGUP : public GUP
{
    public:

        // GUP Methods
        DWORD   Start();
        void    Stop();
        DWORD_PTR   Control( DWORD parameter ) {return 0;}

        //Constructor/Destructor
        hctConversionUtilGUP(){}
        ~hctConversionUtilGUP(){}

        // Interface Methods (interface forwards here)

        // Converts the current vertex selection to vertex colors using the provided VertexPaint modifier
        // selected and unselected vertices are mapped to "selectedValue" and "unselectedValue" luminance colors respectively
        void convertSelectionToVertexChannel( INode* selectedNode, ReferenceTarget* vpModifier, FLOAT selectedValue, FLOAT unselectedValue );
        // Converts the channelID vertex colors to a vertex selection, where colors >= "thresholdValue" yield selected vertices
        // The new selection is named "SelectionName" if the name provided in not NULL
        void convertVertexChannelToSelection( INode* selectedNode, ReferenceTarget* vpModifier, FLOAT thresholdValue, BOOL invert, const MCHAR* SelectionName );

        // Assign vertex colors to the selectedNode using the supplied Vertex Paint modifier and channel ID
        void assignVertexColors( INode* selectedNode, ReferenceTarget* vpModifier, INT channelID, BOOL byVertex );

        static TriObject* extractTriObjectFromObject( TimeValue t, Object* obj, bool& deleteTriObject );

        virtual void DeleteThis() {};

};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
