// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>

#include <ContentTools/Max/MaxSceneExport/GUP/ConversionUtil/hctConversionUtilGUP.h>
#include <ContentTools/Max/MaxSceneExport/GUP/SelectionUtil/hctSelectionUtilGUP.h>


/*===========================================================================*\
| Class Descriptor for the CUITest plugin
\*===========================================================================*/

class hkConversionUtilGUPClassDesc : public ClassDesc2
{
public:
    int             IsPublic() { return 1; }
    void *          Create(BOOL loading = FALSE) { return getConversionUtilGUPInstance(); }
    const MCHAR *   ClassName() { return GetString(IDS_CONVERSION_UTIL_GUP_CLASS_NAME); }
    SClass_ID       SuperClassID() { return GUP_CLASS_ID; }
    Class_ID        ClassID() { return HK_CONVERSION_UTIL_GUP_CLASS_ID; }
    const MCHAR*    Category() { return GetString(IDS_CONVERSION_UTIL_GUP_CATEGORY); }
    const MCHAR*    InternalName() { return _T("hkConversionUtilGUP"); }    // returns fixed parsable name (scripter-visible name)
    HINSTANCE       HInstance() { return hInstance; }               // returns owning module handle
};

ClassDesc2* getHkConversionUtilGUPDesc()
{
    static hkConversionUtilGUPClassDesc ConversionUtilGUPDesc;
    return &ConversionUtilGUPDesc;
}



// Access the only instance of the GUP
hctConversionUtilGUP* getConversionUtilGUPInstance ()
{
    static hctConversionUtilGUP theInstance;
    return &theInstance;
}


/*===========================================================================*\
| The Begin/EndEditParams calls, which create and destroy the toolbar
\*===========================================================================*/

DWORD hctConversionUtilGUP::Start()
{
    return GUPRESULT_KEEP;
}
void hctConversionUtilGUP::Stop()
{
}


TriObject* hctConversionUtilGUP::extractTriObjectFromObject( TimeValue t, Object* obj, bool& deleteTriObject )
{
    // We ask the object to convert itself to a TriObject
    if ( (obj==NULL) || !obj->CanConvertToType(Class_ID(TRIOBJ_CLASS_ID,0)) )
    {
        return HK_NULL;
    }
    TriObject* triObject = reinterpret_cast<TriObject*>( obj->ConvertToType( t, Class_ID(TRIOBJ_CLASS_ID,0) ) );
    // if the two pointers are different the new one was created for us
    deleteTriObject = ( obj != triObject );

    return triObject;
}

IVertexPaint* _findVertexPaintInterface( INode* selectedNode, int channelID )
{
    if( selectedNode )
    {
        Object* curObject = selectedNode->GetObjectRef();
        while ( curObject)
        {
            IDerivedObject* devObject = curObject->SuperClassID() == GEN_DERIVOB_CLASS_ID? reinterpret_cast<IDerivedObject*>(curObject) : NULL;
            if (devObject) // has modifiers
            {
                // check each modifier
                for (int m = devObject->NumModifiers()-1; m >=0 ; --m)
                {
                    Modifier* mod = devObject->GetModifier( m );
                    Class_ID modClassID = mod->ClassID();

                    // is it a vertex paint modifier?
                    if ( mod->IsEnabled() && ( modClassID == PAINTLAYERMOD_CLASS_ID ) )
                    {
                        // get the interface
                        IVertexPaint* iVertexPaint = (IVertexPaint*)mod->GetInterface( IVERTEXPAINT_INTERFACE_ID );

                        // check if the map channel corresponds
                        IVertexPaint::Options options;
                        iVertexPaint->GetOptions( options );
                        if ( options.mapChannel == channelID )
                        {
                            // if so we found it
                            return iVertexPaint;
                        }
                    }
                }

                curObject = devObject->GetObjRef(); // drop down one level the stack
            }
            else
            {
                curObject = HK_NULL;
            }
        }
    }

    return HK_NULL;
}


void hctConversionUtilGUP::convertSelectionToVertexChannel( INode* selectedNode, ReferenceTarget* vpModifier, FLOAT selectedValue, FLOAT unselectedValue )
{
    if( !selectedNode )
    {
        return;
    }

    Interface7* iFace7 = GetCOREInterface7();
    const TimeValue now = iFace7->GetTime();
    Object *obj = selectedNode->EvalWorldState( now ).obj;

    // will be true if the triObject will be created for us
    bool deleteTriObject = false;
    TriObject* triObject = extractTriObjectFromObject( now, obj, deleteTriObject );

    // get the mesh
    Mesh& theMesh = triObject->GetMesh();

    if( ( vpModifier != NULL ) && ( vpModifier->ClassID() == PAINTLAYERMOD_CLASS_ID ) )
    {
        // Colors for selected and unselected vertices
        Color selectedColor( selectedValue, selectedValue, selectedValue );
        Color unselectedColor( unselectedValue, unselectedValue, unselectedValue );

        // Get the selection
        BitArray selState = theMesh.VertSel();

        // make the vertex paint mod the current one
        iFace7->SetCommandPanelTaskMode( TASK_MODE_MODIFY );
        iFace7->SetCurEditObject( static_cast<Modifier*>( vpModifier ) );

        // get the interface from the modifier
        IVertexPaint* vpInterface = (IVertexPaint*)vpModifier->GetInterface( IVERTEXPAINT_INTERFACE_ID );
        // get the map channel
        IVertexPaint::Options options;
        vpInterface->GetOptions( options );
        const int channelID = options.mapChannel;

        // get the mesh again after the modifier has been selected
        if( deleteTriObject )
        {
            delete triObject;
        }
        /*Object **/obj = selectedNode->EvalWorldState( now ).obj;
        /*TriObject* */triObject = extractTriObjectFromObject( now, obj, deleteTriObject );
        // get the mesh
        /*Mesh& */theMesh = triObject->GetMesh();

        // perform conversion
        if ( vpInterface && theMesh.mapSupport( channelID ) )
        {
            // prepare vertex color Tab
            IVertexPaint::VertColorTab vertColors;
            vertColors.SetCount( theMesh.getNumMapVerts( channelID ) );

            // Face info
            int numFaces = theMesh.getNumFaces();
            Face* faces = theMesh.faces;

            // check selection state consistency
            const int numVerts = theMesh.getNumVerts();
            if ( selState.GetSize() != numVerts )
            {
                return;
            }

            // fill color array
            for(int faceIdx = 0; faceIdx<numFaces; ++faceIdx)
            {
                const int idx0 = faces[faceIdx].getVert( 0 );

                const int idx1 = faces[faceIdx].getVert( 1 );

                const int idx2 = faces[faceIdx].getVert( 2 );

                vertColors[ idx0 ] = ( selState[ idx0 ] ) ? &selectedColor : &unselectedColor;
                vertColors[ idx1 ] = ( selState[ idx1 ] ) ? &selectedColor : &unselectedColor;
                vertColors[ idx2 ] = ( selState[ idx2 ] ) ? &selectedColor : &unselectedColor;
            }

            // set colors
            vpInterface->SetColors( selectedNode, vertColors );
        }
    }

    // if the obj != triobject, it means that the triobj has been created for us, and we will have to destroy it
    if( deleteTriObject )
    {
        delete triObject;
    }
}



void hctConversionUtilGUP::convertVertexChannelToSelection( INode* selectedNode, ReferenceTarget* vpModifier, FLOAT thresholdValue, BOOL invert, const MCHAR* SelectionName )
{
    if( !selectedNode )
    {
        return;
    }

    Interface7* iFace7 = GetCOREInterface7();
    {
        const TimeValue now = iFace7->GetTime();

        // will be true if the triObject will be created for us
        bool deleteTriObject = false;

        TriObject* triObject = NULL;

        if( ( vpModifier != NULL ) && ( vpModifier->ClassID() == PAINTLAYERMOD_CLASS_ID ) )
        {
            // Colors for selected and unselected vertices
            Color thresholdColor( thresholdValue, thresholdValue, thresholdValue );

            // Selection values
            const int aboveThreshold = ( invert ) ? 0 : 1;
            const int belowThreshold = ( invert ) ? 1 : 0;

            BaseObject* selMod = iFace7->GetCurEditObject();

            // make the vertex paint mod the current one
            iFace7->SetCommandPanelTaskMode( TASK_MODE_MODIFY );
            iFace7->SetCurEditObject( static_cast<Modifier*>( vpModifier ) );

            // get the interface from the modifier
            IVertexPaint* vpInterface = (IVertexPaint*)vpModifier->GetInterface( IVERTEXPAINT_INTERFACE_ID );
            // get the map channel
            IVertexPaint::Options options;
            vpInterface->GetOptions( options );
            const int channelID = options.mapChannel;

            // get the mesh after the modifier has been selected
            Object *obj = selectedNode->EvalWorldState( now ).obj;

            /*TriObject* */triObject = extractTriObjectFromObject( now, obj, deleteTriObject );
            // get the mesh
            Mesh& theMesh = triObject->GetMesh();

            if( theMesh.mapSupport( channelID ) )
            {
                // prepare data array
                const int numVerts = theMesh.getNumVerts();

                BitArray selState;
                selState.SetSize( numVerts );

                // number of faces
                int numFaces = theMesh.getNumFaces();

                // faces and texture faces
                Face* faces = theMesh.faces;
                TVFace* tFaces = theMesh.mapFaces( channelID );

                // painted values
                UVVert* values = theMesh.mapVerts( channelID );

                for ( int fi = 0; fi < numFaces; ++fi )
                {
                    Face& i_face = faces[ fi ];
                    TVFace& i_tFace = tFaces[ fi ];

                    {
                        const int idx0 = i_face.getVert( 0 );
                        const int idx1 = i_face.getVert( 1 );
                        const int idx2 = i_face.getVert( 2 );

                        const int vert0 = i_tFace.getTVert( 0 );
                        const int vert1 = i_tFace.getTVert( 1 );
                        const int vert2 = i_tFace.getTVert( 2 );

                        selState.Set( idx0, ( values[ vert0 ][0] >= thresholdColor[0] )? aboveThreshold : belowThreshold );
                        selState.Set( idx1, ( values[ vert1 ][0] >= thresholdColor[0] )? aboveThreshold : belowThreshold );
                        selState.Set( idx2, ( values[ vert2 ][0] >= thresholdColor[0] )? aboveThreshold : belowThreshold );
                    }
                }

                // we should have a selection modifier selected, try to use it. If it's not good the first available one will
                // be picked.
                getSelectionUtilGUPInstance()->applyAndCreateVertexSelection( selectedNode, SelectionName, selState, selMod );
            }

        }



        // if the obj!=triobject, it means that the triobj has been created for us, and we will have to destroy it
        if( deleteTriObject )
        {
            delete triObject;
        }
    }
}


void hctConversionUtilGUP::assignVertexColors( INode* selectedNode, ReferenceTarget* vpModifier, INT channelID, BOOL byVertex )
{
    if ( selectedNode == NULL )
    {
        return;
    }

    // find the vertex paint modifier
    if( ( vpModifier != NULL ) && ( vpModifier->ClassID() == PAINTLAYERMOD_CLASS_ID ) )
    {
        IAssignVertexColors_R7* assignVCIface = ( IAssignVertexColors_R7* ) GetCOREInterface( IASSIGNVERTEXCOLORS_R7_INTERFACE_ID );
        if ( assignVCIface )
        {
            IAssignVertexColors_R7::Options2 options;
            options.mapChannel = channelID;
            options.lightingModel = LightingModel::kShadedOnly;
            options.mixVertColors = (byVertex == 1);
            options.castShadows = false;
            options.useMaps = true;
            options.useRadiosity = false;
            options.reuseIllumination = false;
            assignVCIface->SetOptions2( options );

            Tab<INode*> nodes; nodes.Append( 1, &selectedNode );

            assignVCIface->ApplyNodes( &nodes, vpModifier );
        }
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
