// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Common/SceneExport/Filters/hctFilterProcessingUtil.h>
#include <ContentTools/Common/SceneExport/AttributeProcessing/hctAttributeProcessingUtil.h>
#include <ContentTools/Common/SceneExport/AttributeSelection/hctAttributeSelectionUtil.h>
#include <ContentTools/Common/SceneExport/Utils/hctSceneExportUtils.h>
#include <ContentTools/Common/SdkUtils/hctSdkUtils.h>
#include <Common/SceneData/Scene/hkxScene.h>
#include <Common/SceneData/Graph/hkxNode.h>

#include <ContentTools/Max/MaxSceneExport/Exporter/MeshWriter/hctMaxMeshWriter.h>

#include <Common/Base/Serialize/ResourceHandle/hkResourceHandle.h>

#include <vector>

    // Options used during export. They reflect the options set by the user in the UI.
    // Check the 3ds max Exporter documentation for details on the meaning of each option.
struct hctMaxSceneExportOptions
{
    hctMaxSceneExportOptions();

    bool m_batchMode;
    hkStringOld m_optionsFile;
    bool m_visibleOnly;
    bool m_selectedOnly;
    bool m_expandSelectionToChildren; // if A->B->C  and B selected, export C too (easier for artists normaly)
    bool m_expandSelectionToParents;  // if A->B->C  and B selected, export A too (normally do want this except for partial anims etc)
    bool m_expandSelectionToSkeleton; // if A->B->C, A->B->D  and B selected, and all bones, export all bones so {A,B,C,D}
    TimeValue m_animationStart;
    TimeValue m_animationEnd;
    bool m_exportMeshes;
    bool m_exportMaterials;
    bool m_exportAttributes;
    bool m_exportAnnotations;
    bool m_exportLights;
    bool m_exportCameras;
    bool m_exportSplines;
    bool m_exportVertexTangents;
    bool m_exportVertexAnimations;
    bool m_respectModifierSkinPose;
    bool m_autoSkinAttachments;
    bool m_exportWireColorsAsVertexColors;
    bool m_exportMergeVertsOnlyIfSameSrcId;
    hkArray<TimeValue> m_forceVertexAnimationSamplePoints;
    bool m_addDefaultCamera;
    bool m_doNotSplitVertices;
    hkStringOld m_environmentVariables;
    hkStringOld m_configurationSet;
    bool m_storeKeyframeSamplePoints;
};

struct hctFilterSetOptions
{
    // Filter options storage.
    DWORD m_version;
    Tab<char> m_data;
};

//
// This class is responsible for doing the export, is invoked by the utility, but is independent of it
//
class hctMaxSceneExporter
{

    public:

            // Constructor and destructor.
        hctMaxSceneExporter(const hctMaxSceneExportOptions& exportOptions, hctFilterSetOptions& filterSetOptions);
        ~hctMaxSceneExporter();

            // Does the full job : loads the filter manager, exports and invokes it
        bool exportAndProcess();

        bool getFileDependencies(hkArray<hkStringPtr>& fileDependencies);

        bool createScene(bool callStartEndProgress = true, bool updateProgress = true);
        hkRootLevelContainer* getCurrentRootContainer() { return m_currentRootContainer; }
        void cleanupScene();

    private:

            // Give the mesh writer access to the scene.
        friend class hctMaxMeshWriter;

            // Const references to the options passed to the constructor
        const hctMaxSceneExportOptions& m_exportOptions;
        int m_configurationSetIndex;
        hctFilterSetOptions& m_filterSetOptions;

            // A structure that represents the top level container
            // class for scene data, but that has mem managed arrays
            // so that we can store the data easier.
        struct ResizeableScene
        {
            hkRefPtr< hkxNode > m_rootNode;
            hkArray< hkRefPtr< hkxCamera > > m_cameras;
            hkArray< hkRefPtr< hkxLight > > m_lights;
            hkArray< hkRefPtr< hkxMesh > > m_meshes;
            hkArray< hkRefPtr< hkxSpline > > m_splines;
            hkArray< hkRefPtr< hkxMaterial > > m_materials;
            hkArray< hkRefPtr< hkxTextureFile > > m_externalTextures;
            hkArray< hkRefPtr< hkxSkinBinding > > m_skinBindings;
            hkArray< hkRefPtr< hkxNodeSelectionSet > > m_selectionSets;

            inline void clear()
            {
                m_rootNode = HK_NULL;
                m_cameras.setSize(0);
                m_lights.setSize(0);
                m_meshes.setSize(0);
                m_splines.setSize(0);
                m_materials.setSize(0);
                m_externalTextures.setSize(0);
                m_skinBindings.setSize(0);
                m_selectionSets.setSize(0);
            }
        };

            // An array-based representation of the scene
        ResizeableScene m_currentScene;

            // Navigates the scene and fills m_currentScene
        void exportAll( bool updateProgress );

            // Checks for duplicated names in the scene and warns the user if so
        void checkForDuplicatedNames(class hkxScene& scene);

            // Exports one node - and recurses
        hkxNode* exportNode( INode* inode, bool parentTreeHasBones, bool ancestorWasSelected, bool updateProgress );

            // Adds object level named selection sets to m_currentScene
        void exportNodeSelectionSets();

            // General properties of the scene
        float getSceneLength();
    int getNumFrames();

            // Type checking
        bool isBone (INode* inode) const;
        bool isBipedBone (INode* inode) const;
        bool isFootSteps (INode* inode) const;
        bool isMesh (INode* inode) const;
        bool isLight (INode* inode) const;
        bool isCamera (INode* inode) const;
        bool isSpline (INode* inode) const;

            /// Lights, Cameras, Nurbs..
        hkxLight* processLight(INode* node);
        hkxCamera* processCamera(INode* node);
        hkxSpline* processSpline(INode* node);

            /// EXP-69 : Creates a default camera based on the perspective viewport
        hkxCamera* createDefaultCamera();

            /// Mesh
        void processPolyMesh(INode *inode, hkRefVariant& object, bool forceSkinned);

            /// As skins are exported as the hkxNodes are being created, we probably won't have
            /// all the hkxNodes at construction time. It's easy to simply pop back afterwards
            /// and fix up all the pointers (provided the ID of the node is in there at call time,
            /// which it may not be if an option such as exportSelected has been chosen; in such cases
            /// the skin binding cannot be fixed up and is removed from the scene, while the mesh remains).
        void fixupSkins();

            /// Annotations (Note Tracks).
        void addAnnotations( INode* inode, hkxNode* hknode );

            /// Attributes
        hkResult convertSingleAttrib(const class hctCommonParameterInterface& pblock, int idx, hkxAttribute& attributeOut, const hkReflect::Type* klass);
        hkxAttributeGroup* convertAttribGroup( const class hctCommonParameterInterface& pblock, bool exportAll, ReferenceTarget* curObject );
        void exportAttributes(ReferenceTarget* curObject, hkArray<hkxAttributeGroup>& groups);

            // Lookup for attributes so that they can be given proper type info etc - loaded from .xml file
            // in exportAndProcess()
        hctAttributeProcessingUtil m_attributeProcessing;

            // Utility to select attributes based on user-defined settings (EXP-868)
        hctAttributeSelectionUtil m_attributeSelection;
        hctAttributeSelectionUtil::UserAction filterAttribute (const class hctCommonParameterInterface& pblock, int paramIndex);

        hctMaxMeshWriter m_meshWriter;
        hctFilterProcessingUtil m_filters;      // to manage the manager and the filters
        hkRootLevelContainer*   m_currentRootContainer;

        void countNumberOfNodesInScene();
        int m_totalNumNodes;
        int m_curNodeIndex; // for progress bar

        int m_iStaticFrame;

        // ANIMATION PRE-COMPUTE:

            // Looks for animated nodes and samples them all together
        void precomputeAnimation(bool updateProgress);

        static void HK_CALL assignHkxSceneUUIDs(hkxScene* scene);
        static void HK_CALL assignHkxNodeUUID(hkxNode* node, hkArray<char>& memBuffer, hkMap<hkUuid, int>& knownUUIDs);

            // We query all nodes that are animated at the same time so
            // as to favour the internal scene graph state caching in Max
        struct AnimationTrack
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_EXPORT, AnimationTrack);
            AnimationTrack() {} // for the object arrays
            AnimationTrack(const AnimationTrack& other ) { *this = other; }// for the object arrays
            hkArray<hkMatrix4> m_keyFrames;
            AnimationTrack& operator=(const AnimationTrack& other) { m_keyFrames = other.m_keyFrames; return *this; }// for the object arrays
        };

        hkArray<INode*> m_animatedNodes;
        hkArray< AnimationTrack > m_animatedNodeTracks;
        hkPointerMap< const INode*, hkxNode*> m_nodeMap;

            // Calculates the node local tm, taking stretch TM into consideration
        static Matrix3 calculateNodeLocalTM (const INode* node, TimeValue time);

            // Calculates the node world tm, taking stretch TM into consideration
        static Matrix3 calculateNodeWorldTM (const INode* node, TimeValue time);

            // Gets the filter options to use into the filter manager : either from the asset, the registry, or user-specified file
        bool loadFilterSetOptions();

            // Stores the filter options in the registry and the asset
        void saveFilterSetOptions();

            // EXP-861
            // We keep a map from max objects exported to havok meshes exported.
            // This doesn't include skins (we don't support skin instancing).
            // We also use the offset transform (object to local) as meshes will be modified based on that
        struct ExportedMeshInstanceData
        {
            Object* m_maxObject;
            Matrix3 m_objectToLocal;
            hkxMesh* m_havokMesh;
        };
        hkArray<ExportedMeshInstanceData> m_exportedMeshesInstanceData;
        hkxMesh* lookForAlreadyExportedMesh (INode* node);
        void registerExportedMesh (INode* inode, hkxMesh* mesh);

        bool createGenericObjectsFromMaxNodes(hkMemoryResourceContainer* resourceContainer);
        void createGenericObjectsFromMaxNodesRecursive(hkArray<INode*>& nodePath, hkMemoryResourceContainer* resourceContainer);
        const hkReflect::Type* getClassFromMaxModifier(Modifier* modifier);
        hkReflect::Var createEmptyHavokObject(const hkReflect::Type* klass);
        void convertMaxModifierToClassAndObject(Modifier* maxModifier, class hkResourceHandle* resourceHandle, const char* nodeName, INode* maxNode);
        void attributeToClassMember(int pblockIndex, const hkReflect::Var& field, const char* memberPathAndName, const hctCommonParameterInterface& pblock, hkResourceHandle* resourceHandle, const char* nodeName, INode* maxNode);
        void collectINodesRecursively(INode* iNode, hkArray<INode*>& iNodesOut);

};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
