// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#define MAX_EXPORTED_CHANNELS 99
#define INPLACE_CHANNEL_SIZE 6

#include <Common/SceneData/Material/hkxMaterial.h>
#include <ContentTools/Common/SceneExport/Userchannel/hctUserChannelUtil.h>
#include <deque>

class hctCommonSkinInterface;

struct ExportChannel
{
    hkStringOld m_channnelExportName;
    int m_channelID;
    int m_channelType;
    float m_rescaleMin;
    float m_rescaleMax;

    ExportChannel() : m_channnelExportName(""), m_channelID(-1), m_channelType(-1), m_rescaleMin(.0f), m_rescaleMax(1.0f) {}
};

// Utility class internally used to handle the creation of Havok meshes and skins from 3ds max objects
class hctMaxMeshWriter
{
    public:

        hctMaxMeshWriter (const struct hctMaxSceneExportOptions& exportOptions);
        ~hctMaxMeshWriter();

        // we set the owner spo that the mem can be added to the tracked mem
        // and the scene have all materials etc added.
        void setOwner(class hctMaxSceneExporter* owner) { m_owner = owner; }

        // Safe to call init() mulitple times to reuse the array storage etc for subsequent meshes.
        // Call init, then extract, then write.
        BOOL init( INode* inode, int staticFrame);
        BOOL extract();
        // will write into the owners scene data all materials etc found that are not already exported.
        void write( hkxMesh*& writtenMesh, hkxSkinBinding*& writtenSkin, bool forceSkinned );
        void cleanup();

        struct FullVert
        {
            int vertIndex;
            int faceIndex;
            int vertColorIndex;
            int alphaIndex;
            int texCoordIndex;
            int matId;
            int normalId;
            int faceVertexIndexHint; // for Explicit Normal support

            DWORD m_smoothingGroup;
            hkInplaceArray<DWORD,INPLACE_CHANNEL_SIZE> mapChannels;
        };

    protected:

        const hctMaxSceneExportOptions& m_exportOptions;

        // Output methods
        hkxMaterial* findMaterialMatch( Mtl* keyMat, const hkArray<Mtl*>& matsUsed);
        void createMaterial( Mtl* keyMat, const hkArray<Mtl*>& mats, const hkArray<int>& blends, hkxMaterial*& newMat, hkArray<int>& usedChannels );
        void createMaterialDX( class IDxMaterial* dxMat, hkxMaterial* newMat, hkArray<int>& usedChannels );

        void createTextures( const hkArray<Mtl*>& mats, const hkArray<int>& blends, hkArray< hkxMaterial::TextureStage >& newTextures, hkArray<int>& textureChannels, hkArray<int>& textureBlends );
        void createSkin( hkxMesh*& newMesh, hkxSkinBinding*& newSkin );
        void createPhysiqueSkin (IPhysiqueExport * physique, hkxMesh*& newMesh, hkxSkinBinding*& newSkin );
        void getAllExportChannels( hkArray<ExportChannel>& exportChannelsOut );
        void createMesh( hkxMesh*& newMesh, hkArray<float>* weights = NULL, hkArray<int>* indices = NULL, Matrix3* worldTM = NULL, bool useInt8BoneIndices = true);
        void createVertexBuffer( class hkxVertexBuffer*& newVB, std::deque<FullVert>& verts, hkArray<float>* weights, hkArray<int>* indices, hkArray<int>* channelIDs, bool hasMaterial, Matrix3* worldTM = NULL, bool useInt8BoneIndices = true);
        void getSpecularParameters(hkxMaterial& mat, Mtl* pMaxMtl);
        hkxVertexAnimation* getVertexAnimation( INode* pNode, const hkxMeshSection* section, hkxVertexAnimationStateCache& c, const hctUserChannelUtil::SectionToGlobalMap& dataMap, int sampleTicks );

        void addSelectionChannels (class hctUserChannelUtil& userChannelUtil);

        // Formats the channel ID and retrieves the channel name from the INode
        static bool getMeshChannelName (INode* inode, int channelId, MSTR& nameOut);

        hkxTextureFile* findTextureByBitmap(BitmapTex* tex);
        hkPointerMap<BitmapTex*, class hkxTextureFile*> m_exportedFileTextures;
        hkPointerMap<Texmap*, class hkxTextureInplace*> m_exportedInplaceTextures;

        struct UniqueMatConversion
        {
            Mtl* keyMtl;
            hkArray<Mtl*> usedMats;
            hkxMaterial* result;
        };
        hkArray<UniqueMatConversion> m_exportedMaterials;

        int m_iStaticFrame;

        Mesh* m_mesh;
        hctCommonSkinInterface* m_skin;
        INode* m_inode;
        TriObject* m_triObject;
        bool m_deleteTriObject;

        bool m_wasntAMesh; //EXP-848

        hctMaxSceneExporter* m_owner;
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
