// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

void toggleAllParentINodeBindPose(INode* pNode, bool bMode);

//
// We use a common interface to 3ds Max standard Skin modifier and the Physique modifier
//
class hctCommonSkinInterface
{
    public:

        virtual ~hctCommonSkinInterface() {}
        virtual int getNumSkinnedVerts () const =0;

        // Should return false if the skin is not initialized
        virtual bool initialize() = 0;

    virtual bool toggleSkinPose(bool enable, INode* node = HK_NULL) = 0;

        virtual int getNumVertexBones (int vertex) const=0;
        virtual float getVertexBoneWeight (int vertex, int bone) const = 0;
        virtual const INode* getVertexBoneNode (int vertex, int bone) const = 0;
};

// Implementation for the Skin Modifier
class hctStandardSkinInterface : public hctCommonSkinInterface
{
    public:

        hctStandardSkinInterface (ISkin* skinMod, INode* node);

        /*virtual*/ bool initialize ();

    /*virtual*/ bool toggleSkinPose(bool enable, INode* node = HK_NULL);

    /*virtual*/ int getNumSkinnedVerts () const;
        /*virtual*/ int getNumVertexBones (int vertex) const;
        /*virtual*/ float getVertexBoneWeight (int vertex, int bone) const;
        /*virtual*/ const INode* getVertexBoneNode (int vertex, int bone) const;

    private:

        ISkin* m_skinMod;
        ISkinContextData* m_contextData;
        INode* m_inode;
};

// Implementation for the Physique Modifier
class hctPhysiqueSkinInterface : public hctCommonSkinInterface
{
    public:

        hctPhysiqueSkinInterface (IPhysiqueExport* physiqueMod, INode* node);

        ~hctPhysiqueSkinInterface();

        /*virtual*/ bool initialize ();

    /*virtual*/ bool toggleSkinPose(bool enable, INode* node = HK_NULL);

    /*virtual*/ int getNumSkinnedVerts () const;
        /*virtual*/ int getNumVertexBones (int vertex) const;
        /*virtual*/ float getVertexBoneWeight (int vertex, int bone) const;
        /*virtual*/ const INode* getVertexBoneNode (int vertex, int bone) const;

    private:

        IPhysiqueExport* m_physiqueMod;
        IPhyContextExport* m_contextData;
        INode* m_inode;
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
